package com.ptteng.academy.pc.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.*;
import com.ptteng.academy.admin.model.Constant;
import com.ptteng.academy.admin.model.Version;
import com.ptteng.academy.admin.service.ConstantService;
import com.ptteng.academy.common.model.Message;
import com.ptteng.academy.common.model.Sms;
import com.ptteng.academy.common.service.MessageService;
import com.ptteng.academy.common.service.SmsService;
import com.ptteng.academy.course.model.*;
import com.ptteng.academy.course.service.*;
import com.ptteng.academy.document.model.UserFavoriteRelation;
import com.ptteng.academy.document.service.UserFavoriteRelationService;
import com.ptteng.academy.pc.util.DynamicUtil;
import com.ptteng.academy.user.model.Sign;
import com.ptteng.academy.user.model.User;
import com.ptteng.academy.user.model.UserMemberRelation;
import com.ptteng.academy.user.model.UserOpenidRelation;
import com.ptteng.academy.user.service.SignService;
import com.ptteng.academy.user.service.UserMemberRelationService;
import com.ptteng.academy.user.service.UserOpenidRelationService;
import com.ptteng.academy.user.service.UserService;
import com.ptteng.common.storage.util.ImgStorageUtil;
import com.qding.common.util.DataUtils;
import com.qding.common.util.FileUtil;
import com.qding.common.util.http.cookie.CookieUtil;
import com.qding.common.util.http.cookie.IdentityUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.ptteng.academy.user.model.Sign;


/**
 * User  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@SuppressWarnings("ALL")
@Controller
public class UserController {

    private static final Log userLog = LogFactory.getLog("user");
    private static final Log registerLog = LogFactory.getLog("register");

    @Autowired
    private UserService userService;
    @Autowired
    private SignService signService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private UserFavoriteRelationService userFavoriteRelationService;
    @Autowired
    private UserOpenidRelationService userOpenidRelationService;
    @Autowired
    private MessageService messageService;
    @Autowired
    private ConstantService constantService;
    @Autowired
    private ImgStorageUtil imgStorageUtil;
    @Autowired
    private SmsService smsService;
    @Autowired
    private UserMemberRelationService userMemberRelationService;
    @Autowired
    private CookieUtil cookieUtil;
    @Autowired
    private LessonService lessonService;
    @Autowired
    private SubjectService subjectService;
    @Autowired
    private PeriodService periodService;
    @Autowired
    private LoginRecordService loginRecordService;
    @Autowired
    private UnitService unitService;


    //1、用户信息
    @RequestMapping(value = "/a/u/user/detail", method = RequestMethod.GET)
    public String userDetail(HttpServletRequest request, HttpServletResponse response, ModelMap model) throws Exception {

        userLog.info("get user detail");
        Long uid = cookieUtil.getID(request);
        User user = userService.getObjectById(uid);
        userLog.info("get uid " + user.getId());

        try {

            userLog.info(" user is " + user);
            if (user == null) {
                model.addAttribute("code", -2000);
                return "/common/success";
            }


            //查询用户是否是会员，如果是，则返回会员的剩余天数
            Long endAt = 0L;
            long current = System.currentTimeMillis();
            List<Long> memeberIds = userMemberRelationService.getUserMemberRelationIdsByUidAndStatus(user.getId(), User.IS_MEMBER, 0, Integer.MAX_VALUE);
            if (CollectionUtils.isEmpty(memeberIds)) {
                userLog.info(" user " + user.getId() + " is not a member ");

            } else {
                user.setIsMember(User.IS_MEMBER);
                boolean updateResutl = userService.update(user);
                List<UserMemberRelation> userMemberRelations = userMemberRelationService.getObjectsByIds(memeberIds);
                for (UserMemberRelation userMemberRelation : userMemberRelations) {
                    userLog.info(" user member endAt is " + getDate(userMemberRelation.getEndAt()));

                    if (userMemberRelation.getEndAt().longValue() >= endAt) {
                        userLog.info(" user member " + userMemberRelation.getId() + " end time " + userMemberRelation.getEndAt() + " is more than " + endAt);
                        endAt = userMemberRelation.getEndAt().longValue();
                    } else {
                        userLog.info(" user member " + userMemberRelation.getId() + " end time " + userMemberRelation.getEndAt() + " is less than " + endAt);
                    }
                }
                userLog.info("final end at member time is : " + endAt);
                Integer diffDays = MyTimeUtil.diffDays(endAt, current);
                model.addAttribute("period", diffDays);
            }

            model.addAttribute("code", 0);
            model.addAttribute("user", user);

        } catch (Throwable t) {
            t.printStackTrace();
            userLog.error(t.getMessage());
            userLog.error("get userInfo error ");
            model.addAttribute("code", -1);
        }

        return "/academy-user-service/user/json/userDetailJson";
    }

    //2、修改用户信息
    @RequestMapping(value = "/a/u/user/detail", method = RequestMethod.PUT)
    public String updateUser(HttpServletRequest request, HttpServletResponse response, ModelMap model, String alias,
                             Integer grade, String img, String location) throws Exception {
        userLog.info("grade" + grade + "alias" + alias + "img"+img + location + "location");


        userLog.info("update user detail");

        userLog.info("get user detail");
        Long uid = cookieUtil.getID(request);
        User user = userService.getObjectById(uid);
        userLog.info(user);
        userLog.info("get uid " + user.getId());

        try {
            userLog.info(" user is " + user);
            if (user == null) {
                model.addAttribute("code", -2000);
                return "/common/success";
            }

            if (DataUtils.isNotNullOrEmpty(alias)) {
                userLog.info("nick : " + user.getAlias() + " >>>>>>>>>> " + alias);
                user.setAlias(alias);
            }
            if (DataUtils.isNotNullOrEmpty(grade)) {
                userLog.info("grade : " + user.getGrade() + " >>>>>>>>>> " + grade);
                user.setGrade(grade);
            }
            if (DataUtils.isNotNullOrEmpty(img)) {
                userLog.info("img : " + user.getImg() + " >>>>>>>>>> " + img);
                user.setImg(img);
            }
            if (DataUtils.isNotNullOrEmpty(location)) {
                userLog.info("location : " + user.getLocation() + " >>>>>>>>>> " + location);
                user.setLocation(location);
            }
            userService.update(user);

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            userLog.error(t.getMessage());
            userLog.error("update user error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }


    public static String getDate(Long time) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd HH:mm:ss");
        String date = "";
        if (null != time) {
            date = dateFormat.format(new Date(time));
        }
        return date;
    }

    private boolean verifyModel() {
//        return "test".equals(this.accountConfig.get("testModel"));
        return true;
    }


    // 验证码校验
    private boolean verifyMobileCode(ModelMap model, String mobile, String type, String verify)
            throws ServiceException, ServiceDaoException {
        registerLog.info("log2: mobile is " + mobile + ",type = " + type + ",verify" + verify);
        // 是否有发送验证码
        Long sid = smsService.getSmsIdByMobileAndType(mobile, type);
        registerLog.info("sid is " + sid);

        if (sid == null) {
            return false;
        }
        // 获取验证码信息
        Sms sms = smsService.getObjectById(sid);
        registerLog.info("sms is " + sms);
        // 获取验证码
        String message = sms.getMessage();
        registerLog.info("message is " + message);

        //发送是否超时
        Long delay = System.currentTimeMillis() - sms.getSendAt();

        if (delay > 600000) {
            registerLog.info("require verify too long");
            return false;
        }

        if (message.equals(verify)) {
            return true;
        } else {
            return false;
        }

    }

    //5、用户登陆
    @RequestMapping(value = "/a/login", method = RequestMethod.POST)
    public String aLogin(HttpServletRequest request, HttpServletResponse response, ModelMap model, String pwd, String account,
                         String type, String os, String openid) throws Exception {

        registerLog.info("pwd is " + pwd + " account= " + account + " type =  " + type);
        registerLog.info("==========1、校验参数是否为空==========");
        if (StringUtil.isEmpty(account) || (!UserOpenidRelation.TYPE_WEIXIN.equals(type) && StringUtil.isEmpty(pwd))) {
            model.addAttribute("code", -2012);
            return "/common/success";
        } else {
            registerLog.info("params verify OK");
        }

        registerLog.info("==========2、校验用户是否注册==========");
        Long uid = null;
        Long relationId = null;
        if ("mobile".equals(type)) {
            uid = userService.getUserIdByMobile(account);
            registerLog.info(uid + "uid---------");
        } else if ("mail".equals(type)) {
            uid = userService.getUserIdByMail(account);
            registerLog.info(uid + "uid---------");
        } else if ("weixin".equals(type)) {
            registerLog.info("get userOpenidrelation by account "+account+" and  os "+os);
            relationId = userOpenidRelationService.getUserOpenidRelationIdByOpenidAndType( account , os);

//            relationId = userOpenidRelationService.getUserOpenidRelationIdByOpenidAndType(account, os);
            if (relationId == null) {
                registerLog.info(" no bind weixin ");
                model.addAttribute("code", -2000);
                return "/common/success";
            }
            UserOpenidRelation userOpenidRelation = userOpenidRelationService.getObjectById(relationId);
            uid = userOpenidRelation.getUid();
            registerLog.info("user : " + uid + " exist");

        }
        registerLog.info(uid + "uid---------");


        User user = this.userService.getObjectById(uid);

        if (User.STATUS_OFF.equals(user.getStatus())) {
            registerLog.info(" status off ");
            model.addAttribute("code", -2009);
            return "/common/success";
        } else {
            registerLog.info(" status on ");
        }

        Boolean verify = false;
        if (UserOpenidRelation.TYPE_MOBILE.equals(type) || UserOpenidRelation.TYPE_MAIL.equals(type)) {
            String pass = PasswordUtils.encode(pwd);
            userLog.info("pwd is " + pwd + " user pwd is " + user.getPwd());
            verify = pass.equals(user.getPwd());
            if (verify) {
                registerLog.info(" password verify success ");
                //传openid和os则进行现有账号关联
                if (openid != null && os !=null){
                    registerLog.info("Execute account association , openid is " + openid + " ,os is "+os + " , user id is "+uid);
                    UserOpenidRelation newUserOpenidrelation = new UserOpenidRelation();
                    newUserOpenidrelation.setUid(uid);
                    newUserOpenidrelation.setType(UserOpenidRelation.TYPE_WEB);
                    newUserOpenidrelation.setOpenid(openid);
                    Long uorId=userOpenidRelationService.insert(newUserOpenidrelation);
                    registerLog.info("insert userOpenidRelation success , id is " +uorId);
                }

            } else {
                registerLog.info(" password wrong ");
                model.addAttribute("code", -2006);
                return "/common/success";
            }
        } else {
            verify = true;
            registerLog.info("openid login , don't need password verify");
        }

        if (verify) {
            registerLog.info(uid + " login ");
            Map<String, String> maps = new HashMap();
            maps.put(CookieUtil.USER_ID, uid + "");
            cookieUtil.setIdentity(request, response, maps, uid);
            String token = IdentityUtil.encodeCookie("phone", uid);
            user.setLastLoginAt(System.currentTimeMillis());
            userService.update(user);

            model.addAttribute("code", 0);
            model.addAttribute("user", user);
            model.addAttribute("token", token);


        } else {
            registerLog.info(account + " wrong pwd " + pwd);
            model.put("code", -2006);
            return "/common/success";
        }

        String loginRecordOs = "";
        switch (os) {
            case Version.os_android:
                loginRecordOs = "安卓端";
                break;
            case Version.os_ios:
                loginRecordOs = "iOS端";
                break;
            case Version.os_web:
                loginRecordOs = "web端";
                break;
        }

        registerLog.info("insert loginrecord");
        LoginRecord loginRecord = new LoginRecord();
        loginRecord.setUid(uid);
        loginRecord.setOs(loginRecordOs);
        loginRecord.setLoginAt(System.currentTimeMillis());
        registerLog.info(loginRecord);
        loginRecordService.insert(loginRecord);
        registerLog.info("insert loginrecord over");

        return "/academy-user-service/user/json/userLogin";
    }

    //4、收藏任务
    @RequestMapping(value = "/a/u/collection/{targetId}", method = RequestMethod.PUT)
    public String addCollection(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long targetId,
                                Integer status, Integer targetType) throws Exception {

        Long relationId = 0L;

        Task task = null;

        Integer senario = 0;
        String userIdStr = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
//        long userId = Long.parseLong(userIdStr);
        Long userId = cookieUtil.getID(request);
        userLog.info("get uid " + userId);

        userLog.info("user : " + userId + " set collection : type = " + targetType + " id = " + targetId + " status = " + status);

        try {
            if (DataUtils.isNullOrEmpty(status) || DataUtils.isNullOrEmpty(targetType)) {
                userLog.info("params is null");
                model.addAttribute("code", -1000);
                return "/common/success";
            }

            // 校验收藏状态
            if (!status.equals(UserFavoriteRelation.STATUS_ACTIVE) && !status.equals(UserFavoriteRelation.STATUS_PASSIVE)) {

                userLog.info("status is not legal");
                model.addAttribute("code", -2103);
                return "/common/success";
            }
            // 校验收藏的目标类型
            if (targetType.equals(UserFavoriteRelation.TARGET_TYPE_DOCUMENT) && !targetType.equals(UserFavoriteRelation.TARGET_TYPE_TASK) && !targetType.equals(UserFavoriteRelation.TARGET_TYPE_VIDEO)) {

                userLog.info(" targetType is not legal");
                model.addAttribute("code", -2100);
                return "/common/success";
            }


            //校验收藏对象是否存在
            if (UserFavoriteRelation.TARGET_TYPE_TASK.equals(targetType)) {
                task = taskService.getObjectById(targetId);
                if (null == task) {
                    model.addAttribute("code", -2104);
                    userLog.info("task which targetId is " + targetId + " doesn't exist ");
                    return "/common/success";
                } else {
                    userLog.info(" get target task success");
                }
            }


            if (status.equals(UserFavoriteRelation.STATUS_PASSIVE)) {
                userLog.info("============  取消收藏  ===========");
                relationId = userFavoriteRelationService.getUserFavoriteRelationIdByTargetIdAndUidAndTargetTypeAndType(targetId, userId, targetType, UserFavoriteRelation.TYPE_COLLECTION);

                if (null == relationId) {
                    userLog.info("favourite relation which relationId is" + relationId + " doesn't exist ");
                    model.addAttribute("code", -2101);
                    return "/common/success";
                }

                UserFavoriteRelation favRelation = userFavoriteRelationService.getObjectById(relationId);
                Integer favStatus = favRelation.getStatus();

                if (UserFavoriteRelation.STATUS_PASSIVE.equals(favStatus)) {

                    userLog.info(" already exists passive status relation which id is " + relationId);
                    model.addAttribute("code", -2101);
                    return "/common/success";

                } else {

                    favRelation.setStatus(UserFavoriteRelation.STATUS_PASSIVE);
                    userFavoriteRelationService.update(favRelation);
                    userLog.info("cancel relation collection success, id is" + relationId);
                }

            }
            if (status.equals(UserFavoriteRelation.STATUS_ACTIVE)) {
                userLog.info("======== 收藏 ========");

                relationId = userFavoriteRelationService.getUserFavoriteRelationIdByTargetIdAndUidAndTargetTypeAndType(targetId, userId, targetType, UserFavoriteRelation.TYPE_COLLECTION);
                if (null != relationId) {
                    UserFavoriteRelation favRelation = userFavoriteRelationService.getObjectById(relationId);
                    Integer favStatus = favRelation.getStatus();

                    if (UserFavoriteRelation.STATUS_ACTIVE.equals(favStatus)) {
                        userLog.info("favorite relation :" + relationId + " already exists");
                        model.addAttribute("code", -2102);
                    } else {

                        favRelation.setStatus(UserFavoriteRelation.STATUS_ACTIVE);
                        userFavoriteRelationService.update(favRelation);
                        userLog.info("collection success");

                    }
                } else {
                    UserFavoriteRelation favRelation = new UserFavoriteRelation();
                    favRelation.setUid(userId);
                    favRelation.setTargetType(targetType);
                    favRelation.setTargetId(targetId);
                    favRelation.setStatus(UserFavoriteRelation.STATUS_ACTIVE);
                    favRelation.setType(UserFavoriteRelation.TYPE_COLLECTION);

                    userFavoriteRelationService.insert(favRelation);
                    userLog.info("collection sucess");
                }
            }


            model.addAttribute("code", 0);

        } catch (Throwable t) {

            t.printStackTrace();
            userLog.error(t.getMessage());
            userLog.error("user : " + userId + " set collection : targetType = " + targetType + " targetId = " + targetId + " status = " + status + " error");
            model.addAttribute("code", -1);
        }


        return "/common/success";
    }

    //4、单个任务是否收藏
    @RequestMapping(value = "/a/u/isCollection/{targetId}", method = RequestMethod.GET)
    public String getIsCollection(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long targetId,
                                  Integer status, Integer targetType) throws Exception {

        Long uid = cookieUtil.getID(request);
        registerLog.info(uid + "uidaaaaaaaaaaaaaaaaaaaaaaaaaaa");
        Integer type = 2;
        Long userFavoriteRelationId = userFavoriteRelationService.getUserFavoriteRelationIdByTargetIdAndUidAndTargetTypeAndTypeAndStatus(targetId, uid, targetType, type, status);
        UserFavoriteRelation userFavoriteRelation = userFavoriteRelationService.getObjectById(userFavoriteRelationId);
        if (userFavoriteRelation != null) {
            model.addAttribute("code", 0);
            model.addAttribute("isCollection", status);
        } else {
            status = 2;

            model.addAttribute("code", 0);
            model.addAttribute("isCollection", status);
        }

        return "/academy-course-service/lesson/json/userFavoriteTask";
    }


    //12、用户收藏任务列表
    @RequestMapping(value = "/a/u/task/collection/list", method = RequestMethod.GET)
    public String getCollectionByUserListJson(HttpServletRequest request, HttpServletResponse response,
                                              ModelMap model, Integer page, Integer size, Integer collectType) throws Exception {

        List<Long> taskIds = new ArrayList<>();
        List<Task> taskList = new ArrayList<>();
        List<Long> totalIds = new ArrayList<>();
        List<UserFavoriteRelation> relationList = new ArrayList<>();

        if (DataUtils.isNullOrEmpty(collectType)) {
            model.addAttribute("code", -1000);
            return "/common/success";
        }

        if (!collectType.equals(UserFavoriteRelation.TYPE_LIKE) && !collectType.equals(UserFavoriteRelation.TYPE_VIEW_RECORD) && !collectType.equals(UserFavoriteRelation.TYPE_COLLECTION)) {
            model.addAttribute("code", -1001);
            return "/common/success";
        }


        if (null == page) {
            page = 1;
        }
        if (null == size) {
            size = 10;
        }

        int start = (page - 1) * size;
        Boolean next = false;

        Long uid = cookieUtil.getID(request);
        User user = userService.getObjectById(uid);
        userLog.info("get uid " + uid + " favourite list");

        try {
            userLog.info("user is " + user);

            userLog.info("=======获取收藏课程列表=======");
            List<Long> relationIds = userFavoriteRelationService.getUserFavoriteRelationIdByUidAndTargetTypeAndTypeAndStatus(uid, UserFavoriteRelation.TARGET_TYPE_TASK, collectType, UserFavoriteRelation.STATUS_ACTIVE, start, size);

            relationList = userFavoriteRelationService.getObjectsByIds(relationIds);
            taskIds = MyListUtil.getFieldValueListFromModelList(relationList, true, UserFavoriteRelation.class.getDeclaredField("targetId"));

            taskList = taskService.getObjectsByIds(taskIds);

            // periodId_alias   lessonId_alias   subjectId_alias
            List<Long> periodIdsR = MyListUtil.getDistinctList(Task.class.getDeclaredField("periodId"), taskList);
            List<Long> lessonIdsR = MyListUtil.getDistinctList(Task.class.getDeclaredField("lessonId"), taskList);
            List<Long> subjectIdsR = MyListUtil.getDistinctList(Task.class.getDeclaredField("subjectId"), taskList);

            List<Period> periodList = periodService.getObjectsByIds(periodIdsR);
            List<Lesson> lessonList = lessonService.getObjectsByIds(lessonIdsR);
            List<Subject> subjectList = subjectService.getObjectsByIds(subjectIdsR);

            Map<Long, String> periodId_alias = MyListUtil.convert2Map(Period.class.getDeclaredField("id"), Period.class.getDeclaredField("periodName"), periodList);
            Map<Long, String> lessonId_alias = MyListUtil.convert2Map(Lesson.class.getDeclaredField("id"), Lesson.class.getDeclaredField("lessonName"), lessonList);
            Map<Long, String> subjectId_alias = MyListUtil.convert2Map(Subject.class.getDeclaredField("id"), Subject.class.getDeclaredField("subjectName"), subjectList);

            model.addAttribute("taskList", taskList);
            model.addAttribute("periodId_alias", periodId_alias);
            model.addAttribute("lessonId_alias", lessonId_alias);
            model.addAttribute("subjectId_alias", subjectId_alias);
            userLog.info("collection taskIds: " + taskIds);

            totalIds = userFavoriteRelationService.getUserFavoriteRelationIdByUidAndTargetTypeAndTypeAndStatus
                    (uid, UserFavoriteRelation.TARGET_TYPE_TASK, collectType, UserFavoriteRelation.STATUS_ACTIVE, 0, Integer.MAX_VALUE);

            userLog.info(" total = " + totalIds.size());
            Integer totalPage = (((totalIds.size() - 1)) / size) + 1;
            userLog.info("   totalPage = " + totalPage);

            // 添加视频链接
            Map<String, Object> unitParam = DynamicUtil.getUnitList(Unit.media_type_video);
            List<Long> unitIds = unitService.getIdsByDynamicCondition(Unit.class, unitParam, 0, Integer.MAX_VALUE);
            List<Unit> unitList = unitService.getObjectsByIds(unitIds);

            Map<Long, String> taskIdVideoLinkMap = MyListUtil.convert2Map(Unit.class.getDeclaredField("taskId"), Unit.class.getDeclaredField("resourceLink"), unitList);

            if (totalPage > page) {
                next = true;
            }

            model.addAttribute("code", 0);
            model.addAttribute("next", next);
            model.addAttribute("page", page);
            model.addAttribute("total", totalIds.size());
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("taskList", taskList);
            model.addAttribute("taskIdVideoLinkMap", taskIdVideoLinkMap);


        } catch (Throwable t) {
            t.printStackTrace();
            userLog.error(t.getMessage());
            userLog.error("get collection task error ");
            model.addAttribute("code", -1);
        }


        return "/academy-course-service/lesson/json/userFavoriteLesson";
    }

    //删除收藏（学习）记录
    @RequestMapping(value = "/a/u/collection/{taskId}", method = RequestMethod.DELETE)
    public String deleteCollectionSingleJson(HttpServletRequest request, HttpServletResponse response, @PathVariable Long taskId, Integer collectType, Integer targetType, ModelMap model) {

        try {

            Long uid = cookieUtil.getID(request);
            if (DataUtils.isNullOrEmpty(uid)) {
                model.addAttribute("code", -2000);
                return "common/success";
            }
            User user = userService.getObjectById(uid);

            Long relationIdR = userFavoriteRelationService.getUserFavoriteRelationIdByTargetIdAndUidAndTargetTypeAndType(taskId, uid, targetType, collectType);

            userFavoriteRelationService.getUserFavoriteRelationIdByTargetIdAndUidAndTargetTypeAndType(taskId, uid, targetType, collectType);
            if (DataUtils.isNullOrEmpty(relationIdR)) {
                model.addAttribute("code", -2108);
                return "common/success";
            }

            boolean delete = userFavoriteRelationService.delete(relationIdR);
            userLog.info("successfully delete userFavouriteRelation which Id is" + relationIdR);
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            userLog.error(t.getMessage());
            userLog.error("get collection task error ");
            model.addAttribute("code", -1);
        }


        return "common/success";
    }

    //删除全部学习记录
    @RequestMapping(value = "/a/u/collection/all", method = RequestMethod.DELETE)
    public String deleteCollectAllJson(HttpServletRequest request, HttpServletResponse response, ModelMap model) {

        Long uid = cookieUtil.getID(request);
        if (DataUtils.isNullOrEmpty(uid)) {
            model.addAttribute("code", -2000);
            return "common/success";

        }
        try {
            User user = userService.getObjectById(uid);
            List<Long> relationIds = userFavoriteRelationService.getUserFavoriteRelationIdsByUserIDAndType(uid, UserFavoriteRelation.TYPE_VIEW_RECORD, 0, Integer.MAX_VALUE);

            //userFavoriteRelationService.getUserFavoriteRelationIdByTargetIdAndUidAndTargetTypeAndTypeAndStatus(uid, UserFavoriteRelation.TARGET_TYPE_TASK, UserFavoriteRelation.TYPE_VIEW_RECORD, UserFavoriteRelation.STATUS_ACTIVE);

            if (DataUtils.isNullOrEmpty(relationIds)) {
                model.addAttribute("code", -2109);
                return "common/success";
            }

            userFavoriteRelationService.deleteList(UserFavoriteRelation.class, relationIds);

        } catch (Throwable t) {
            t.printStackTrace();
            userLog.error(t.getMessage());
            userLog.error("get collection task error ");
            model.addAttribute("code", -1);
        }


        return "common/success";
    }

    //14、签到
    @RequestMapping(value = "/a/u/user/sign", method = RequestMethod.PUT)
    public String sign(HttpServletRequest request, HttpServletResponse response, ModelMap model) throws Exception {

        Long uid = cookieUtil.getID(request);
        User user = userService.getObjectById(uid);
        userLog.info("get uid " + uid);

        userLog.info("user : " + uid + " sign");

        try {

            userLog.info(" user is " + user);
            if (user == null) {
                model.addAttribute("code", -2000);
                return "/common/success";
            }

            userLog.info("=====判断当天是否签到=====");
            Long now = System.currentTimeMillis();
            Long signId = signService.getSignIdByUidAndSignDate(uid, MyTimeUtil.getStartTime(now));
            if (null != signId) {
                user.setSign(User.SIGN);
                userService.update(user);
                userLog.info("already sign today");
                model.addAttribute("code", -2017);
                return "/common/success";
            } else {
                userLog.info("user not sign");
            }

            Integer signStatus = user.getSign();
            userLog.info("user sign is : " + signStatus);

            userLog.info("=====插入用户签到记录=====");
            Sign signRecord = new Sign();
            signRecord.setUid(uid);
            signRecord.setSignAt(now);
            signRecord.setSignDate(MyTimeUtil.getStartTime(now));
            userLog.info("insert sign record : " + signRecord);
            signService.insert(signRecord);

            userLog.info("=====修改连续签到次数=====");
            //查询昨天是否签到，决定当前连续签到次数
            Long yDayZero = MyTimeUtil.getPreZeroTimeMillions(1);
            userLog.info("yesterday zero time : " + yDayZero);
            Long yDaySignId = signService.getSignIdByUidAndSignDate(uid, yDayZero);
            if (null == yDaySignId) {
                userLog.info("not continue sign");
                user.setConsecutive(1);
            } else {
                userLog.info("continue sign");
                Integer consecutive = user.getConsecutive();
                user.setConsecutive(consecutive + 1);
                userLog.info("user consecutive : " + consecutive + " >>>>>>>>>> " + user.getConsecutive());
            }

            userLog.info("=====修改历史最高签到记录=====");
            //根据当前连续签到次数与历史最高签到次数比较，确定是否更新历史最高签到记录
            Integer signHighest = user.getSignHighest();
            userLog.info("user signHighest : " + signHighest);
            userLog.info(user.getConsecutive() + " " + signHighest);
            if (user.getConsecutive() > signHighest) {
                user.setSignHighest(user.getConsecutive());
                userLog.info("user consecutive : " + signHighest + " >>>>>>>>>> " + user.getSignHighest());
            } else {
                userLog.info("user consecutive less than signHighest");
            }

            //获取学习星数按当前连续签到次数计算
            Integer addScore = user.getConsecutive();
            if (addScore > 5) {
                addScore = 5;
            }

            Long score = user.getScore();
            user.setScore(score + addScore);
            userLog.info("user score : " + score + " >>>>>>>>>> " + user.getScore());
            user.setSign(User.SIGN);

            Integer signTotal = user.getSignTotal();
            user.setSignTotal(signTotal + 1);
            userLog.info("user signTotal : " + signTotal + " >>>>>>>>>> " + user.getSignTotal());

            userService.update(user);

            //这是一个垃圾的单发短信。。。。
            DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String date = dateFormat.format(new Date(System.currentTimeMillis()));
            String title = "获得逆袭豆通知";
            String content = "您已完成签到，获得" + addScore + "颗逆袭豆。";

            Message message = new Message();
            message.setType(Message.Type_pesson);
            message.setName(title);
            message.setContent(content);
            message.setUserId(uid);
            message.setPublishAt(System.currentTimeMillis());
            message.setSort(1);
            messageService.insert(message);
            userLog.info("send message success");

            model.addAttribute("code", 0);
            model.addAttribute("score", addScore);

        } catch (Throwable t) {
            t.printStackTrace();
            userLog.error(t.getMessage());
            userLog.error("user : " + uid + " sign error ");
            model.addAttribute("code", -1);
        }

        return "/academy-user-service/user/json/signInfo";
    }


    //14、用户签到信息
    @RequestMapping(value = "/a/u/user/sign/list", method = RequestMethod.GET)
    public String signInfo(HttpServletRequest request, HttpServletResponse response, ModelMap model, String year, String month) throws Exception {

        Long uid = cookieUtil.getID(request);
        User user = userService.getObjectById(uid);
        Integer signTotal = user.getSignTotal();
        userLog.info("get uid " + uid);
        userLog.info("get signTotal" + signTotal);

        model.addAttribute("signTotal", signTotal);

        userLog.info("get user : " + uid + " " + year + "-" + month + " sign list");

        if (StringUtil.isEmpty(year) || StringUtil.isEmpty(month)) {
            userLog.info("params is null");
            model.addAttribute("code", -1000);
            return "/common/success";
        }

        try {

            userLog.info(" user is " + user);
            if (user == null) {
                model.addAttribute("code", -2000);
                return "/common/success";
            }

            Date inDate = new Date();

            try {
                if (Integer.valueOf(month) < 10) {
                    month = "0" + month;
                }
                String date = year + month + "01000000";
                DateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
                inDate = dateFormat.parse(date);

            } catch (Exception e) {
                userLog.error(e.getMessage());
                userLog.info("wrong date format");
                model.addAttribute("code", -1007);
                return "/common/success";
            }

            DateFormat weekFormat = new SimpleDateFormat("E");
            DateFormat dayFormat = new SimpleDateFormat("dd");
            Date monthBegin = TimeUtil.getMonthBegin(inDate);
            Date monthEnd = TimeUtil.getMonthEnd(inDate);
            String week = weekFormat.format(monthBegin);
            String day = dayFormat.format(monthEnd);
            userLog.info("the first day week of month : " + week + " , the day number of month : " + day);
            model.addAttribute("week", week);
            model.addAttribute("dayCount", day);

            //查询昨天是否签到，决定当前连续签到次数
            Long yDayZero = MyTimeUtil.getPreZeroTimeMillions(1);
            Long tDayZero = MyTimeUtil.getPreZeroTimeMillions(0);
            Long yDaySignId = signService.getSignIdByUidAndSignDate(uid, yDayZero);
            Long tDaySignId = signService.getSignIdByUidAndSignDate(uid, tDayZero);
            userLog.info("yesterday sign id : " + yDaySignId + " , today sign id : " + tDaySignId);

            if (null == yDaySignId && null == tDaySignId) {
                userLog.info("not continue sign");
                user.setConsecutive(0);
                userService.update(user);
                userLog.info("update user consecutive : 0 ");
            } else {
                userLog.info("continue sign : " + user.getConsecutive());
            }
            model.addAttribute("continue", user.getConsecutive());

            Map<Long, String> id_signDay = new HashMap();
            List<Integer> signDayList = new ArrayList<>();
            userLog.info("monthBegin.getTime() is :" + monthBegin.getTime());
            userLog.info("monthEnd.getTime() is :" + monthEnd.getTime());
            List<Long> signIds = signService.getSignIdsByUidAndSignDateAreaOrderBySignDateAsc(uid, monthBegin.getTime(), monthEnd.getTime());
            userLog.info("sign id size : " + signIds.size());
            List<Sign> signs = signService.getObjectsByIds(signIds);

            String signDay = "";
            for (Sign sign : signs) {
                signDay = dayFormat.format(sign.getSignDate());
                id_signDay.put(sign.getId(), signDay);

                Integer dayDate = Integer.valueOf(signDay);
                signDayList.add(dayDate);
            }

            List<Integer> signList = new ArrayList<>();
            Integer dayCountInt = Integer.valueOf(day);
            for (int i = 1; i <= dayCountInt; i++) {
                if (signDayList.contains(i)) {
                    signList.add(1);
                } else {
                    signList.add(0);
                }
            }

            model.addAttribute("code", 0);
            model.addAttribute("signIds", signIds);
            model.addAttribute("signList", signList);
            model.addAttribute("id_signDay", id_signDay);

        } catch (Throwable t) {
            t.printStackTrace();
            userLog.error(t.getMessage());
            userLog.error("user : " + uid + " sign error ");
            model.addAttribute("code", -1);
        }

        return "/academy-user-service/user/json/userSignList";
    }

    //10、修改用户密码
    @RequestMapping(value = "/a/u/password", method = RequestMethod.PUT)
    public String updateUserPwd(HttpServletRequest request, HttpServletResponse response, ModelMap model, String pwd, String newpwd) throws Exception {

        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        userLog.info("get uid " + uid);

        try {
            userLog.info(" user : " + uid + " want update pwd");

            if (StringUtil.isEmpty(newpwd) || StringUtils.isEmpty(pwd)) {
                userLog.info("params is null");
                model.addAttribute("code", -3003);
                return "/common/success";
            }

            String pass = PasswordUtils.encode(pwd);
            Boolean verify = user.getPwd().equals(pass);
            if (verify) {
                userLog.info(uid + " have right pwd ");

                String encodePass = PasswordUtils.encode(newpwd);
                user.setPwd(encodePass);
                boolean result = userService.update(user);

            } else {
                userLog.info(uid + " wrong pwd " + pwd);
                model.put("code", -2006);
                return "/common/success";
            }

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            userLog.error(t.getMessage());
            userLog.error("user " + uid + " update pwd error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }

    // 6、忘记密码
    @RequestMapping(value = "/a/password/forget", method = RequestMethod.PUT)
    public String resetPassword(HttpServletRequest request, HttpServletResponse response, ModelMap model, String mobile,
                                String verify, String newpwd, String account) throws Exception {
        try {

            registerLog.info(" mobile = " + mobile + " verify  = " + verify + " pwd = " + newpwd + " account = " + account);

            if (StringUtil.isEmpty(mobile) && StringUtil.isEmpty(account)) {
                registerLog.info("params is null");
                model.addAttribute("code", -3002);
                return "/common/success";
            } else if (StringUtil.isNotEmpty(mobile)) {
                account = mobile;
            }
//            if (StringUtil.isEmpty(verify)) {
//                registerLog.info("params is null");
//                model.addAttribute("code", -3004);
//
//                return "/common/success";
//            }
            if (StringUtil.isEmpty(newpwd)) {
                registerLog.info("params is null");
                model.addAttribute("code", -3003);

                return "/common/success";
            }

            registerLog.info("==========2、校验account类型==========");
            String accountType = "";
            Pattern p = Pattern.compile("^([a-zA-Z0-9_-])+@([a-zA-Z0-9_-])+(\\.([a-zA-Z0-9_-])+)+$");
            Matcher m = p.matcher(account);
            boolean mailCheckResult = m.matches();
            userLog.info("mail address verify result : " + mailCheckResult);
            if (mailCheckResult) {
                accountType = "mail";
            } else {
                accountType = "mobile";
            }

            // 是否已注册
            Long uid = 0L;
            if ("mail".equals(accountType)) {
                uid = userService.getUserIdByMail(account);
            } else {
                uid = userService.getUserIdByMobile(account);
            }

            // 用户不存在
            if (uid == null) {
                registerLog.info(mobile + " not exist ");
                model.addAttribute("code", -2000);
                return "/common/success";
            } else {
                registerLog.info(mobile + " exist and uid is " + uid);
            }

            User user = userService.getObjectById(uid);

            if (null == user) {
                registerLog.info("user not exist ");
                model.addAttribute("code", -2000);
                return "/common/success";
            } else {
                if (null == user.getAreaCode()) {
                    userLog.info("user area code null , set +86");
                    user.setAreaCode("+86");
                }
            }

            if ("mail".equals(accountType)) {
                userLog.info("send mail message to : " + account);
            } else {
                account = user.getAreaCode() + user.getMobile();
                userLog.info("send message to : " + account);
            }

            boolean verifyResult = false;

            String type = "password";

            // 测试模式
//            if (verifyModel()) {
//                if ("555555".equals(verify)) {
//                    registerLog.info("test ,so not verify mobile ");
//                    verifyResult = true;
//                } else {
//                    verifyResult = verifyMobileCode(model, account, type, verify);
//                }
//            } else {
//                verifyResult = verifyMobileCode(model, account, type, verify);
//            }

            // 判断验证码的验证结果
            //if (verifyResult) {

            String encodePass = PasswordUtils.encode(newpwd);
            user.setPwd(encodePass);
            boolean result = userService.update(user);

            registerLog.info(mobile + " change password," + newpwd + "result is " + result);
            registerLog.info("rewrite password success! ");

            model.addAttribute("code", 0);
//            }
// else {
//                registerLog.error("rewritepwd verifycode");
//                model.addAttribute("code", -2005);
//
//                return "/common/success";
//            }

        } catch (Throwable t) {
            t.printStackTrace();
            registerLog.error(t.getMessage());
            registerLog.error("add user error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";

    }

    //15、其他用户信息
    @RequestMapping(value = "/a/u/user/detail/{id}", method = RequestMethod.GET)
    public String otherUserDetail(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {

        userLog.info("get user " + id + " detail");

        try {
            User user = userService.getObjectById(id);
            userLog.info(" user is " + user);
            if (user == null) {
                model.addAttribute("code", -2000);
                return "/common/success";
            }

            Long endAt = 0L;

            model.addAttribute("code", 0);
            model.addAttribute("user", user);

        } catch (Throwable t) {
            t.printStackTrace();
            userLog.error(t.getMessage());
            userLog.error("get userInfo error ");
            model.addAttribute("code", -1);
        }

        return "/academy-user-service/user/json/otherUserDetailJson";
    }


    @RequestMapping(value = "/a/u/img/{module}", method = RequestMethod.POST)
    public String uploadFile(HttpServletRequest request,
                             HttpServletResponse response, ModelMap model, @RequestParam MultipartFile file, @PathVariable String module)
            throws Exception {
        userLog.info("hello upload " + module);
        if (StringUtils.isBlank(module)) {
            module = "common";
        }
        int code = 0;
        userLog.info(file.getOriginalFilename());

        //Long uid = cookieUtil.getID(request, response);
        try {
            String type = file.getContentType();
            long size = file.getSize();
            userLog.info("  size is =" + size / 1048576);
            String extend = FileUtil.getFileExtension(file
                    .getOriginalFilename());

            String fileName = UUID.randomUUID().toString() + "." + extend;
            userLog.info("new name is " + fileName);
            //  /data/temp/
            String filePath = "/data/temp/" + fileName;

            File tempPic = new File(filePath);
            file.transferTo(tempPic);
            String url = this.imgStorageUtil.imgStorage(module, module + "/"
                    + fileName, filePath);
            userLog.info(module + " upload success ,and file name is " + fileName
                    + "temp path is " + filePath + " access url is " + url);
            tempPic.delete();
            userLog.info(file.getOriginalFilename() + " delete success ");
            model.addAttribute("url", url);
            model.addAttribute("code", 0);
            return "/common/img";
        } catch (Throwable t) {
            t.printStackTrace();
            userLog.error(t.getMessage());
            return "/common/success";
        }

    }


    @RequestMapping(value = "/a/wrong/{token}", method = RequestMethod.GET)
    public String wrong(HttpServletRequest request,
                        HttpServletResponse response, ModelMap model, @PathVariable String token) throws Exception {

        userLog.info(" wrong user " + token);

        model.addAttribute("code", -2);
        model.addAttribute("token", token);

        return "/common/wrongUser";

    }

    /**
     * 强制更新版本重定向到此请求
     *
     * @param request
     * @param response
     * @param model
     * @return
     */
    @RequestMapping(value = "/a/force/update/version", method = RequestMethod.GET)
    public String forceUpdate(HttpServletRequest request, HttpServletResponse response,
                              ModelMap model) {
        userLog.info("method forceUpdate begin...");

        try {
            Long constantIdByCode = constantService.getConstantIdByKeyAndType("code", "version");
            Long constantIdByUrl = constantService.getConstantIdByKeyAndType("url", "version");
            Long constantIdByIosName = constantService.getConstantIdByKeyAndType("iosName", "version");
            Long constantIdByAndroidName = constantService.getConstantIdByKeyAndType("androidName", "version");
            Long constantIdByInfo = constantService.getConstantIdByKeyAndType("info", "version");

            if (null != constantIdByCode && null != constantIdByUrl) {
                Constant constantByCode = constantService.getObjectById(constantIdByCode);
                Constant constantByUrl = constantService.getObjectById(constantIdByUrl);
                Constant constantByIosName = constantService.getObjectById(constantIdByIosName);
                Constant constantByAndroidName = constantService.getObjectById(constantIdByAndroidName);
                Constant constantByInfo = constantService.getObjectById(constantIdByInfo);

                String iosName = constantByIosName.getValue();
                String androidName = constantByAndroidName.getValue();
                String url = constantByUrl.getValue();
                String versionCode = constantByCode.getValue();
                String info = constantByInfo.getValue();

                model.addAttribute("url", url);
                model.addAttribute("iosName", iosName);
                model.addAttribute("androidName", androidName);
                model.addAttribute("info", info);
                model.addAttribute("versionCode", versionCode);

                userLog.info("get version : iosName =  " + iosName + " androidName " + androidName + " url = " + url + " code = " + versionCode + " info = " + info);
            } else {
                userLog.info("no version");
            }

            model.addAttribute("code", -9);

        } catch (Exception e) {
            e.printStackTrace();
            userLog.error(e.getMessage());
            model.addAttribute("code", -9);
            return "/common/success";
        }

        return "/common/versionUpdate";
    }

    // 修改密码
    @RequestMapping(value = "/a/u/pwd", method = RequestMethod.PUT)
    public String updateManagerPassword(HttpServletRequest request,
                                        HttpServletResponse response, ModelMap model, String oldPwd, String newPwd) throws Exception {
        Long uid = Long.valueOf(cookieUtil.getKeyIdentity(request,
                CookieUtil.USER_ID));
        userLog.info("do update password params:uid" + uid + ",password=" + oldPwd + ",newpassword=" + newPwd);
        if (oldPwd == null || newPwd == null || oldPwd.trim().equals("") || newPwd.trim().equals("")) {
            userLog.info(" pwd  is null");
            model.addAttribute("code", -1004);
            return "/common/success";
        }

        if (oldPwd.length() > 200 || oldPwd.length() < 0 || newPwd.length() > 200 || newPwd.length() < 0) {
            userLog.info(" pwd  is null");
            model.addAttribute("code", -1000);
            return "/common/success";
        }

        String oldPwdEncode = com.gemantic.common.util.PasswordUtils.encode(oldPwd);

        User u = userService.getObjectById(uid);
        if (u.getPwd().equals(oldPwdEncode)) {
            String newenp = com.gemantic.common.util.PasswordUtils.encode(newPwd);
            u.setPwd(newenp);
            u.setUpdateBy(uid);
            userService.update(u);

            model.addAttribute("code", 0);
        } else {

            model.addAttribute("code", -2006);
            model.addAttribute("result", "你输入的旧密码有误！");
        }

        return "/common/success";
    }

}