package com.ptteng.academy.pc.controller;

import com.gemantic.common.util.MyListUtil;
import com.ptteng.academy.course.model.Lesson;
import com.ptteng.academy.course.model.Period;
import com.ptteng.academy.course.model.Task;
import com.ptteng.academy.course.service.LessonService;
import com.ptteng.academy.course.service.PeriodService;
import com.ptteng.academy.course.service.TaskService;
import com.ptteng.academy.pc.util.DynamicUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

@Controller
public class LessonController {

    private static final Log log = LogFactory.getLog("Lesson");

    @Autowired
    private LessonService lessonService;
    @Autowired
    private PeriodService periodService;
    @Autowired
    private TaskService taskService;



    // 专题详情暨课程列表
    @RequestMapping(value = "/a/lesson/period/list/{lessonId}", method = RequestMethod.GET)
    public String getLessonPeriodListJson(HttpServletRequest request, HttpServletResponse response, @PathVariable Long lessonId, ModelMap model) {


        try {
            Lesson lesson = lessonService.getObjectById(lessonId);

            if (null == lesson) {
                model.addAttribute("code", -5043);
                return "/common/success";
            }

            // 专题对应的课程
            List<Long> periodIds = periodService.getPeriodIdsByLessonIDAndStatusOrderBySort(lessonId, Lesson.status_normal, 0, Integer.MAX_VALUE);

            List<Period> periodList = periodService.getObjectsByIds(periodIds);

            // 课程对应的任务
            Map<String, Object> taskParam = DynamicUtil.getTaskList(Task.status_normal);
            List<Long> taskIds = taskService.getIdsByDynamicCondition(Task.class, taskParam, 0, Integer.MAX_VALUE);
            List<Task> taskList = taskService.getObjectsByIds(taskIds);

            Map<Long, List<Task>> periodIdTaskMap = MyListUtil.convert2ListMap(Task.class.getDeclaredField("periodId"), taskList);

            model.addAttribute("periodList", periodList);
            model.addAttribute("lesson", lesson);
            model.addAttribute("periodIdTaskMap", periodIdTaskMap);


        } catch (Throwable throwable) {

        }


        return "/academy-course-service/lesson/json/lessonDetailJson";
    }


}
