package com.ptteng.academy.home.controller;

import com.ptteng.academy.admin.model.Manager;
import com.ptteng.academy.home.util.DynamicUtil;
import com.ptteng.academy.user.model.Member;
import com.ptteng.academy.user.model.Notice;
import com.ptteng.academy.user.service.MemberService;
import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Member  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class MemberController {
	private static final Log log = LogFactory.getLog(MemberController.class);

	@Autowired
	private MemberService memberService;






    /**
	 *  会员套餐列表
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

	@RequestMapping(value = "/a/u/member/online", method = RequestMethod.GET)
	public String getmemberList(HttpServletRequest request, HttpServletResponse response, ModelMap model,Integer page, Integer size)throws Exception {
   		log.info("the url is: get  /a/u/member/search" );
   		log.info("the page is:" + page+ ",size is +" + size);
		if (page == null) {
			page = 1;
		}

		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}
		try {
			List<Member> memberList = new ArrayList<>();
			Map<String, Object> params = DynamicUtil.getMemberList(false);
			log.info("params is :" + params);
			List<Long> idList = memberService.getIdsByDynamicCondition(Member.class, params, start, size);
			log.info("idList is :" + idList);
			if (idList.size() <= 0) {
				log.info("member idList is null");
			}
			memberList = memberService.getObjectsByIds(idList);
			log.info("memberList.size() is :" + memberList.size());
			Boolean recommendStatus = false;
			for (Member member : memberList) {
				if (Member.IS_RECOMMEND.equals(member.getRecommend())) {
					recommendStatus = true;
					break;
				}
			}
			int totalPage = 1;
			Map<String, Object> totalParams = DynamicUtil.getMemberList(true);
//			BigInteger	total = (BigInteger) memberService.getObjectByDynamicCondition(Member.class,totalParams,0,Integer.MAX_VALUE);
			Integer total = memberService.getIdsByDynamicCondition(Member.class,totalParams,0,Integer.MAX_VALUE).size();

			if(total>0){
				totalPage = (((total - 1)) / (size)) + 1;
			}

			log.info("page:" + page + ",size" + size + ",total:" + total + ",totalPage :" + totalPage);
			model.addAttribute("code",0);
			model.addAttribute("page",page);
			model.addAttribute("size",size);
			model.addAttribute("total",total);
			model.addAttribute("totalPage",totalPage);
			model.addAttribute("recommendStatus", recommendStatus);
			model.addAttribute("memberList",memberList);

		}catch(Throwable t){
			t.printStackTrace();
			log.error("get memberList error");
			log.error(t.getMessage());
			model.addAttribute("code",-1);
		}
		return "/academy-user-service/member/json/memberListJson";
	}






	/**
	 *  会员套餐详情
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@RequestMapping(value = "/a/u/member/{id}", method = RequestMethod.GET)
	public String getMemberJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		if(DataUtils.isNullOrEmpty(id)){
			log.error("id is null ");
			model.addAttribute("code",-9101);
			return "/common/success";
		}
		try {
			Member member = memberService.getObjectById(id);
			if (DataUtils.isNullOrEmpty(member)){
				log.error("member is not exist");
				model.addAttribute("code",-9100);
				return "/common/success";
			}
			log.info("get member data is " + member);

			model.addAttribute("code", 0);

			model.addAttribute("member", member);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get member error,id is  " + id);
			model.addAttribute("code", -1);
		}

		return "/academy-user-service/member/json/memberDetailJson";
	}








}

