package com.ptteng.academy.home.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.*;

/**
 * Created by asus on 2016/8/6.
 */
public class TxtUtil {

    private static final Log paperLog = LogFactory.getLog("paper");

    public static String path = "/data/webs/learn-home-web/temp/";

    public static String zippath = "/data/webs/learn-home-web/down-file/";

    private static String filenameTemp;


    public static String creatTxtFile(String name) throws IOException {

        paperLog.info("==========create txt start==========");
        boolean flag = false;
        String filenameTemp = "";

        filenameTemp = path + name + ".txt";
        File filename = new File(filenameTemp);
        if (!filename.exists()) {
            paperLog.info(filename + " not exist , so create");
            filename.createNewFile();
            flag = true;
        }
        if(!filename.exists()){
            paperLog.info("create fail");
        }else {
            paperLog.info("create success");
        }

        paperLog.info("flag : " + flag + " return " + filenameTemp);
        paperLog.info("==========create txt end==========");
        return filenameTemp;
    }

    /**
     * 写文件
     *
     * @param newStr
     *            新内容
     * @throws IOException
     */
    public static boolean writeTxtFile (String newStr, String name)
            throws IOException {
        // 先读取原有文件内容，然后进行写入操作
        boolean flag = false;
        String filein = newStr + "\r\n";
        String temp = "";

        FileInputStream fis = null;
        InputStreamReader isr = null;
        BufferedReader br = null;

        FileOutputStream fos = null;
        PrintWriter pw = null;
        try {
            // 文件路径
            filenameTemp = path + name + ".txt";
            File file = new File(filenameTemp);
            // 将文件读入输入流
            fis = new FileInputStream(file);
            isr = new InputStreamReader(fis);
            br = new BufferedReader(isr);
            StringBuffer buf = new StringBuffer();

            // 保存该文件原有的内容
            for (int j = 1; (temp = br.readLine()) != null; j++) {
                buf = buf.append(temp);
            // System.getProperty("line.separator")
            // 行与行之间的分隔符 相当于“\n”
                buf = buf.append("\r\n");
            }
            buf.append(filein);

            fos = new FileOutputStream(file);
            pw = new PrintWriter(fos);
            pw.write(buf.toString().toCharArray());
            pw.flush();
            flag = true;
        } catch (IOException e1) {
            // TODO 自动生成 catch 块
            throw e1;
        } finally {
            if (pw != null) {
                pw.close();
            }
            if (fos != null) {
                fos.close();
            }
            if (br != null) {
                br.close();
            }
            if (isr != null) {
                isr.close();
            }
            if (fis != null) {
                fis.close();
            }
        }
        return flag;
    }

    public static void deleteZipFile(String name) throws IOException {

        paperLog.info("==========delete zip start==========");
        boolean flag = false;
        String filenameTemp = "";

        filenameTemp = zippath + name + ".zip";
        File filename = new File(filenameTemp);
        if (filename.exists()) {
            paperLog.info(filename + " exist , so delete");
            filename.delete();
        }
        if(filename.exists()){
            paperLog.info("zip delete fail");
        }else {
            paperLog.info("zip delete success");
        }

        String folderNameTemp = zippath + name + "/";
        File folderName = new File(folderNameTemp);
        if (folderName.exists()) {
            paperLog.info(folderName + " exist , so delete");
            folderName.delete();
        }
        if(folderName.exists()){
            paperLog.info("folder delete fail");
        }else {
            paperLog.info("folder delete success");
        }

        paperLog.info("==========delete zip end==========");

    }

    public static void main(String[] args){

    }
}
