package com.ptteng.academy.home.controller;

import com.ptteng.academy.document.model.Hollow;
import com.ptteng.academy.document.service.HollowService;
import com.ptteng.academy.user.model.User;
import com.ptteng.academy.user.service.UserService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * Hollow  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class HollowController {
    private static final Log log = LogFactory.getLog(HollowController.class);

    @Autowired
    private HollowService hollowService;
    @Autowired
    private UserService userService;


    /**
     * @Description 获取最热树叶列表
     * @param
     * @Author: PeiyuFeng
     * @Time 2017/5/2 16:02
     */
    @RequestMapping(value = "/a/u/hollow/list", method = RequestMethod.GET)
    public String getHollowList(HttpServletRequest request, HttpServletResponse response, ModelMap model) throws Exception {

        log.info("get hollow list ");

        try {

            List<Long> hollowIds = hollowService.getPopularHollowIds();
            log.info("get hollow data is " + hollowIds);

            List<Hollow> hollows = hollowService.getObjectsByIds(hollowIds);

            model.addAttribute("code", 0);
            model.addAttribute("hollowList", hollows);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get hollow error");
            model.addAttribute("code", -1);
        }

        return "/academy-document-service/hollow/json/hollowListJson";
    }



    /**
     * @param
     * @Description 随机获取树叶
     * @Author: PeiyuFeng
     * @Time 2017/5/2 15:48
     */
    @RequestMapping(value = "/a/u/hollow/random", method = RequestMethod.GET)
    public String getRandomHollow(HttpServletRequest request, HttpServletResponse response, ModelMap model) throws Exception {

        User user = (User) request.getAttribute("user");
        log.info("user : " + user.getId() + " get random hollow");

        try {

            if(User.HOLLOW_STATUS_NEVER.equals(user.getHollowStatus())){
                user.setHollowStatus(User.HOLLOW_STATUS_USED);
                userService.update(user);
                log.info("user hollow status update to used");
            }else {
                log.info("user have been used hollow");
            }

            Long hollowId = hollowService.getRandomHollowId();
            log.info("get hollow id is " + hollowId);

            Hollow hollow = hollowService.getObjectById(hollowId);
            log.info("get hollow : " + hollow);

            model.addAttribute("code", 0);
            model.addAttribute("hollow", hollow);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get random hollow error");
            model.addAttribute("code", -1);
        }

        return "/academy-document-service/hollow/json/hollowDetailJson";
    }



    /**
     * @Description 新建树叶
     * @param
     * @Author: PeiyuFeng
     * @Time 2017/5/3 11:02
     */
    @RequestMapping(value = "/a/u/hollow", method = RequestMethod.POST)
    public String addPostsJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, String content) throws Exception {

        User user = (User) request.getAttribute("user");
        log.info("user : " + user.getId() + "add hollow : " + content);

        if (content == null) {
            model.addAttribute("code", -1000);
            return "/common/success";
        } else {
            log.info("params verify OK");
        }


        try {
            Hollow hollow = new Hollow();
            hollow.setUid(user.getId());
            hollow.setContent(content);

            log.info("insert hollow : " + hollow);
            hollowService.insert(hollow);
            log.info("insert hollow success");

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add hollow error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }


    /**
     * @Description 点赞
     * @Author: PeiyuFeng
     * @param
     * @Time 2017/5/4 16:58
     */
    @RequestMapping(value = "/a/u/hollow/bump/{id}", method = RequestMethod.PUT)
    public String bump(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {

        User user = (User) request.getAttribute("user");
        log.info("user : " + user.getId() + "bump hollow : " + id);


        try {
            Hollow hollow = hollowService.getObjectById(id);
            if(hollow == null){
                log.info("hollow not exist");
                model.addAttribute("code", -2400);
                return "/common/success";
            }else {
                log.info("get hollow : " + id);
            }

            Integer bump = hollow.getBumpCount();
            hollow.setBumpCount(bump + 1);
            log.info("hollow : " + id + " bump count : " + bump + " >>>>>>>>>> " + hollow.getBumpCount());
            hollowService.update(hollow);
            log.info("bump hollow success");

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("bump hollow error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }



    /**
     * @Description 踩
     * @Author: PeiyuFeng
     * @param
     * @Time 2017/5/4 17:19
     */
    @RequestMapping(value = "/a/u/hollow/down/{id}", method = RequestMethod.PUT)
    public String down(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {

        User user = (User) request.getAttribute("user");
        log.info("user : " + user.getId() + "down hollow : " + id);


        try {
            Hollow hollow = hollowService.getObjectById(id);
            if(hollow == null){
                log.info("hollow not exist");
                model.addAttribute("code", -2400);
                return "/common/success";
            }else {
                log.info("get hollow : " + id);
            }

            Integer down = hollow.getDownCount();
            hollow.setDownCount(down + 1);
            log.info("hollow : " + id + " down count : " + down + " >>>>>>>>>> " + hollow.getDownCount());
            hollowService.update(hollow);
            log.info("down hollow success");

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("down hollow error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }




    /**
     * @param
     * @Description 随机获取6片树叶（由于ios端公众号不能正确获取相应的树叶，故新增此接口）
     * @Author: sx
     * @Time 2017/7/21 15:48
     */
    @RequestMapping(value = "/a/u/hollow/randomlist", method = RequestMethod.GET)
    public String getSixRandomHollow(HttpServletRequest request, HttpServletResponse response, ModelMap model) throws Exception {

        User user = (User) request.getAttribute("user");
        log.info("user : " + user.getId() + " get random hollow");

        try {

            if(User.HOLLOW_STATUS_NEVER.equals(user.getHollowStatus())){
                user.setHollowStatus(User.HOLLOW_STATUS_USED);
                userService.update(user);
                log.info("user hollow status update to used");
            }else {
                log.info("user have been used hollow");
            }

            List<Long> sixIdsList = new ArrayList<>();

            List<Long> idList = hollowService.getHollowIds(0,Integer.MAX_VALUE);
            log.info("idList.size() is:" + idList.size());

            for(int i=0;i<6;i++) {
                if(idList.isEmpty()){
                    return  "common/success";
                }else {
                    //随机取一个下标
                    int index = (int) (Math.random() * (idList.size()));
                    Long id = idList.get(index);
                    log.info("id is :" + id);
                    sixIdsList.add(id);
                    idList.remove(index);
                    }
            }
//            List<Long> hollowIdList = hollowService.getSixRandomHollowIds();
            log.info("get hollow ids are " + sixIdsList);

            List<Hollow> hollowList = hollowService.getObjectsByIds(sixIdsList);

            log.info("get hollow.size : " + hollowList.size());

            model.addAttribute("code", 0);
            model.addAttribute("hollowList", hollowList);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get random hollowList error");
            model.addAttribute("code", -1);
        }

        return "/academy-document-service/hollow/json/hollowListJson";
    }

}