package com.ptteng.academy.home.controller;

import com.ptteng.academy.document.model.UserFavoriteRelation;
import com.ptteng.academy.document.model.Video;
import com.ptteng.academy.document.service.UserFavoriteRelationService;
import com.ptteng.academy.document.service.VideoService;
import com.ptteng.academy.home.util.DynamicUtil;
import com.ptteng.academy.user.model.User;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * Video  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class VideoController {
	private static final Log log = LogFactory.getLog(VideoController.class);

	@Autowired
	private VideoService videoService;

	@Autowired
	private UserFavoriteRelationService userFavoriteRelationService;


	/**
	 * @Description 查看视频详情
	 * @param id 视频id
	 * @Author: PeiyuFeng
	 * @Time 2017/3/17 12:57
	 */
	@RequestMapping(value = "/a/u/video/{id}", method = RequestMethod.GET)
	public String getShareLessonJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {

		if (id == null) {
			model.addAttribute("code", -1000);
			return "/common/success";
		}

		User user = (User) request.getAttribute("user");
		Long uid = user.getId();
		log.info("get uid " + uid);

		log.info("get data : id= " + id);

		Boolean collectionStatus = false;
		Boolean likeStatus = false;

		try {

			Video video = videoService.getObjectById(id);

			if (video == null) {
				model.addAttribute("code", -2106);
				return "/common/success";
			}else {
				Integer readCount = video.getRead_count();
				video.setRead_count(readCount + 1);
				log.info("document " + id + " read count : " + readCount + " >>>>>>>>>> " + video.getRead_count());
				videoService.update(video);
			}

			//用户收藏状态
			Long collectionRelationId = userFavoriteRelationService.getUserFavoriteRelationIdByTargetIdAndUidAndTargetTypeAndTypeAndStatus
					(id, uid, UserFavoriteRelation.TARGET_TYPE_VIDEO, UserFavoriteRelation.TYPE_COLLECTION, UserFavoriteRelation.STATUS_ACTIVE);
			if(null == collectionRelationId){
				log.info("no collection relation");
			}else {
				log.info("collection relation id : " + id);
				collectionStatus = true;
			}
			//用户点赞状态
			Long likeRelationId = userFavoriteRelationService.getUserFavoriteRelationIdByTargetIdAndUidAndTargetTypeAndTypeAndStatus
					(id, uid, UserFavoriteRelation.TARGET_TYPE_VIDEO, UserFavoriteRelation.TYPE_LIKE, UserFavoriteRelation.STATUS_ACTIVE);
			if(null == likeRelationId){
				log.info("no like relation");
			}else {
				log.info("like relation id : " + id);
				likeStatus = true;
			}

			model.addAttribute("code", 0);
			model.addAttribute("video", video);
			model.addAttribute("collectionStatus", collectionStatus);
			model.addAttribute("likeStatus", likeStatus);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get video error,id is  " + id);
			model.addAttribute("code", -1);
		}

		return "/academy-document-service/video/json/videoDetailJson";
	}

	/**
	 * @Description 查看视频列表
	 * @param type 视频类型
	 * @param title 视频标题
	 * @Author: PeiyuFeng
	 * @Time 2017/3/17 12:58
	 */
	@RequestMapping(value = "/a/u/video/list", method = RequestMethod.GET)
	public String getDocumentList(HttpServletRequest request, HttpServletResponse response, ModelMap model,
								  Integer page, Integer size, Integer type, String title, Integer grade, Integer subject) throws Exception {

		log.info("get video list type is" + type + " title is " + title);

		List<Long> videoIds = new ArrayList<>();
		List<Long> count = new ArrayList<>();

		Integer total = null;
		if (page == null) {
			page = 1;
		}
		if (size == null || size == 0) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);
		User user = (User) request.getAttribute("user");
		Long uid = user.getId();
		try {
			Map<String, Object> param = DynamicUtil.getVideoList(type, title, grade, subject);
			log.info("param is " + param);
			videoIds = videoService.getIdsByDynamicCondition(Video.class, param, start, size);
			count = videoService.getIdsByDynamicCondition(Video.class, param, 0, Integer.MAX_VALUE);
			total = count.size();
			log.info("total size " + total);

			if (videoIds != null && videoIds.size() > 0) {

				log.info("get article list ids is" + videoIds);
				List<Video> videoList = videoService.getObjectsByIds(videoIds);
				model.addAttribute("videoList", videoList);
			}

			Boolean next = false;
			Integer nex = start + size;

			if (total > nex) {
				next = true;
			}

			Integer totalPage = 1;
			if (total > 0) {
				totalPage = (total - 1) / size + 1;
			}
			model.addAttribute("total", total);
			model.addAttribute("totalPage", totalPage);
			model.addAttribute("size", size);
			model.addAttribute("code", 0);
			model.addAttribute("next", next);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get video list error,page is  " + start + " , size " + size);

			model.addAttribute("code", -1);
		}

		return "/academy-document-service/video/json/videoListJson";
	}



	@RequestMapping(value = "/a/u/subject/list", method = RequestMethod.GET)
	public String getSubjectList(HttpServletRequest request, HttpServletResponse response, ModelMap model) throws Exception {

		log.info("get subject list");

		List<Long> ids = new ArrayList<Long>(){{
			add(1L);
			add(2L);
			add(3L);
			add(4L);
			add(5L);
			add(6L);
			add(7L);
			add(8L);
			add(9L);
		}
		};
		Map<Long, String> id_subject = new HashMap<>();
		User user = (User) request.getAttribute("user");
		Long uid = user.getId();
		try {

			id_subject.put(1L , "语文");
			id_subject.put(2L , "数学");
			id_subject.put(3L , "英语");
			id_subject.put(4L , "物理");
			id_subject.put(5L , "化学");
			id_subject.put(6L , "生物");
			id_subject.put(7L , "历史");
			id_subject.put(8L , "地理");
			id_subject.put(9L , "政治");

			//查询科目下是否有视频
			Map<Long, String> haveVideo = new HashMap<>();

			for(int i=1;i<=9;i++){
				Map<String, Object> params = DynamicUtil.getSubjectVideoStatus(i);
				log.info(params);
				List<Long> total = videoService.getIdsByDynamicCondition(Video.class,params,0,Integer.MAX_VALUE);
				log.info("videoIds  are" + total);
				if(total.get(0)>0){
					haveVideo.put(Long.valueOf(i),"1");
				}else {
					haveVideo.put(Long.valueOf(i), "2");
				}
			}
			model.addAttribute("code", 0);
			model.addAttribute("ids", ids);
			model.addAttribute("id_subject", id_subject);
			model.addAttribute("haveVideo", haveVideo);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get subject list error");

			model.addAttribute("code", -1);
		}

		return "/academy-document-service/video/json/subjectListJson";
	}




}

