package com.ptteng.academy.home.controller;

import com.gemantic.common.util.MyListUtil;
import com.ptteng.academy.document.model.Posts;
import com.ptteng.academy.document.model.Reply;
import com.ptteng.academy.document.service.PostsService;
import com.ptteng.academy.document.service.ReplyService;
import com.ptteng.academy.user.model.User;
import com.ptteng.academy.user.service.UserService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.mapping.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * Posts  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class PostsController {
	private static final Log log = LogFactory.getLog(PostsController.class);

	public static final Integer SORT_DESC = 1;
	public static final Integer SORT_ASC = 2;

	@Autowired
	private PostsService postsService;
	@Autowired
	private UserService userService;
	@Autowired
	private ReplyService replyService;


	/**
	 * @Description 置顶帖列表
	 * @param
	 * @Author: PeiyuFeng
	 * @Time 2017/5/2 11:46
	 */
	@RequestMapping(value = "/a/u/post/sticky/list", method = RequestMethod.GET)
	public String getStickyPostList(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer grade) throws Exception {

		log.info("get grade : " + grade + " sticky post list ");

		try {
			if(grade == null){
				model.addAttribute("code", -2304);
				return "/common/success";
			}

			List<Long> ids= postsService.getStickyPostsIdsByGradeOrderByStickyAt(grade);
			log.info("get sticky post is " + ids);

			List<Posts> postsList = postsService.getObjectsByIds(ids);
			log.info("get posts data is " + postsList.size());

			model.addAttribute("code", 0);
			model.addAttribute("postsList", postsList);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get grade : " + grade + " posts list error");
			// for test
			model.addAttribute("code", -1);
		}

		return "/academy-document-service/posts/json/postsListJson";
	}



	/**
	 * @Description 精华帖列表
	 * @param
	 * @Author: PeiyuFeng
	 * @Time 2017/5/2 12:07
	 */
		@RequestMapping(value = "/a/u/post/digest/list", method = RequestMethod.GET)
	public String getDigestPostList(HttpServletRequest request, HttpServletResponse response, ModelMap model,
									Integer page, Integer size, Integer grade) throws Exception {


		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("get grade " + grade + " digest post : page= " + start + " , size=" + size);

		try {

			if(grade == null){
				model.addAttribute("code", -2304);
				return "/common/success";
			}

			List<Long> ids= postsService.getDigestPostsIdsByGradeOrderByDigestAt(grade,start,size);
			log.info("get digest post is " + ids);

			List<Posts> postsList = postsService.getObjectsByIds(ids);
			log.info("get digest posts data is " + postsList.size());

			Integer total = postsService.countDigestPostsIdsByGradeOrderByDigestAt(grade);
			log.info("get digest posts count is " + total);

			//获取用户名
			List<Long> uids = MyListUtil.getFieldValueListFromModelList(postsList, false, Posts.class.getDeclaredField("uid"));
			List<User> users = userService.getObjectsByIds(uids);
			Map<Long,String> uid_alias = MyListUtil.convert2Map(User.class.getDeclaredField("id"), User.class.getDeclaredField("alias"), users);
			Map<Long,String> uid_img = MyListUtil.convert2Map(User.class.getDeclaredField("id"), User.class.getDeclaredField("img"), users);
			log.info("uid_alias : " + uid_alias);
			log.info("uid_img : " + uid_img);

			model.addAttribute("uid_alias", uid_alias);
			model.addAttribute("uid_img", uid_img);

			Boolean next = false;
			Integer nex = start + size;

			if (total > nex) {
				next = true;
			}

			Integer totalPage = 1;
			if (total > 0) {
				totalPage = (total - 1) / size + 1;
			}

			model.addAttribute("code", 0);
			model.addAttribute("next", next);
			model.addAttribute("totalPage", totalPage);
			model.addAttribute("postsList", postsList);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get posts list error,page is  " + start + " , size " + size);
			// for test
			model.addAttribute("code", -1);
		}

		return "/academy-document-service/posts/json/postsListJson";
	}


	/**
	 * @Description 帖子列表
	 * @param
	 * @Author: PeiyuFeng
	 * @Time 2017/5/2 12:23
	 */
	@RequestMapping(value = "/a/u/post/list", method = RequestMethod.GET)
	public String getPostsJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer grade, Integer page, Integer size)
			throws Exception {

		log.info("get grade : " + grade + " post list ");

		if (page == null) {
			page = 1;
		}
		if (size == null || size == 0) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		try {

			if(grade == null){
				model.addAttribute("code", -2304);
				return "/common/success";
			}

			List<Long> postIds = postsService.getNormalPostsIdsByGradeOrderByCreateAt(grade, start, size);
			log.info("get postIds : " + postIds);
			Integer total = postsService.countNormalPostsIdsByGradeOrderByCreateAt(grade);
			log.info("total size " + total);

			if (postIds != null && postIds.size() > 0) {

				log.info("get post list ids is" + postIds);
				List<Posts> postList = postsService.getObjectsByIds(postIds);

				//获取用户名
				List<Long> uids = MyListUtil.getFieldValueListFromModelList(postList, false, Posts.class.getDeclaredField("uid"));
				List<User> users = userService.getObjectsByIds(uids);
				Map<Long,String> uid_alias = MyListUtil.convert2Map(User.class.getDeclaredField("id"), User.class.getDeclaredField("alias"), users);
				Map<Long,String> uid_img = MyListUtil.convert2Map(User.class.getDeclaredField("id"), User.class.getDeclaredField("img"), users);
				log.info("uid_alias : " + uid_alias);
				log.info("uid_img : " + uid_img);

				model.addAttribute("postsList", postList);
				model.addAttribute("uid_alias", uid_alias);
				model.addAttribute("uid_img", uid_img);
			}

			Boolean next = false;
			Integer nex = start + size;

			if (total > nex) {
				next = true;
			}

			Integer totalPage = 1;
			if (total > 0) {
				totalPage = (total - 1) / size + 1;
			}
			model.addAttribute("totalPage", totalPage);
			model.addAttribute("code", 0);
			model.addAttribute("next", next);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get posts error");
			model.addAttribute("code", -1);
		}

		return "/academy-document-service/posts/json/postsListJson";
	}

	/**
	 * @Description 用户帖子列表
	 * @param
	 * @Author: PeiyuFeng
	 * @Time 2017/5/2 13:44
	 */
	@RequestMapping(value = "/a/u/posts/user/list", method = RequestMethod.GET)
	public String userPostList(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer page, Integer size) throws Exception {

		User user = (User) request.getAttribute("user");

		log.info("get user : " + user.getId() + " post list ");

		if (page == null) {
			page = 1;
		}
		if (size == null || size == 0) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		try {
			List<Long> postIds = postsService.getPostsIdsByUidOrderByCreateAt(user.getId(), start, size);
			log.info("get postIds : " + postIds);
			Integer total = postsService.countPostsIdsByUidOrderByCreateAt(user.getId());
			log.info("total size " + total);

			if (postIds != null && postIds.size() > 0) {

				log.info("get post list ids is" + postIds);
				List<Posts> postList = postsService.getObjectsByIds(postIds);

				//获取用户名
				List<Long> uids = MyListUtil.getFieldValueListFromModelList(postList, false, Posts.class.getDeclaredField("uid"));
				List<User> users = userService.getObjectsByIds(uids);
				Map<Long,String> uid_alias = MyListUtil.convert2Map(User.class.getDeclaredField("id"), User.class.getDeclaredField("alias"), users);
				Map<Long,String> uid_img = MyListUtil.convert2Map(User.class.getDeclaredField("id"), User.class.getDeclaredField("img"), users);
				log.info("uid_alias : " + uid_alias);
				log.info("uid_img : " + uid_img);

				model.addAttribute("postsList", postList);
				model.addAttribute("uid_alias", uid_alias);
				model.addAttribute("uid_img", uid_img);

			}

			Boolean next = false;
			Integer nex = start + size;

			if (total > nex) {
				next = true;
			}

			Integer totalPage = 1;
			if (total > 0) {
				totalPage = (total - 1) / size + 1;
			}
			model.addAttribute("totalPage", totalPage);
			model.addAttribute("code", 0);
			model.addAttribute("next", next);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get posts error");
			model.addAttribute("code", -1);
		}

		return "/academy-document-service/posts/json/postsListJson";
	}


	/**
	 * @Description 发帖
	 * @param
	 * @Author: PeiyuFeng
	 * @Time 2017/5/2 13:59
	 */
	@RequestMapping(value = "/a/u/post", method = RequestMethod.POST)
	public String addPostsJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, Posts posts) throws Exception {

		User user = (User) request.getAttribute("user");
		log.info("user : " + user.getId() + "add posts : posts= " + posts);

		if (posts == null) {
			model.addAttribute("code", -1000);
			return "/common/success";
		}

		if (posts.getTitle() == null || posts.getGrade() == null || posts.getContent() == null ) {
			model.addAttribute("code", -1000);
			return "/common/success";
		} else {
			log.info("params verify OK");
		}

		try {

			posts.setId(null);
			posts.setUid(user.getId());
			posts.setDigest(Posts.NOT_DIGEST);
			posts.setSticky(Posts.NOT_STICKY);
			posts.setDigestAt(null);
			posts.setStickyAt(null);
			posts.setReadCount(0);
			posts.setRepliesCount(0);
			posts.setDeleteStatus(null);

			log.info("insert posts : " + posts);
			postsService.insert(posts);
			log.info("insert posts success");

			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add posts error ");
			model.addAttribute("code", -1);
		}

		return "/common/success";
	}



	/**
	 * @Description 帖子删除
	 * @param
	 * @Author: PeiyuFeng
	 * @Time 2017/4/28 16:18
	 */
	@RequestMapping(value = "/a/u/post/{id}", method = RequestMethod.DELETE)
	public String deletePost(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {

		User user = (User) request.getAttribute("user");

		log.info("delete post : " + id);

		try {
			Posts post = postsService.getObjectById(id);

			if (null == post) {
				model.addAttribute("code", -2300);
				return "/common/success";
			} else {
				log.info("get post : " + post);
			}

			if(user.getId().equals(post.getUid())){
				log.info("post : " + id + " belong to user : " + user.getId());
			}else {
				model.addAttribute("code", -2303);
				return "/common/success";
			}

			postsService.delete(id);

			List<Long> rids = replyService.getReplyIdsByPidOrderByFloor(id, 0, Integer.MAX_VALUE);
			replyService.deleteList(Reply.class, rids);
			log.info("delete post " + id + " success");

			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete post error");
			model.addAttribute("code", -1);
		}

		return "/common/success";
	}


	/**
	 * @Description 获取帖子回复列表
	 * @param
	 * @Author: PeiyuFeng
	 * @Time 2017/4/27 16:07
	 */
	@RequestMapping(value = "/a/u/reply/list/{id}", method = RequestMethod.GET)
	public String getReplyList(HttpServletRequest request, HttpServletResponse response, ModelMap model,
							   Integer page, Integer size, @PathVariable Long id, Integer sort) throws Exception {

		log.info("get post " + id + " reply list ");

		Integer total = null;
		if (page == null) {
			page = 1;
		}
		if (size == null || size == 0) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {

			Posts post = postsService.getObjectById(id);

			if (post == null) {
				log.info("post don't exist");
				model.addAttribute("code", -2300);
				return "/common/success";
			}else {

			}

			List<Long> replyIds = new ArrayList<>();
			if(SORT_DESC.equals(sort)){
				replyIds = replyService.getReplyIdsByPidOrderByFloorDesc(id, start, size);
			}else {
				replyIds = replyService.getReplyIdsByPidOrderByFloor(id, start, size);
			}

			total = replyService.countReplyIdsByPidOrderByFloor(id);
			log.info("total size " + total);

			if (replyIds != null && replyIds.size() > 0) {

				log.info("get post reply list ids is" + replyIds);
				List<Reply> replyList = replyService.getObjectsByIds(replyIds);

				List<Long> uids = MyListUtil.getFieldValueListFromModelList(replyList, false, Reply.class.getDeclaredField("uid"));
				List<User> users = userService.getObjectsByIds(uids);
				Map<Long,String> uid_alias = MyListUtil.convert2Map(User.class.getDeclaredField("id"), User.class.getDeclaredField("alias"), users);
				Map<Long,String> uid_img = MyListUtil.convert2Map(User.class.getDeclaredField("id"), User.class.getDeclaredField("img"), users);

				for(Reply reply : replyList){
					if(Reply.DELETE_STATUS_DELETED.equals(reply.getDeleteStatus())){
						reply.setContent("");
					}
				}

				model.addAttribute("replyList", replyList);
				model.addAttribute("uid_alias", uid_alias);
				model.addAttribute("uid_img", uid_img);
			}

			Boolean next = false;
			Integer nex = start + size;

			if (total > nex) {
				next = true;
			}

			Integer totalPage = 1;
			if (total > 0) {
				totalPage = (total - 1) / size + 1;
			}
			model.addAttribute("total", total);
			model.addAttribute("totalPage", totalPage);
			model.addAttribute("size", size);
			model.addAttribute("code", 0);
			model.addAttribute("next", next);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get post list error,page is  " + start + " , size " + size);

			model.addAttribute("code", -1);
		}

		return "/academy-document-service/reply/json/replyListJson";
	}



	/**
	 * @Description 删除帖子回复
	 * @param
	 * @Author: PeiyuFeng
	 * @Time 2017/4/28 17:57
	 */
	@RequestMapping(value = "/a/u/reply/{id}", method = RequestMethod.DELETE)
	public String deleteReply(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {

		User user = (User) request.getAttribute("user");
		log.info("delete reply : " + id);

		try {
			Reply reply = replyService.getObjectById(id);

			if (null == reply) {
				model.addAttribute("code", -2302);
				return "/common/success";
			} else {
				log.info("get reply : " + reply);
			}

			Posts post = postsService.getObjectById(reply.getPid());
			if (null == post) {
				model.addAttribute("code", -2300);
				return "/common/success";
			} else {
				log.info("get reply : " + reply);
			}

			if(user.getId().equals(reply.getUid()) || user.getId().equals(post.getUid())){
				log.info("reply : " + id + " belong to user : " + user.getId());
			}else {
				model.addAttribute("code", -2303);
				return "/common/success";
			}

			reply.setDeleteStatus(Reply.DELETE_STATUS_DELETED);

			replyService.update(reply);
			log.info("delete reply " + id + " success");

			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete reply error");
			model.addAttribute("code", -1);
		}

		return "/common/success";
	}



	/**
	 * @Description 回复帖子
	 * @param
	 * @Author: PeiyuFeng
	 * @Time 2017/5/2 13:59
	 */
	@RequestMapping(value = "/a/u/reply/{id}", method = RequestMethod.POST)
	public String addReplyJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, Reply reply, @PathVariable Long id) throws Exception {

		User user = (User) request.getAttribute("user");
		log.info("user : " + user.getId() + "add reply : reply = " + reply);

		if (reply == null) {
			model.addAttribute("code", -1000);
			return "/common/success";
		}

		if (reply.getContent() == null) {
			model.addAttribute("code", -1000);
			return "/common/success";
		} else {
			log.info("params verify OK");
		}

		try {

			Posts posts = postsService.getObjectById(id);
			if(posts == null){
				log.info("post don't exist");
				model.addAttribute("code", -2300);
				return "/common/success";
			}else {
				log.info(" get post " + id + " success");
			}

			Integer floor = 0;
			List<Long> replyIds = replyService.getReplyIdsByPidOrderByFloor(id, 0, Integer.MAX_VALUE);
			if(CollectionUtils.isNotEmpty(replyIds)){
				Long lastReplyId = replyIds.get(replyIds.size()-1);
				Reply lastReply = replyService.getObjectById(lastReplyId);
				floor = lastReply.getFloor();
			}

			reply.setId(null);
			reply.setUid(user.getId());
			reply.setPid(id);
			reply.setDeleteStatus(Reply.DELETE_STATUS_NORMAL);
			reply.setFloor(floor+1);

			log.info("insert posts : " + reply);
			replyService.insert(reply);
			log.info("insert reply success");

			posts.setReplyStatus(Posts.REPLY);
			Integer repliesCount = posts.getRepliesCount();
			posts.setRepliesCount(repliesCount + 1);

			//施星，设置发帖人用户帖子回复状态为未读
		/*	User postUser = userService.getObjectById(posts.getUid());
			postUser.setPoststatus(User.POST_UNREAD);
			userService.update(postUser);*/


			log.info("post : " + id + " read count " + repliesCount + " >>>>>>>>>> " + posts.getRepliesCount());
			postsService.update(posts);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("add reply error ");
			model.addAttribute("code", -1);
		}

		return "/common/success";
	}



	/**
	 * @Description 帖子详情
	 * @param
	 * @Author: PeiyuFeng
	 * @Time 2017/4/24 18:17
	 */
	@RequestMapping(value = "/a/u/post/{id}", method = RequestMethod.GET)
	public String getPost(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {

		if (id == null) {
			model.addAttribute("code", -1000);
			return "/common/success";
		}

		User user = (User) request.getAttribute("user");

		log.info("user : " + user.getId() + "  get post data : id= " + id);

		try {

			Posts post = postsService.getObjectById(id);

			if (post == null) {
				log.info("post don't exist");
				model.addAttribute("code", -2300);
				return "/common/success";
			}

			String author = "";
			String img = "";
			User postUser = userService.getObjectById(post.getUid());
			if(postUser == null){
				log.info("user don't exist");
				model.addAttribute("code", -2301);
				return "/common/success";
			}else {
				author = postUser.getAlias();
				img = postUser.getImg();
			}

			//作者获取帖子详情时将帖子回复状态更新为无新回复
			if(postUser.getId().equals(user.getId())){
				log.info("author read the post");
				post.setReplyStatus(Posts.NO_REPLY);
				postsService.update(post);
			}

			//施星，查看帖子详情更改楼主的帖子信息poststatus
//			if(postUser.getId().equals(user.getId()) || ){
//			user.setPoststatus(User.POST_READ);
//			userService.update(user);


			Integer readCount = post.getReadCount();
			post.setReadCount(readCount + 1);
			log.info("post : " + id + " read count " + readCount + " >>>>>>>>>> " + post.getReadCount());
			postsService.update(post);

			model.addAttribute("code", 0);
			model.addAttribute("img", img);
			model.addAttribute("posts", post);
			model.addAttribute("author", author);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get document error,id is  " + id);
			model.addAttribute("code", -1);
		}

		return "/academy-document-service/posts/json/postsDetailJson";
	}


	/**
	 * @Description 查看其它用户帖子
	 * @Author: PeiyuFeng
	 * @param
	 * @Time 2017/5/5 10:03
	 */
	@RequestMapping(value = "/a/u/posts/user/list/{id}", method = RequestMethod.GET)
	public String otherUserPostList(HttpServletRequest request, HttpServletResponse response, ModelMap model,
									@PathVariable Long id, Integer page, Integer size) throws Exception {

		log.info("get user : " + id + " post list ");

		if (page == null) {
			page = 1;
		}
		if (size == null || size == 0) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		try {
			List<Long> postIds = postsService.getPostsIdsByUidOrderByCreateAt(id, start, size);
			log.info("get postIds : " + postIds);
			Integer total = postsService.countPostsIdsByUidOrderByCreateAt(id);
			log.info("total size " + total);

			if (postIds != null && postIds.size() > 0) {

				log.info("get post list ids is" + postIds);
				List<Posts> postList = postsService.getObjectsByIds(postIds);

				//获取用户名
				List<Long> uids = MyListUtil.getFieldValueListFromModelList(postList, false, Posts.class.getDeclaredField("uid"));
				List<User> users = userService.getObjectsByIds(uids);
				Map<Long,String> uid_alias = MyListUtil.convert2Map(User.class.getDeclaredField("id"), User.class.getDeclaredField("alias"), users);
				Map<Long,String> uid_img = MyListUtil.convert2Map(User.class.getDeclaredField("id"), User.class.getDeclaredField("img"), users);
				log.info("uid_alias : " + uid_alias);
				log.info("uid_img : " + uid_img);

				model.addAttribute("postsList", postList);
				model.addAttribute("uid_alias", uid_alias);
				model.addAttribute("uid_img", uid_img);

			}

			Boolean next = false;
			Integer nex = start + size;

			if (total > nex) {
				next = true;
			}

			Integer totalPage = 1;
			if (total > 0) {
				totalPage = (total - 1) / size + 1;
			}
			model.addAttribute("totalPage", totalPage);
			model.addAttribute("code", 0);
			model.addAttribute("next", next);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get posts error");
			model.addAttribute("code", -1);
		}

		return "/academy-document-service/posts/json/postsListJson";
	}

}

