package com.ptteng.academy.goods.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.academy.goods.model.Goods;
import com.ptteng.common.dao.BaseDaoService;
import org.osoa.sca.annotations.Remotable;

import java.util.List;
import java.util.Map;

@Remotable
public interface GoodsService extends BaseDaoService {


	

		//jdbcTemplate查询
		public List<Map<String,Object>> getCountByDynamicConditionByDynamicCondition(Map<String, Object> condition, Integer start, Integer size);

   		   
		
		public Long insert(Goods goods)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Goods> insertList(List<Goods> goodsList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(Goods goods)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<Goods> goodsList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public Goods getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Goods> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


				
	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getGoodsIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countGoodsIds() throws ServiceException, ServiceDaoException;
	

}

