/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.academy.document.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.academy.document.model.Document;
import com.ptteng.academy.document.service.DocumentService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DocumentServiceImpl
extends BaseDaoServiceImpl
implements DocumentService {
    private static final Log log = LogFactory.getLog(DocumentServiceImpl.class);

    public Long insert(Document document) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + document));
        if (document == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        document.setCreateAt(Long.valueOf(currentTimeMillis));
        document.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)document);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + document));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Document> insertList(List<Document> documentList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (documentList == null ? "null" : Integer.valueOf(documentList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(documentList)) {
            return new ArrayList<Document>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Document document : documentList) {
            document.setCreateAt(Long.valueOf(currentTimeMillis));
            document.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(documentList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + documentList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Document.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Document document) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (document == null ? "null" : document.getId())));
        boolean result = false;
        if (document == null) {
            return true;
        }
        document.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)document);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + document));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + document));
        }
        return result;
    }

    public boolean updateList(List<Document> documentList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (documentList == null ? "null" : Integer.valueOf(documentList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(documentList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Document document : documentList) {
            document.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(documentList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + documentList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + documentList.size()));
        return result;
    }

    public Document getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Document document = null;
        if (id == null) {
            return document;
        }
        try {
            document = (Document)this.dao.get(Document.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return document;
    }

    public List<Document> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List document = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Document>();
        }
        try {
            document = this.dao.getList(Document.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (document == null ? "null" : Integer.valueOf(document.size()))));
        return document;
    }

    public List<Long> getDocumentIdsByStatusAndTypeOrderByUpdateAt(Integer status, Integer type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by status,type,start,limit  : " + status + " , " + type + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getDocumentIdsByStatusAndTypeOrderByUpdateAt", new Object[]{status, type}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by status,type,start,limit)  : " + status + " , " + type + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countDocumentIdsByStatusAndTypeOrderByUpdateAt(Integer status, Integer type) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by status,type  : " + status + " , " + type));
        }
        Integer count = null;
        try {
            count = this.dao.count("getDocumentIdsByStatusAndTypeOrderByUpdateAt", new Object[]{status, type});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by status,type)  : " + status + " , " + type));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getDocumentIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getDocumentIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countDocumentIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getDocumentIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getDocumentIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

