package com.ptteng.academy.document.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.academy.document.model.Posts;
import com.ptteng.common.dao.BaseDaoService;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface PostsService extends BaseDaoService {

	



   		   
		
		public Long insert(Posts posts)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Posts> insertList(List<Posts> postsList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(Posts posts)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<Posts> postsList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public Posts getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Posts> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


			
			
	/**
	 * @Description 统计加精贴数量
	 * @param
	 * @Author: PeiyuFeng
	 * @Time 2017/5/2 13:33
	 */
	public Integer  countDigestPostsIdsByGradeOrderByDigestAt(Integer grade)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * @Description 统计普通帖数量
	 * @param
	 * @Author: PeiyuFeng
	 * @Time 2017/5/2 13:33
	 */
	public Integer  countNormalPostsIdsByGradeOrderByCreateAt(Integer grade)throws ServiceException, ServiceDaoException;

			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countPostsIdsByUidOrderByCreateAt(Long uid)throws ServiceException, ServiceDaoException;
					
			
	/**
	 * @Description 获取精华帖列表
	 * @param
	 * @Author: PeiyuFeng
	 * @Time 2017/5/2 12:11
	 */
	public List<Long>  getDigestPostsIdsByGradeOrderByDigestAt(Integer grade, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * @Description 获取普通帖列表
	 * @param
	 * @Author: PeiyuFeng
	 * @Time 2017/5/2 13:29
	 */
	public List<Long>  getNormalPostsIdsByGradeOrderByCreateAt(Integer grade, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * @Description 获取置顶帖列表
	 * @param
	 * @Author: PeiyuFeng
	 * @Time 2017/5/2 13:24
	 */
	public List<Long>  getStickyPostsIdsByGradeOrderByStickyAt(Integer grade)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * @Description 获取用户帖列表
	 * @param
	 * @Author: PeiyuFeng
	 * @Time 2017/5/2 13:29
	 */
	public List<Long>  getPostsIdsByUidOrderByCreateAt(Long uid, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 * @Description 计算各板块帖子数量
	 * @param
	 * @Author: PeiyuFeng
	 * @Time 2017/5/2 10:25
	 */
	public Integer  countPostsIdsByGrade(Integer grade)throws ServiceException, ServiceDaoException;





	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getPostsIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countPostsIds() throws ServiceException, ServiceDaoException;
	

}

