package com.ptteng.academy.course.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.academy.course.model.User;
import com.ptteng.common.dao.BaseDaoService;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface UserService extends BaseDaoService {


    public Long insert(User user) throws ServiceException, ServiceDaoException;


    public List<User> insertList(List<User> userList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(User user) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<User> userList) throws ServiceException, ServiceDaoException;


    public User getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<User> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    public List<Long> getUserIdsByStudyList(Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    public Long getUserIdByMobile(String mobile) throws ServiceException, ServiceDaoException;

    public Long getUserIdByMail(String mail) throws ServiceException, ServiceDaoException;

    public Long getUserIdByInvitationCode(String invitationCode) throws ServiceException, ServiceDaoException;

    public List<Long> getUserIdByRecommendId(Long recommendId, Integer start, Integer size) throws ServiceException, ServiceDaoException;

    public Integer countUserIdByRecommendId(Long recommendId) throws ServiceException, ServiceDaoException;

    public List<Long> getUserIdByGrade(Integer grade) throws ServiceException, ServiceDaoException;


    public List<Long> getUserIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    public Integer countUserIds() throws ServiceException, ServiceDaoException;


}

