package com.ptteng.academy.course.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.academy.course.model.Subject;
import com.ptteng.common.dao.BaseDaoService;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface SubjectService extends BaseDaoService {


    public Long insert(Subject subject) throws ServiceException, ServiceDaoException;


    public List<Subject> insertList(List<Subject> subjectList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(Subject subject) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<Subject> subjectList) throws ServiceException, ServiceDaoException;


    public Subject getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<Subject> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getSubjectIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    //
//	/**
//	 *
//	 * @param
//	 * @return
//	 * @throws ServiceException
//	 * @throws ServiceDaoException
//	 */
    public List<Long> getSubjectIdsByStatus(Integer status, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * 根据科目名称搜科目
     *
     * @param start
     * @param limit
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getSubjectIdsByName(String name, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    public List<Long> getSubjectIdsOrderBySort(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;


    public List<Long> getSubjectIdsByStatusOrderBySort(Integer status, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    public List<Long> getSubjectIdsByStatusAndGradeDeptOrderBySort(Integer status, Integer gradeDept, Integer start, Integer limit) throws ServiceDaoException;

}

