package com.ptteng.academy.course.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.academy.course.model.Introduce;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface IntroduceService extends BaseDaoService {

	



   		   
		
		public Long insert(Introduce introduce)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Introduce> insertList(List<Introduce> introduceList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(Introduce introduce)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<Introduce> introduceList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public Introduce getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Introduce> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;



		public List<Long> getIdsByLessonId(Long lessonId)throws ServiceException, ServiceDaoException;

    	
	


			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countIntroduceIdsByLevel(Integer level)throws ServiceException, ServiceDaoException;
					
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getIntroduceIdsByLevel(Integer level, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
		
	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getIntroduceIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countIntroduceIds() throws ServiceException, ServiceDaoException;
	

}

