package com.ptteng.academy.course.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;


@Entity
@Table(name = "lesson")
public class Lesson implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 1584522328531636224L;

    public static final Integer status_normal = 1;
    public static final Integer status_freeze = 2;

    public static final Integer not_lock = 0;
    public static final Integer is_lock = 1;

    private Long id;

    private String lessonName;

    private String introText;

    private Long subjectId;

    private String frontCoverURL;

    private String appCoverURL;

    private Integer sort;

    private Integer isLock;

    private BigDecimal price;

    private BigDecimal iosPrice;

    //上下架状态
    private Integer status = Lesson.status_freeze;

    private String subjectName;

    private Integer grade;

    private Integer gradeDept;

    private Long createBy;

    private Long updateBy;

    private Long updateAt;

    private Long createAt;

    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "lesson_name")
    public String getLessonName() {
        return lessonName;
    }

    public void setLessonName(String lessonName) {
        this.lessonName = lessonName;
    }

    @Column(name = "subject_id")
    public Long getSubjectId() {
        return subjectId;
    }

    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    @Column(name = "front_cover_url")
    public String getFrontCoverURL() {
        return frontCoverURL;
    }

    public void setFrontCoverURL(String frontCoverURL) {
        this.frontCoverURL = frontCoverURL;
    }

    @Column(name = "app_cover_url")
    public String getAppCoverURL() {
        return appCoverURL;
    }

    public void setAppCoverURL(String appCoverURL) {
        this.appCoverURL = appCoverURL;
    }

    @Column(name = "sort")
    public Integer getSort() {
        return sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    @Transient
    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }


    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    @Column(name = "grade")
    public Integer getGrade() {
        return grade;
    }

    public void setGrade(Integer grade) {
        this.grade = grade;
    }

    @Column(name = "grade_dept")
    public Integer getGradeDept() {
        return gradeDept;
    }

    public void setGradeDept(Integer gradeDept) {
        this.gradeDept = gradeDept;
    }

    @Column(name = "intro_text")
    public String getIntroText() {
        return introText;
    }

    public void setIntroText(String introText) {
        this.introText = introText;
    }
    @Column(name = "is_lock")
    public Integer getIsLock() {
        return isLock;
    }

    public void setIsLock(Integer isLock) {
        this.isLock = isLock;
    }
    @Column(name = "price")
    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }
    @Column(name = "ios_price")
    public BigDecimal getIosPrice() {
        return iosPrice;
    }

    public void setIosPrice(BigDecimal iosPrice) {
        this.iosPrice = iosPrice;
    }
}

