/**
 * 
 */
package com.ptteng.sca.academy.course.client;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.academy.course.model.Introduce;
import com.ptteng.academy.course.service.IntroduceService;

import java.util.List;
import java.util.Map;

public class IntroduceSCAClient implements IntroduceService {

    private IntroduceService introduceService;

	public IntroduceService getIntroduceService() {
		return introduceService;
	}
	
	
	public void setIntroduceService(IntroduceService introduceService) {
		this.introduceService =introduceService;
	}
	
	
			   
		@Override
		public Long insert(Introduce introduce)throws ServiceException, ServiceDaoException{
		
		return introduceService.insert(introduce);
		          
		
		}	
		  
    	   
		@Override
		public List<Introduce> insertList(List<Introduce> introduceList)throws ServiceException, ServiceDaoException{
		
		return introduceService.insertList(introduceList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return introduceService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(Introduce introduce)throws ServiceException, ServiceDaoException{
		
		return introduceService.update(introduce);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<Introduce> introduceList)throws ServiceException, ServiceDaoException{
		
		return introduceService.updateList(introduceList);
		          
		
		}	
		  
    	   
		@Override
		public Introduce getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return introduceService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<Introduce> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return introduceService.getObjectsByIds(ids);
		          
		
		}

	@Override
	public List<Long> getIdsByLessonId(Long lessonId) throws ServiceException, ServiceDaoException {
		return introduceService.getIdsByLessonId(lessonId);
	}


	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long> getIntroduceIdsByLevel(Integer level, Integer start, Integer limit)throws ServiceException, ServiceDaoException{
		
		return introduceService.getIntroduceIdsByLevel(level,start,limit);
	
	
	}
	
		
	
	
    			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer countIntroduceIdsByLevel(Integer level)throws ServiceException, ServiceDaoException{
		
		return introduceService.countIntroduceIdsByLevel(level);
	
	
	}
	
		
	
		@Override
	public List<Long> getIntroduceIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return introduceService.getIntroduceIds(start, limit);
	}

	@Override
	public Integer countIntroduceIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return introduceService.countIntroduceIds();
	}
	
	
	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return introduceService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return introduceService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   introduceService.deleteList(clz, ids);
		
	}
	
	@Override
	public Object getObjectByDynamicCondition(Class clz,
                                              Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
	
		return this.introduceService.getObjectByDynamicCondition(clz, conditions, start, limit);
	}


 
}

