package com.ptteng.academy.course.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.academy.course.model.LessonIntroduction;
import com.ptteng.common.dao.BaseDaoService;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface LessonIntroductionService extends BaseDaoService {


    public Long insert(LessonIntroduction lessonIntroduction) throws ServiceException, ServiceDaoException;


    public List<LessonIntroduction> insertList(List<LessonIntroduction> lessonIntroductionList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(LessonIntroduction lessonIntroduction) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<LessonIntroduction> lessonIntroductionList) throws ServiceException, ServiceDaoException;


    public LessonIntroduction getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<LessonIntroduction> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getLessonIntroductionIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countLessonIntroductionIds() throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getLessonIntroductionIdsByLessonId(Long lessonId, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


}

