package com.ptteng.academy.course.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.academy.course.model.DictationSubject;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface DictationSubjectService extends BaseDaoService {

	



   		   
		
		public Long insert(DictationSubject dictationSubject)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<DictationSubject> insertList(List<DictationSubject> dictationSubjectList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(DictationSubject dictationSubject)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<DictationSubject> dictationSubjectList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public DictationSubject getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<DictationSubject> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;



	/**
	 * @Description 获取上架科目id
	 * @param
	 * @Author: PeiyuFeng
	 * @Time 2017/5/17 15:03
	 */
	public List<Long> getIdsOnline(Integer start, Integer limit) throws ServiceException, ServiceDaoException;


	/**
	 * @Description 根据科目名称获取科目id
	 * @param
	 * @Author: PeiyuFeng
	 * @Time 2017/5/18 14:25
	 */
	public Long getIdByName(String name)throws ServiceException, ServiceDaoException;
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getDictationSubjectIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countDictationSubjectIds() throws ServiceException, ServiceDaoException;
	

}

