package com.ptteng.academy.course.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;


@Entity
@Table(name = "unit")
public class Unit implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 8952524438732243968L;

    /* 图片类型、文本类型、音频类型、视频类型*/
    public static final Integer media_type_image = 1;
    public static final Integer media_type_text = 2;
    public static final Integer media_type_audio = 3;
    public static final Integer media_type_video = 5;

    /*视频类型的正文 或 习题解析   图片类型 文本类型 */
    public static final Integer media_type_analysis_text = 6;
    public static final Integer media_type_analysis_image = 7;

    private Long id;

    // 用于存取文本
    private String textContent;

    // 备用字段
    private String imageLink;

    // 媒体类型（图、音、视、文本）
    private Integer mediaType;

    private Integer sort;

    private Long taskId;

    // 用于存取各种资源的URL
    private String resourceURL;

    private String resourceLink;

    private Long createBy;

    private Long updateBy;

    private Long updateAt;

    private Long createAt;

    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }


    @Column(name = "sort")
    public Integer getSort() {
        return sort;
    }


    public void setSort(Integer sort) {
        this.sort = sort;
    }


    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

    @Column(name = "text_content")
    public String getTextContent() {
        return textContent;
    }

    public void setTextContent(String textContent) {
        this.textContent = textContent;
    }

    @Column(name = "media_type")
    public Integer getMediaType() {
        return mediaType;
    }

    public void setMediaType(Integer mediaType) {
        this.mediaType = mediaType;
    }

    @Column(name = "task_id")
    public Long getTaskId() {
        return taskId;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    @Column(name = "resource_link")
    public String getResourceLink() {
        return resourceLink;
    }

    public void setResourceLink(String resourceLink) {
        this.resourceLink = resourceLink;
    }

    @Column(name = "image_link")
    public String getImageLink() {
        return imageLink;
    }

    public void setImageLink(String imageLink) {
        this.imageLink = imageLink;
    }

    @Transient
    public String getResourceURL() {
        return resourceURL;
    }

    public void setResourceURL(String resourceURL) {
        this.resourceURL = resourceURL;
    }


}

