package com.ptteng.academy.course.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;


@Entity
@Table(name = "page_statistic")
public class PageStatistic implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 477484822479398161L;


    /**
     * 会员
     */
    public static final Integer IS_MEMBER = 1;

    /**
     * 非会员
     */
    public static final Integer IS_NOT_MEMBER = 2;

    /**
     * 专题详情页
     */
    public static final Integer LESSON = 0;

    /**
     * 任务详情页
     */
    public static final Integer TASK = 1;

    /**
     * 个人中心页
     */
    public static final Integer USER_DETAIL = 2;

    /**
     * 签到页
     */
    public static final Integer USER_SIGN = 3;

    /**
     * 开通会员
     */
    public static final Integer OPEN_MEMBERSHIP = 4;

    /**
     * 卡券激活
     */
    public static final Integer COUPON_ACTIVE = 5;


    private Long id;


    private Long targetId;


    private Integer targetType;


    private Integer viewsStat;


    private Long viewAt;


    private Integer collectsStat;


    private Integer cachesStat;


    private Integer isMember;


    private Long createAt;


    private Long updateAt;


    private Long createBy;


    private Long updateBy;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "target_id")
    public Long getTargetId() {
        return targetId;
    }


    public void setTargetId(Long targetId) {
        this.targetId = targetId;
    }

    @Column(name = "target_type")
    public Integer getTargetType() {
        return targetType;
    }


    public void setTargetType(Integer targetType) {
        this.targetType = targetType;
    }

    @Column(name = "views_stat")
    public Integer getViewsStat() {
        return viewsStat;
    }


    public void setViewsStat(Integer viewsStat) {
        this.viewsStat = viewsStat;
    }

    @Column(name = "view_at")
    public Long getViewAt() {
        return viewAt;
    }


    public void setViewAt(Long viewAt) {
        this.viewAt = viewAt;
    }

    @Column(name = "collects_stat")
    public Integer getCollectsStat() {
        return collectsStat;
    }


    public void setCollectsStat(Integer collectsStat) {
        this.collectsStat = collectsStat;
    }

    @Column(name = "caches_stat")
    public Integer getCachesStat() {
        return cachesStat;
    }


    public void setCachesStat(Integer cachesStat) {
        this.cachesStat = cachesStat;
    }

    @Column(name = "is_member")
    public Integer getIsMember() {
        return isMember;
    }


    public void setIsMember(Integer isMember) {
        this.isMember = isMember;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

