package com.ptteng.sca.academy.campaign.client;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.academy.campaign.model.UserProcessRank;
import com.ptteng.academy.campaign.service.UserProcessRankService;
import java.util.List;
import java.util.Map;

public class UserProcessRankSCAClient implements UserProcessRankService {
    private UserProcessRankService userProcessRankService;

    public UserProcessRankSCAClient() {
    }

    public UserProcessRankService getUserProcessRankService() {
        return this.userProcessRankService;
    }

    public void setUserProcessRankService(UserProcessRankService userProcessRankService) {
        this.userProcessRankService = userProcessRankService;
    }

    public Long insert(UserProcessRank userProcessRank) throws ServiceException, ServiceDaoException {
        return this.userProcessRankService.insert(userProcessRank);
    }

    public List<UserProcessRank> insertList(List<UserProcessRank> userProcessRankList) throws ServiceException, ServiceDaoException {
        return this.userProcessRankService.insertList(userProcessRankList);
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        return this.userProcessRankService.delete(id);
    }

    public boolean update(UserProcessRank userProcessRank) throws ServiceException, ServiceDaoException {
        return this.userProcessRankService.update(userProcessRank);
    }

    public boolean updateList(List<UserProcessRank> userProcessRankList) throws ServiceException, ServiceDaoException {
        return this.userProcessRankService.updateList(userProcessRankList);
    }

    public UserProcessRank getObjectById(Long id) throws ServiceException, ServiceDaoException {
        return this.userProcessRankService.getObjectById(id);
    }

    public List<UserProcessRank> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        return this.userProcessRankService.getObjectsByIds(ids);
    }

    public Long getUserProcessRankIdByUserIdAndProcessId(Long userId, Long processId) throws ServiceException, ServiceDaoException {
        return this.userProcessRankService.getUserProcessRankIdByUserIdAndProcessId(userId, processId);
    }

    public List<Long> getUserProcessRankIdsByProcessIdAndGradeDept(Long processId, Integer gradeDept, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        return this.userProcessRankService.getUserProcessRankIdsByProcessIdAndGradeDept(processId, gradeDept, start, limit);
    }

    public Integer countUserProcessRankIdsByProcessIdAndGradeDept(Long processId) throws ServiceException, ServiceDaoException {
        return this.userProcessRankService.countUserProcessRankIdsByProcessIdAndGradeDept(processId);
    }

    public List<Long> getUserProcessRankIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        return this.userProcessRankService.getUserProcessRankIds(start, limit);
    }

    public Integer countUserProcessRankIds() throws ServiceException, ServiceDaoException {
        return this.userProcessRankService.countUserProcessRankIds();
    }

    public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        return this.userProcessRankService.getIdsByDynamicCondition(clz, conditions, start, limit);
    }

    public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
        return this.userProcessRankService.fakeDelete(clz, id);
    }

    public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
        this.userProcessRankService.deleteList(clz, ids);
    }

    public Object getObjectByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        return this.userProcessRankService.getObjectByDynamicCondition(clz, conditions, start, limit);
    }
}
