/**
 *
 */
package com.ptteng.sca.academy.campaign.client;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.academy.campaign.model.Process;
import com.ptteng.academy.campaign.service.ProcessService;

import java.util.List;
import java.util.Map;

public class ProcessSCAClient implements ProcessService {

    private ProcessService processService;

    public ProcessService getProcessService() {
        return processService;
    }


    public void setProcessService(ProcessService processService) {
        this.processService = processService;
    }


    @Override
    public Long insert(Process process) throws ServiceException, ServiceDaoException {

        return processService.insert(process);


    }


    @Override
    public List<Process> insertList(List<Process> processList) throws ServiceException, ServiceDaoException {

        return processService.insertList(processList);


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {

        return processService.delete(id);


    }


    @Override
    public boolean update(Process process) throws ServiceException, ServiceDaoException {

        return processService.update(process);


    }


    @Override
    public boolean updateList(List<Process> processList) throws ServiceException, ServiceDaoException {

        return processService.updateList(processList);


    }


    @Override
    public Process getObjectById(Long id) throws ServiceException, ServiceDaoException {

        return processService.getObjectById(id);


    }


    @Override
    public List<Process> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {

        return processService.getObjectsByIds(ids);


    }


    @Override
    public List<Long> getProcessIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return processService.getProcessIds(start, limit);
    }

    @Override
    public List<Long> getProcessIdsByCampaignId(Long campaignId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        return processService.getProcessIdsByCampaignId(campaignId, start, limit);
    }

    @Override
    public Integer countProcessIds() throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return processService.countProcessIds();
    }


    @Override
    public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return processService.getIdsByDynamicCondition(clz, conditions, start, limit);
    }


    @Override
    public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return processService.fakeDelete(clz, id);
    }


    @Override
    public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
        processService.deleteList(clz, ids);

    }

    @Override
    public Object getObjectByDynamicCondition(Class clz,
                                              Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        return this.processService.getObjectByDynamicCondition(clz, conditions, start, limit);
    }


}

