/**
 *
 */
package com.ptteng.sca.academy.campaign.client;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.academy.campaign.model.ProcessQuesbank;
import com.ptteng.academy.campaign.service.ProcessQuesbankService;

import java.util.List;
import java.util.Map;

public class ProcessQuesbankSCAClient implements ProcessQuesbankService {

    private ProcessQuesbankService processQuesbankService;

    public ProcessQuesbankService getProcessQuesbankService() {
        return processQuesbankService;
    }


    public void setProcessQuesbankService(ProcessQuesbankService processQuesbankService) {
        this.processQuesbankService = processQuesbankService;
    }


    @Override
    public Long insert(ProcessQuesbank processQuesbank) throws ServiceException, ServiceDaoException {

        return processQuesbankService.insert(processQuesbank);


    }


    @Override
    public List<ProcessQuesbank> insertList(List<ProcessQuesbank> processQuesbankList) throws ServiceException, ServiceDaoException {

        return processQuesbankService.insertList(processQuesbankList);


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {

        return processQuesbankService.delete(id);


    }


    @Override
    public boolean update(ProcessQuesbank processQuesbank) throws ServiceException, ServiceDaoException {

        return processQuesbankService.update(processQuesbank);


    }


    @Override
    public boolean updateList(List<ProcessQuesbank> processQuesbankList) throws ServiceException, ServiceDaoException {

        return processQuesbankService.updateList(processQuesbankList);


    }


    @Override
    public ProcessQuesbank getObjectById(Long id) throws ServiceException, ServiceDaoException {

        return processQuesbankService.getObjectById(id);


    }


    @Override
    public List<ProcessQuesbank> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {

        return processQuesbankService.getObjectsByIds(ids);


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getProcessQuesbankIdsByProcessId(Long processId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        return processQuesbankService.getProcessQuesbankIdsByProcessId(processId, start, limit);


    }

    @Override
    public List<Long> getProcessQuesbankIdsByQuesbankId(Long quesbankId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        return processQuesbankService.getProcessQuesbankIdsByQuesbankId(quesbankId, start, limit);
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countProcessQuesbankIdsByProcessId(Long processId) throws ServiceException, ServiceDaoException {

        return processQuesbankService.countProcessQuesbankIdsByProcessId(processId);


    }


    @Override
    public List<Long> getProcessQuesbankIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return processQuesbankService.getProcessQuesbankIds(start, limit);
    }

    @Override
    public Integer countProcessQuesbankIds() throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return processQuesbankService.countProcessQuesbankIds();
    }


    @Override
    public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return processQuesbankService.getIdsByDynamicCondition(clz, conditions, start, limit);
    }


    @Override
    public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return processQuesbankService.fakeDelete(clz, id);
    }


    @Override
    public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
        processQuesbankService.deleteList(clz, ids);

    }

    @Override
    public Object getObjectByDynamicCondition(Class clz,
                                              Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        return this.processQuesbankService.getObjectByDynamicCondition(clz, conditions, start, limit);
    }


}

