/**
 *
 */
package com.ptteng.sca.academy.campaign.client;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.academy.campaign.model.News;
import com.ptteng.academy.campaign.service.NewsService;

import java.util.List;
import java.util.Map;

public class NewsSCAClient implements NewsService {

    private NewsService newsService;

    public NewsService getNewsService() {
        return newsService;
    }


    public void setNewsService(NewsService newsService) {
        this.newsService = newsService;
    }


    @Override
    public Long insert(News news) throws ServiceException, ServiceDaoException {

        return newsService.insert(news);


    }


    @Override
    public List<News> insertList(List<News> newsList) throws ServiceException, ServiceDaoException {

        return newsService.insertList(newsList);


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {

        return newsService.delete(id);


    }


    @Override
    public boolean update(News news) throws ServiceException, ServiceDaoException {

        return newsService.update(news);


    }


    @Override
    public boolean updateList(List<News> newsList) throws ServiceException, ServiceDaoException {

        return newsService.updateList(newsList);


    }


    @Override
    public News getObjectById(Long id) throws ServiceException, ServiceDaoException {

        return newsService.getObjectById(id);


    }


    @Override
    public List<News> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {

        return newsService.getObjectsByIds(ids);


    }


    @Override
    public List<Long> getNewsIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return newsService.getNewsIds(start, limit);
    }

    @Override
    public Integer countNewsIds() throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return newsService.countNewsIds();
    }


    @Override
    public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return newsService.getIdsByDynamicCondition(clz, conditions, start, limit);
    }


    @Override
    public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return newsService.fakeDelete(clz, id);
    }


    @Override
    public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
        newsService.deleteList(clz, ids);

    }

    @Override
    public Object getObjectByDynamicCondition(Class clz,
                                              Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        return this.newsService.getObjectByDynamicCondition(clz, conditions, start, limit);
    }


}

