package com.ptteng.academy.campaign.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.academy.campaign.model.UserNews;
import com.ptteng.common.dao.BaseDaoService;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface UserNewsService extends BaseDaoService {


    public Long insert(UserNews userNews) throws ServiceException, ServiceDaoException;


    public List<UserNews> insertList(List<UserNews> userNewsList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(UserNews userNews) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<UserNews> userNewsList) throws ServiceException, ServiceDaoException;


    public UserNews getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<UserNews> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countUserNewsIdsByUserId(Long userId) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getUserNewsIdsByUserId(Long userId, Integer start, Integer limit) throws ServiceException, ServiceDaoException;

    public Long getUserNewsIdsByUserIdAndNewsIdAndTargetType(Long userId, Long newsId, Integer targetType) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getUserNewsIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countUserNewsIds() throws ServiceException, ServiceDaoException;


}

