package com.ptteng.academy.campaign.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.academy.campaign.model.UserCampaign;
import com.ptteng.common.dao.BaseDaoService;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface UserCampaignService extends BaseDaoService {


    public Long insert(UserCampaign userCampaign) throws ServiceException, ServiceDaoException;


    public List<UserCampaign> insertList(List<UserCampaign> userCampaignList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(UserCampaign userCampaign) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<UserCampaign> userCampaignList) throws ServiceException, ServiceDaoException;


    public UserCampaign getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<UserCampaign> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getUserCampaignIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countUserCampaignIds() throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getUserCampaignIdsByUserId(Long userId, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Long getUserCampaignIdByUserIdAndCampaignId(Long userId, Long campaignId) throws ServiceException, ServiceDaoException;


    public List<Long> getUserCampaignIdsByCampaignId(Long campaignId, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


}

