package com.ptteng.academy.campaign.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.academy.campaign.model.ProcessQuesbank;
import com.ptteng.common.dao.BaseDaoService;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface ProcessQuesbankService extends BaseDaoService {


    public Long insert(ProcessQuesbank processQuesbank) throws ServiceException, ServiceDaoException;


    public List<ProcessQuesbank> insertList(List<ProcessQuesbank> processQuesbankList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(ProcessQuesbank processQuesbank) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<ProcessQuesbank> processQuesbankList) throws ServiceException, ServiceDaoException;


    public ProcessQuesbank getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<ProcessQuesbank> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countProcessQuesbankIdsByProcessId(Long processId) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getProcessQuesbankIdsByProcessId(Long processId, Integer start, Integer limit) throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getProcessQuesbankIdsByQuesbankId(Long quesbankId, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getProcessQuesbankIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countProcessQuesbankIds() throws ServiceException, ServiceDaoException;


}

