package com.ptteng.academy.admin.util;

import com.gemantic.common.util.PasswordUtils;
import com.ptteng.academy.admin.exception.MyException;
import com.ptteng.academy.user.model.User;
import com.qding.common.util.DataUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFDataFormatter;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.CellReference;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.*;

/**
 * 解析盘库excel和倒查excel
 *
 * @author liut
 */
public class ParseExcel {


    private static final Log log = LogFactory.getLog("parseExcel");

    /**
     * 上传的临时文件在服务器上的存放路径
     */
    public static final String FILE_PATH = "/data/temp/academy";

    /**
     * 本项目excel相关，根目录
     */
    public static final String excelPath = "/data/webs/academy-admin-web/excel";
    /**
     * 审计详情第一部分的excel模版
     */
    public static final String report_part1 = "report_part1_template.xls";
    /**
     * 审计详情第二部分的excel模版
     */
    public static final String report_part2 = "report_part2_template.xls";
    /**
     * 厂家任务列表的excel模版
     */
    public static final String venderTask_list = "venderTask_list_template.xls";

    /**
     * 2003和2007excel文件的尾缀
     */
    public static final String[] EXCEL_SUFFIX = {"xls", "xlsx", "csv"};

    static {
        PropertiesUtil.loadFiles("cfg/excel.properties");
    }

    private static final Properties PRO = PropertiesUtil.loadFilesToProps("cfg/constant.properties");
    /**
     * 用户excel表中有用的6个字段，按序排列
     * grade class name userType mobile mail pwd
     */
    static final int[] inventory_colums = {0, 1, 2, 3, 4, 5, 6};

    /**
     * 倒查模板表中有用的三个字段，按序排列
     */
    static final int[] inspect_colums = {3, 7, 13};

    /**
     * 私有化构造器
     */
    private ParseExcel() {
    }

    /**
     * 解析excel
     *
     * @param inventoryUrl
     * @return
     */
    public static List<User> parseUserExcel(String inventoryUrl) {
        List<User> list = new ArrayList<>();
        log.info("argument inventoryUrl is: " + inventoryUrl);
        if (StringUtils.isEmpty(inventoryUrl)) {
            log.info("arg inventoryUrl is empty");
            return list;
        }
        //服务器用
        Workbook wb = getWb(getExcelFilePath(inventoryUrl));
        //本地调试用
//        Workbook wb = getWb(inventoryUrl);
        if (wb == null) {
            log.info("no workBook, can not parse");
            return list;
        }
        /* 固定只取出第一张sheet */
        Sheet sheet_0 = wb.getSheetAt(0);
        if (sheet_0 == null) {
            log.info("no first sheet, can not parse");
            return list;
        }
        Map<String, Object> map = PropertiesUtil.getPropertesMap();
        Map<String, Object> userMap = new HashMap<>();
        log.info("map is " + map);
        log.info("PRO is " + PRO.toString());

        try {
            int rowNums = 1;
            // 共有多少列，配置文件中配置字段的数量
            int colNum = map.size();
            //清除掉excel中的空行
            CellReference cellReference = new CellReference("A4");
            boolean flag = false;
            log.info("当前总行数："+(sheet_0.getLastRowNum()+1));
            for (int i = cellReference.getRow(); i <= sheet_0.getLastRowNum();) {
                Row r = sheet_0.getRow(i);
                if (r == null) {
//                    log.info("如果是空行（即没有任何数据、格式），直接把它以下的数据往上移动");
                    // 如果是空行（即没有任何数据、格式），直接把它以下的数据往上移动
                    sheet_0.shiftRows(i + 1, sheet_0.getLastRowNum(), -1);
                    continue;
                }
                flag = false;
                for (Cell c : r) {
                    if (c.getCellType() != Cell.CELL_TYPE_BLANK) {
                        flag = true;
                        break;
                    }
                }
                if (flag) {
                    i++;
                    continue;
                } else {
                    //如果是空白行（即可能没有数据，但是有一定格式）
                    if (i == sheet_0.getLastRowNum()){
                        //如果到了最后一行，直接将那一行remove掉
                        sheet_0.removeRow(r);
                    } else{
                        //如果还没到最后一行，则数据往上移一行
                        sheet_0.shiftRows(i + 1, sheet_0.getLastRowNum(), -1);
                    }
                }
            }
            rowNums = sheet_0.getLastRowNum() + 1;
            log.info("整理后总行数" + rowNums);
            for (int i = 0; i < rowNums; i++) {
                log.info("============ i ============ " + i);
                Row row = sheet_0.getRow(i);
                log.info("total rowNum: " + rowNums + ", total colNum: " + colNum);
                //取表头
                if (i == 0) {
                    log.info("this row is table title");
                    // 打印标题记录日志
                    for (int j = 0; j < colNum; j++) {
                        Cell cell = row.getCell(j);
                        log.info("column:" + j + ", title is " + cell);
                    }
                    for (int j = 0; j < colNum; j++) {
                        Cell cell = row.getCell(j);
                        String value = getValue(cell);

                        log.info("value is " + value);
                        if (DataUtils.isNullOrEmpty(value)) {
                            log.info("value is null");
                            continue;
                            //以表头值为key，user表字段值为value，如果找到user表对应的值，则进行转换
                        } else {
                            log.info("j=" + j + " , value=" + value + " user key is " + map.get(value));
                            userMap.put(String.valueOf(j), map.get(value));
                        }
                    }
                    log.info("userMap is " + userMap);
                } else {
                    String value = null;
                    Map<String, Object> newMap = new HashMap<>();
                    // 表示该行用户名是否为空
                    Boolean aliasIsNull = false;
                    for (int j = 0; j < colNum; j++) {
                        Cell cell = row.getCell(j);
                        String val = (String) userMap.get(String.valueOf(j));
                        if (DataUtils.isNullOrEmpty(val)) {
                            continue;
                        }
                        // 正确读取手机号格式
                        if (val.equals("mobile")) {
                            HSSFDataFormatter dataFormatter = new HSSFDataFormatter();
                            value = dataFormatter.formatCellValue(cell);
                        } else {
                            value = getValue(cell);
                        }
                        if (val.equals("alias")) {
                            if (DataUtils.isNullOrEmpty(value)) {
                                log.info("alias is null ");
                                aliasIsNull = true;
                                break;
                            }
                        }
                        if (val.equals("pwd")) {
                            if (DataUtils.isNullOrEmpty(value)) {
//                                MyException me = new MyException("pwd cannot be null");
//                                me.setErrorCode("-4");
//                                throw me;
                                value="000000";
                            }
                            value = PasswordUtils.encode(value);

                        }
                        if (DataUtils.isNotNullOrEmpty(PRO.getProperty(value))) {
                            newMap.put(userMap.get(String.valueOf(j)).toString(), PRO.getProperty(value));
                        } else {
                            newMap.put(userMap.get(String.valueOf(j)).toString(), value);
                        }
                        log.info("this user key is " + userMap.get(String.valueOf(j)).toString() + " ," +
                                "" +
                                "value is " + value + "pro value is " + PRO.getProperty(value));
                    }
                    //log.info("new map is " + newMap);
                    // 该行用户名不为空，才保存这条记录
                    if (!aliasIsNull) {
                        User user = (User) AcademyUserUtil.map2Object(newMap, User.class);
                        list.add(user);
                    } else {
                        log.info("alias is null in this row, ");
                    }
                }
            }
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage(), t);
        }
        return list;
    }
//
//  /**
//   * 解析倒查excel
//   *
//   * @param inventoryUrl
//   * @return
//   */
//  public static List<Inspect> parseInspectExcel(String inspectUrl) {
//    List<Inspect> list = new ArrayList<>();
//    log.info("argument inspectUrl is: " + inspectUrl);
//    if (StringUtils.isEmpty(inspectUrl)) {
//      log.info("arg inspectUrl is empty");
//      return list;
//    }
//    Workbook wb = getWb(getExcelFilePath(inspectUrl));
//    if (wb == null) {
//      log.info("no workBook, can not parse");
//      return list;
//    }
//    /* 固定只取出第一张sheet */
//    Sheet sheet_0 = wb.getSheetAt(0);
//    if (sheet_0 == null) {
//      log.info("no first sheet, can not parse");
//      return list;
//    }
//    int rowNum = sheet_0.getLastRowNum() + 1; // 共有多少行
//    Row row_0 = sheet_0.getRow(0); // 取出第一行，标题栏
//    int colNum = row_0.getLastCellNum() + 1; // 共有多少列
//    log.info("total rowNum: " + rowNum + ", total colNum: " + colNum);
//
//    /* 从第二行开始遍历每一行每一列的数据 */
//    for (int i = 1; i < rowNum; i++) {
//      Row row = sheet_0.getRow(i);
//      Inspect ins = new Inspect();
//      for (int j = 0; j < colNum; j++) {
//        Cell cell = row.getCell(j);
//        if (j == inspect_colums[0]) {
//          ins.setDistributorName(getValue(cell));
//        }
//        else if (j == inspect_colums[1]) {
//          ins.setVinNo(getValue(cell));
//        }
//        else if (j == inspect_colums[2]) {
//          ins.setSettlementDate(getValue(cell));
//        }
//        else {
//          continue;
//        }
//      }
//      list.add(ins);
//    }
//    return list;
//  }
//

    /**
     * 每个cell中的值
     *
     * @param cell
     * @return
     */
    private static String getValue(Cell cell) {

//        log.info("取值为 " + cell);
        if (DataUtils.isNullOrEmpty(cell)) {
            return "";
        }
        if (cell.getCellType() == Cell.CELL_TYPE_BOOLEAN) {
            return String.valueOf(cell.getBooleanCellValue());
        } else if (cell.getCellType() == Cell.CELL_TYPE_NUMERIC) {
            if (HSSFDateUtil.isCellDateFormatted(cell)) {
                Date d = cell.getDateCellValue();
                return DateFormatUtils.format(d, "yyyy/MM/dd");
            } else {
                return String.valueOf((int) cell.getNumericCellValue());
            }
        } else {
            return String.valueOf(cell.getStringCellValue());
        }
    }

    /**
     * 拿到workbook对象
     *
     * @param excelFilePath
     * @return
     */
    private static Workbook getWb(String excelFilePath) {
        String suffix = excelFilePath.substring(excelFilePath.lastIndexOf(".") + 1);
        log.info("suffix is: " + suffix);
        InputStream is;
        Workbook wb = null;
        try {
            is = new FileInputStream(excelFilePath);
            if (EXCEL_SUFFIX[0].equals(suffix)) {
                log.info("file is xls");
                wb = new HSSFWorkbook(is);
            } else if (EXCEL_SUFFIX[1].equals(suffix)) {
                log.info("file is xlsx");
                wb = new XSSFWorkbook(is);
            } else {
                log.info("file is other, illegal");
                wb = null;
            }
        } catch (FileNotFoundException ex) {
            log.error("getWb error...", ex);
            wb = null;
        } catch (IOException ex) {
            log.error("getWb error...", ex);
            wb = null;
        }
        return wb;
    }

    /**
     * 根据url拼接excel文件在服务器上的临时存放路径
     *
     * @param url
     * @return
     */
    public static String getExcelFilePath(String url) {
        log.info("argument url is: " + url);
        int begin = url.lastIndexOf("/") - 1;
        String temp = url.substring(begin, url.length());
        log.info("temp is:" + temp);
        return FILE_PATH + "/" + temp;
    }

    public static void main(String[] args) {
    }
}
