package com.ptteng.academy.admin.util;

import com.ptteng.academy.user.model.Invitation;
import com.ptteng.academy.user.model.User;
import com.ptteng.academy.user.service.InvitationService;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Component
public class AcademyUserUtil {
    private static final Log registerLog = LogFactory.getLog(AcademyUserUtil.class);


    public static AcademyUserUtil academyUserUtil;
    @Autowired
    private CookieUtil cookieUtil;
    @Autowired
    private InvitationService invitationService;

    @PostConstruct
    public void init() {
        academyUserUtil = this;
    }

    public static Long getUserIdLongValue(HttpServletRequest request) {

        Long userIdLong = 0L;

        String userIdStr = academyUserUtil.cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);

        if (DataUtils.isNotNullOrEmpty(userIdStr)) {

            return Long.valueOf(userIdStr);

        } else if (DataUtils.isNullOrEmpty(userIdStr)) {

            User user = (User) request.getAttribute("user");

            return user.getId();
        }

        return userIdLong;
    }


    /**
     * show 获取唯一邀请码
     *
     * @param limit 邀请码数量
     * @return java.lang.String
     * @throws Exception 异常信息
     * @author lishaobo
     * @date 2018/4/27
     */
    public static List<String> getInvitations(Integer limit) throws Exception {
        registerLog.info("get invitationCode count " + limit);
        List<String> result = new ArrayList<>();
        //取可用码
        try {
            List<Long> invitations = academyUserUtil.invitationService.getNewInvitations(limit);
            registerLog.info("invitations size is " + invitations.size());
            if (!invitations.isEmpty()) {
                registerLog.info("code ids size is " + invitations.size());

                List<Invitation> invitationList = academyUserUtil.invitationService.getObjectsByIds(invitations);
                for (int i = 0; i < invitations.size(); i++) {
                    //批量导入数量较大，优化流程，暂不记录用户id
//                    invitationList.get(i).setUid(uids.get(i));
                    invitationList.get(i).setStatus(Invitation.DISABLE);
                    result.add(invitationList.get(i).getId().toString());
                }

                academyUserUtil.invitationService.updateList(invitationList);
                registerLog.info("set users invitation success , uids size is " + limit + " ,invitation size is " + invitationList.size());
            }
        } catch (Throwable e) {
            e.printStackTrace();
            registerLog.error(e.getMessage(), e);
        }

        return result;
    }

    public static Object map2Object(Map<String, Object> map, Class<?> clazz) {
        if (map == null) {
            return null;
        }
        Object obj = null;
        try {
            obj = clazz.newInstance();

            Field[] fields = obj.getClass().getDeclaredFields();
            for (Field field : fields) {
                int mod = field.getModifiers();
                if (Modifier.isStatic(mod) || Modifier.isFinal(mod)) {
                    continue;
                }
                field.setAccessible(true);
                try {
                    field.set(obj, map.get(field.getName()));
                } catch (Throwable t) {
                    field.set(obj, Integer.valueOf(map.get(field.getName()).toString()));
                }

            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return obj;
    }

}
