package com.ptteng.academy.admin.interceptor;


import com.gemantic.commons.code.annotation.FileTemplate;
import com.gemantic.commons.code.util.GenerateFileUtil;
import com.ptteng.academy.admin.model.Manager;
import com.ptteng.academy.admin.service.ManagerService;
import com.ptteng.academy.admin.service.ModuleService;
import com.ptteng.academy.admin.service.RoleModuleService;
import com.ptteng.academy.admin.service.RoleService;
import com.qding.common.util.http.cookie.CookieUtil;
import com.qding.common.util.http.cookie.UserCryptUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class UserInterceptor extends HandlerInterceptorAdapter {

    private static final Log log = LogFactory.getLog(UserInterceptor.class);


    @Autowired
    private ManagerService managerService;
    @Autowired
    private RoleService roleService;

    @Autowired
    private ModuleService moduleService;

    @Autowired
    private RoleModuleService roleModuleService;
    public static String SPLITTER_REGEX = "\\|";
    public static final String USER_ID = "userId";

    @Autowired
    private CookieUtil cookieUtil;

    @Autowired
    @Qualifier("velocityGenerateFileUtil")
    private GenerateFileUtil generate;

    @Override
    public boolean preHandle(HttpServletRequest request,
                             HttpServletResponse response, Object handler) throws Exception {
        log.info("intercepter preHandle start ...");

        String token = request.getParameter("token");
        if (null == token) {
            token = request.getHeader("token");
        }
        log.info(" intercept token is    " + token);

        Cookie[] cookies = request.getCookies();
        log.info("get cookies  " + Arrays.asList(cookies));
        Map<String, String> maps = cookieUtil.getIdentity(request);
        log.info("get maps  from cookie is " + maps);
        Long uid = cookieUtil.getID(request);


        log.info(uid);
        if (uid == null) {

            log.error("not legal user request");
            return noLogin(response, request);

        }
        log.info("get uid  from cookie is " + uid);
        Manager manager = this.managerService.getObjectById(uid);
        if (manager == null) {
            log.error(uid + " not get any data ");
            return noLogin(response, request);
        } else {
            log.info("get manager name is " + manager.getName());
            request.setAttribute("manager", manager);
        }
        log.info("get uid is " + uid);


        return true;
    }

    public static Map getUserIdentity(String userName, Long userId) {
        Map map = new HashMap();
        map.put(CookieUtil.USER_NAME, userName);
        map.put(CookieUtil.USER_ID, userId);
        return map;
    }

    private Map decodeCookie(String value) {
        if (StringUtils.isBlank(value))
            return null;
        try {
            String[] p = value.split(SPLITTER_REGEX);
            Long userId = new Long(p[0]);
            String crypt = p[1];
            String plainUserInfo = UserCryptUtil.userDecrypt(crypt);
            String userName = UserCryptUtil.getUserNameFromPlain(plainUserInfo);
            Long uid = UserCryptUtil.getUserIdFromPlain(plainUserInfo);
            if (userId.equals(uid)) {
                return getUserIdentity(userName, userId);
            }
        } catch (Exception e) {
            e.printStackTrace();
            log.error("Wrong cookie format: [" + value + "] message is:" + e.getMessage());
            return null;
        }

        return null;
    }

    private boolean noPermission(HttpServletResponse response, HttpServletRequest request) {
        log.info("sssssssssssss");
        log.info("ddddddddd   " + request.getRequestURI());


        RequestDispatcher rd = request.getRequestDispatcher("/r/json/noPermission.json");
        try {
            rd.forward(request, response);
        } catch (ServletException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        // response.sendRedirect("/noPermissin");


        return false;

    }

    private boolean noLogin(HttpServletResponse response, HttpServletRequest request) throws IOException {

        log.info(" manager don't login");

//        RequestDispatcher rd =  request.getRequestDispatcher("/r/json/noLogin.json");
        try {
//            rd.forward(request,response);
//            response.sendRedirect("/r/json/noLogin.json");
            response.sendRedirect("/nologin");
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } /*catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }*/
        // response.sendRedirect("/noPermissin");


        return false;

    }

    //
    @Override
    public void postHandle(HttpServletRequest request,
                           HttpServletResponse response, Object handler,
                           ModelAndView modelAndView) throws Exception {

        log.info("   postHandle  start  ======================= ");


        String fileType = request.getParameter("excel");
        if ("excel".equals(fileType)) {
            log.info("you want import excel ");

            HandlerMethod handler2 = (HandlerMethod) handler;

            Map model = modelAndView.getModel();


            Method m = handler2.getMethod();
            log.info("method name is " + m.getName());
            String excelName = "coupon_" + System.currentTimeMillis() + ".csv";

            if (m.isAnnotationPresent(FileTemplate.class)) {
                FileTemplate p = m.getAnnotation(FileTemplate.class);

                String content = generate.generateFileEncoding(model, p.templatePath(), p.filePath(),
                        excelName, false, "GBK");
                log.info("test result is " + content);

            } else {

            }
            String url = "/exceldownload/" + excelName;
            model.put("url", url);
            model.put("code", 0);
            modelAndView.setViewName("/data/img");

        } else {

        }


    }
//

    /**
     * 获取跳转链接的地址
     */
    public String getInterceptorUrl(HttpServletRequest request) {

        String interceptorUrl = request.getRequestURI()
                + (null == request.getQueryString() ? "" : "?"
                + request.getQueryString()).toString();
        log.info(interceptorUrl);
        interceptorUrl = interceptorUrl.replace("/app/", "/");

        log.info("get getInterceptorUrl is " + interceptorUrl);

        return interceptorUrl;
    }

    public static void main(String[] args) throws UnsupportedEncodingException {

        String x = URLEncoder.encode("p/hello", "utf-8");
        log.info(x);

    }
}
