package com.ptteng.academy.admin.controller;


import com.ptteng.academy.admin.model.Manager;
import com.ptteng.academy.admin.util.AcademyMemberUtil;
import com.ptteng.academy.admin.util.DynamicUtil;
import com.ptteng.academy.user.model.Member;
import com.ptteng.academy.user.service.MemberService;
import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Member  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class MemberController {
    private static final Log log = LogFactory.getLog(MemberController.class);

    @Autowired
    private MemberService memberService;


    /**
     * 会员套餐列表
     *
     * @param
     * @return
     */

    @RequestMapping(value = "/a/u/member/search", method = RequestMethod.GET)
    public String getmemberListByDynamicSearch(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer page, Integer size, String name, String minPeriod, String maxPeriod, Integer status, String minPrice, BigDecimal maxIOSPrice, BigDecimal minIOSPrice, String maxPrice) throws Exception {
        log.info("the url is: get  /a/u/member/search");
        log.info("the page is:" + page + ",size is +" + size + "the name is :" + name + ",minPeriod is: " + minPeriod + ",maxPeriod is: " + maxPeriod + ",status is: " + status + ",minPrice is :" + minPrice + ",maxPrice is :" + maxPrice);
        if (page == null) {
            page = 1;
        }

        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        try {
            List<Member> memberList = new ArrayList<>();
            Map<String, Object> params = DynamicUtil.getMemberList(name, minPeriod, maxPeriod, minPrice, maxPrice, minIOSPrice, maxIOSPrice, status, false);
            log.info("params is :" + params);
            List<Long> idList = memberService.getIdsByDynamicCondition(Member.class, params, start, size);
            log.info("idList is :" + idList);
            if (idList.size() <= 0) {
                log.info("member idList is null");
            }
            memberList = memberService.getObjectsByIds(idList);
            log.info("memberList.size() is :" + memberList.size());
            Boolean recommendStatus = false;
            for (Member member : memberList) {
                if (Member.IS_RECOMMEND.equals(member.getRecommend())) {
                    recommendStatus = true;
                    break;
                }
            }
            int totalPage = 1;
            Map<String, Object> totalParams = DynamicUtil.getMemberList(name, minPeriod, maxPeriod, minPrice, maxPrice, minIOSPrice, maxIOSPrice, status, true);
            // BigInteger total = (BigInteger) memberService.getObjectByDynamicCondition(Member.class, totalParams, 0, Integer.MAX_VALUE);

            List<Long> countList = memberService.getIdsByDynamicCondition(Member.class, totalParams, 0, Integer.MAX_VALUE);
            Long total = countList.get(0);

            if (null != total) {
                if (total.intValue() > 0) {
                    totalPage = (((total.intValue() - 1)) / (size)) + 1;
                    ;
                }
            }
            log.info("page:" + page + ",size" + size + ",total:" + total + ",totalPage :" + totalPage);
            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", total);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("recommendStatus", recommendStatus);
            model.addAttribute("memberList", memberList);
            log.info("member search success");
        } catch (Throwable t) {
            t.printStackTrace();
            log.error("get memberList error");
            log.error(t.getMessage());
            model.addAttribute("code", -1);
        }

        return "/academy-user-service/member/json/memberListJson";
    }


    /**
     * 会员套餐详情
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/a/u/member/{id}", method = RequestMethod.GET)
    public String getMemberJson(HttpServletRequest request,
                                HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("get data : id= " + id);
        if (DataUtils.isNullOrEmpty(id)) {
            log.error("id is null ");
            model.addAttribute("code", -9101);
            return "/common/success";
        }
        try {
            Member member = memberService.getObjectById(id);
            if (DataUtils.isNullOrEmpty(member)) {
                log.error("member is not exist");
                model.addAttribute("code", -9100);
                return "/common/success";
            }
            log.info("get member data is " + member);
            model.addAttribute("code", 0);
            model.addAttribute("member", member);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get member error,id is  " + id);
            model.addAttribute("code", -1);
        }

        return "/academy-user-service/member/json/memberDetailJson";
    }


    /**
     * 编辑会员套餐
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/a/u/member/{id}", method = RequestMethod.PUT)
    public String updateMemberJson(HttpServletRequest request,
                                   HttpServletResponse response, ModelMap model, Member member, @PathVariable Long id) throws Exception {

        log.info("update member : member= " + member);
        //得到更新人的信息
        Manager manager = (Manager) request.getAttribute("manager");
        Long managerId = manager.getId();
        //原有的会员套餐
        Member oldMember = memberService.getObjectById(id);
        if (null == oldMember) {
            log.error("the introducing member is null ");
            model.addAttribute("code", -9100);
            return "/data/json";
        }
        Integer code = AcademyMemberUtil.paramCheck(member);
        if (DataUtils.isNotNullOrEmpty(code)) {
            model.addAttribute("code", code);
            return "/data/json";
        }

        try {
            log.info("member cache amount record is " + oldMember.getCacheAmountLimit() + "  change to " + member.getCacheAmountLimit());
            //更新原有的不用传入的member，因为原有的有其他字段
            oldMember.setName(member.getName());
            oldMember.setPeriod(member.getPeriod());
            oldMember.setPrice(member.getPrice());
            oldMember.setIosPrice(member.getIosPrice());
            oldMember.setUpdateBy(managerId);
            oldMember.setOrderBy(member.getOrderBy());
            oldMember.setIosDiscountPrice(member.getIosDiscountPrice());
            oldMember.setDiscountPrice(member.getDiscountPrice());
            oldMember.setCacheAmountLimit(member.getCacheAmountLimit());

            boolean result = memberService.update(oldMember);
            log.info("update member :" + id + ", result is :" + result);
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update member error,id is  " + member.getId());
            model.addAttribute("code", -1);
        }

        return "/data/json";
    }


    /**
     * 新增会员套餐
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/a/u/member", method = RequestMethod.POST)
    public String addMemberJson(HttpServletRequest request,
                                HttpServletResponse response, ModelMap model, Member member)
            throws Exception {

        log.info("member is :" + member);

        Integer code = AcademyMemberUtil.paramCheck(member);
        if (DataUtils.isNotNullOrEmpty(code)) {
            model.addAttribute("code", code);
            return "/data/json";
        }

        try {
            member.setStatus(Member.STATUS_DOWN);
            member.setRecommend(Member.NOT_RECOMMEND);

            Long result = memberService.insert(member);

            log.info("update member result is :" + result);
            log.info("get  member data is " + member);

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get member error,id is  ");
            model.addAttribute("code", -1);
        }

        return "/data/json";
    }


    /**
     * 删除会员套餐
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/a/u/member/{id}", method = RequestMethod.DELETE)
    public String deleteMemberJson(HttpServletRequest request,
                                   HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("delete member : id= " + id);
        Member member = memberService.getObjectById(id);
        if (DataUtils.isNullOrEmpty(member)) {
            model.addAttribute("code", -9100);
            return "/data/json";
        }
        try {
            boolean result = memberService.delete(id);

            log.info("add member  success and result is : " + result);
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete member error,id is  " + id);
            model.addAttribute("code", -1);

        }

        return "/data/json";
    }


    /**
     * 更改会员套餐状态
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/a/u/member/{id}/status/{status}", method = RequestMethod.PUT)
    public String updateMemberStatusJson(HttpServletRequest request,
                                         HttpServletResponse response, ModelMap model, @PathVariable Long id, @PathVariable Integer status)
            throws Exception {

        log.info("id ,status are  :" + id + "," + status);


        //入参校验
        if (DataUtils.isNullOrEmpty(id)) {
            log.error("update error ,id is null");
            model.addAttribute("code", -9101);
            return "/data/json";
        }
        if (DataUtils.isNullOrEmpty(status)) {
            log.error("update error, status is null");
            model.addAttribute("code", -9105);
            return "/data/json";
        }


        try {


            Member member = memberService.getObjectById(id);
            log.info("member is :" + member);
            member.setStatus(status);
            boolean result = memberService.update(member);
            log.info("update status ,result : " + result);
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("update member status error,id is  ");
            model.addAttribute("code", -1);
        }

        return "/data/json";
    }


    //设置推荐套餐
    @RequestMapping(value = "/a/u/recommend/{id}", method = RequestMethod.PUT)
    public String recommendMember(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("set recommend member : id = " + id);

        Manager manager = (Manager) request.getAttribute("manager");
        Long managerId = manager.getId();

        try {
            //确认套餐是否存在
            Member member = memberService.getObjectById(id);
            if (null == member) {
                model.addAttribute("code", -9003);
                log.info("member not exist");
                return "/common/success";
            } else {
                log.info("member exist : " + member);
            }

            //确定套餐是否是未推荐状态
            if (Member.IS_RECOMMEND.equals(member.getRecommend())) {
                model.addAttribute("code", -9006);
                log.info("member already recommend");
                return "/common/success";
            } else {
                log.info("member not recommend");
            }

            //将当前推荐套餐列表取出并设为未推荐（正常应该只有一个）
            List<Long> memberIds = memberService.getMemberIdsByRecommend(Member.IS_RECOMMEND, 0, Integer.MAX_VALUE);
            log.info("now recommend member id : " + memberIds);
            List<Member> members = memberService.getObjectsByIds(memberIds);
            for (Member memberObj : members) {
                memberObj.setRecommend(Member.NOT_RECOMMEND);
            }
            memberService.updateList(members);
            log.info("recommend member reset success");

            //将该套餐状态置1
            member.setRecommend(Member.IS_RECOMMEND);
            memberService.update(member);
            log.info("member " + id + " set recommend success");

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("set recommend error,id is  " + id);
            model.addAttribute("code", -1);

        }

        return "/common/success";
    }


    /**
     * @param id
     * @Description 取消推荐套餐
     * @Author: PeiyuFeng
     * @Time 2017/2/10 11:36
     */
    @RequestMapping(value = "/a/u/recommend/cancel/{id}", method = RequestMethod.PUT)
    public String cancelRecommendMember(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("cancel recommend member : id = " + id);

        Manager manager = (Manager) request.getAttribute("manager");
        Long managerId = manager.getId();

        try {
            //确认套餐是否存在
            Member member = memberService.getObjectById(id);
            if (null == member) {
                model.addAttribute("code", -9003);
                log.info("member not exist");
                return "/common/success";
            } else {
                log.info("member exist : " + member);
            }

            //确定套餐是否是推荐状态
            if (Member.NOT_RECOMMEND
                    .equals(member.getRecommend())) {
                model.addAttribute("code", -9007);
                log.info("member not recommend");
                return "/common/success";
            } else {
                log.info("member already recommend");
            }

            //将该套餐状态置1
            member.setRecommend(Member.NOT_RECOMMEND);
            memberService.update(member);
            log.info("member " + id + " cancel recommend success");

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("cancel recommend error,id is  " + id);
            model.addAttribute("code", -1);

        }

        return "/common/success";
    }

//    /**
//     *排序接口,用字段排序,作废
//     * @param request
//     * @param response
//     * @param model
//     * @param ids
//     * @return
//     * @throws Exception
//     */
//    @RequestMapping(value = "/a/u/member/sort", method = RequestMethod.POST)
//    public String sort(HttpServletRequest request,
//                       HttpServletResponse response, ModelMap model,
//                       @RequestBody List<Long> ids) throws Exception {
//
//        log.info("sort lesson : uids= " + ids);
//
//        try {
//            List<Member> memberList = memberService.getObjectsByIds(ids);
//
//            int index = 0;
//            for (Member article : memberList) {
//                article.setOrderBy(index);
//                index = index + 10;
//            }
//            this.memberService.updateList(memberList);
//
//            model.addAttribute("code", 0);
//        } catch (Throwable t) {
//            t.printStackTrace();
//            log.error(t.getMessage());
//            log.error("add bookUnit error ");
//            model.addAttribute("code", -1);
//        }
//
//        return "/common/success";
//    }

}

