package com.ptteng.academy.admin.util;


import com.gemantic.common.util.StringUtil;
import com.ptteng.academy.admin.constant.CooperatorConstant;
import com.ptteng.academy.admin.exception.MyException;
import com.ptteng.academy.common.model.Message;
import com.ptteng.academy.document.model.Document;
import com.ptteng.academy.document.model.Video;
import com.ptteng.academy.user.model.Member;
import com.ptteng.academy.user.model.UserOpenidRelation;
import com.ptteng.common.dao.util.SQLUtil;
import com.qding.common.util.DataUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang.StringUtils;

import java.math.BigDecimal;
import java.util.*;

import static com.ptteng.common.dao.util.SQLUtil.convertTable;

/**
 * Created by liangxj on 2015/9/7.
 */
public class DynamicUtil {


    public static Map<String, Object> getArticleListParam(String title, String url, String content, Integer status, Integer type, Integer bannerType) {

        Map<String, Object> params = new HashMap<String, Object>();
        Set<String> tables = new HashSet();
        tables.add("article");

        if (DataUtils.isNotNullOrEmpty(type)) {

            params.put(" article.type", type);
        } else {
            params.put(" (article.type ", " 1 or type = 2)");
        }
        if (DataUtils.isNotNullOrEmpty(bannerType)) {

            params.put(" article.banner_type", bannerType);
        }
        if (DataUtils.isNotNullOrEmpty(content)) {

            params.put(" article.content & like", " '%" + content + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(title)) {

            params.put(" article.title & like", " '%" + title + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(url)) {

            params.put(" article.url & like", " '%" + url + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(status)) {

            params.put(" article.status ", status);
        }


        params.put("@order", "  orderBy asc , create_at desc ");
        params.put("@query", " id ");
        String table = convertTable(tables);
        params.put("@table", table);

        return params;
    }


    public static Map<String, Object> getDocumentList(Integer type, String title, String author, Integer status,
                                                      Integer minLike, Integer maxLike, Integer minCollection, Integer maxCollection) {
        Map<String, Object> params = new HashedMap();
        if (DataUtils.isNotNullOrEmpty(title)) {
            params.put("title & like", " '%" + title + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put("type", type);
        }
        if (DataUtils.isNotNullOrEmpty(author)) {
            params.put("author & like", " '%" + author + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("status", status);
        }
        if (DataUtils.isNotNullOrEmpty(minLike)) {
            params.put("love & >=", minLike);
        }
        if (DataUtils.isNotNullOrEmpty(maxLike)) {
            params.put("love & <=", maxLike);
        }
        if (DataUtils.isNotNullOrEmpty(minCollection)) {
            params.put("collection & >=", minCollection);
        }
        if (DataUtils.isNotNullOrEmpty(maxCollection)) {
            params.put("collection & <=", maxCollection);
        }

        params.put("@order", " rank asc, order_by asc, create_at desc ");
        params.put("@query", " id");

        params.put("@table", " document ");

        return params;
    }


    public static Map<String, Object> getVideoList(Integer type, String title, String grade, Integer status, Integer subject,
                                                   Integer minLike, Integer maxLike, Integer minCollection, Integer maxCollection,
                                                   String teacherName) {
        Map<String, Object> params = new HashedMap();
        Set<String> tables = new HashSet();
        tables.add("video");
        if (DataUtils.isNotNullOrEmpty(title)) {
            params.put("video.title & like", " '%" + title + "%'");
        }
//        if (DataUtils.isNotNullOrEmpty(grade)) {
//            params.put("grade", grade );
//        }
        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put("video.type", "'" + type + "'");
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("video.status", "'" + status + "'");
        }
        if (DataUtils.isNotNullOrEmpty(subject)) {
            params.put("video.subject", "'" + subject + "'");
        }
        if (DataUtils.isNotNullOrEmpty(minLike)) {
            params.put("video.love & >=", "'" + minLike + "'");
        }
        if (DataUtils.isNotNullOrEmpty(maxLike)) {
            params.put("video.love & <=", "'" + maxLike + "'");
        }
        if (DataUtils.isNotNullOrEmpty(minCollection)) {
            params.put("video.collection & >=", "'" + minCollection + "'");
        }
        if (DataUtils.isNotNullOrEmpty(maxCollection)) {
            params.put("video.collection & <=", "'" + maxCollection + "'");
        }
        if (DataUtils.isNotNullOrEmpty(teacherName)) {
            params.put("video.teacher_name & like", " '%" + teacherName + "%'");
        }

        if (Video.Type_Banner.equals(type)) {
            params.put("@order", " video.rank asc,video.order_by asc, video.update_at desc ");
        } else {
            params.put("@order", "video.rank asc, video.create_at desc ");
        }

        if (DataUtils.isNotNullOrEmpty(grade)) {
            //查询视频年级关联表
            params.put("video.id", "video_grade_relation.video_id");
            tables.add("video_grade_relation");
            params.put("video_grade_relation.grade", "'" + grade + "'");
        }

        params.put("@query", " video.id");
        String table = convertTable(tables);
        params.put("@table", table);
        return params;
    }


    public static Map<String, Object> getDocumentMaxOrderBy() {
        Map<String, Object> params = new HashMap<String, Object>();

        params.put("@order", " order_by desc ");

        params.put("@query", " id ");

        params.put("@table", " document");

        return params;

    }

    public static Map<String, Object> getVideoMaxOrderBy() {
        Map<String, Object> params = new HashMap<String, Object>();

        params.put("@order", " order_by desc ");

        params.put("@query", " id ");

        params.put("@table", " video");

        return params;

    }


    public static Map<String, Object> getMessageList(Integer grade, String name, Integer messageType, String nick, Long timeLow, Long timeHigh, String mail, Integer type) {
        Map<String, Object> params = new HashedMap();
        if (DataUtils.isNotNullOrEmpty(name)) {
            params.put("name & like", " '%" + name + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(mail)) {
            params.put("mail & like", " '%" + mail + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(nick)) {
            params.put("nick & like", " '%" + nick + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(messageType)) {
            params.put("message_type", "'" + messageType + "'");
        }
        if (DataUtils.isNotNullOrEmpty(grade)) {
            params.put("grade", "'" + grade + "'");
        }
        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put("type", "'" + type + "'");
            if (type == 1) {
                params.put("grade & <", "'" + 8 + "'");
            }
        }
        if (DataUtils.isNotNullOrEmpty(timeLow)) {
            params.put("create_at&>", "'" + timeLow + "'");
        }
        if (DataUtils.isNotNullOrEmpty(timeHigh)) {
            params.put("create_at&<", "'" + timeHigh + "'");
        }

        if (Message.Type_Advice.equals(type)) {
            params.put("@order", "  create_at desc  ");
        } else {
            params.put("@order", "  sort asc ");
        }

        params.put("@query", " id");

        params.put("@table", " message ");

        return params;
    }


    public static Map<String, Object> getUserList(String alias, String mail, String mobile, Integer grade, Integer status, Integer scoreStart,
                                                  Integer scoreEnd, String location, Long schoolId, String className, List<Integer> isMembers, List<Long> userIds) {
        Map<String, Object> params = new HashMap<String, Object>();

        if (alias != null) {
            params.put("alias & like", " '%" + alias + "%'");
        }
        if (mail != null) {
            params.put("mail & like", " '%" + mail + "%'");
        }
        if (mobile != null) {
            params.put("mobile & like", " '%" + mobile + "%'");
        }
        if (grade != null) {
            params.put("grade", grade);
        }
        if (status != null) {
            params.put("status", status);
        }
        if (scoreStart != null) {
            params.put("score & >=", scoreStart);
        }
        if (scoreEnd != null) {
            params.put("score & <=", scoreEnd);
        }
        if (location != null) {
            params.put("location & like", " '%" + location + "%'");
        }
        if (schoolId != null) {
            params.put(" school_id ", schoolId);
        }
        if (className != null) {
            params.put(" class_name & like ", "'%" + className + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(userIds)) {
            params.put(" id & in ", "(" + StringUtils.join(userIds, ",") + ")");
        }
        if (CollectionUtils.isNotEmpty(isMembers)) {
            params.put(" is_member & in", "(" + StringUtils.join(isMembers, ",") + ")");
        }
        params.put("@order", " create_at desc");
        params.put("@table", " user");

        return params;

    }

    public static Map<String, Object> getUserListByIsMember(Integer isMember, Long schoolId) {
        Map<String, Object> params = new HashMap<String, Object>();

        if (DataUtils.isNotNullOrEmpty(isMember)) {
            params.put(" is_member ", isMember);
        }
        if (DataUtils.isNotNullOrEmpty(schoolId)) {
            params.put(" school_id ", schoolId);
        }
        params.put("@order", " create_at desc");
        params.put("@table", " user");
        return params;

    }

    private static final Integer READ_SORT_ASC = 1;
    private static final Integer READ_SORT_DESC = 2;
    private static final Integer REPLY_SORT_ASC = 3;
    private static final Integer REPLY_SORT_DESC = 4;

    public static Map<String, Object> getPostList(Integer type, String title, String author, Integer grade, Long minAt, Long maxAt, Integer sort) {
        Map<String, Object> params = new HashMap<String, Object>();
        Set<String> tables = new HashSet();
        tables.add("posts");

        if (type != null) {
            params.put("posts.digest", type);
        }
        if (title != null) {
            params.put("posts.title & like", " '%" + title + "%'");
        }
        if (StringUtil.isNotEmpty(author)) {
            params.put("user.id ", "posts.uid");
            params.put(" user.alias & like ", "'%" + author + "%'");
            tables.add("academy_user.user");
        }
        if (grade != null) {
            params.put("posts.grade", grade);
        }
        if (minAt != null) {
            params.put("create_at & >=", minAt);
        }
        if (maxAt != null) {
            params.put("create_at & <=", maxAt);
        }

        if (READ_SORT_ASC.equals(sort)) {
            params.put("@order", " posts.read_count asc");
        } else if (READ_SORT_DESC.equals(sort)) {
            params.put("@order", " posts.read_count desc");
        } else if (REPLY_SORT_ASC.equals(sort)) {
            params.put("@order", " posts.replies_count asc");
        } else if (REPLY_SORT_DESC.equals(sort)) {
            params.put("@order", " posts.replies_count desc");
        } else {
            params.put("@order", " posts.sticky desc , posts.create_at desc");
        }

        params.put("@query", " posts.id");

        String table = convertTable(tables);
        params.put("@table", table);

        return params;

    }


    public static Map<String, Object> getHollowList(Long minAt, Long maxAt, Integer minHotLevel, Integer maxHotLevel,
                                                    Integer minBumpCount, Integer maxBumpCount, Integer minDownCount,
                                                    Integer maxDownCount, Integer status) {

        Map<String, Object> params = new HashMap<String, Object>();

        if (minHotLevel != null) {
            params.put(" (bump_count + down_count)  & >= ", minHotLevel);
        }
        if (maxHotLevel != null) {
            params.put(" (bump_count + down_count)  & <= ", maxHotLevel);
        }

        if (minBumpCount != null) {
            params.put("bump_count & >=", minBumpCount);
        }
        if (maxBumpCount != null) {
            params.put("bump_count & <=", maxBumpCount);
        }

        if (minDownCount != null) {
            params.put("down_count & >=", minDownCount);
        }
        if (maxDownCount != null) {
            params.put("down_count & <=", maxDownCount);
        }


        if (minAt != null) {
            params.put("create_at & >=", minAt);
        }
        if (maxAt != null) {
            params.put("create_at & <=", maxAt);
        }

        params.put("@order", " create_at desc");
        params.put("@query", " id");
        params.put("@table", "hollow");

        return params;

    }

    //获得couponList列表
    public static Map<String, Object> getCouponList(Integer status, String number, String minPeriod, String maxPeriod, Long effectBegin, Long effectEnd,
                                                    Long invalidBegin, Long invalidEnd, Long memberId, boolean count) {
        Map<String, Object> params = new HashedMap();
        Set<String> tables = new HashSet();
        tables.add("coupon");
        if (DataUtils.isNotNullOrEmpty(number)) {
            params.put("coupon.number & like", " '%" + number + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("coupon.status ", " '" + status + "'");
        }
        if (DataUtils.isNotNullOrEmpty(minPeriod)
                || DataUtils.isNotNullOrEmpty(maxPeriod)
                || DataUtils.isNotNullOrEmpty(memberId)) {
            if (DataUtils.isNotNullOrEmpty(minPeriod)) {
                params.put("member.period+0 & >= ", " '" + minPeriod + "'");
            }
            if (DataUtils.isNotNullOrEmpty(maxPeriod)) {
                params.put("member.period+0 & <= ", " '" + maxPeriod + "'");
            }
            if (DataUtils.isNotNullOrEmpty(memberId)) {
                params.put(" coupon.member_id  ", " '" + memberId + "'");

            }
            params.put(" coupon.member_id ", " member.id");
            tables.add("member");

        }
        if (DataUtils.isNotNullOrEmpty(effectBegin)) {
            params.put("coupon.create_at & >= ", " '" + effectBegin + "'");
        }
        if (DataUtils.isNotNullOrEmpty(effectEnd)) {
            params.put("coupon.create_at & <= ", " '" + effectEnd + "'");
        }

        if (DataUtils.isNotNullOrEmpty(invalidBegin)) {
            params.put("coupon.deadline & >= ", " '" + invalidBegin + "'");
        }
        if (DataUtils.isNotNullOrEmpty(invalidEnd)) {
            params.put("coupon.deadline & <= ", " '" + invalidEnd + "'");
        }

        if (count) {
            params.put("@query", " count(coupon.id) ");

        } else {
            params.put("@order", "  coupon.create_at desc ");
            params.put("@query", " coupon.id ");
        }

        String table = convertTable(tables);
        params.put("@table", table);

        return params;

    }

//    //得到会员套餐列表
//    public static Map<String, Object> getMemberList(String name, String minPeriod, String maxPeriod, String minPrice, String maxPrice, Integer status, boolean count) {
//        Map<String, Object> params = new HashedMap();
//        if (StringUtil.isNotEmpty(name)) {
//            params.put("name & like", " '%" + name + "%'");
//        }
//        if (DataUtils.isNotNullOrEmpty(status)) {
//            params.put("status", " '" + status + "'");
//        }
//        if (DataUtils.isNotNullOrEmpty(minPeriod)) {
//            params.put("period+0 & >= ", " '" + minPeriod + "'");
//        }
//        if (DataUtils.isNotNullOrEmpty(maxPeriod)) {
//            params.put("period+0 & <= ", " '" + maxPeriod + "'");
//        }
//        if (DataUtils.isNotNullOrEmpty(minPrice)) {
//            params.put("price+0 & >= ", " '" + minPrice + "'");
//        }
//        if (DataUtils.isNotNullOrEmpty(maxPrice)) {
//            params.put("price+0 & <= ", " '" + maxPrice + "'");
//        }
//
//
//        if (count) {
//            params.put("@query", " count(id)");
//
//        } else {
//            params.put("@order", "  orderBy, create_at desc ");
//            params.put("@query", " id");
//        }
//
//
//        params.put("@table", " member ");
//
//        return params;
//    }


    //得到会员套餐列表(新增ios价格）
    public static Map<String, Object> getMemberList(String name, String minPeriod, String maxPeriod, String minPrice, String maxPrice, BigDecimal minIOSPrice, BigDecimal maxIOSPrice, Integer status, boolean count) {
        Map<String, Object> params = new HashedMap();
        if (StringUtil.isNotEmpty(name)) {
            params.put("name & like", " '%" + name + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("status", " '" + status + "'");
        }
        if (DataUtils.isNotNullOrEmpty(minPeriod)) {
            params.put("period+0 & >= ", " '" + minPeriod + "'");
        }
        if (DataUtils.isNotNullOrEmpty(maxPeriod)) {
            params.put("period+0 & <= ", " '" + maxPeriod + "'");
        }
        if (DataUtils.isNotNullOrEmpty(minPrice)) {
            params.put("price+0 & >= ", " '" + minPrice + "'");
        }
        if (DataUtils.isNotNullOrEmpty(maxPrice)) {
            params.put("price+0 & <= ", " '" + maxPrice + "'");
        }
        if (DataUtils.isNotNullOrEmpty(minIOSPrice)) {
            params.put("ios_price & >= ", " '" + minIOSPrice + "'");
        }
        if (DataUtils.isNotNullOrEmpty(maxIOSPrice)) {
            params.put("ios_price & <= ", " '" + maxIOSPrice + "'");
        }


        if (count) {
            params.put("@query", " count(id)");

        } else {
            params.put("@order", "  orderBy, create_at desc ");
            params.put("@query", " id");
        }
//        if (DataUtils.isNullOrEmpty(platform)) {
        params.put("platform", Member.PLATFORM_DOUNIXUE);
//        }else {
//            params.put("platform",platform);
//        }


        params.put("@table", " member ");

        String s = SQLUtil.convert2Sql(params, 0, Integer.MAX_VALUE);

        System.out.println(s);
        return params;
    }


    //公告栏列表
    public static Map<String, Object> getNoticeList(String title, Integer status, boolean count) {
        Map<String, Object> params = new HashMap<>();
        if (DataUtils.isNotNullOrEmpty(title)) {
            params.put("title & like", "'%" + title + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("status", status);
        }
        if (count) {
            params.put("@query", "count(id)");
        } else {
            params.put("@query", "id");
            params.put("@order", "create_at desc");
        }
        params.put("@table", "notice");

        return params;
    }


    //查询视频年级关联表的内容
    public static Map<String, Object> getVideoGradeRelationIds(Long videoId) {
        Map<String, Object> params = new HashMap<>();
        params.put("video_id", videoId);
        params.put("@query", "id");
        params.put("@order", "create_at desc");

        params.put("@table", "video_grade_relation");

        return params;

    }

    //文章置顶
    public static Map<String, Object> getDocumentRank(Long documentId) {
        Map<String, Object> params = new HashMap<>();

        params.put("rank", Document.RANK_TOP);
        params.put("@query", "id");
        params.put("@order", "create_at desc");

        params.put("@table", "document");

        return params;

    }

    //视频置顶
    public static Map<String, Object> getVideotRank(Long videoId) {
        Map<String, Object> params = new HashMap<>();

        params.put("rank", Video.RANK_TOP);
        params.put("@query", "id");
        params.put("@order", "create_at desc");

        params.put("@table", "video");

        return params;

    }

    //按照类型搜索视频列表
    public static Map<String, Object> getVideoListByType(Integer type) {
        Map<String, Object> params = new HashMap<>();

        params.put(" type ", type);
        params.put("@query", "id");
        params.put("@order", " rank asc, create_at desc");

        params.put("@table", "video");

        return params;

    }

    //搜索原有的视频关联表，拿到总数
    public static Map<String, Object> getVideoGradeIds(Long id) {
        Map<String, Object> params = new HashedMap();
        params.put("video_id", "'" + id + "'");
        params.put("@query", "count(id)");
        params.put("@table", "video_grade_relation");

        return params;
    }

    //搜索原有的视频关联表，拿到总数
    public static Map<String, Object> getVideoGradeIdsTotal(Long id) {
        Map<String, Object> params = new HashedMap();
        params.put("video_id", "'" + id + "'");
        params.put("@query", "id");
        params.put("@table", "video_grade_relation");

        return params;
    }

    public static Map<String, Object> getTaskList(Integer taskType, String taskName, List<Long> subjectIds, List<Long> lessonIds, List<Long> periodIds,
                                                  Integer gradeDept, Integer status, Integer specificType, Integer difficultyLevel) {
        Map<String, Object> params = new HashedMap();
        Set<String> tables = new HashSet();
        tables.add("task");
        if (DataUtils.isNotNullOrEmpty(taskName)) {
            params.put("task.task_name & like", " '%" + taskName + "%'");
        }

        if (CollectionUtils.isNotEmpty(subjectIds)) {
            params.put("task.subject_id & in", "(" + StringUtils.join(subjectIds, ",") + ")");
        }
        if (DataUtils.isNotNullOrEmpty(taskType)) {
            params.put("task.task_type", "'" + taskType + "'");
        }
        if (CollectionUtils.isNotEmpty(lessonIds)) {

            params.put("task.lesson_id & in", "(" + StringUtils.join(lessonIds, ",") + ")");
        }
        if (CollectionUtils.isNotEmpty(periodIds)) {
            params.put("task.period_id & in", "(" + StringUtils.join(periodIds, ",") + ")");
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("task.status", "'" + status + "'");
        }
        if (DataUtils.isNotNullOrEmpty(gradeDept)) {
            params.put("task.grade_dept", "'" + gradeDept + "'");
        }
        if (DataUtils.isNotNullOrEmpty(specificType)) {

            params.put("task.specific_type", "'" + specificType + "'");
            if (DataUtils.isNotNullOrEmpty(difficultyLevel)) {
                params.put("task.difficulty_level", "'" + difficultyLevel + "'");
            }
        }


        params.put("@order", "  task.sort");
        params.put("@query", " task.id");
        String table = convertTable(tables);

        params.put("@table", table);

        return params;
    }

    public static Map<String, Object> getPeriodList(String periodName, String lessonIds, String subjectIds, Integer status, Integer gradeDept) {

        Map<String, Object> params = new HashedMap();
        Set<String> tables = new HashSet();
        tables.add("period");
        if (DataUtils.isNotNullOrEmpty(periodName)) {
            params.put("period.period_name & like", " '%" + periodName + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(lessonIds)) {

            params.put("period.lesson_id & in", "(" + lessonIds + ")");
        }
        if (DataUtils.isNotNullOrEmpty(subjectIds)) {

            params.put("period.subject_id & in", "(" + subjectIds + ")");
        }
        if (DataUtils.isNotNullOrEmpty(gradeDept)) {
            params.put("grade_dept", "'" + gradeDept + "'");
        }
        if (DataUtils.isNotNullOrEmpty(status)) {

            params.put("period.status", "'" + status + "'");
        }

        params.put("@order", "  period.sort");
        params.put("@query", " period.id ");
        String table = convertTable(tables);
        params.put("@table", table);

        String s = SQLUtil.convert2Sql(params, 0, Integer.MAX_VALUE);
        System.out.println(s);
        return params;

    }

    public static Map<String, Object> getBannerListByPeriod(Long periodId) {

        Map<String, Object> params = new HashedMap();
        Set<String> tables = new HashSet();
        tables.add("article");
        if (DataUtils.isNotNullOrEmpty(periodId)) {
            params.put(" content & like ", " '%\"periodId\":" + periodId + "%'");
        }

        params.put(" status ", "1");

        params.put("@query", " id ");
        String table = convertTable(tables);
        params.put("@table", table);

        String s = SQLUtil.convert2Sql(params, 0, Integer.MAX_VALUE);
        System.out.println(s);
        return params;

    }

    public static Map<String, Object> getLessonList(String lessonName, List<Long> subjectIds, Integer status, Integer gradeDept) {

        Map<String, Object> params = new HashedMap();

        if (DataUtils.isNotNullOrEmpty(lessonName)) {
            params.put("lesson_name & like", " '%" + lessonName + "%'");
        }

        if (CollectionUtils.isNotEmpty(subjectIds)) {
            params.put("subject_id & in", "(" + StringUtils.join(subjectIds, ",") + ")");
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("status", "'" + status + "'");
        }
        if (DataUtils.isNotNullOrEmpty(gradeDept)) {
            params.put("grade_dept", "'" + gradeDept + "'");
        }

        params.put("@order", "  sort asc, update_at desc");
        params.put("@query", " id");
        params.put("@table", " lesson ");

        return params;
    }

    // 搜索科目列表
    public static Map<String, Object> getSubjectList(String subjectName, Integer gradeDept, Integer status) {

        Map<String, Object> params = new HashedMap();
        if (DataUtils.isNotNullOrEmpty(subjectName)) {
            params.put(" subject_name & like", " '%" + subjectName + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(gradeDept)) {
            params.put("grade_dept", "'" + gradeDept + "'");
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("status", " '" + status + "'");
        }

        params.put("@order", "  sort asc ");
        params.put("@query", " id");

        params.put("@table", " subject ");

        return params;
    }

    public static Map<String, Object> getSchoolList(String name, Long id) {
        Map<String, Object> params = new HashMap<>();
        if (DataUtils.isNotNullOrEmpty(name)) {
            params.put(" name & like ", "'%" + name + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(id)) {
            params.put(" id ", id);
        }

        params.put("@order", "  update_at desc ");
        params.put("@query", " id");

        params.put("@table", " school ");

        return params;
    }

    public static Map<String, Object> getSchoolListByName(String name) {
        Map<String, Object> params = new HashMap<>();
        if (DataUtils.isNotNullOrEmpty(name)) {
            params.put(" name ", "'" + name + "'");
        }

        params.put("@order", "  update_at desc ");
        params.put("@query", " id");

        params.put("@table", " school ");

        return params;
    }

    public static Map<String, Object> getOpinionList(String name, String mail, Long startAt, Long endAt) {
        Map<String, Object> params = new HashMap<>();
        if (DataUtils.isNotNullOrEmpty(name)) {
            params.put(" name & like ", "'%" + name + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(mail)) {
            params.put(" mail ", mail);
        }
        if (DataUtils.isNotNullOrEmpty(startAt)) {
            params.put(" create_at & >= ", startAt);
        }
        if (DataUtils.isNotNullOrEmpty(endAt)) {
            params.put(" create_at & <= ", endAt);
        }
        params.put("@order", "  update_at desc ");
        params.put("@query", " id");

        params.put("@table", " opinion ");

        return params;
    }

    public static Map<String, Object> getOpinionListByName(String name) {
        Map<String, Object> params = new HashMap<>();
        if (DataUtils.isNotNullOrEmpty(name)) {
            params.put(" name ", "'" + name + "'");
        }

        params.put("@order", "  update_at desc ");
        params.put("@query", " id");

        params.put("@table", " opinion ");

        return params;
    }

    public static Map<String, Object> getUidListByUserMemberRelation(Long endAt, String name, Integer status) {
        Map<String, Object> params = new HashMap<>();
        if (DataUtils.isNotNullOrEmpty(endAt)) {
            params.put(" end_at & <= ", endAt);
        }
        if (DataUtils.isNotNullOrEmpty(name)) {
            params.put(" name ", "'" + name + "'");
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put(" status ", status);
        }
        params.put("@order", "  create_at desc ");
        params.put("@query", "distinct uid");

        params.put("@table", " user_member_relation ");

        return params;
    }

    public static Map<String, Object> getOpenidByMobileList(List<String> openidList, String type) {
        Map<String, Object> params = new HashMap<>();
        if (DataUtils.isNotNullOrEmpty(openidList)) {
            params.put(" openid & in ", "('" + org.apache.commons.lang3.StringUtils.join(openidList, "','") + "')");
        }
        if (DataUtils.isNotNullOrEmpty(type)) {
            if (type.equals(UserOpenidRelation.TYPE_MOBILE)) {
                params.put(" type ", "'" + UserOpenidRelation.TYPE_MOBILE + "'");
            } else if (type.equals(UserOpenidRelation.TYPE_MAIL)) {
                params.put(" type ", "'" + UserOpenidRelation.TYPE_MAIL + "'");
            }
        }


        params.put("@order", "  create_at desc ");
        params.put("@query", " id ");

        params.put("@table", " user_openid_relation ");

        return params;
    }


    public static Map<String, Object> getUserIdByMobileList(List<String> openidList) {
        Map<String, Object> params = new HashMap<>();
        if (DataUtils.isNotNullOrEmpty(openidList)) {
            params.put(" mobile & in ", "('" + org.apache.commons.lang3.StringUtils.join(openidList, "','") + "')");
        }

        params.put("@order", "  create_at desc ");
        params.put("@query", " id ");
        params.put("@table", " user ");

        return params;
    }

    public static Map<String, Object> getUnitList(Integer mediaType) {

        Map<String, Object> params = new HashMap<>();

        if (DataUtils.isNotNullOrEmpty(mediaType)) {

            params.put("media_type", "'" + mediaType + "'");
        }

        params.put("@order", " sort asc ");
        params.put("@query", "id");

        return params;
    }


    public static Map<String, Object> getUserFavoriteRelationList(Integer targetType, Integer collectType, boolean count) {

        Map<String, Object> params = new HashMap<>();
        if (DataUtils.isNotNullOrEmpty(targetType)) {

            params.put("target_type", "'" + targetType + "'");
        }
        if (DataUtils.isNotNullOrEmpty(collectType)) {

            params.put("type", "'" + collectType + "'");
        }
        if (count) {
            params.put("@query", " count(id) ");

        } else {

            params.put("@query", " id ");
        }
        params.put("@table", " user_favorite_relation");

        String s = SQLUtil.convert2Sql(params, 0, Integer.MAX_VALUE);

        return params;
    }


    public static Map<String, Object> getPageStatisticsList(List<Long> targetIds, Integer targetType, Integer os, Integer isMember, Long startAt, Long endAt) {

        Map<String, Object> params = new HashMap<>();

        if (CollectionUtils.isNotEmpty(targetIds)) {
            String targetIdsStr = org.apache.commons.lang3.StringUtils.join(targetIds, ",");
            params.put(" target_id & in ", "(" + targetIdsStr + ")");
        }
        if (DataUtils.isNotNullOrEmpty(targetType)) {
            params.put("target_type", "'" + targetType + "'");
        }
        if (DataUtils.isNotNullOrEmpty(isMember)) {
            params.put("is_member", "'" + isMember + "'");
        }
        if (DataUtils.isNotNullOrEmpty(os)) {
            params.put("os", "'" + os + "'");
        }
        if (DataUtils.isNullOrEmpty(startAt) || DataUtils.isNullOrEmpty(endAt)) {

        }
        if (DataUtils.isNotNullOrEmpty(startAt) && DataUtils.isNotNullOrEmpty(endAt)) {

            if (startAt > endAt) {
                throw new MyException("5027", "startAt later than endAt!");
            }

            if (startAt.equals(endAt)) {
                params.put("view_at", "'" + startAt + "'");
            } else {
                params.put("view_at & >=", "'" + startAt + "'");
                params.put("view_at & <=", "'" + endAt + "'");
            }
        }

        params.put("@table", " page_statistic");

        System.out.println(SQLUtil.convert2Sql(params, 0, Integer.MAX_VALUE));
        return params;

    }


    public static Map<String, Object> getXinHuaMeiYuUserList(String username, String mobile, Integer minOrderNumber, Integer maxOrderNumber,
                                                             Double minOrderMoney, Double maxOrderMoney, boolean count) {
        Map<String, Object> params = new HashMap<>();


        params.put("@table", " (SELECT\n" +
                "\tuser.id,\n" +
                "\tuser.name,\n" +
                "\tuser.mobile,\n" +
                "\tuser.status,\n" +
                "\tuser_openid_relation.type,\n" +
                "\tuser_openid_relation.openid as username,\n" +
                "\tuser_openid_relation.create_at as create_at,\n" +
                "\tCOALESCE(temp_order.lesson_order_number,0) AS lesson_order_number,\n" +
                "\tCOALESCE(temp_order.member_order_number,0) AS member_order_number,\n" +
                "\tCOALESCE(temp_order.price,0) AS total_money,\n" +
                "\tCOALESCE(temp_order.total_order_number,0) AS total_order_number\n" +
                "FROM\n" +
                "\tuser\n" +
                "LEFT JOIN user_openid_relation ON user_openid_relation.uid =user.id\n" +
                "LEFT JOIN (\n" +
                "\tSELECT\n" +
                "\t\tuser_id,\n" +
                "\t\tcreate_at,\n" +
                "\t\tSUM(price) AS price,\n" +
                "\t\tSUM(buy_type = 1) AS lesson_order_number,\n" +
                "\t\tSUM(buy_type = 6) AS member_order_number,\n" +
                "\t\tCOUNT(id) AS total_order_number\n" +
                "\tFROM\n" +
                "\t\tuser_order\n" +
                "\tWHERE\n" +
                "\t\tSTATUS = 3 \n" +
                "\t\tAND os = 2\n" +
                "\tGROUP BY\n" +
                "\t\tuser_id\n" +
                ") temp_order ON temp_order.user_id = user.id\n" +
                "WHERE user_openid_relation.type like '%xinhuameiyu%'\n" +
                "\n" +
                "GROUP BY\n" +
                "\tuser.id\n" +
                "ORDER BY\n" +
                "\tuser_openid_relation.create_at DESC)t ");


        if (StringUtils.isNotBlank(username)) {
            params.put("username & like", " '%" + username + "%' ");
        }

        if (StringUtils.isNotBlank(mobile)) {
            params.put(" mobile & like ", " '%" + mobile + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(minOrderNumber)) {
            params.put("t.total_order_number+0 & >= ", " '" + minOrderNumber + "' ");
        }

        if (DataUtils.isNotNullOrEmpty(maxOrderNumber)) {
            params.put("t.total_order_number+0 & <= ", " '" + maxOrderNumber + "' ");
        }

        if (DataUtils.isNotNullOrEmpty(minOrderMoney)) {
            params.put("total_money+0 & >= ", " '" + minOrderMoney + "' ");
        }

        if (DataUtils.isNotNullOrEmpty(maxOrderMoney)) {
            params.put("total_money+0 & <= ", " '" + maxOrderMoney + "' ");
        }


        if (count) {
            params.put("@query", " count(t.id) ");
        } else {
            params.put("@query", " t.id,t.total_money,t.lesson_order_number,t.member_order_number,t.mobile,t.username,t.type,t.total_order_number,t.name,t.status ");
        }

        params.put("@order", " t.create_at desc");


        return params;
    }


    public static Map<String, Object> getXinHuaMeiYuUserRelationIdByUid(Long uid) {
        Map<String, Object> params = new HashMap<>();

        params.put("@table", "user_openid_relation");
        params.put("type & like ", " 'xinhuameiyu%' ");
        params.put("@query", " id ");
        params.put("@order", " create_at desc ");

        params.put(" uid ", " '" + uid + "' ");
        params.put(" create_at+0 & >=", " '" + CooperatorConstant.COOPERATOR_LINK_START_TIME + "' ");

        return params;
    }

    public static Map<String, Object> getXinHuaMeiYuOrder(Long uid, boolean count) {
        Map<String, Object> params = new HashMap<>();

        params.put("@table", "(SELECT\n" +
                "\tuser_order.user_id AS id,\n" +
                "\tuser_order.buy_type AS type,\n" +
                "\tuser_order.price,\n" +
                "\tCOALESCE (\n" +
                "\t\tmember. NAME,\n" +
                "\t\tlesson.lesson_name\n" +
                "\t) AS order_name,\n" +
                "\tuser_order.pay_at AS time\n" +
                "FROM\n" +
                "\tuser_order\n" +
                "LEFT JOIN user_openid_relation ON user_order.user_id = user_openid_relation.uid\n" +
                "LEFT JOIN academy_course.lesson ON lesson.id = user_order.target_id\n" +
                "LEFT JOIN member ON member.id = user_order.target_id\n" +
                "WHERE\n" +
                "\tuser_order. STATUS = 3 AND user_order.os = 2\n" +
                "AND user_openid_relation.type LIKE 'xinhuameiyu%') t");

        if (DataUtils.isNotNullOrEmpty(uid)) {
            params.put(" t.id+0 ", " '" + uid + "' ");
        }

        if (count) {
            params.put("@query", "count(id)");
        } else {
            params.put("@query", " t.id,t.price,t.time,t.order_name,t.time,t.type");
        }


        params.put("@order", " t.time desc");

        return params;
    }


    /**
     * 为了填充日期无订单日期写出的方法，怎么实现的我也不是很明白，扩展性为0，非神人勿看
     *
     * @param startAt
     * @param endAt
     * @param page
     * @param size
     * @return
     */
    public static Map<String, Object> getXinHuaMeiYuDateOrder(Long startAt, Long endAt, Integer page, Integer size) {
        Map<String, Object> params = new HashMap<>();

        //由于时间在使用这个方法的地方多加了一天，所以这里要减掉一天
        startAt = DateUtil.getTimeInMillisDayStart(startAt);
        endAt = DateUtil.getTimeInMillisDayStart(endAt) - 86400000L;

        StringBuilder stringBuilder = new StringBuilder("select 1  ");
        String append = " union all select 1 ";

        Integer start = page - 1;

        Integer dayNumber = (int) ((endAt - startAt) / 86400000L) + 1;

        if (dayNumber < size) {
            size = dayNumber;
        } else {
            if ((dayNumber - start * size) > size) {
                endAt = endAt - 86400000L * start * size;
            } else {
                endAt = endAt - 86400000L * start * size;
                size = (dayNumber - start * size);
            }

            while (endAt < startAt) {
                endAt = endAt + 86400000;
            }
        }


        if (size > 1) {
            for (int i = 1; i < size; i++) {
                stringBuilder.append(append);
            }
        }


        params.put("@table", " (SELECT \n" +
                "\tdate,UNIX_TIMESTAMP(date)*1000 as time,\n" +
                "\tCOALESCE(total_money,0) AS total_money,\n" +
                "\tCOALESCE(lesson_order_number,0) AS lesson_order_number,\n" +
                "\tCOALESCE(member_order_number,0) AS member_order_number,\n" +
                "\tCOALESCE(total_order_number,0)AS total_order_number ,\n" +
                "\tCOALESCE(lesson_money,0) AS lesson_money,\n" +
                "\tCOALESCE(member_money,0) AS member_money\n" +
                "FROM \n" +
                "\t(select date_add(DATE_FORMAT(from_unixtime(" + endAt + "/1000),'%Y-%m-%d'),interval @i:=@i-1 day) as date \n" +
                "\tfrom ( " + stringBuilder.toString() + " ) as tmp,\n" +
                " (select @i:= +1)t)temp_time LEFT JOIN (SELECT\n" +
                "\tFROM_UNIXTIME(user_order.pay_at / 1000,'%Y-%m-%d') AS time,\n" +
                "\tROUND(SUM(price),2) AS total_money,\n" +
                "\tSUM(buy_type = 1) AS lesson_order_number,\n" +
                "\tSUM(buy_type = 6) AS member_order_number,\n" +
                "\tCOUNT(user_order.id) AS total_order_number,\n" +
                "\tROUND(SUM(CASE WHEN buy_type = 1 THEN price ELSE 0 END),2) AS lesson_money,\n" +
                "\tROUND(SUM(CASE WHEN buy_type = 6 THEN price ELSE 0 END),2) AS member_money\n" +
                "FROM\n" +
                "\tuser_order\n" +
                "LEFT JOIN user_openid_relation ON user_openid_relation.uid = user_order.user_id\n" +
                "WHERE\n" +
                "\tuser_order.status = 3 AND user_order.os = 2\n" +
                "AND user_openid_relation.type LIKE 'xinhuameiyu%'\n" +
                "GROUP BY time\n" +
                "ORDER BY time DESC)date_order ON temp_time.date = date_order.time)t ");

        params.put("@query", " t.time,lesson_money,t.lesson_order_number,t.member_money,t.member_order_number,t.total_money  ");

        return params;
    }

//    /**
//     * 为了填充日期无订单日期写出的方法，怎么实现的我也不是很明白，扩展性为0，非神人勿看
//     * @param startAt
//     * @param endAt
//     * @param page
//     * @param size
//     * @return
//     */
//    public static Map<String, Object> getXinHuaMeiYuDateOrder(Long startAt, Long endAt, Integer page,Integer size) {
//        Map<String, Object> params = new HashMap<>();
//
//        //由于时间在使用这个方法的地方多加了一天，所以这里要减掉一天
//        startAt = DateUtil.getTimeInMillisDayStart(startAt);
//        endAt = DateUtil.getTimeInMillisDayStart(endAt)-86400000L;
//
//        StringBuilder stringBuilder = new StringBuilder("select 1  ");
//        String append = " union all select 1 ";
//
//        Integer start = page - 1;
//
//        Integer dayNumber = (int) ((endAt - startAt) / 86400000L)+1;
//
//        if (dayNumber < size) {
//            size = dayNumber;
//        }else{
//            if ((dayNumber - start * size) > size) {
//                endAt = endAt - 86400000L * start * size;
//            } else {
//                endAt = endAt - 86400000L * start  * size;
//                size = (dayNumber - start * size);
//            }
//
//            while (endAt < startAt) {
//                endAt = endAt + 86400000;
//            }
//        }
//
//
//        if (size > 1) {
//            for (int i = 1; i < size ; i++) {
//                stringBuilder.append(append);
//            }
//        }
//
//
//        params.put("@table", " (SELECT temp1.date as time ,lesson.lesson_money,lesson.lesson_order_number,member.member_order_number,member.member_money FROM (select date_add(DATE_FORMAT(from_unixtime(" + endAt + "/1000),'%Y-%m-%d'),interval @i:=@i-1 day) as date \n" +
//                "from ( " + stringBuilder.toString() + " ) as tmp,\n" +
//                " (select @i:= +1)t)temp1 LEFT JOIN (SELECT\n" +
//                "\tDATE_FORMAT(from_unixtime(uesr_course_relation.create_at/1000),'%Y-%m-%d')  AS date,\n" +
//                "\tacademy_user.uesr_course_relation.create_at AS time,\n" +
//                "\tcount(uesr_course_relation.id) AS lesson_order_number,\n" +
//                "\tROUND(SUM(lesson.price),2) AS lesson_money\n" +
//                "FROM\n" +
//                "\tacademy_user.uesr_course_relation\n" +
//                "LEFT JOIN academy_course.lesson ON lesson.id = uesr_course_relation.target_id\n" +
//                "LEFT JOIN user_openid_relation ON user_openid_relation.uid = uesr_course_relation.uid \n" +
//                "WHERE user_openid_relation.type like '%xinhuameiyu%' AND user_openid_relation.create_at >= " + CooperatorConstant.COOPERATOR_LINK_START_TIME + "  And uesr_course_relation.create_at >= user_openid_relation.create_at \n" +
//                "GROUP BY\n" +
//                " DATE_FORMAT(from_unixtime(uesr_course_relation.create_at/1000),'%Y-%m-%d') DESC)lesson ON lesson.date = temp1.date \n" +
//                "left JOIN (SELECT\n" +
//                "\tDATE_FORMAT(from_unixtime(user_member_relation.create_at/1000),'%Y-%m-%d') AS date,\n" +
//                "\tuser_member_relation.create_at as time,\n" +
//                "\tCOUNT(user_member_relation.id) AS member_order_number,\n" +
//                "\tROUND(SUM(price),2) AS member_money\n" +
//                "FROM\n" +
//                "\tuser_member_relation\n" +
//                "\n" +
//                "LEFT JOIN user_openid_relation ON user_openid_relation.uid = user_member_relation.uid\n" +
//                "\n" +
//                "WHERE user_openid_relation.type like '%xinhuameiyu%' AND user_openid_relation.create_at >= " + CooperatorConstant.COOPERATOR_LINK_START_TIME + " AND  user_member_relation.create_at >= user_openid_relation.create_at \n" +
//                "\n" +
//                "GROUP BY\n" +
//                "\tdate\n" +
//                "\n" +
//                "ORDER BY\n" +
//                "\tuser_member_relation.create_at DESC)member ON member.date = temp1.date)t ");
//
//        params.put("@query", " UNIX_TIMESTAMP(t.time)*1000 as time,COALESCE(t.lesson_money,0) as lesson_money,COALESCE(t.lesson_order_number,0) as lesson_order_number,COALESCE(t.member_money,0) as member_money,COALESCE(t.member_order_number,0) as member_order_number,(COALESCE(t.lesson_money,0)+ COALESCE(t.member_money,0)) AS total_money  ");
//
//        return params;
//    }

    public static Map<String, Object> getRecommendList(String invitationCode, String name, String registerNumStart, String registerNumEnd,
                                                       String minDiscount, String maxDiscount, String minSettlement, String maxSettlement,
                                                       Integer recommendStatus, String mobile, String mail, Boolean count) {

        Map<String, Object> params = new HashMap<String, Object>();
        Set<String> tables = new HashSet();
        tables.add("user");
        if (DataUtils.isNotNullOrEmpty(name)) {
            params.put("user.nick  & like  ", "'%" + name + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(invitationCode)) {
            params.put("user.invitation_code  & like  ", "'%" + invitationCode + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(mail)) {
            params.put("user.register_mail  & like  ", "'%" + mail + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(mobile)) {
            params.put("user.mobile  & like  ", "'%" + mobile + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(recommendStatus)) {
            params.put("user_recommend.recommend_status ", recommendStatus);

        }

        params.put(" user_recommend.id", "user.id");
        tables.add(" user_recommend ");

        if (DataUtils.isNotNullOrEmpty(registerNumStart)) {
            params.put(" user_recommend.recommend_num & >= ", registerNumStart);
        }
        if (DataUtils.isNotNullOrEmpty(registerNumEnd)) {
            params.put(" user_recommend.recommend_num & <= ", registerNumEnd);
        }

        if (DataUtils.isNotNullOrEmpty(minDiscount)) {
            params.put(" user_recommend.discount & >= ", minDiscount);
        }
        if (DataUtils.isNotNullOrEmpty(maxDiscount)) {
            params.put(" user_recommend.discount & <= ", maxDiscount);
        }

        if (DataUtils.isNotNullOrEmpty(minSettlement)) {
            params.put(" user_recommend.ios_amount+user_recommend.android_amount-user_recommend.ios_settlement-user_recommend.android_settlement & >= ", minSettlement);
        }
        if (DataUtils.isNotNullOrEmpty(maxSettlement)) {
            params.put(" user_recommend.ios_amount+user_recommend.android_amount-user_recommend.ios_settlement-user_recommend.android_settlement & <= ", maxSettlement);
        }

        if (count) {
            params.put("@query", " count(user.id) ");
        } else {
            params.put("@order", "  user_recommend.update_at desc ");
            params.put("@query", " user.id");
        }
        String table = convertTable(tables);
        params.put("@table", table);
        return params;

    }


}