package com.ptteng.academy.admin.controller.course;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.MyListUtil;
import com.ptteng.academy.admin.util.AcademyCourseLessonUtil;
import com.ptteng.academy.admin.util.AcademyUserUtil;
import com.ptteng.academy.admin.util.DynamicUtil;
import com.ptteng.academy.course.model.*;
import com.ptteng.academy.course.service.*;
import com.ptteng.academy.course.vo.LessonAndIntroduction;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;


/**
 * Lesson  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class LessonController {
    private static final Log log = LogFactory.getLog("lesson");

    @Autowired
    private LessonService lessonService;
    @Autowired
    private PeriodService periodService;
    @Autowired
    private SubjectService subjectService;

    @Autowired
    private TaskService taskService;

    @Autowired
    private CookieUtil cookieUtil;
    @Autowired
    private LessonIntroductionService lessonIntroductionService;

    /**
     * 根据条件查找专题
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     * @author tongzhirong
     * @author tongzhirong
     */

    @RequestMapping(value = "/a/u/lesson/list", method = RequestMethod.GET)
    public String getLessonsOrderBySortJsonList(HttpServletRequest request,
                                                HttpServletResponse response, ModelMap model,
                                                Integer page,
                                                Integer size, String subjectName, String name,
                                                Integer status, Integer gradeDept) throws Exception {

        log.info("get lesson subject is " + subjectName + " name is " + name);
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        log.info("pageList : page= " + start + " , size=" + size);

        try {
            // 根据subjectName 来找到对应的subjectId
            Map<String, Object> subjectParam = DynamicUtil.getSubjectList(subjectName, null, null);
            List<Long> subjectIds = subjectService.getIdsByDynamicCondition(Subject.class, subjectParam, 0, Integer.MAX_VALUE);


            Map<String, Object> lessonParam = DynamicUtil.getLessonList(name, subjectIds, status, gradeDept);
            List<Long> ids = lessonService.getIdsByDynamicCondition(Lesson.class, lessonParam, start, size);
            List<Long> count = lessonService.getIdsByDynamicCondition(Lesson.class, lessonParam, 0, Integer.MAX_VALUE);
            log.info("get countLessonIdsByLevelOrderBySort size is " + ids.size());

            // 取得
            List<Lesson> lessonList = lessonService.getObjectsByIds(ids);
            log.info("get lesson data is " + lessonList.size());
            List<Long> subjectIdsR = MyListUtil.getFieldValueListFromModelList(lessonList, false, Lesson.class.getDeclaredField("subjectId"));
            List<Subject> subjectList = subjectService.getObjectsByIds(subjectIdsR);
            Map subjectId_alias = MyListUtil.convert2Map(Subject.class.getDeclaredField("id"), Subject.class.getDeclaredField("subjectName"), subjectList);


            Integer total = count.size();
            log.info("get lesson count is " + total);

            model.addAttribute("code", 0);
            boolean next = false;
            if (ids.size() + start + 1 <= total) {
                next = true;
            }
            Integer totalPage = (total - 1) / size + 1;
            model.addAttribute("next", next);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", total);
            model.addAttribute("subjectId_alias", subjectId_alias);
            model.addAttribute("lessonList", lessonList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get lesson list error,page is  " + start + " , size " + size);
            model.addAttribute("code", -100000);
        }

        return "/academy-course-service/lesson/json/lessonListJson";
    }


//   通过 subjectId 查找对应的专题列表

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     * @Author tongzhirong
     */

    @RequestMapping(value = "/a/u/lesson/list/{subjectId} ", method = RequestMethod.GET)
    public String getLessonsBySubjectIdJsonList(HttpServletRequest request,
                                                HttpServletResponse response, ModelMap model, @PathVariable Long subjectId) throws Exception {


        try {

            List<Long> ids = lessonService.getLessonIdsBySubjectOrderBySort(subjectId, 0, Integer.MAX_VALUE);
            log.info("get  " + ids);

            List<Lesson> lessonList = lessonService.getObjectsByIds(ids);

            // TODO: 2017/9/22  科目对应的专题列表判空 
            if (null != lessonList && lessonList.size() > 0) {

                log.info("get lesson list data is " + lessonList.size());
            } else {
                log.info("get lesson list data is null");
            }

            List<Long> subjectIds = MyListUtil.getFieldValueListFromModelList(lessonList, false, Lesson.class.getDeclaredField("subjectId"));
            List<Subject> subjectList = subjectService.getObjectsByIds(subjectIds);
            Map subjectId_alias = MyListUtil.convert2Map(Subject.class.getDeclaredField("id"), Subject.class.getDeclaredField("subjectName"), subjectList);

            model.addAttribute("lessonList", lessonList);
            model.addAttribute("subjectId_alias", subjectId_alias);
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get lesson list error, id is  " + subjectId);
            // for test
            model.addAttribute("code", -100000);
        }

        return "/academy-course-service/lesson/json/lessonListJson";
    }


    /**
     * 查看专题详情
     *
     * @param request
     * @param response
     * @param model
     * @param id
     * @return
     * @throws Exception
     * @author tongzhirong
     */
    @RequestMapping(value = "/a/u/lesson/{id}", method = RequestMethod.GET)
    public String getLessonJson(HttpServletRequest request,
                                HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        if (id == null) {
            model.addAttribute("code", -1000);
            return "/common/success";
        }
        log.info("get data : id= " + id);
        try {
            Lesson lesson = lessonService.getObjectById(id);
            if (lesson == null) {
                model.addAttribute("code", -1000);
                return "/common/success";
            }
            Long subId = lesson.getSubjectId();
            Subject subject = subjectService.getObjectById(subId);
            if (subject != null) {
                lesson.setSubjectName(subject.getSubjectName());
            }

            log.info("get lesson data is " + lesson);

            List<Long> introductionIds = lessonIntroductionService.getLessonIntroductionIdsByLessonId(id, 0, Integer.MAX_VALUE);
            List<LessonIntroduction> introductionList = lessonIntroductionService.getObjectsByIds(introductionIds);

            model.addAttribute("code", 0);
            model.addAttribute("lesson", lesson);
            model.addAttribute("introductionList", introductionList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get lesson error,id is  " + id);
            model.addAttribute("code", -100000);
        }

        return "/academy-course-service/lesson/json/lessonDetailJson";
    }


    /**
     * 编辑专题
     *
     * @param request
     * @param response
     * @param model
     * @param
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/lesson/{id}", method = RequestMethod.PUT)
    public String updateLessonJson(HttpServletRequest request,
                                   HttpServletResponse response, ModelMap model, @PathVariable Long id, @RequestBody LessonAndIntroduction lessonAndIntroduction) throws Exception {

        log.info("lessonId " + id);

        Long userId = AcademyUserUtil.getUserIdLongValue(request);

        Lesson lesson = lessonAndIntroduction.getLesson();
        Lesson lessonRecord = lessonService.getObjectById(id);
        String lessonName = lesson.getLessonName();
        String frontCoverURL = lesson.getFrontCoverURL();
        String appCoverURL = lesson.getAppCoverURL();
        Long subjectId = lesson.getSubjectId();
        Integer gradeDept = lesson.getGradeDept();
        String introText = lesson.getIntroText();
        BigDecimal price = lesson.getPrice();
        BigDecimal iosPrice = lesson.getIosPrice();

        if (null == lessonRecord) {
            log.info("lesson record is null ");
            model.addAttribute("code", -5042);
            return "/common/success";
        }

        if (DataUtils.isNullOrEmpty(lessonName)) {
            log.info("lessonName is null");
            model.addAttribute("code", -1000);
            return "/common/success";
        }

        if (DataUtils.isNullOrEmpty(frontCoverURL)) {
            log.info("frontCoverURL is null");
            model.addAttribute("code", -1000);
            return "/common/success";
        }

        if (DataUtils.isNullOrEmpty(appCoverURL)) {
            log.info("appCoverURL is null");
            model.addAttribute("code", -1000);
            return "/common/success";
        }

        if (DataUtils.isNullOrEmpty(subjectId)) {
            log.info("subjectId is null");
            model.addAttribute("code", -1000);
            return "/common/success";
        }
        if (DataUtils.isNullOrEmpty(gradeDept)) {
            log.info("grade is null");
            model.addAttribute("code", -1000);
            return "/common/success";
        }
        if (DataUtils.isNullOrEmpty(introText)) {
            log.info("introText is null");
            model.addAttribute("code", -1000);
            return "/common/success";
        }
        if (DataUtils.isNullOrEmpty(price)) {
            log.info("price is null");
            model.addAttribute("code", -1000);
            return "/common/success";
        }
        if (DataUtils.isNullOrEmpty(iosPrice)) {
            log.info("iosPrice is null");
            model.addAttribute("code", -1000);
            return "/common/success";
        }


        try {
            log.info("subjectId is " + subjectId);
            String subjectIdStr = subjectId.toString();
            // 检查是否有重名专题
            if (lessonName.equals(lessonRecord.getLessonName())) {
                log.info("lessonName hasn't change");
            } else {

                List<Long> subjectIdList = new ArrayList<>();
                subjectIdList.add(subjectId);
                Map<String, Object> lessonParam = DynamicUtil.getLessonList(lessonName, subjectIdList, null, null);
                List<Long> lessonIds = lessonService.getIdsByDynamicCondition(Lesson.class, lessonParam, 0, Integer.MAX_VALUE);
                List<Lesson> lessonList = lessonService.getObjectsByIds(lessonIds);

                for (Lesson lesson1 : lessonList) {
                    if (lesson.getLessonName().equals(lesson1.getLessonName())) {
                        model.addAttribute("code", -4111);
                        return "/common/success";
                    }

                }
            }

            lesson.setId(id);
            lesson.setStatus(lessonRecord.getStatus());
            lesson.setUpdateBy(Long.valueOf(userId));
            lesson.setCreateBy(lessonRecord.getCreateBy());
            lesson.setCreateAt(lessonRecord.getCreateAt());
            lesson.setSort(lessonRecord.getSort());

            lessonService.update(lesson);

            List<LessonIntroduction> lessonIntroductionList = lessonAndIntroduction.getLessonIntroductionList();
            log.info("lessonIntroductionList size is " + lessonIntroductionList.size());

            AcademyCourseLessonUtil.updateLessonIntroduction(id, userId, lessonIntroductionList);
            log.info("successfully update");
            model.addAttribute("code", 0);
            model.addAttribute("message", "success");
            return "/common/success";

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update lesson error,id is  " + lesson.getId());
            model.addAttribute("code", -6003);

        }

        return null;
    }

    /**
     * 新增专题
     *
     * @param request
     * @param response
     * @param model
     * @return
     * @throws Exception
     * @author tongzhirong
     */
    @RequestMapping(value = "/a/u/lesson", method = RequestMethod.POST)
    public String addLessonJson(HttpServletRequest request,
                                HttpServletResponse response, ModelMap model, @RequestBody LessonAndIntroduction lessonAndIntroduction) throws Exception {

        Long userId = AcademyUserUtil.getUserIdLongValue(request);
        Lesson lesson = lessonAndIntroduction.getLesson();
        String lessonName = lesson.getLessonName();
        String frontCoverURL = lesson.getFrontCoverURL();
        String appCoverURL = lesson.getAppCoverURL();
        Long subjectId = lesson.getSubjectId();
        Integer gradeDept = lesson.getGradeDept();
        String introText = lesson.getIntroText();
        BigDecimal price = lesson.getPrice();
        BigDecimal iosPrice = lesson.getIosPrice();

        if (DataUtils.isNullOrEmpty(lessonName)) {
            log.info("lessonName is null");
            model.addAttribute("code", -1000);
            return "/common/success";
        }

        if (DataUtils.isNullOrEmpty(frontCoverURL)) {
            log.info("frontCoverURL is null");
            model.addAttribute("code", -1000);
            return "/common/success";
        }

        if (DataUtils.isNullOrEmpty(appCoverURL)) {
            log.info("appCoverURL is null");
            model.addAttribute("code", -1000);
            return "/common/success";
        }

        if (DataUtils.isNullOrEmpty(subjectId)) {
            log.info("subjectId is null");
            model.addAttribute("code", -1000);
            return "/common/success";
        }
        if (DataUtils.isNullOrEmpty(gradeDept)) {
            log.info("grade is null");
            model.addAttribute("code", -1000);
            return "/common/success";
        }
        if (DataUtils.isNullOrEmpty(subjectId)) {
            log.info("subjectId is null");
            model.addAttribute("code", -1000);
            return "/common/success";
        }

        if (DataUtils.isNullOrEmpty(price)) {
            log.info("price is null");
            model.addAttribute("code", -1000);
            return "/common/success";
        }
        if (DataUtils.isNullOrEmpty(iosPrice)) {
            log.info("iosPrice is null");
            model.addAttribute("code", -1000);
            return "/common/success";
        }
        if (DataUtils.isNullOrEmpty(introText)) {
            log.info("introText is null");
            model.addAttribute("code", -1000);
            return "/common/success";
        }
        try {
            lesson.setId(null);
            List<Long> subjectIdList = new ArrayList<>();
            subjectIdList.add(subjectId);
            // 检查是否有重名专题
            Map<String, Object> lessonParam = DynamicUtil.getLessonList(lessonName, subjectIdList, null, null);
            List<Long> lessonIds = lessonService.getIdsByDynamicCondition(Lesson.class, lessonParam, 0, Integer.MAX_VALUE);
            List<Lesson> lessonList = lessonService.getObjectsByIds(lessonIds);


            if (CollectionUtils.isNotEmpty(lessonIds)) {
                log.info("Already exist lesson which lessonName is " + lessonName);
                model.addAttribute("code", -4111);
                return "/common/success";
            }

            lesson.setSort(this.getMaxSort());
            lesson.setStatus(2);
            lesson.setCreateBy(userId);

            Long lessonNewId = lessonService.insert(lesson);

            Lesson lessonR = lessonService.getObjectById(lessonNewId);
            lessonR.setIosPriceId("ptt_lesson_" + lessonNewId);
            lessonService.update(lessonR);

            List<LessonIntroduction> lessonIntroductionList = lessonAndIntroduction.getLessonIntroductionList();
            AcademyCourseLessonUtil.updateLessonIntroduction(lessonNewId, userId, lessonIntroductionList);
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add lesson error ");
            model.addAttribute("code", -1);
        }
        return "/common/success";
    }

    /**
     * 上下架专题
     *
     * @param request
     * @param response
     * @param model
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/lesson/{id}/status/{status}", method = RequestMethod.PUT)
    public String updateLessonStatusJson(HttpServletRequest request,
                                         HttpServletResponse response, ModelMap model,
                                         @PathVariable Long id, @PathVariable Integer status)
            throws Exception {

        log.info("update status lesson : id= " + id);

        if (!status.equals(Lesson.status_normal) && !status.equals(Lesson.status_freeze)) {
            model.addAttribute("code", -5030);
            return "/common/success";
        }
        try {
            Lesson lesson = lessonService.getObjectById(id);
            if (lesson == null) {
                model.addAttribute("code", -1000);
                return "/common/success";
            }

            String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
            Long subjectId = lesson.getSubjectId();
            Subject subject = subjectService.getObjectById(subjectId);

            Map<String, Object> periodParam = DynamicUtil.getPeriodList(null, id.toString(), null, Period.status_normal, null);
            List<Long> periodIds = periodService.getIdsByDynamicCondition(Period.class, periodParam, 0, Integer.MAX_VALUE);
            boolean lessonHasNormalPeriods = CollectionUtils.isNotEmpty(periodIds);

            //下架逻辑
            if (Lesson.status_freeze.equals(status)) {

                if (lessonHasNormalPeriods) {
                    // 不能下架
//                    model.addAttribute("code", 7);
//                    return "/common/success";
                }
                lesson.setStatus(status);
                lesson.setUpdateBy(Long.parseLong(userId));
                lessonService.update(lesson);
                List<Long> subjectIdList = new ArrayList<>();
                subjectIdList.add(subjectId);

                Map<String, Object> lessonParam = DynamicUtil.getLessonList(null, subjectIdList, Subject.status_normal, null);
                List<Long> lessonIds = lessonService.getIdsByDynamicCondition(Lesson.class, lessonParam, 0, Integer.MAX_VALUE);
                if (CollectionUtils.isEmpty(lessonIds)) {
                    // 下架 subject
                    subject.setStatus(Subject.status_freeze);
                    subjectService.update(subject);
                }

            }

            // 上架逻辑
            if (Lesson.status_normal.equals(status)) {
                if (!lessonHasNormalPeriods) {
                    // 不能上架
                    model.addAttribute("code", -4101);
                    return "/common/success";
                }
                lesson.setStatus(status);
                lesson.setUpdateBy(Long.parseLong(userId));
                lessonService.update(lesson);
            }

            log.info("lesson update : " + lesson);
            lessonService.update(lesson);


        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update lesson error,id is  " + id);
            model.addAttribute("code", -6004);
        }
        model.addAttribute("code", 0);
        model.addAttribute("message", "success");
        return "/common/success";
    }


    /**
     * 排序专题
     *
     * @param request
     * @param response
     * @param model
     * @param ids
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/lesson/sort", method = RequestMethod.POST)
    public String sort(HttpServletRequest request,
                       HttpServletResponse response, ModelMap model,
                       @RequestBody List<Long> ids) throws Exception {

        log.info("sort lesson : uids= " + ids);

        try {
            List<Lesson> lessonList = lessonService.getObjectsByIds(ids);

            int index = 1;

            for (Lesson lesson : lessonList) {
                lesson.setSort(index);
                index = index + 1;
            }
            this.lessonService.updateList(lessonList);

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add bookUnit error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }

    /*
     * 删除专题
     * @author: tongzhirong
     * */
    @RequestMapping(value = "/a/u/lesson/id}", method = RequestMethod.DELETE)
    public String deleteLessonJson(HttpServletRequest request,
                                   HttpServletResponse response, ModelMap model, @PathVariable Long lessonId)
            throws Exception {

        log.info(" will delete lesson: id= " + lessonId);
        try {

            Lesson target = lessonService.getObjectById(lessonId);
            if (null == target) {
                log.info("there are no lesson which Id is" + lessonId);
            }
            boolean delete = lessonService.delete(lessonId);

            if (delete == true) {

                log.info("delete lesson success");
            } else {
                log.info("delete lesson failure");

            }
            model.addAttribute("code", 0);
            List<Long> lessonIds = new ArrayList<>();
            lessonIds.add(lessonId);

            Map<String, Object> periodParam = DynamicUtil.getPeriodList(null, null, lessonId.toString(), null, null);
            Map<String, Object> taskParam = DynamicUtil.getTaskList(null, null, null, lessonIds, null, null, null, null, null);

            List<Long> periodIds = periodService.getIdsByDynamicCondition(Period.class, periodParam, 0, Integer.MAX_VALUE);
            List<Long> taskIds = taskService.getIdsByDynamicCondition(Task.class, taskParam, 0, Integer.MAX_VALUE);

            if (null != periodIds && periodIds.size() > 0) {
                periodService.deleteList(Period.class, periodIds);
                log.info("successfully delete periods " + periodIds + " under LessonId " + lessonId);
            } else {
                log.info("There are no periods under lessonId " + lessonId);
            }

            if (null != taskIds && taskIds.size() > 0) {
                taskService.deleteList(Task.class, taskIds);
                log.info("successfully delete taskIds " + taskIds + " under lessonId " + lessonId);
            } else {
                log.info("There are no tasks under lessonId " + lessonId);
            }


        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete subject error, id is  " + lessonId);
            model.addAttribute("code", -6004);

        }

        return "/data/json";
    }

    private Integer getMaxSort() throws ServiceException, ServiceDaoException {

        Map<String, Object> param = DynamicUtil.getLessonList(null, null, null, null);
        List<Long> maxs = this.lessonService.getIdsByDynamicCondition(Lesson.class, param, 0, Integer.MAX_VALUE);
        Integer max = 0;
        if (CollectionUtils.isEmpty(maxs)) {
            log.info("first order ");

        } else {
            Long maxID = maxs.get(maxs.size() - 1);
            max = this.lessonService.getObjectById(maxID).getSort();
            log.info("quiz max order is " + max);
        }
        return max + 1;
    }

    private Integer getMinSort(Long lessonId) throws ServiceException, ServiceDaoException {

        Map<String, Object> param = DynamicUtil.getLessonList(null, null, null, null);
        List<Long> mins = this.lessonService.getIdsByDynamicCondition(
                Lesson.class, param, 0, 1);

        Integer min = 0;
        if (CollectionUtils.isEmpty(mins)) {
            log.info("first order ");

        } else {
            log.info(" mins id  = " + mins.get(0));
            Long minID = mins.get(0);
            min = this.lessonService.getObjectById(minID).getSort();
            log.info("quiz min order is " + min);
        }
        return min - 1;
    }

}

