package com.ptteng.academy.admin.controller;
import java.util.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.baidu.yun.core.filter.IFieldFilter;
import com.ptteng.academy.admin.util.DynamicUtil;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.academy.admin.model.School;
import com.ptteng.academy.admin.service.SchoolService;

/**
 * School  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class SchoolController {
	private static final Log log = LogFactory.getLog(SchoolController.class);

	@Autowired
	private SchoolService schoolService;
	@Autowired
	private CookieUtil cookieUtil;




    /**
	 * 
	 * @param
	 * @return
	 * @throws Exception
	 *
	 */

	@RequestMapping(value = "/c/school", method = RequestMethod.GET)
	public String getschoolList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model) throws Exception {

		
		
		log.info("/school  to /school/view/schoolList");

		return "/academy-admin-service/school/view/schoolList";
	}
    
    

    
	
	@RequestMapping(value = "/a/u/school/list", method = RequestMethod.GET)
	public String getSchool(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, String name,Long id,Integer page, Integer size)
			throws Exception {

		log.info("get school list name is " + name + " id is " + id );

		List<School> schoolList = new ArrayList<>();
		Integer total = null;
		if (page == null) {
			page = 1;
		}
		if (size == null || size == 0) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {
			Map<String ,Object>param = DynamicUtil.getSchoolList(name,id);
			 total = schoolService.getIdsByDynamicCondition(School.class,param,0,Integer.MAX_VALUE).size();
			List<Long> ids = schoolService.getIdsByDynamicCondition(School.class,param,start,size);
			log.info("get school size is " + ids.size());
			if (ids.size()>0){
				schoolList = schoolService.getObjectsByIds(ids);
			}

			model.addAttribute("code", 0);
			model.addAttribute("size", size);
			model.addAttribute("page", page);

			model.addAttribute("schoolList", schoolList);
			model.addAttribute("total", total);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get school error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/admin/school/json/schoolListJson";
	}
	
	
	
	    
	

	@RequestMapping(value = "/a/u/school/{id}", method = RequestMethod.GET)
	public String getSchoolJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		try {
			School school = schoolService.getObjectById(id);
			log.info("get school data is " + school);

			model.addAttribute("code", 0);

			model.addAttribute("school", school);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get school error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/admin/school/json/schoolDetailJson";
	}

	/**
	 *@Description 编辑学校
	 * @param school 学校参数
	 * @return message 返回信息
	 * @throws Exception；
	 *
	 */
	@RequestMapping(value = "/a/u//school/{id}", method = RequestMethod.PUT)
	public String updateSchoolJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, School school,@PathVariable Long id) throws Exception {
		
		log.info("update school : school= " + school);
		Long uid = Long.valueOf(cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID));
		//参数校验
		School oSchool = schoolService.getObjectById(id);
		if (oSchool == null) {
			model.addAttribute("code",-7011 );
			return "/common/success";
		}else {
			school.setCreateBy(oSchool.getCreateBy());
			school.setCreateAt(oSchool.getCreateAt());
		}


		if (school.getName() == null) {
			model.addAttribute("code",-1000 );
			return "/common/success";
		} else {
			//防止学校重名
			Map<String,Object> param = DynamicUtil.getSchoolListByName(school.getName());
			List<Long> schoolIds = schoolService.getIdsByDynamicCondition(School.class,param,0,1);
			if (schoolIds.size() != 0 && !schoolIds.get(0).equals(id)) {
				model.addAttribute("code",-7010 );
				return "/common/success";
			} else {
				log.info("This school name is available");

			}
		}

		try {
			school.setUpdateBy(uid);
			schoolService.update(school);

			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update school error,id is  " + school.getId());
			model.addAttribute("code", -1000);

		}

		return "/common/success";
	}



	/**
	 *@Description 添加学校
	 * @param school 学校参数
	 * @return message 返回信息
	 * @throws Exception；
	 *
	 */
	@RequestMapping(value = "/a/u/school", method = RequestMethod.POST)
	public String addSchoolJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, School school) throws Exception {
		
		log.info("insert school : school= " + school);
		Long uid = Long.valueOf(cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID));

		if (school.getName() == null) {
			model.addAttribute("code",-1000 );
			return "/common/success";
		} else {
			//防止学校重名
			Map<String,Object> param = DynamicUtil.getSchoolListByName(school.getName());
			List<Long> schoolIds = schoolService.getIdsByDynamicCondition(School.class,param,0,1);
			if (schoolIds.size() != 0 ) {
				model.addAttribute("code",-7010 );
				return "/common/success";
			} else {
				log.info("This school name is available");
			}
		}


		try {

			school.setId(null);
			school.setCreateBy(uid);
			school.setUpdateBy(uid);
			Long id = schoolService.insert(school);
			Map<String,Long> data = new HashMap<>();
			data.put("id",id);
			log.info("insert school success, id is " + id);
			model.addAttribute("code", 0);
			model.addAttribute("data", data);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add school error ");
			model.addAttribute("code", -1);
		}

		return "/common/success";
	}

	@RequestMapping(value = "/a/school/{id}", method = RequestMethod.DELETE)
	public String deleteSchoolJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete school : id= " + id);
		try {
			schoolService.delete(id);

			log.info("add school success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete school error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}
	
	
	@RequestMapping(value = "/a/multi/school", method = RequestMethod.GET)
	public String getMultiSchoolJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {
			
		List<Long> idList = new ArrayList();	
	   if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			

			List<School> schoolList = schoolService.getObjectsByIds(idList);
			log.info("get  school data is " + schoolList);

			model.addAttribute("code", 0);			
			model.addAttribute("total",schoolList.size());

			model.addAttribute("schoolList", schoolList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get school error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/admin/school/json/schoolListJson";
	}
	
	
	
	
	
}

