package com.ptteng.academy.admin.controller;

import com.ptteng.academy.admin.util.DynamicUtil;
import com.ptteng.academy.document.model.Hollow;
import com.ptteng.academy.document.service.HollowService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * Hollow  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class HollowController {
    private static final Log log = LogFactory.getLog(HollowController.class);

    @Autowired
    private HollowService hollowService;

    /**
     * @Description 删除树叶
     * @param
     * @Author: PeiyuFeng
     * @Time 2017/5/3 15:10
     */
    @RequestMapping(value = "/a/u/hollow/{id}", method = RequestMethod.DELETE)
    public String deleteHollowJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("delete hollow : " + id);

        try {
            Hollow hollow = hollowService.getObjectById(id);

            if (null == hollow) {
                model.addAttribute("code", -2400);
                return "/common/success";
            } else {
                log.info("get hollow : " + hollow);
            }

            hollowService.delete(id);
            log.info("delete hollow " + id + " success");

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete hollow error");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }


    /**
     * @param
     * @Description 树洞列表
     * @Author: PeiyuFeng
     * @Time 2017/5/3 13:40
     */
    @RequestMapping(value = "/a/u/hollow/list", method = RequestMethod.GET)
    public String getHollowList(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long minAt,
                                Long maxAt, Integer minHotLevel, Integer maxHotLevel, Integer minBumpCount, Integer maxBumpCount,
                                Integer minDownCount, Integer maxDownCount, Integer status, Integer page, Integer size) throws Exception {

        log.info("get hollow list minAt is " + minAt + " maxAt is " + maxAt + " minHotLevel is " + minHotLevel +
                " maxHotLevel is " + maxHotLevel + " minBumpCount is " + minBumpCount + " maxBumpCount is " + maxBumpCount +
                " minDownCount is " + minDownCount + " maxDownCount is " + maxDownCount + " status is " + status +
                        " page is " + page + " size is " + size);

        List<Long> hollowIds = new ArrayList<>();
        List<Long> count = new ArrayList<>();

        Integer total = null;
        if (page == null) {
            page = 1;
        }
        if (size == null || size == 0) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        log.info("pageList : page= " + start + " , size=" + size);

        try {
            Map<String, Object> param = DynamicUtil.getHollowList(minAt, maxAt, minHotLevel, maxHotLevel, minBumpCount,
                    maxBumpCount, minDownCount, maxDownCount, status);
            log.info("param is " + param);
            hollowIds = hollowService.getIdsByDynamicCondition(Hollow.class, param, start, size);
            log.info("get postIds : " + hollowIds);
            count = hollowService.getIdsByDynamicCondition(Hollow.class, param, 0, Integer.MAX_VALUE);
            total = count.size();
            log.info("total size " + total);

            if (hollowIds != null && hollowIds.size() > 0) {

                log.info("get hollow list ids is" + hollowIds);
                List<Hollow> hollowList = hollowService.getObjectsByIds(hollowIds);

                model.addAttribute("hollowList", hollowList);
            }

            Boolean next = false;
            Integer nex = start + size;

            if (total > nex) {
                next = true;
            }

            Integer totalPage = 1;
            if (total > 0) {
                totalPage = (total - 1) / size + 1;
            }
            model.addAttribute("total", total);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("size", size);
            model.addAttribute("code", 0);
            model.addAttribute("next", next);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get hollow list error,page is  " + start + " , size " + size);

            model.addAttribute("code", -1);
        }

        return "/academy-document-service/hollow/json/hollowListJson";
    }


}

