package com.ptteng.academy.admin.controller;

import com.ptteng.academy.admin.util.DynamicUtil;
import com.ptteng.academy.user.model.Notice;
import com.ptteng.academy.user.model.User;
import com.ptteng.academy.user.service.NoticeService;
import com.ptteng.academy.user.service.UserService;
import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * Notice  crud
 * create_by shixing
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class NoticeController {
	private static final Log log = LogFactory.getLog(NoticeController.class);

	@Autowired
	private NoticeService noticeService;

	@Autowired
	private UserService userService;



    /**
	 * 公告栏列表
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

	@RequestMapping(value = "/a/u/notice/search", method = RequestMethod.GET)
	public String getnoticeList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Integer page, Integer size,  String title, Integer status) throws Exception {

		log.info("the page is :" + page + ",size is :" + size + ",title is :" + title + ",status is :" + status);

		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}
		BigInteger total = BigInteger.ZERO;
		List<Long> ids = null;
		List<Notice> noticesList = new ArrayList<>();
		try {
			Map<String, Object> params = DynamicUtil.getNoticeList(title, status, false);
			log.info("params is :" + params);
			ids = noticeService.getIdsByDynamicCondition(Notice.class,params,start,size);
			if(CollectionUtils.isEmpty(ids)) {
				log.info("the noticeList ids is null !");
			}else{
				log.info("the noticeList ids's is : " + ids);
				noticesList = noticeService.getObjectsByIds(ids);

				//查询列表总数
				Map<String, Object> paramsAll = DynamicUtil.getNoticeList(title, status, true);
				log.info("paramsAll is :" + paramsAll);
				List<Long> notices = noticeService.getIdsByDynamicCondition(Notice.class,paramsAll,0,Integer.MAX_VALUE);
				total = BigInteger.valueOf(notices.get(0));
			log.info("notice====="+notices);
			}
			log.info("noticeList.size() is :" + noticesList.size());
			int totalPage = 1;
			if(null != total){
				if(total.intValue()>0){
					totalPage = (((total.intValue() - 1)) / (size)) + 1;;
				}
			}
//			Integer totalPage = (total.intValue() - 1) / size + 1;
			model.addAttribute("code",0);
			model.addAttribute("page",page);
			model.addAttribute("size",size);
			model.addAttribute("total",total);
			log.info("page:" + page + ",size" + size + ",total:" + total + ",totalPage :" + totalPage);
			model.addAttribute("noticesList",noticesList);
			model.addAttribute("totalPage",totalPage);
		}catch(Throwable t){
			t.getMessage();
			log.error("getNoticeList error");
			model.addAttribute("code",-1);
		}

		return "/academy-user-service/notice/json/noticeListJson";
	}




	/**
	 * create_by shixing
	 * 公告栏详情
	 * @param
	 * @return
	 */

	@RequestMapping(value = "/a/u/notice/{id}", method = RequestMethod.GET)
	public String getNotice(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {
		log.info(" The url is : /a/u/notice/"+id);
		if(DataUtils.isNullOrEmpty(id)){
			model.addAttribute("code", -1000);
			log.info("id is null");
		}else{
			log.info("id is :" + id);
		}
		try{
			Notice notice = noticeService.getObjectById(id);
			log.info("notice is :" + notice);
			if(DataUtils.isNullOrEmpty(notice)){
				model.addAttribute("code",-9000);
				log.info("notice is not exist");
			}
			model.addAttribute("code",0);
			model.addAttribute("notice",notice);
		}catch (Throwable t){
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get notice detail error ");
			model.addAttribute("code", -1);
		}

		return "/academy-user-service/notice/json/noticeDetailJson";
	}


	/**
	 * create_by shixing
	 * 修改公告
	 * @param
	 * @return
	 */

	@RequestMapping(value = "/a/u/notice/{id}", method = RequestMethod.PUT)
	public String updateNoticeJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model,@PathVariable Long id, String title , String context) throws Exception {
		
		log.info("update notice : id is: " + id + ",title is :" + title + ",context is :" + context );

//		Long uid = Long.valueOf(cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID));

		if(DataUtils.isNullOrEmpty(id)){
			log.error("notice id is null");
			model.addAttribute("code",-9001);
			return "/common/success";
		}
		//限制标题长度为10个字
		if(DataUtils.isNullOrEmpty(title) || title.length()>10){
			log.error("notice title is null or too long");
			model.addAttribute("code",-9002);
			return "/common/success";
		}
		if(DataUtils.isNullOrEmpty(context)){
			log.error("notice context is null");
			model.addAttribute("code",-9003);
			return "/common/success";
		}
		try {
			Notice notice = noticeService.getObjectById(id);
			log.info("notice is :" + notice);
			if(DataUtils.isNullOrEmpty(notice)){
				log.error("notice is not exist");
				model.addAttribute("code",-9000);
				return "/common/success";
			}
			notice.setTitle(title);
			notice.setContext(context);
			log.info("notice is :" + notice);
			boolean result = noticeService.update(notice);
			log.info("update notice result" + result);
			List<Long> userIds= null;
			List<User> userList = new ArrayList<>();
			//当公告栏的状态为上架的时候，修改公告栏就要修改所有的用户的公告栏为未读状态
			if(notice.getStatus()==Notice.NOTICE_UP) {
				userIds = userService.getUserIds(0, Integer.MAX_VALUE);
				userList = userService.getObjectsByIds(userIds);
				for (User user : userList) {
					user.setIsRead(User.NOTICE_UNREAD);
					log.info("userList column IsRead status is :" + user.getIsRead());
				}
				boolean updateUserListResult = userService.updateList(userList);
				log.info("update  UserList  Result is :" + updateUserListResult);
			}


			model.addAttribute("code", 0);


		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update notice error,id is  " );
			model.addAttribute("code", -1);
		}

		return "/data/json";
	}

	/**
	 * create_by shixing
	 * 新增公告
	 * @param title context
	 * @return code message
	 */
	@RequestMapping(value = "/a/u/notice", method = RequestMethod.POST)
	public String addNoticeJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, String title, String context) throws Exception {
		
		log.info("update notice : title= " + title + ",context =" + context);

		if(DataUtils.isNullOrEmpty(title) || title.length() > 10){
			log.error("title is null");
			model.addAttribute("code",-9002);
			return "/data/json";
		}
		if(DataUtils.isNullOrEmpty(context)){
			log.error("context is null");
			model.addAttribute("code",-9003);
			return "/data/json";
		}

		try {
			Notice notice = new Notice();
			notice.setTitle(title);
			notice.setContext(context);
			notice.setStatus(Notice.NOTICE_DOWN);
			Long result = noticeService.insert(notice);
			log.info("insert notice result is :" + result);
			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add notice error ");
			model.addAttribute("code", -9005);
		}

		return "/data/json";
	}

	/**
	 * create_by shixing
	 * 删除公告
	 * @param id
	 * @return code message
	 */
	@RequestMapping(value = "/a/u/notice/{id}", method = RequestMethod.DELETE)
	public String deleteNoticeJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete notice : id= " + id);
		if(DataUtils.isNullOrEmpty(id)){
			log.error("id is null");
			model.addAttribute("code",-9001);
			return "/data/json";
		}
		try {
			Notice notice = noticeService.getObjectById(id);
			if(DataUtils.isNullOrEmpty(notice)){
				log.error("notice is not exist");
				model.addAttribute("code",-9000);
				return "/common/success";
			}
			Boolean result = noticeService.delete(id);
			log.info("delete notice when id = " + id);
			log.info("add notice success");
			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete notice error,id is  " + id);
			model.addAttribute("code", -9006);
		}

		return "/data/json";
	}




	/**
	 * create_by shixing
	 * 修改公告状态
	 * @param id
	 * @return code message
	 */
	@RequestMapping(value = "/a/u/notice/id/{id}/status/{status}", method = RequestMethod.PUT)
	public String deleteNoticeJson(HttpServletRequest request,  HttpServletResponse response,
		ModelMap model, @PathVariable Long id,  @PathVariable Integer status)  throws Exception {

		log.info("changing notice : id= " + id + ",status :" + status);
		if(DataUtils.isNullOrEmpty(id)){
			log.error("id is null");
			model.addAttribute("code",-9001);
			return "/data/json";
		}
		if(DataUtils.isNullOrEmpty(status)){
			log.error("status is null");
			model.addAttribute("code",-9007);
			return "/data/json";
		}
		try {


			//如果公告上架，更新所有用户的isRead为未读状态
			List<Long> userIds= new ArrayList<>();
			List<User> userList = new ArrayList<>();
			List<Long> noticeIdsList = new ArrayList<>();
			List<Notice> noticeList = new ArrayList<>();
			if(status==Notice.NOTICE_UP) {
				//如果要上架公告，先设置其他的公告为下架
				noticeIdsList = noticeService.getNoticeIds(0,Integer.MAX_VALUE);
				log.info("idsList are :" + noticeIdsList);
				noticeList = noticeService.getObjectsByIds(noticeIdsList);
				log.info("noticeList are :" + noticeList);

				for(Notice notice:noticeList){
					notice.setStatus(Notice.NOTICE_DOWN);
				}
				boolean result= noticeService.updateList(noticeList);
				log.info("update noticeList ,result is :" + result);

				//设置所有用户的公告为未读状态
				userIds = userService.getUserIds(0, Integer.MAX_VALUE);
				userList = userService.getObjectsByIds(userIds);
				for (User user : userList) {
					user.setIsRead(User.NOTICE_UNREAD);
					log.info("updating notice status,user IsRead status is :" + user.getIsRead());
				}
				boolean updateUserListResult = userService.updateList(userList);
				log.info("update  UserList  Result is :" + updateUserListResult);

			}else if(status == Notice.NOTICE_DOWN){
				log.info("status is notice down ");
				userIds = userService.getUserIds(0, Integer.MAX_VALUE);
				userList = userService.getObjectsByIds(userIds);

				for (User user : userList) {
					user.setIsRead(User.NOTICE_READ);
					log.info("updating notice status,user IsRead status is :" + user.getIsRead());
				}
				boolean updateUserListResult = userService.updateList(userList);
				log.info("update  UserList  Result is :" + updateUserListResult);

			}else{
				log.error("status is incorrect");
				model.addAttribute("code",-9105);
				return "/data/json";
			}


			Notice notice = noticeService.getObjectById(id);
			notice.setStatus(status);
			Boolean noticeResult = noticeService.update(notice);
			log.info("update notice status result is :" + noticeResult);

			log.info("update notice status success");
				model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update notice status error,id is  " + id);
			model.addAttribute("code", -1);
		}

		return "/data/json";
	}





}

