package com.ptteng.academy.admin.util;

import com.csvreader.CsvReader;
import com.gemantic.common.util.PasswordUtils;
import com.ptteng.academy.user.model.User;
//import com.ptteng.haichuan.audit.model.Inventory;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

import static com.ptteng.academy.admin.util.ParseExcel.*;

/**
 * 解析盘库和倒查csv文件
 * 
 * @author liut
 *
 */
public class ParseCSV {
  
  
  private static final Log log = LogFactory.getLog(ParseCSV.class);
  
  /**
   * 私有化构造器
   */
  private ParseCSV() {
  }
  
  /**
   * 解析盘库csv文件
   * 
   * @param inventoryUrl
   * @return
   */
  public static List<User> parseUserCSV(String inventoryUrl) {
    List<User> list = new ArrayList<>();
    if (StringUtils.isEmpty(inventoryUrl)) {
      log.info("arg inventoryUrl is empty");
      return list;
    }
    CsvReader reader = null;
    try {
      reader = new CsvReader(getExcelFilePath(inventoryUrl), ',', Charset.forName("GBK"));
      reader.readHeaders(); // 跳过表头
      
      User user = null;
      String[] values = null;
      String cur = null;
      while (reader.readRecord()) { // 遍历表体中的数据
        user = new User();
        values = reader.getValues();
        for (int i = 0; i < values.length; i++) {
          cur = values[i];
          if (i == inventory_colums[0]) {
            //设置年级
            log.info("手机：" + cur+"----->"+Integer.valueOf(cur));
            user.setGrade(Integer.valueOf(cur));
          }
          else if (i == inventory_colums[1]) {
            //设置班级
            log.info("班级：" + cur);
            user.setClassName(cur);
          }
          else if (i == inventory_colums[2]) {
            //设置姓名
            log.info("姓名：" + cur);
            user.setAlias(cur);
          }
          else if (i == inventory_colums[3]) {
            //设置手机
            log.info("手机：" + cur);
            user.setMobile(cur);
          }
          else if (i == inventory_colums[4]) {
            //设置邮件
            log.info("邮件：" + cur);
            user.setMail(cur);
          }
          else if (i == inventory_colums[5]) {
            //设置密码;
            log.info("密码：" + cur);
            String encodePass = PasswordUtils.encode("000000");
            if (cur != null) {
              encodePass = PasswordUtils.encode(cur);
            }
            user.setPwd(encodePass);
          }
          else {
            continue;
          }
        }
        list.add(user);
      }
    }
    catch (Exception e) {
      log.error("parseInventoryCSV error...", e);
    }
    finally {
      if (reader != null) {
        reader.close();
      }
    }
    return list;
  }
  
  
//  /**
//   * 解析倒查csv文件
//   *
//   * @param inventoryUrl
//   * @return
//   */
//  public static List<Inspect> parseInspectCSV(String inspectUrl) {
//    List<Inspect> list = new ArrayList<>();
//    if (StringUtils.isEmpty(inspectUrl)) {
//      log.info("arg inspectUrl is empty");
//      return list;
//    }
//    CsvReader reader = null;
//    try {
//      reader = new CsvReader(getExcelFilePath(inspectUrl), ',', Charset.forName("GBK"));
//      reader.readHeaders(); // 跳过表头
//
//      Inspect ins = null;
//      String[] values = null;
//      String cur = null;
//      while (reader.readRecord()) { // 遍历表体中的数据
//        ins = new Inspect();
//        values = reader.getValues();
//        for (int i = 0; i < values.length; i++) {
//          cur = values[i];
//          if (i == inspect_colums[0]) {
//            ins.setDistributorName(cur);
//          }
//          else if (i == inspect_colums[1]) {
//            ins.setVinNo(cur);
//          }
//          else if (i == inspect_colums[2]) {
//            ins.setSettlementDate(cur);
//          }
//          else {
//            continue;
//          }
//        }
//        list.add(ins);
//      }
//    }
//    catch (Exception e) {
//      log.error("parseInspectCSV error...", e);
//    }
//    finally {
//      if (reader != null) {
//        reader.close();
//      }
//    }
//    return list;
//  }
}
