package com.ptteng.academy.admin.controller;

import com.ptteng.academy.user.model.UserMemberRelation;
import com.ptteng.academy.user.service.UserMemberRelationService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * UserMemberRelation  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class UserMemberRelationController {
	private static final Log log = LogFactory.getLog(UserMemberRelationController.class);

	@Autowired
	private UserMemberRelationService userMemberRelationService;






    /**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

	@RequestMapping(value = "/c/userMemberRelation", method = RequestMethod.GET)
	public String getuserMemberRelationList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model) throws Exception {

		
		
		log.info("/userMemberRelation  to /userMemberRelation/view/userMemberRelationList");

		return "/academy-user-service/userMemberRelation/view/userMemberRelationList";
	}
    
    

    
	
	@RequestMapping(value = "/c/userMemberRelation/{id}", method = RequestMethod.GET)
	public String getUserMemberRelation(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("/userMemberRelation/" + id + "  to /userMemberRelation/view/userMemberRelationDeail");
		if(null != id){
			model.addAttribute("id", id);
		}else{
			model.addAttribute("id", 0);
		}

		return "/academy-user-service/userMemberRelation/view/userMemberRelationDetail";
	}
	
	
	
	    
	

	@RequestMapping(value = "/a/userMemberRelation/{id}", method = RequestMethod.GET)
	public String getUserMemberRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		try {
			UserMemberRelation userMemberRelation = userMemberRelationService.getObjectById(id);
			log.info("get userMemberRelation data is " + userMemberRelation);

			model.addAttribute("code", 0);

			model.addAttribute("userMemberRelation", userMemberRelation);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get userMemberRelation error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/academy-user-service/userMemberRelation/json/userMemberRelationDetailJson";
	}

	@RequestMapping(value = "/a/userMemberRelation/{id}", method = RequestMethod.PUT)
	public String updateUserMemberRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, UserMemberRelation userMemberRelation) throws Exception {
		
		log.info("update userMemberRelation : userMemberRelation= " + userMemberRelation);
		
		try {
			
			userMemberRelationService.update(userMemberRelation);

			model.addAttribute("code", 0);

			model.addAttribute("userMemberRelation", userMemberRelation);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update userMemberRelation error,id is  " + userMemberRelation.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/userMemberRelation", method = RequestMethod.POST)
	public String addUserMemberRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, UserMemberRelation userMemberRelation) throws Exception {
		
		log.info("update userMemberRelation : userMemberRelation= " + userMemberRelation);
		
		try { 
			userMemberRelation.setId(null);

			userMemberRelationService.insert(userMemberRelation);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add userMemberRelation error ");
			model.addAttribute("code", -6002);
		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/userMemberRelation/{id}", method = RequestMethod.DELETE)
	public String deleteUserMemberRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete userMemberRelation : id= " + id);
		try {
			userMemberRelationService.delete(id);

			log.info("add userMemberRelation success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete userMemberRelation error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}
	
	
	@RequestMapping(value = "/a/multi/userMemberRelation", method = RequestMethod.GET)
	public String getMultiUserMemberRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {
			
		List<Long> idList = new ArrayList();	
	   if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			

			List<UserMemberRelation> userMemberRelationList = userMemberRelationService.getObjectsByIds(idList);
			log.info("get  userMemberRelation data is " + userMemberRelationList);

			model.addAttribute("code", 0);			
			model.addAttribute("total",userMemberRelationList.size());

			model.addAttribute("userMemberRelationList", userMemberRelationList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get userMemberRelation error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/academy-user-service/userMemberRelation/json/userMemberRelationListJson";
	}
	
	
	
	
	
}

