package com.ptteng.academy.admin.controller;

import com.gemantic.common.util.MyListUtil;
import com.ptteng.academy.admin.util.DynamicUtil;
import com.ptteng.academy.document.model.Posts;
import com.ptteng.academy.document.model.Reply;
import com.ptteng.academy.document.service.PostsService;
import com.ptteng.academy.document.service.ReplyService;
import com.ptteng.academy.user.model.User;
import com.ptteng.academy.user.service.UserService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * Posts  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class PostsController {
	private static final Log log = LogFactory.getLog(PostsController.class);

	@Autowired
	private PostsService postsService;
	@Autowired
	private UserService userService;
	@Autowired
	private ReplyService replyService;


	/**
	 * @Description 帖子详情
	 * @param
	 * @Author: PeiyuFeng
	 * @Time 2017/4/24 18:17
	 */
	@RequestMapping(value = "/a/u/post/{id}", method = RequestMethod.GET)
	public String getPost(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {

		if (id == null) {
			model.addAttribute("code", -1000);
			return "/common/success";
		}

		log.info("get post data : id= " + id);
		try {

			Posts post = postsService.getObjectById(id);

			if (post == null) {
				log.info("post don't exist");
				model.addAttribute("code", -2300);
				return "/common/success";
			}

			String author = "";
			User user = userService.getObjectById(post.getUid());
			if(user == null){
				log.info("user don't exist");
				model.addAttribute("code", -2301);
				return "/common/success";
			}else {
				author = user.getAlias();
			}

			model.addAttribute("code", 0);
			model.addAttribute("posts", post);
			model.addAttribute("author", author);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get document error,id is  " + id);
			model.addAttribute("code", -1);
		}

		return "/academy-document-service/posts/json/postsDetailJson";
	}

	/**
	 * @Description 帖子列表
	 * @param
	 * @Author: PeiyuFeng
	 * @Time 2017/4/24 18:22
	 */
	@RequestMapping(value = "/a/u/post/list", method = RequestMethod.GET)
	public String getPostList(HttpServletRequest request, HttpServletResponse response, ModelMap model,
								  Integer page, Integer size, Integer type, String title, String author, Integer grade,
								  Long minAt, Long maxAt, Integer sort) throws Exception {

		log.info("get post list type is " + type + " title is " + title + " author is " + author + " grade is " + grade +
				" minAt is " + minAt + " maxAt is " + maxAt);

		List<Long> postIds = new ArrayList<>();
		List<Long> count = new ArrayList<>();

		Integer total = null;
		if (page == null) {
			page = 1;
		}
		if (size == null || size == 0) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {
			Map<String, Object> param = DynamicUtil.getPostList(type, title, author, grade, minAt, maxAt, sort);
			log.info("param is " + param);
			postIds = postsService.getIdsByDynamicCondition(Posts.class, param, start, size);
			log.info("get postIds : " + postIds);
			count = postsService.getIdsByDynamicCondition(Posts.class, param, 0, Integer.MAX_VALUE);
			total = count.size();
			log.info("total size " + total);

			if (postIds != null && postIds.size() > 0) {

				log.info("get post list ids is" + postIds);
				List<Posts> postList = postsService.getObjectsByIds(postIds);

				//获取用户名
				List<Long> uids = MyListUtil.getFieldValueListFromModelList(postList, false, Posts.class.getDeclaredField("uid"));
				List<User> users = userService.getObjectsByIds(uids);
				Map<Long,String> uid_alias = MyListUtil.convert2Map(User.class.getDeclaredField("id"), User.class.getDeclaredField("alias"), users);
				log.info("uid_alias : " + uid_alias);

				model.addAttribute("postsList", postList);
				model.addAttribute("uid_alias", uid_alias);
			}

			Boolean next = false;
			Integer nex = start + size;

			if (total > nex) {
				next = true;
			}

			Integer totalPage = 1;
			if (total > 0) {
				totalPage = (total - 1) / size + 1;
			}
			model.addAttribute("total", total);
			model.addAttribute("totalPage", totalPage);
			model.addAttribute("size", size);
			model.addAttribute("code", 0);
			model.addAttribute("next", next);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get post list error,page is  " + start + " , size " + size);

			model.addAttribute("code", -1);
		}

		return "/academy-document-service/posts/json/postsListJson";
	}



	/**
	 * @Description 获取帖子回复列表
	 * @param
	 * @Author: PeiyuFeng
	 * @Time 2017/4/27 16:07
	 */
	@RequestMapping(value = "/a/u/reply/list/{id}", method = RequestMethod.GET)
	public String getReplyList(HttpServletRequest request, HttpServletResponse response, ModelMap model,
							  Integer page, Integer size, @PathVariable Long id) throws Exception {

		log.info("get post " + id + " reply list ");

		Integer total = null;
		if (page == null) {
			page = 1;
		}
		if (size == null || size == 0) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {

			Posts post = postsService.getObjectById(id);

			if (post == null) {
				log.info("post don't exist");
				model.addAttribute("code", -2300);
				return "/common/success";
			}else {

			}

			List<Long> replyIds = replyService.getReplyIdsByPidOrderByFloor(id, start, size);
			total = replyService.countReplyIdsByPidOrderByFloor(id);
			log.info("total size " + total);

			if (replyIds != null && replyIds.size() > 0) {

				log.info("get post reply list ids is" + replyIds);
				List<Reply> replyList = replyService.getObjectsByIds(replyIds);

				List<Long> uids = MyListUtil.getFieldValueListFromModelList(replyList, false, Reply.class.getDeclaredField("uid"));
				List<User> users = userService.getObjectsByIds(uids);
				Map<Long,String> uid_alias = MyListUtil.convert2Map(User.class.getDeclaredField("id"), User.class.getDeclaredField("alias"), users);

				for(Reply reply : replyList){
					if(Reply.DELETE_STATUS_DELETED.equals(reply.getDeleteStatus())){
						reply.setContent("");
					}
				}

				model.addAttribute("replyList", replyList);
				model.addAttribute("uid_alias", uid_alias);
			}

			Boolean next = false;
			Integer nex = start + size;

			if (total > nex) {
				next = true;
			}

			Integer totalPage = 1;
			if (total > 0) {
				totalPage = (total - 1) / size + 1;
			}
			model.addAttribute("total", total);
			model.addAttribute("totalPage", totalPage);
			model.addAttribute("size", size);
			model.addAttribute("code", 0);
			model.addAttribute("next", next);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get post list error,page is  " + start + " , size " + size);

			model.addAttribute("code", -1);
		}

		return "/academy-document-service/reply/json/replyListJson";
	}

	/**
	 * @Description 帖子加精取精
	 * @param
	 * @Author: PeiyuFeng
	 * @Time 2017/4/28 15:29
	 */
	@RequestMapping(value = "/a/u/post/digest/{id}", method = RequestMethod.PUT)
	public String updateDigest(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {

		log.info("set / cancel digest post : " + id);

		try {
			Posts post = postsService.getObjectById(id);

			if (null == post) {
				model.addAttribute("code", -2300);
				return "/common/success";
			} else {
				log.info("get post : " + post);
			}

			log.info("post digest status : " + post.getDigest());
			if (Posts.DIGEST.equals(post.getDigest())) {
				post.setDigest(Posts.NOT_DIGEST);
			} else {
				post.setDigest(Posts.DIGEST);
			}
			post.setDigestAt(System.currentTimeMillis());
			postsService.update(post);
			log.info("update post " + post + " success");

			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update post error ");
			model.addAttribute("code", -1);
		}

		return "/common/success";
	}


	/**
	 * @Description 贴子置顶取消置顶
	 * @param 
	 * @Author: PeiyuFeng
	 * @Time 2017/4/28 16:15
	 */
	@RequestMapping(value = "/a/u/post/sticky/{id}", method = RequestMethod.PUT)
	public String updateSticky(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {

		log.info("set / cancel sticky post : " + id);

		try {
			Posts post = postsService.getObjectById(id);

			if (null == post) {
				model.addAttribute("code", -2300);
				return "/common/success";
			} else {
				log.info("get post : " + post);
			}

			log.info("post sticky status : " + post.getSticky());
			if (Posts.STICKY.equals(post.getSticky())) {
				post.setSticky(Posts.NOT_STICKY);
			} else {
				//将帖子置顶先校验置顶帖是否已满三个,从第三个开始取消置顶
				List<Long> postIds = postsService.getStickyPostsIdsByGradeOrderByStickyAt(post.getGrade());
				log.info("sticky post ids : " + postIds);
				if(postIds.size() > 2){
					List<Posts> posts = postsService.getObjectsByIds(postIds);
					for(int i = 2; i < posts.size() ; i++){
						Posts stickyPost = posts.get(i);
						stickyPost.setSticky(Posts.NOT_STICKY);
						stickyPost.setStickyAt(System.currentTimeMillis());
						log.info("post : " + stickyPost.getId() + " cancel sticky");
					}
					postsService.updateList(posts);
				}else {
					log.info("sticky post ids : " + postIds + " less than 2");
				}
				post.setSticky(Posts.STICKY);
				post.setStickyAt(System.currentTimeMillis());
				//如果置顶帖是加精贴，先取消加精
				if(Posts.DIGEST.equals(post.getDigest())){
					log.info("post digest status true , cancel first");
					post.setDigest(Posts.NOT_DIGEST);
					post.setDigestAt(System.currentTimeMillis());
				}else {
					log.info("post digest status false");
				}
			}
			postsService.update(post);
			log.info("update post " + post + " success");

			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update post error");
			model.addAttribute("code", -1);
		}

		return "/common/success";
	}

	/**
	 * @Description 帖子删除
	 * @param
	 * @Author: PeiyuFeng
	 * @Time 2017/4/28 16:18
	 */
	@RequestMapping(value = "/a/u/post/{id}", method = RequestMethod.DELETE)
	public String deletePost(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {

		log.info("delete post : " + id);

		try {
			Posts post = postsService.getObjectById(id);

			if (null == post) {
				model.addAttribute("code", -2300);
				return "/common/success";
			} else {
				log.info("get post : " + post);
			}

			postsService.delete(id);

			List<Long> rids = replyService.getReplyIdsByPidOrderByFloor(id, 0, Integer.MAX_VALUE);
			replyService.deleteList(Reply.class, rids);
			log.info("delete post " + id + " success");

			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete post error");
			model.addAttribute("code", -1);
		}

		return "/common/success";
	}


	/**
	 * @Description 删除帖子回复
	 * @param
	 * @Author: PeiyuFeng
	 * @Time 2017/4/28 17:57
	 */
	@RequestMapping(value = "/a/u/reply/{id}", method = RequestMethod.DELETE)
	public String deleteReply(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {

		log.info("delete reply : " + id);

		try {
			Reply reply = replyService.getObjectById(id);

			if (null == reply) {
				model.addAttribute("code", -2302);
				return "/common/success";
			} else {
				log.info("get reply : " + reply);
			}

			reply.setDeleteStatus(Reply.DELETE_STATUS_DELETED);

			replyService.update(reply);
			log.info("delete reply " + id + " success");

			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete reply error");
			model.addAttribute("code", -1);
		}

		return "/common/success";
	}

	/**
	 * @Description 帖子数量
	 * @param
	 * @Author: PeiyuFeng
	 * @Time 2017/5/2 13:18
	 */
	@RequestMapping(value = "/a/u/post/num", method = RequestMethod.GET)
	public String deleteReply(HttpServletRequest request, HttpServletResponse response, ModelMap model) throws Exception {

		log.info("get post count ");

		try {

			Integer total = postsService.countPostsIds();

			Integer juniorCount = postsService.countPostsIdsByGrade(Posts.GRADE_JUNIOR);

			Integer highCount = postsService.countPostsIdsByGrade(Posts.GRADE_HIGH);

			log.info("get post count , total : " + total + " 初中部 ： " + juniorCount + " 高中部 ：" + highCount);

			model.addAttribute("code", 0);
			model.addAttribute("total", total);
			model.addAttribute("juniorCount", juniorCount);
			model.addAttribute("highCount", highCount);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("count post error");
			model.addAttribute("code", -1);
		}

		return "/academy-document-service/posts/json/postsCount";
	}
}

