package com.ptteng.academy.admin.util;


import com.gemantic.common.util.StringUtil;
import com.ptteng.academy.document.model.Document;
import com.ptteng.academy.document.model.Video;
import com.ptteng.common.dao.util.SQLUtil;
import com.ptteng.academy.common.model.Message;
import com.qding.common.util.DataUtils;
import org.apache.commons.collections.map.HashedMap;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * Created by liangxj on 2015/9/7.
 */
public class DynamicUtil {


    public static Map<String, Object> getArticleListParam(Long startAt, Long endAt,
                                                          Integer type, String createBy, String title, String status) {

        Map<String, Object> params = new HashMap<String, Object>();
        Set<String> tables = new HashSet();
        tables.add("article");
        if (DataUtils.isNotNullOrEmpty(startAt)) {
            params.put(" article.update_at & >= ", "'" + startAt + "'");
        }
        if (DataUtils.isNotNullOrEmpty(title)) {
            params.put(" article.title & like", " '%" + title + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(endAt)) {
            params.put(" article.update_at & <= ", "'" + endAt + "'");
        }
        if (type == null) {
            params.put(" (article.type ", " 1 or type = 2)");
        }
        if (DataUtils.isNotNullOrEmpty(type)) {

            params.put(" article.type", type);
        }

        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put(" article.status", status);

        }
        if (StringUtil.isNotEmpty(createBy)) {
            params.put("manager.id ", "article.create_by");
            params.put(" manager.name & like ", "'%" + createBy + "'");
            tables.add("manager");
        }


        params.put("@order", "  orderBy asc , create_at desc ");
        params.put("@query", " id ");
        String table = SQLUtil.convertTable(tables);


        params.put("@table", table);

        return params;
    }


    public static Map<String, Object> getDocumentList(Integer type, String title, String author, Integer status,
                                                      Integer minLike, Integer maxLike, Integer minCollection, Integer maxCollection) {
        Map<String, Object> params = new HashedMap();
        if (DataUtils.isNotNullOrEmpty(title)) {
            params.put("title & like", " '%" + title + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put("type", type);
        }
        if (DataUtils.isNotNullOrEmpty(author)) {
            params.put("author & like", " '%" + author + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("status", status);
        }
        if (DataUtils.isNotNullOrEmpty(minLike)) {
            params.put("love & >=", minLike);
        }
        if (DataUtils.isNotNullOrEmpty(maxLike)) {
            params.put("love & <=", maxLike);
        }
        if (DataUtils.isNotNullOrEmpty(minCollection)) {
            params.put("collection & >=", minCollection);
        }
        if (DataUtils.isNotNullOrEmpty(maxCollection)) {
            params.put("collection & <=", maxCollection);
        }

        params.put("@order", " rank asc, order_by asc, create_at desc ");
        params.put("@query", " id");

        params.put("@table", " document ");

        return params;
    }


    public static Map<String, Object> getVideoList(Integer type, String title, String grade, Integer status, Integer subject,
                                                   Integer minLike, Integer maxLike, Integer minCollection, Integer maxCollection,
                                                   String teacherName) {
        Map<String, Object> params = new HashedMap();
        Set<String> tables = new HashSet();
        tables.add("video");
        if (DataUtils.isNotNullOrEmpty(title)) {
            params.put("video.title & like", " '%" + title + "%'");
        }
//        if (DataUtils.isNotNullOrEmpty(grade)) {
//            params.put("grade", grade );
//        }
        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put("video.type","'" + type + "'");
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("video.status","'"+status+"'");
        }
        if (DataUtils.isNotNullOrEmpty(subject)) {
            params.put("video.subject", "'"+subject+"'");
        }
        if (DataUtils.isNotNullOrEmpty(minLike)) {
            params.put("video.love & >=","'"+minLike+"'");
        }
        if (DataUtils.isNotNullOrEmpty(maxLike)) {
            params.put("video.love & <=", "'"+maxLike+"'");
        }
        if (DataUtils.isNotNullOrEmpty(minCollection)) {
            params.put("video.collection & >=","'"+ minCollection+"'");
        }
        if (DataUtils.isNotNullOrEmpty(maxCollection)) {
            params.put("video.collection & <=", "'"+maxCollection+"'");
        }
        if (DataUtils.isNotNullOrEmpty(teacherName)) {
            params.put("video.teacher_name & like", " '%" + teacherName + "%'");
        }

        if (Video.Type_Banner.equals(type)) {
            params.put("@order", " video.rank asc,video.order_by asc, video.update_at desc ");
        } else {
            params.put("@order", "video.rank asc, video.create_at desc ");
        }

        if (DataUtils.isNotNullOrEmpty(grade)) {
            //查询视频年级关联表
            params.put("video.id", "video_grade_relation.video_id");
            tables.add("video_grade_relation");
            params.put("video_grade_relation.grade","'" + grade +"'");
        }

        params.put("@query", " video.id");
        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;
    }


    public static Map<String, Object> getDocumentMaxOrderBy() {
        Map<String, Object> params = new HashMap<String, Object>();

        params.put("@order", " order_by desc ");

        params.put("@query", " id ");

        params.put("@table", " document");

        return params;

    }

    public static Map<String, Object> getVideoMaxOrderBy() {
        Map<String, Object> params = new HashMap<String, Object>();

        params.put("@order", " order_by desc ");

        params.put("@query", " id ");

        params.put("@table", " video");

        return params;

    }


    public static Map<String, Object> getMessageList(Integer grade, String name, Integer messageType, String nick, Long timeLow, Long timeHigh, String mail, Integer type) {
        Map<String, Object> params = new HashedMap();
        if (DataUtils.isNotNullOrEmpty(name)) {
            params.put("name & like", " '%" + name + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(mail)) {
            params.put("mail & like", " '%" + mail + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(nick)) {
            params.put("nick & like", " '%" + nick + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(messageType)) {
            params.put("message_type", "'" + messageType + "'");
        }
        if (DataUtils.isNotNullOrEmpty(grade)) {
            params.put("grade", "'" + grade + "'");
        }
        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put("type", "'" + type + "'");
            if (type == 1) {
                params.put("grade & <", "'" + 8 + "'");
            }
        }
        if (DataUtils.isNotNullOrEmpty(timeLow)) {
            params.put("create_at&>", "'" + timeLow + "'");
        }
        if (DataUtils.isNotNullOrEmpty(timeHigh)) {
            params.put("create_at&<", "'" + timeHigh + "'");
        }

        if (Message.Type_Advice.equals(type)) {
            params.put("@order", "  create_at desc  ");
        } else {
            params.put("@order", "  sort asc ");
        }

        params.put("@query", " id");

        params.put("@table", " message ");

        return params;
    }


    public static Map<String, Object> getUserList(String alias, String mail, String mobile, Integer grade, Integer status, Integer scoreStart,
                                                  Integer scoreEnd, String location) {
        Map<String, Object> params = new HashMap<String, Object>();

        if (alias != null) {
            params.put("alias & like", " '%" + alias + "%'");
        }
        if (mail != null) {
            params.put("mail & like", " '%" + mail + "%'");
        }
        if (mobile != null) {
            params.put("mobile & like", " '%" + mobile + "%'");
        }
        if (grade != null) {
            params.put("grade", grade);
        }
        if (status != null) {
            params.put("status", status);
        }
        if (scoreStart != null) {
            params.put("score & >=", scoreStart);
        }
        if (scoreEnd != null) {
            params.put("score & <=", scoreEnd);
        }
        if (location != null) {
            params.put("location & like", " '%" + location + "%'");
        }


        params.put("@order", " create_at desc");


        params.put("@table", " user");

        return params;

    }

    private static final Integer READ_SORT_ASC = 1;
    private static final Integer READ_SORT_DESC = 2;
    private static final Integer REPLY_SORT_ASC = 3;
    private static final Integer REPLY_SORT_DESC = 4;

    public static Map<String, Object> getPostList(Integer type, String title, String author, Integer grade, Long minAt, Long maxAt, Integer sort) {
        Map<String, Object> params = new HashMap<String, Object>();
        Set<String> tables = new HashSet();
        tables.add("posts");

        if (type != null) {
            params.put("posts.digest", type);
        }
        if (title != null) {
            params.put("posts.title & like", " '%" + title + "%'");
        }
        if (StringUtil.isNotEmpty(author)) {
            params.put("user.id ", "posts.uid");
            params.put(" user.alias & like ", "'%" + author + "%'");
            tables.add("academy_user.user");
        }
        if (grade != null) {
            params.put("posts.grade", grade);
        }
        if (minAt != null) {
            params.put("create_at & >=", minAt);
        }
        if (maxAt != null) {
            params.put("create_at & <=", maxAt);
        }

        if (READ_SORT_ASC.equals(sort)) {
            params.put("@order", " posts.read_count asc");
        } else if (READ_SORT_DESC.equals(sort)) {
            params.put("@order", " posts.read_count desc");
        } else if (REPLY_SORT_ASC.equals(sort)) {
            params.put("@order", " posts.replies_count asc");
        } else if (REPLY_SORT_DESC.equals(sort)) {
            params.put("@order", " posts.replies_count desc");
        } else {
            params.put("@order", " posts.sticky desc , posts.create_at desc");
        }

        params.put("@query", " posts.id");

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;

    }


    public static Map<String, Object> getHollowList(Long minAt, Long maxAt, Integer minHotLevel, Integer maxHotLevel,
                                                    Integer minBumpCount, Integer maxBumpCount, Integer minDownCount,
                                                    Integer maxDownCount, Integer status) {

        Map<String, Object> params = new HashMap<String, Object>();

        if (minHotLevel != null) {
            params.put(" (bump_count + down_count)  & >= ", minHotLevel);
        }
        if (maxHotLevel != null) {
            params.put(" (bump_count + down_count)  & <= ", maxHotLevel);
        }

        if (minBumpCount != null) {
            params.put("bump_count & >=", minBumpCount);
        }
        if (maxBumpCount != null) {
            params.put("bump_count & <=", maxBumpCount);
        }

        if (minDownCount != null) {
            params.put("down_count & >=", minDownCount);
        }
        if (maxDownCount != null) {
            params.put("down_count & <=", maxDownCount);
        }


        if (minAt != null) {
            params.put("create_at & >=", minAt);
        }
        if (maxAt != null) {
            params.put("create_at & <=", maxAt);
        }

        params.put("@order", " create_at desc");
        params.put("@query", " id");
        params.put("@table", "hollow");

        return params;

    }

    //获得couponList列表
    public static Map<String, Object> getCouponList(Integer status, String number, String minPeriod, String maxPeriod, Long effectBegin, Long effectEnd,
                                                    Long invalidBegin, Long invalidEnd, Long memberId, boolean count) {
        Map<String, Object> params = new HashedMap();
        Set<String> tables = new HashSet();
        tables.add("coupon");
        if (DataUtils.isNotNullOrEmpty(number)) {
            params.put("coupon.number & like", " '%" + number + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("coupon.status ", " '" + status + "'");
        }
        if (DataUtils.isNotNullOrEmpty(minPeriod)
                || DataUtils.isNotNullOrEmpty(maxPeriod)
                || DataUtils.isNotNullOrEmpty(memberId)) {
            if (DataUtils.isNotNullOrEmpty(minPeriod)) {
                params.put("member.period+0 & >= ", " '" + minPeriod + "'");
            }
            if (DataUtils.isNotNullOrEmpty(maxPeriod)) {
                params.put("member.period+0 & <= ", " '" + maxPeriod + "'");
            }
            if (DataUtils.isNotNullOrEmpty(memberId)) {
                params.put(" coupon.member_id  ", " '" + memberId + "'");

            }
            params.put(" coupon.member_id ", " member.id");
            tables.add("member");

        }
        if (DataUtils.isNotNullOrEmpty(effectBegin)) {
            params.put("coupon.create_at & >= ", " '" + effectBegin + "'");
        }
        if (DataUtils.isNotNullOrEmpty(effectEnd)) {
            params.put("coupon.create_at & <= ", " '" + effectEnd + "'");
        }

        if (DataUtils.isNotNullOrEmpty(invalidBegin)) {
            params.put("coupon.deadline & >= ", " '" + invalidBegin + "'");
        }
        if (DataUtils.isNotNullOrEmpty(invalidEnd)) {
            params.put("coupon.deadline & <= ", " '" + invalidEnd + "'");
        }

        if (count) {
            params.put("@query", " count(coupon.id) ");

        } else {
            params.put("@order", "  coupon.create_at desc ");
            params.put("@query", " coupon.id ");
        }

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;

    }

    //得到会员套餐列表
    public static Map<String, Object> getMemberList(String name, String minPeriod, String maxPeriod, String minPrice, String maxPrice, Integer status, boolean count) {
        Map<String, Object> params = new HashedMap();
        if (StringUtil.isNotEmpty(name)) {
            params.put("name & like", " '%" + name + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("status", " '" + status + "'");
        }
        if (DataUtils.isNotNullOrEmpty(minPeriod)) {
            params.put("period+0 & >= ", " '" + minPeriod + "'");
        }
        if (DataUtils.isNotNullOrEmpty(maxPeriod)) {
            params.put("period+0 & <= ", " '" + maxPeriod + "'");
        }
        if (DataUtils.isNotNullOrEmpty(minPrice)) {
            params.put("price+0 & >= ", " '" + minPrice + "'");
        }
        if (DataUtils.isNotNullOrEmpty(maxPrice)) {
            params.put("price+0 & <= ", " '" + maxPrice + "'");
        }


        if (count) {
            params.put("@query", " count(id)");

        } else {
            params.put("@order", "   create_at desc ");
            params.put("@query", " id");
        }


        params.put("@table", " member ");

        return params;
    }


    //公告栏列表
    public static Map<String, Object> getNoticeList(String title, Integer status, boolean count) {
        Map<String, Object> params = new HashMap<>();
        if (DataUtils.isNotNullOrEmpty(title)) {
            params.put("title & like", "'%" + title + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("status", status);
        }
        if (count) {
            params.put("@query", "count(id)");
        } else {
            params.put("@query", "id");
            params.put("@order", "create_at desc");
        }
        params.put("@table", "notice");

        return params;
    }


    //查询视频年级关联表的内容
    public static Map<String, Object> getVideoGradeRelationIds(Long videoId) {
        Map<String, Object> params = new HashMap<>();
        params.put("video_id", videoId);
        params.put("@query", "id");
        params.put("@order", "create_at desc");

        params.put("@table", "video_grade_relation");

        return params;

    }

    //文章置顶
    public static Map<String, Object> getDocumentRank(Long documentId) {
        Map<String, Object> params = new HashMap<>();

        params.put("rank", Document.RANK_TOP);
        params.put("@query", "id");
        params.put("@order", "create_at desc");

        params.put("@table", "document");

        return params;

    }

    //视频置顶
    public static Map<String, Object> getVideotRank(Long videoId) {
        Map<String, Object> params = new HashMap<>();

        params.put("rank", Video.RANK_TOP);
        params.put("@query", "id");
        params.put("@order", "create_at desc");

        params.put("@table", "video");

        return params;

    }

    //搜索原有的视频关联表，拿到总数
    public static Map<String, Object> getVideoGradeIds(Long id) {
        Map<String, Object> params = new HashedMap();
        params.put("video_id", "'" + id + "'");
        params.put("@query", "count(id)");
        params.put("@table", "video_grade_relation");

        return params;
    }

    //搜索原有的视频关联表，拿到总数
    public static Map<String, Object> getVideoGradeIdsTotal(Long id) {
        Map<String, Object> params = new HashedMap();
        params.put("video_id", "'" + id + "'");
        params.put("@query", "id");
        params.put("@table", "video_grade_relation");

        return params;
    }

}