package com.ptteng.academy.admin.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.academy.admin.util.DynamicUtil;
import com.ptteng.academy.document.model.Teacher;
import com.ptteng.academy.document.model.Video;
import com.ptteng.academy.document.model.VideoGradeRelation;
import com.ptteng.academy.document.service.TeacherService;
import com.ptteng.academy.document.service.VideoGradeRelationService;
import com.ptteng.academy.document.service.VideoService;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * Video  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class VideoController {
	private static final Log log = LogFactory.getLog(VideoController.class);

	@Autowired
	private VideoService videoService;

	@Autowired
	private TeacherService teacherService;

	@Autowired
	private CookieUtil cookieUtil;

	@Autowired
	private VideoGradeRelationService videoGradeRelationService;


	/**
	 * @Description 修改视频
	 * @param
	 * @Author: PeiyuFeng
	 * @Time 2017/3/17 16:11
	 */
	@RequestMapping(value = "/a/u/video/{id}", method = RequestMethod.PUT)
	public String updateDocument(HttpServletRequest request,
								 HttpServletResponse response, ModelMap model, String title, Integer[] grade, Integer type, String url,
								 String coverImg, String content, String summary, Integer subject, Long tid, String cutImg, String duration,
								 @PathVariable Long id , Integer charge) throws Exception {

		log.info("update video " + id + " : title = " + title  + " type = " + type + " coverImg " + coverImg
				+ " content = " + content + " summary = " + summary + " subject = " + subject + " tid = " + tid + " cutImg = " + cutImg
		+ " duration = " + duration);
		log.info("grade.size() are");

		try {
			Video video = videoService.getObjectById(id);

			if (video == null) {
				log.info("video don't exist");
				model.addAttribute("code", -2100);
				return "/common/success";
			} else {
				log.info("get video : " + video);
			}

			Teacher teacher = teacherService.getObjectById(tid);
			if (teacher == null) {
				log.info("teacher don't exist");
				model.addAttribute("code", -2200);
				return "/common/success";
			} else {
				log.info("get teacher : " + teacher);
			}

			//标题
			if (DataUtils.isNotNullOrEmpty(title)) {
				video.setTitle(title);
			} else {
				log.info("title not change");
			}
			//年级
//			if (DataUtils.isNotNullOrEmpty(grade)) {
//				video.setGrade(grade);
//			} else {
//				log.info("grade not change");
//			}

			//类型
			if (DataUtils.isNotNullOrEmpty(type)) {
				video.setType(type);
			} else {
				log.info("type not change");
			}
			//封面图
			if (DataUtils.isNotNullOrEmpty(coverImg)) {
				video.setCoverImg(coverImg);
			} else {
				log.info("coverImg not change");
			}
			//正文
			if (DataUtils.isNotNullOrEmpty(content)) {
				video.setContent(content);
			} else {
				log.info("content not change");
			}
			//简介
			if (DataUtils.isNotNullOrEmpty(summary)) {
				video.setSummary(summary);
			} else {
				log.info("summary not change");
			}
			//科目
			if (DataUtils.isNotNullOrEmpty(subject)) {
				video.setSubject(subject);
			} else {
				log.info("subject not change");
			}
			//教师头像
			if (DataUtils.isNotNullOrEmpty(tid)) {
				video.setTeacherImg(teacher.getProfilePhoto());
			} else {
				log.info("teacherImg not change");
			}
			//教师名称
			if (DataUtils.isNotNullOrEmpty(tid)) {
				video.setTeacherName(teacher.getName());
			} else {
				log.info("teacherName not change");
			}
			//视频截图
			if (DataUtils.isNotNullOrEmpty(cutImg)) {
				video.setCutImg(cutImg);
			} else {
				log.info("cutImg not change");
			}
			if (DataUtils.isNotNullOrEmpty(duration)) {
				video.setDuration(duration);
			} else {
				log.info("duration not change");
			}
			if (DataUtils.isNotNullOrEmpty(url)) {
				video.setUrl(url);
			} else {
				log.info("url not change");
			}
			if (DataUtils.isNotNullOrEmpty(charge)) {
				video.setCharge(charge);
			} else {
				log.info("charge not change");
			}
			log.info("update video : " + video);
			videoService.update(video);

			//删除原有视频联表
			Map<String, Object> param = DynamicUtil.getVideoGradeIdsTotal(id);
			log.info("param is :" + param);
			List<Long> videoGradeIds = videoGradeRelationService.getIdsByDynamicCondition(VideoGradeRelation.class,param,0,Integer.MAX_VALUE);
			videoGradeRelationService.deleteList(VideoGradeRelation.class,videoGradeIds);
			//视频属于多个年级grade，往video_grade_relation表插入多条数据（一个年级对应一条）
			List<VideoGradeRelation> videoGradeRelationList = new ArrayList<>();

			//将传进来的grade列表存到videoGradeRelation里面
			for(Integer gradeNum:grade) {
				VideoGradeRelation videoGradeRelation = new VideoGradeRelation();
				videoGradeRelation.setVideoId(id);
				videoGradeRelation.setGrade(gradeNum);
				videoGradeRelation.setUpdateAt(System.currentTimeMillis());
				videoGradeRelation.setCreateAt(System.currentTimeMillis());
				videoGradeRelationList.add(videoGradeRelation);
				log.info("videoGradeRelation is:" + videoGradeRelation);
			}
			log.info("videoGradeRelationList are ===================="+videoGradeRelationList);
			videoGradeRelationService.insertList(videoGradeRelationList);
//			log.info("update videoGradeRelationList result is " + result);


			model.addAttribute("code", 0);
			model.addAttribute("video", video);


		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update video error,id is  " + id);
			model.addAttribute("code", -1);
		}

		return "/common/success";
	}

	/**
	 * @Description 新增视频
	 * @param
	 * @Author: PeiyuFeng
	 * @Time 2017/3/17 16:11
	 */
	@RequestMapping(value = "/a/u/video", method = RequestMethod.POST)
	public String addDocument(HttpServletRequest request,
							  HttpServletResponse response, ModelMap model, Video video,Integer[] grade) throws Exception {

		log.info("insert video : " + video);
		log.info("grade are :" +grade.length);

		Long uid = Long.valueOf(cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID));

		if (video == null) {
			model.addAttribute("code", -1000);
			return "/common/success";
		}

		if (video.getTitle() == null || video.getType() == null || video.getCutImg() == null || video.getTeacherImg() == null
				|| video.getContent() == null || video.getSummary() == null  || video.getSubject() == null) {
			model.addAttribute("code", -1000);
			return "/common/success";
		} else {
			log.info("params verify OK");
		}


		try {
			video.setCreateBy(uid);
			video.setUpdateBy(uid);
			video.setId(null);
			video.setStatus(video.Status_Unpublished);
			video.setPublishAt(System.currentTimeMillis());
			video.setLove(0L);
			video.setCollection(0L);
			video.setRead_count(0);
			video.setCharge(Video.UN_ChARGE);
			video.setRank(Video.RANK_DOWN);

			if(Video.Type_Banner.equals(video.getType())){
				video.setOrderBy(getMaxSort());
			}

			log.info("insert video : " + video);
			Long aid = videoService.insert(video);
			log.info("insert video success");
			List<VideoGradeRelation> videoGradeRelationList = new ArrayList<>();
//			VideoGradeRelation videoGradeRelation = new VideoGradeRelation();
			for(Integer gradeNum:grade) {
				VideoGradeRelation videoGradeRelation = new VideoGradeRelation();
				videoGradeRelation.setVideoId(aid);
				videoGradeRelation.setGrade(gradeNum);
				videoGradeRelationList.add(videoGradeRelation);
				log.info("videoGradeRelation is:" + videoGradeRelation);
			}
			List<VideoGradeRelation> result = videoGradeRelationService.insertList(videoGradeRelationList);
			log.info("result is " + result);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("add video error ");
			model.addAttribute("code", -1);
		}
		return "/common/success";
	}


	/**
	 * @Description 视频上下架
	 * @param
	 * @Author: PeiyuFeng
	 * @Time 2017/3/17 16:13
	 */
	@RequestMapping(value = "/a/u/video/{id}/status", method = RequestMethod.PUT)
	public String updateDocumentStatus(HttpServletRequest request,
									   HttpServletResponse response, ModelMap model,@PathVariable Long id) throws Exception {

		Video video =  videoService.getObjectById(id);
		Integer status=video.getStatus();
		log.info("update video status : id , status = " + id + " , " + status);

		try {

			String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);

			video.setUpdateBy(Long.parseLong(userId));
			log.info("video is  " + video);
			if(video.Status_Unpublished.equals(status)){
				log.info("change publish");

				//将banner上架先校验上架banner是否已满八个,从第八个开始取消置顶
				List<Long> bannerIds = videoService.getVideoIdsByGradeAndSubjectAndTypeAndStatusOrderByUpdateAt(video.getGrade(), video.getSubject(), Video.Type_Banner, Video.Status_Published, 0 , Integer.MAX_VALUE);
				log.info("public banner ids : " + bannerIds);
				if(bannerIds.size() > 7){
					List<Video> videos = videoService.getObjectsByIds(bannerIds);
					for(int i = 7; i < videos.size() ; i++){
						Video videoBanner = videos.get(i);
						videoBanner.setStatus(Video.Status_Unpublished);
						log.info("video : " + videoBanner.getId() + " unPublish");
					}
					videoService.updateList(videos);
				}else {
					log.info("banner ids : " + bannerIds + " less than 8");
				}

				Long time = System.currentTimeMillis();
				video.setStatus(video.Status_Published);//发布
				video.setPublishAt(time);
				video.setRank(Video.RANK_DOWN);
			}else{
				log.info("change unPublish");
				video.setStatus(video.Status_Unpublished);//下架
			}

			videoService.update(video);
			model.addAttribute("code", 0);


		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update video status error,id is  " + id);
			model.addAttribute("code", -1);

		}

		return "common/success";
	}


	/**
	 * @Description 视频banner排序
	 * @param ids 排序banner id
	 * @Author: PeiyuFeng
	 * @Time 2017/3/17 16:10
	 */
	@RequestMapping(value = "/a/u/video/sort", method = RequestMethod.POST)
	public String sort(HttpServletRequest request,
					   HttpServletResponse response, ModelMap model,
					   @RequestBody List<Long> ids) throws Exception {

		log.info("sort video : ids= " + ids);

		try {
			List<Video> videoList = videoService.getObjectsByIds(ids);

			int index = 1;
			for (Video video : videoList) {
				video.setOrderBy(index);
				index = index +1;
			}
			this.videoService.updateList(videoList);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update video sort error ");
			model.addAttribute("code", -1);
		}

		return "/common/success";
	}



	/**
	 * @param id 视频id
	 * @Description 查看视频详情
	 * @Author: PeiyuFeng
	 * @Time 2017/3/15 17:16
	 */
	@RequestMapping(value = "/a/u/video/{id}", method = RequestMethod.GET)
	public String getDocument(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {

		if (id == null) {
			model.addAttribute("code", -1000);
			return "/common/success";
		}

		log.info("get data : id= " + id);
		try {

			Video video = videoService.getObjectById(id);

			if (video == null) {
				log.info("video don't exist");
				model.addAttribute("code", -2107);
				return "/common/success";
			}else {
				log.info("get video");
			}

			List<VideoGradeRelation> videoGradeRelations = new ArrayList<>();
			Map<String, Object> params = DynamicUtil.getVideoGradeRelationIds(id);
			log.info("params is :" + params);
			List<Long> videoGradeIds = videoGradeRelationService.getIdsByDynamicCondition(VideoGradeRelation.class,params,0,Integer.MAX_VALUE);
			log.info("videoGradeIds.size() is :" + videoGradeIds.size());
			if(videoGradeIds.size()>0) {
				videoGradeRelations = videoGradeRelationService.getObjectsByIds(videoGradeIds);
				log.info("videoGradeRelations.size() is :" + videoGradeRelations.size());
			}else {
				log.info("video doesn't has a grade");
				model.addAttribute("code",-1);
			}
			model.addAttribute("code", 0);
			model.addAttribute("video", video);
			model.addAttribute("videoGradeRelations",videoGradeRelations);


		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get video error,id is  " + id);
			model.addAttribute("code", -1);
		}

		return "academy-document-service/video/json/videoListJsonAndGrade";
	}

	/**
	 * @Description 查询视频列表
	 * @param type 文档类型banner/normal
	 * @param title 文档标题
	 * @Author: PeiyuFeng
	 * @Time 2017/3/15 17:42
	 */
	@RequestMapping(value = "/a/u/video/list", method = RequestMethod.GET)
	public String getDocumentList(HttpServletRequest request, HttpServletResponse response, ModelMap model,
								  Integer page, Integer size, Integer type, String title, String grade, Integer status,
								  Integer subject, Integer minLike, Integer maxLike, Integer minCollection, Integer maxCollection,
	String teacherName) throws Exception {

		log.info("get video list type is " + type + " title is " + title + " grade is " + grade + " status is " + status +
				" subject is " + subject + " minLike is " + minLike + " maxLike is " + maxLike + " minCollection is " + minCollection +
				" maxCollection is " + maxCollection + " teacherName is " + teacherName );

		List<Long> videoIds = new ArrayList<>();
		List<Long> count = new ArrayList<>();

		Integer total = null;
		if (page == null) {
			page = 1;
		}
		if (size == null || size == 0) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {
			Map<String, Object> param = DynamicUtil.getVideoList(type, title, grade, status, subject, minLike, maxLike,
					minCollection, maxCollection, teacherName);
			log.info("param is " + param);
			videoIds = videoService.getIdsByDynamicCondition(Video.class, param, start, size);
			count = videoService.getIdsByDynamicCondition(Video.class, param, 0, Integer.MAX_VALUE);
			total = count.size();
			log.info("total size " + total);

			if (videoIds != null && videoIds.size() > 0) {

				log.info("get video list ids is" + videoIds);
				List<Video> videoList = videoService.getObjectsByIds(videoIds);
				model.addAttribute("videoList", videoList);
			}
			List<VideoGradeRelation> videoGradeRelationListAll = new ArrayList<>();
			//返回grade字段多个年级
			for(Long id:videoIds) {
				List<Long> relationIds = new ArrayList<>();
				Map<String, Object> gradeParam = DynamicUtil.getVideoGradeRelationIds(id);
				relationIds = videoGradeRelationService.getIdsByDynamicCondition(VideoGradeRelation.class,gradeParam,0,Integer.MAX_VALUE);
				log.info("relationIds are:" + relationIds);
				List<VideoGradeRelation> videoGradeRelationList = videoGradeRelationService.getObjectsByIds(relationIds);
				for(VideoGradeRelation vgr: videoGradeRelationList) {
					log.info("vgr.getGrade()"+vgr.getGrade());
				}
//				model.addAttribute("videoGradeRelationList",videoGradeRelationList);
				log.info("videoGradeRelationList" + videoGradeRelationList);
				videoGradeRelationListAll.addAll(videoGradeRelationList);
			}
			model.addAttribute("videoGradeRelationListAll",videoGradeRelationListAll);
//			log.info("videoGradeRelationListAll are :" + videoGradeRelationListAll);

			Boolean next = false;
			Integer nex = start + size;

			if (total > nex) {
				next = true;
			}

			Integer totalPage = 1;
			if (total > 0) {
				totalPage = (total - 1) / size + 1;
			}
			model.addAttribute("total", total);
			model.addAttribute("totalPage", totalPage);
			model.addAttribute("size", size);
			model.addAttribute("code", 0);
			model.addAttribute("next", next);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get video list error,page is  " + start + " , size " + size);

			model.addAttribute("code", -1);
		}

		return "/academy-document-service/video/json/videoListJson";
	}


	private Integer getMaxSort() throws ServiceException, ServiceDaoException {
		Map<String, Object> param = DynamicUtil.getVideoMaxOrderBy();
		List<Long> maxs = this.videoService.getIdsByDynamicCondition(Video.class, param, 0, 1);
		Integer max = 0;
		if (CollectionUtils.isEmpty(maxs)) {
			log.info("first order ");

		} else {
			Long maxID = maxs.get(maxs.size() - 1);
			log.info(" maxID = " + maxID);
			max = this.videoService.getObjectById(maxID).getOrderBy();
			if (null == max) {
				max = 0;
			}
			log.info("quiz max order is " + max);
		}
		return max + 1;
	}


	/**
	 * @Description 文档置顶/取消置顶
	 * @Author: shixing
	 * @Time 2017/6/28 00:00
	 */
	@RequestMapping(value = "/a/u/video/rank/{id}", method = RequestMethod.PUT)
	public String rankDocument(HttpServletRequest request, HttpServletResponse response, ModelMap model,
							   @PathVariable Long id) throws Exception {

		log.info("id is :" + id);
		if (DataUtils.isNullOrEmpty(id)) {
			model.addAttribute("code", -1);
			return "common/success";
		}
		try {
			Video video = videoService.getObjectById(id);
			log.info("video is :" + video);
			if (null == video) {
				model.addAttribute("code", -1);
				return "common/success";
			} else {
				log.info("video is exist");
			}
			//置顶的可以直接取消置顶，非置顶的如要置顶需要满足：没有其他置顶的文章,对于已经有置顶的，就把它顶下去
			if (Video.RANK_TOP.equals(video.getRank())) {
				video.setRank(Video.RANK_DOWN);
				log.info("video.getRank() is :" + video.getRank());
			} else {
				Map<String, Object> param = DynamicUtil.getVideotRank(id);
				List<Long> videoIds = videoService.getIdsByDynamicCondition(Video.class,param,0,Integer.MAX_VALUE);
				if(videoIds.size()==0){
					video.setRank(Video.RANK_TOP);
					log.info("video.getRank() is :" + video.getRank());
				}else if(videoIds.size()==1){
					Long videoId = videoIds.get(0);
					Video alreadyRankTopVideo = videoService.getObjectById(videoId);
					alreadyRankTopVideo.setRank(Video.RANK_DOWN);
					log.info("alreadyRankTopDocument.size() is " + alreadyRankTopVideo.getRank());
					boolean result = videoService.update(alreadyRankTopVideo);
					log.info("result is :" + result);
					video.setRank(Video.RANK_TOP);
					log.info("video.getRank() is :" + video.getRank());
				}else {
					model.addAttribute("code", -1);
					return "common/success";
				}

			}
			boolean result1 = videoService.update(video);
			log.info("result1 is :" + result1);
			model.addAttribute("code",0);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get document  error,id is:" + id);
			model.addAttribute("code", -1);
		}

		return "common/success";
	}

	/**
	 * @Description 视频的年级批量插入到视频年级关联表中
	 * @Author: shixing
	 * @Time 2017/6/30 00:00
	 */
	@RequestMapping(value = "/a/u/video/videograderalation", method = RequestMethod.GET)
	public String updateVideoToRelation(HttpServletRequest request, HttpServletResponse response, ModelMap model) throws Exception {
		log.info("start import video grade data to table videograderalation");
		try {
			List<Long> videoIds = videoService.getVideoIds(0,Integer.MAX_VALUE);

			List<Long> videoIdListAll = new ArrayList<>();
//			先判断是否有videoId在关联表中存在，如果有就不插入，没有则插入,也就是判重，有就从videoIds里面remove()
				for (Long id : videoIds) {
					Map<String, Object> params = DynamicUtil.getVideoGradeRelationIds(id);
					List<Long> vgrIdList = videoGradeRelationService.getIdsByDynamicCondition(VideoGradeRelation.class, params, 0, Integer.MAX_VALUE);
					if(vgrIdList.size()==0){
						log.info("this videoId is not exist in the relation,can be insert");
						videoIdListAll.add(id);
					}else{
						log.info("this id is already exists");
					}
				}
			List<VideoGradeRelation> vgrList = new ArrayList<>();
			List<Video> videoList = videoService.getObjectsByIds(videoIdListAll);
			for(Video video:videoList){
			VideoGradeRelation vgr = new VideoGradeRelation();
			//考虑到video表的grade可能为空，为空时不加入到关联表中
				if(DataUtils.isNullOrEmpty(video.getGrade())){
					log.info("already exist in the table video");
				}else {
					vgr.setId(null);
					vgr.setGrade(video.getGrade());
					vgr.setVideoId(video.getId());
					vgrList.add(vgr);
				}
				log.info("vgrList.size()"+vgrList.size());
			}
			videoGradeRelationService.insertList(vgrList);
			log.info("insert List success =.=    , congratulations");
			model.addAttribute("code",0);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get document  error,id is:" );
			model.addAttribute("code", -1);
		}

		return "common/success";
	}



}

