package com.ptteng.academy.admin.controller;

import com.ptteng.academy.admin.util.DynamicUtil;
import com.ptteng.academy.user.model.User;
import com.ptteng.academy.user.service.UserService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * User  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class UserController {
	private static final Log log = LogFactory.getLog(UserController.class);

	/**
	 *
	 */
	@Autowired
	private UserService userService;


	//1、用户详情
	@RequestMapping(value = "/a/u/user/{id}", method = RequestMethod.GET)
	public String getUserJson(HttpServletRequest request,
							  HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {
		log.info("get data : id= " + id);
		try {
			User user = userService.getObjectById(id);
			log.info("get user data is " + user);

			if (null == user) {
				log.info("user not exist");
				model.addAttribute("code", -2000);
				return "/common/success";
			}else {
				log.info("get user : " + user);
			}

			model.addAttribute("code", 0);
			model.addAttribute("user", user);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get user error,id is  " + id);
			model.addAttribute("code", -1);
		}

		return "/academy-user-service/user/json/userDetailJson";
	}


	//2、冻结解冻用户
	@RequestMapping(value = "/a/u/freeze/user/{id}", method = RequestMethod.PUT)
	public String updateUserJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
								 @PathVariable Long id, Integer status) throws Exception {

		log.info("update user : userId is= " + id + " status : " + status);

		try {
			User user = userService.getObjectById(id);
			if (user == null) {
				model.addAttribute("code", 2);
				return "/common/success";
			}

			if (User.STATUS_OFF != status && User.STATUS_NORMAL != status) {
				model.addAttribute("code", -1001);
				return "/common/success";
			}

			user.setStatus(status);
			userService.update(user);
			log.info("update user status " + status + " success ");

			model.addAttribute("code", 0);
			model.addAttribute("user", user);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update user status error,id is  " + id);
			model.addAttribute("code", -1);

		}

		return "/common/success";
	}


	//3、用户列表
	@RequestMapping(value = "/a/u/user/list", method = RequestMethod.GET)
	public String getMultiUserJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer status,
								   String alias, Integer grade, String mail, String mobile, Integer scoreStart,
								   Integer scoreEnd, String location, Integer page, Integer size) throws Exception {

		List<Long> idList = new ArrayList();
		Boolean next = false;

		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("get user list by : status = " + status + " alias = " + alias + " grade = " + grade + " mail = " + mail +
		" mobile = " + mobile + " minScore = " + scoreStart + " maxScore = " + scoreEnd + " location = " + location + " page = "
		+ page + " size = " + size);

		try {
			Map<String, Object> params = DynamicUtil.getUserList(alias, mail, mobile, grade, status, scoreStart, scoreEnd, location);
			idList = userService.getIdsByDynamicCondition(User.class, params, start, size);
			List<User> userList = userService.getObjectsByIds(idList);
			log.info("get  user data is " + userList.size());

			Integer userCount = userService.countUserIds();

			log.info("   total = " + userCount);
			model.addAttribute("userCount", userCount);
			List<Long> usercountIds = userService.getIdsByDynamicCondition(User.class, params, 0, Integer.MAX_VALUE);
			userCount = usercountIds.size();
			Integer totalPage = (((userCount - 1)) / size) + 1;
			log.info("   totalPage = " + totalPage);

			if (idList != null && idList.size() > 0) {
				if (size.equals(idList.size())) {
					next = true;
					idList = idList.subList(0, size);
				}
			}

			Integer total = userService.countUserIds();

			model.addAttribute("code", 0);
			model.addAttribute("next", next);
			model.addAttribute("total", total);
			model.addAttribute("totalPage", totalPage);
			model.addAttribute("userList", userList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get user list error");
			model.addAttribute("code", -1);
		}

		return "/academy-user-service/user/json/userListJson";
	}
	
	
}

