package com.ptteng.academy.admin.controller;

import com.ptteng.academy.document.model.Teacher;
import com.ptteng.academy.document.service.TeacherService;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;

/**
 * Teacher  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class TeacherController {
	private static final Log log = LogFactory.getLog(TeacherController.class);

	@Autowired
	private TeacherService teacherService;

	@Autowired
	private CookieUtil cookieUtil;

	/**
	 * @Description 新增教师
	 * @param
	 * @Author: PeiyuFeng
	 * @Time 2017/3/17 16:11
	 */
	@RequestMapping(value = "/a/u/teacher", method = RequestMethod.POST)
	public String addTeacher(HttpServletRequest request,
							  HttpServletResponse response, ModelMap model, String name, String photo) throws Exception {

		log.info("insert teacher : name = " + name + " photo = " + photo);

		Long uid = Long.valueOf(cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID));

		if (StringUtils.isEmpty(name) || StringUtils.isEmpty(photo)) {
			model.addAttribute("code", -1000);
			return "/common/success";
		} else {
			log.info("params verify OK");
		}

		try {
			Teacher teacher = new Teacher();
			teacher.setCreateBy(uid);
			teacher.setUpdateBy(uid);
			teacher.setName(name);
			teacher.setProfilePhoto(photo);

			log.info("insert teacher : " + teacher);
			Long id = teacherService.insert(teacher);
			log.info("insert teacher success : " + id);


			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("add teacher error");
			model.addAttribute("code", -1);
		}
		return "/common/success";
	}



	/**
	 * @Description 删除教师
	 * @param id 教师id
	 * @Author: PeiyuFeng
	 * @Time 2017/3/18 17:02
	 */
	@RequestMapping(value = "/a/u/teacher/{id}", method = RequestMethod.DELETE)
	public String addDocument(HttpServletRequest request,
							  HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {

		log.info("delete teacher : id = " + id );

		Long uid = Long.valueOf(cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID));

		try {

			Teacher teacher = teacherService.getObjectById(id);
			if(teacher == null){
				log.info("teacher not exist");
				model.addAttribute("code", -2200);
				return "/common/success";
			}else {
				log.info("get teacher : " + teacher);
			}

			teacherService.delete(id);
			log.info("delete teacher success : " + id);


			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete teacher error");
			model.addAttribute("code", -1);
		}
		return "/common/success";
	}

	/**
	 * @Description 获取教师列表
	 * @param
	 * @Author: PeiyuFeng
	 * @Time 2017/3/18 17:08
	 */
	@RequestMapping(value = "/a/u/teacher/list", method = RequestMethod.GET)
	public String addDocument(HttpServletRequest request, HttpServletResponse response, ModelMap model) throws Exception {

		log.info("get teacher list ");

		Long uid = Long.valueOf(cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID));

		try {
			List<Teacher> teachers = new ArrayList<>();
			List<Long> tids = teacherService.getTeacherIds(0, Integer.MAX_VALUE);
			if(CollectionUtils.isEmpty(tids)){
				log.info("no teacher exist");
			}else {
				teachers = teacherService.getObjectsByIds(tids);
				log.info("get teacher list size : " + teachers.size());
			}

			model.addAttribute("code", 0);
			model.addAttribute("teacherList", teachers);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get teacher list error");
			model.addAttribute("code", -1);
		}
		return "/academy-document-service/teacher/json/teacherListJson";
	}
}

