package com.ptteng.academy.admin.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.academy.admin.util.DynamicUtil;
import com.ptteng.academy.document.model.Document;
import com.ptteng.academy.document.service.DocumentService;
import com.ptteng.academy.user.model.User;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Document  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class DocumentController {
    private static final Log log = LogFactory.getLog(DocumentController.class);

    @Autowired
    private DocumentService documentService;
    @Autowired
    private CookieUtil cookieUtil;


    /**
     * @param
     * @Description 修改文档
     * @Author: PeiyuFeng
     * @Time 2017/3/17 16:11
     */
    @RequestMapping(value = "/a/u/document/{id}", method = RequestMethod.PUT)
    public String updateDocument(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, String title, String author, Integer type,
                                 String img, String content, String summary, @PathVariable Long id) throws Exception {

        log.info("update document : title = " + title + " author = " + author + " type = " + type + " img " + img
                + " content = " + content + " summary = " + summary);

        try {
            Document document = documentService.getObjectById(id);

            if (document == null) {
                log.info("document don't exist");
                model.addAttribute("code", -2100);
                return "/common/success";
            } else {
                log.info("get document : " + document);
            }

            if (DataUtils.isNotNullOrEmpty(title)) {
                document.setTitle(title);
            } else {
                log.info("title not change");
            }

            if (DataUtils.isNotNullOrEmpty(author)) {
                document.setAuthor(author);
            } else {
                log.info("author not change");
            }

            if (DataUtils.isNotNullOrEmpty(type)) {
                document.setType(type);
            } else {
                log.info("type not change");
            }

            if (DataUtils.isNotNullOrEmpty(img)) {
                document.setImg(img);
            } else {
                log.info("img not change");
            }

            if (DataUtils.isNotNullOrEmpty(content)) {
                document.setContent(content);
            } else {
                log.info("content not change");
            }

            if (DataUtils.isNotNullOrEmpty(summary)) {
                document.setSummary(summary);
            } else {
                log.info("summary not change");
            }

            log.info("update document : " + document);
            documentService.update(document);

            model.addAttribute("code", 0);
            model.addAttribute("document", document);


        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update document error,id is  " + id);
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }

    /**
     * @param
     * @Description 新增文档
     * @Author: PeiyuFeng
     * @Time 2017/3/17 16:11
     */
    @RequestMapping(value = "/a/u/document", method = RequestMethod.POST)
    public String addDocument(HttpServletRequest request,
                              HttpServletResponse response, ModelMap model, Document document) throws Exception {

        log.info("insert document : " + document);

        Long uid = Long.valueOf(cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID));

        if (document == null) {
            model.addAttribute("code", -1000);
            return "/common/success";
        }

        if (document.getTitle() == null || document.getType() == null || document.getImg() == null || document.getAuthor() == null
                || document.getContent() == null || document.getSummary() == null) {
            model.addAttribute("code", -1000);
            return "/common/success";
        } else {
            log.info("params verify OK");
        }

        try {
            document.setCreateBy(uid);
            document.setUpdateBy(uid);

            document.setId(null);
            document.setStatus(Document.Status_Unpublished);
            document.setPublishAt(System.currentTimeMillis());
            document.setLove(0L);
            document.setCollection(0L);
            document.setRead_count(0);
            document.setRank(2);

            if (Document.Type_Banner.equals(document.getType())) {
                document.setOrderBy(getMaxSort());
            }

            log.info("insert document : " + document);
            Long aid = documentService.insert(document);
            log.info("insert document success");


            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add lesson error ");
            model.addAttribute("code", -1);
        }
        return "/common/success";
    }


    /**
     * @param
     * @Description 文档上下架
     * @Author: PeiyuFeng
     * @Time 2017/3/17 16:13
     */
    @RequestMapping(value = "/a/u/document/{id}/status", method = RequestMethod.PUT)
    public String updateDocumentStatus(HttpServletRequest request,
                                       HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {

        Document document = documentService.getObjectById(id);
        Integer status = document.getStatus();
        log.info("update document status : id , status = " + id + " , " + status);

        try {

            String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);

            document.setUpdateBy(Long.parseLong(userId));
            log.info("document is  " + document);
            if (Document.Status_Unpublished.equals(status)) {
                log.info("change publish");

                //将banner上架先校验上架banner是否已满八个,从第八个开始取消置顶
                List<Long> bannerIds = documentService.getDocumentIdsByStatusAndTypeOrderByUpdateAt(Document.Status_Published, Document.Type_Banner, 0, Integer.MAX_VALUE);
                log.info("public banner ids : " + bannerIds);
                if (bannerIds.size() > 7) {
                    List<Document> documents = documentService.getObjectsByIds(bannerIds);
                    for (int i = 7; i < documents.size(); i++) {
                        Document banner = documents.get(i);
                        banner.setStatus(Document.Status_Unpublished);
                        log.info("post : " + banner.getId() + " cancel sticky");
                    }
                    documentService.updateList(documents);
                } else {
                    log.info("banner ids : " + bannerIds + " less than 8");
                }

                Long time = System.currentTimeMillis();
                document.setStatus(Document.Status_Published);//发布
                document.setPublishAt(time);
            } else {
                log.info("change unPublish");
                document.setStatus(Document.Status_Unpublished);//下架
            }

            documentService.update(document);
            model.addAttribute("code", 0);


        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update document status error,id is  " + id);
            model.addAttribute("code", -1);

        }

        return "common/success";
    }


    /**
     * @param ids 排序banner id
     * @Description 文档banner排序
     * @Author: PeiyuFeng
     * @Time 2017/3/17 16:10
     */
    @RequestMapping(value = "/a/u/document/sort", method = RequestMethod.POST)
    public String sort(HttpServletRequest request,
                       HttpServletResponse response, ModelMap model,
                       @RequestBody List<Long> ids) throws Exception {

        log.info("sort document : ids= " + ids);

        try {
            List<Document> documentList = documentService.getObjectsByIds(ids);

            int index = 1;
            for (Document document : documentList) {
                document.setOrderBy(index);
                index = index + 1;
            }
            this.documentService.updateList(documentList);

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update document sort error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }


    /**
     * @param id 文档id
     * @Description 查看文档详情
     * @Author: PeiyuFeng
     * @Time 2017/3/15 17:16
     */
    @RequestMapping(value = "/a/u/document/{id}", method = RequestMethod.GET)
    public String getDocument(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {

        if (id == null) {
            model.addAttribute("code", -1000);
            return "/common/success";
        }

        log.info("get data : id= " + id);
        try {

            Document document = documentService.getObjectById(id);

            if (document == null) {
                log.info("document don't exist");
                model.addAttribute("code", -2107);
                return "/common/success";
            }

            model.addAttribute("code", 0);
            model.addAttribute("document", document);


        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get document error,id is  " + id);
            model.addAttribute("code", -1);
        }

        return "/academy-document-service/document/json/documentDetailJson";
    }

    /**
     * @param type  文档类型banner/normal
     * @param title 文档标题
     * @Description 查询文档列表
     * @Author: PeiyuFeng
     * @Time 2017/3/15 17:42
     */
    @RequestMapping(value = "/a/u/document/list", method = RequestMethod.GET)
    public String getDocumentList(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                  Integer page, Integer size, Integer type, String title, String author, Integer status,
                                  Integer minLike, Integer maxLike, Integer minCollection, Integer maxCollection) throws Exception {

        log.info("get document list type is " + type + " title is " + title + " author is " + author + " status is " + status +
                " minLike is " + minLike + " maxLike is " + maxLike + " minCollection is " + minCollection + " maxCollection is " + maxCollection);

        List<Long> documentIds = new ArrayList<>();
        List<Long> count = new ArrayList<>();

        Integer total = null;
        if (page == null) {
            page = 1;
        }
        if (size == null || size == 0) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        log.info("pageList : page= " + start + " , size=" + size);

        try {
            Map<String, Object> param = DynamicUtil.getDocumentList(type, title, author, status, minLike, maxLike, minCollection, maxCollection);
            log.info("param is " + param);
            documentIds = documentService.getIdsByDynamicCondition(Document.class, param, start, size);
            count = documentService.getIdsByDynamicCondition(Document.class, param, 0, Integer.MAX_VALUE);
            total = count.size();
            log.info("total size " + total);

            if (documentIds != null && documentIds.size() > 0) {

                log.info("get article list ids is" + documentIds);
                List<Document> documentList = documentService.getObjectsByIds(documentIds);
                model.addAttribute("documentList", documentList);
            }

            Boolean next = false;
            Integer nex = start + size;

            if (total > nex) {
                next = true;
            }

            Integer totalPage = 1;
            if (total > 0) {
                totalPage = (total - 1) / size + 1;
            }
            model.addAttribute("total", total);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("size", size);
            model.addAttribute("code", 0);
            model.addAttribute("next", next);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get document list error,page is  " + start + " , size " + size);

            model.addAttribute("code", -1);
        }

        return "/academy-document-service/document/json/documentListJson";
    }


    private Integer getMaxSort() throws ServiceException, ServiceDaoException {
        Map<String, Object> param = DynamicUtil.getDocumentMaxOrderBy();
        List<Long> maxs = this.documentService.getIdsByDynamicCondition(Document.class, param, 0, 1);
        Integer max = 0;
        if (CollectionUtils.isEmpty(maxs)) {
            log.info("first order ");

        } else {
            Long maxID = maxs.get(maxs.size() - 1);
            log.info(" maxID = " + maxID);
            max = this.documentService.getObjectById(maxID).getOrderBy();
            if (null == max) {
                max = 0;
            }
            log.info("quiz max order is " + max);
        }
        return max + 1;
    }


    /**
     * @Description 文档置顶/取消置顶
     * @Author: shixing
     * @Time 2017/6/28 00:00
     */
    @RequestMapping(value = "/a/u/document/rank/{id}", method = RequestMethod.PUT)
    public String rankDocument(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                               @PathVariable Long id) throws Exception {

        log.info("id is :" + id);
        if (DataUtils.isNullOrEmpty(id)) {
            model.addAttribute("code", -1);
            return "common/success";
        }
        try {
            Document document = documentService.getObjectById(id);
            log.info("document is :" + document);
            if (null == document) {
                model.addAttribute("code", -1);
                return "common/success";
            } else {
                log.info("document is exist");
            }
            //置顶的可以直接取消置顶，非置顶的如要置顶需要满足：没有其他置顶的文章,对于已经有置顶的，就把它顶下去
            if (Document.RANK_TOP.equals(document.getRank())) {
                document.setRank(Document.RANK_DOWN);
                log.info("document.getRank() is :" + document.getRank());
            } else {
                Map<String, Object> param = DynamicUtil.getDocumentRank(id);
                List<Long> documentIds = documentService.getIdsByDynamicCondition(Document.class,param,0,Integer.MAX_VALUE);
                if(documentIds.size()==0){
                    document.setRank(Document.RANK_TOP);
                    log.info("document.getRank() is :" + document.getRank());
                }else if(documentIds.size()==1){
                    Long documentId = documentIds.get(0);
                    Document alreadyRankTopDocument = documentService.getObjectById(documentId);
                    alreadyRankTopDocument.setRank(Document.RANK_DOWN);
                    log.info("alreadyRankTopDocument.size() is " + alreadyRankTopDocument.getRank());
                    boolean result = documentService.update(alreadyRankTopDocument);
                    log.info("result is :" + result);
                    document.setRank(Document.RANK_TOP);
                    log.info("document.getRank() is :" + document.getRank());
                }else {
                    model.addAttribute("code", -1);
                    return "common/success";
                }

            }
            boolean result1 = documentService.update(document);
            log.info("result1 is :" + result1);
            model.addAttribute("code",0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get document  error,id is:" + id);
            model.addAttribute("code", -1);
        }

        return "common/success";
    }

}