package com.ptteng.academy.admin.controller;

import com.gemantic.common.util.StringUtil;
import com.gemantic.commons.code.annotation.FileTemplate;
import com.ptteng.academy.admin.CouponParam.CouponParam;
import com.ptteng.academy.admin.model.Constant;
import com.ptteng.academy.admin.service.ConstantService;
import com.ptteng.academy.admin.util.CommonUtil;
import com.ptteng.academy.admin.util.DynamicUtil;
import com.ptteng.academy.admin.util.Txt;
import com.ptteng.academy.user.model.Coupon;
import com.ptteng.academy.user.model.Member;
import com.ptteng.academy.user.service.CouponService;
import com.ptteng.academy.user.service.MemberService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * Coupon  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class CouponController {
	private static final Log log = LogFactory.getLog(CouponController.class);

	@Autowired
	private CouponService couponService;


	@Autowired
	private MemberService memberService;
	@Autowired
	private ConstantService constantService;


	/**
	 * 卡券列表
	 * @param request
	 * @param response
	 * @param model
	 * @param page
	 * @param size
	 * @param status 状态
	 * @param number 序列号
	 * @param minPeriod 有效期始
	 * @param maxPeriod 有效期终
	 * @param effectBegin 生成日期起
	 * @param effectEnd  生成日期终
	 * @param invalidBegin 失效日期起始
	 * @param invalidEnd 失效日期结束
	 * @param memberId 套餐id
	 * @param excel 是否导出excel
	 * @return
	 * @throws Exception
	 */
	@FileTemplate(templatePath = "excel/excel.vm",filePath="/data/webs/academy-admin-web/excel/",fileName="")
	@RequestMapping(value = "/a/u/coupon/search", method = RequestMethod.GET)
	public String getMemberIdsByStatusJsonList(HttpServletRequest request,
											   HttpServletResponse response, ModelMap model, Integer page,
											   Integer size,Integer status,String number,String minPeriod,String maxPeriod,Long  effectBegin,Long effectEnd,
											   Long  invalidBegin,Long invalidEnd,Long memberId,String excel) throws Exception {
		log.info(" /a/member/search number = "+number+" status = "+status+" minPeriod = "+minPeriod+" maxPeriod = "+maxPeriod
				+" effectBegin = "+effectBegin+" effectEnd = "+effectEnd+" invalidBegin = "+invalidBegin+" invalidEnd "+
				invalidEnd+" memberId = "+memberId+" excel = "+excel);

		if (page == null) {
			page = 1;
		}
		if("excel".equals(excel)){
			size = Integer.MAX_VALUE;
		}else{
			if (size == null) {
				size = 10;
			}
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {

			Map<String,Object> map = DynamicUtil.getCouponList
					(status,number,minPeriod,maxPeriod,effectBegin,effectEnd,invalidBegin,invalidEnd,memberId,false);
			log.info(" map = "+map);
			List<Long> ids= couponService.getIdsByDynamicCondition(Coupon.class,map,start,size);

			List<Coupon> couponList = new ArrayList<>();

			if(CollectionUtils.isEmpty(ids)){
				log.info(" get couponList   ids ,size is 0 ");

			}else {
				log.info(" get couponList   ids ,size is  "+ids.size() );
				couponList = couponService.getObjectsByIds(ids);
				log.info("get coupon data is " + couponList.size());

				if("excel".equals(excel)){
					setIndentName(couponList);
					log.info("  excel is true ");
					CouponParam couponParam = new CouponParam();
					Map<String,String> config = couponParam.getConfig();
					model.put("config", config);
					String[] clumns = couponParam.getKeys();
					model.put("configKeys", clumns);
					for(String fieldName:clumns){
						Field field=CouponParam.class.getDeclaredField(fieldName);
						field.setAccessible(true);
						field.get(couponParam);
					}
				}else{
					log.info("  excel is false ");
				}
				model.addAttribute("list", couponList);

			}




			map = DynamicUtil.getCouponList
					(status, number, minPeriod, maxPeriod, effectBegin, effectEnd, invalidBegin, invalidEnd, memberId, true);

			BigInteger total =(BigInteger) couponService.getObjectByDynamicCondition(Coupon.class,map,0,Integer.MAX_VALUE);
			log.info("get coupon count is " + total);
			log.info("get couponList  total is " + total);
			int totalPage = 1;
			if(null != total){
				if(total.intValue()>0){
					totalPage = (((total.intValue() - 1)) / (size)) + 1;;
				}
			}

			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			model.addAttribute("total", total);
			model.addAttribute("totalPage", totalPage);

			model.addAttribute("couponList", couponList);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get member list error,page is  " + start + " , size "
					+ size);
			model.addAttribute("code", -1);
		}

		return "/academy-user-service/coupon/json/couponListJson";
	}

	public static  void setIndentName(List<Coupon> list) {
		log.info(" setIndentName start ... ");
		for (Coupon coupon : list) {
			Integer status = coupon.getStatus();
			if (null != status) {
				if (Coupon.UNUSE_STATUS == status) {
					coupon.setStatusStr("未使用");
				} else if (Coupon.USED_STATUS == status) {
					coupon.setStatusStr("已使用");
				} else if (Coupon.OUTOFDATE_STATUS == status) {
					coupon.setStatusStr("已过期");
				} else {
					coupon.setStatusStr("");
				}
			}

			coupon.setCreateDate(getDate(coupon.getCreateAt()));
			coupon.setDeadlineDate(getDate(coupon.getDeadline()));
		}
	}
	public static String getDate(Long time){
		SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		String date = "";

		if(null != time){
			date = dateFormat.format(new Date(time));
		}
		return  date;
	}

	/**
	 * 生成卡券
	 * @param request
	 * @param response
	 * @param model
	 * @param amount 数量
	 * @param deadline 失效日期
	 * @param memberId 套餐ID
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/coupon", method = RequestMethod.POST)
	public String addCouponJson(HttpServletRequest request,
								HttpServletResponse response, ModelMap model,String amount ,Long deadline,Long memberId) throws Exception {
		log.info(" batch generate coupon start , amount = " + amount + " deadline = " + deadline + " memberId = " + memberId);

		try {

			if(StringUtil.isEmpty(amount)){
				model.addAttribute("code", -9005);
				return "/data/json";
			}
			int length = amount.length();
			log.info("  batch generate coupon , length = "+length);
			BigInteger amountNum = new BigInteger(amount);

			if(amountNum.intValue()>0){
				log.info(" batch generate ,amount > 0 ");

			}else {
				log.info(" batch generate ,amount <= 0 ");
				model.addAttribute("code", -9004);
				return "/data/json";
			}

			Member member = memberService.getObjectById(memberId);
			if(null == member){
				model.addAttribute("code", -9003);
				return "/data/json";
			}

			String fileName = Txt.creatSqlFile("coupon");
			log.info(" batch generate ,fileName = "+fileName);
			//在生成第几批
			Constant constant  = constantService.getObjectById(constantService.getConstantIdByKeyAndType("pointss_batch", "points"));
			String pointBatch = constant.getValue();
			log.info("batch generate ,pointBatch =  " + pointBatch);
			constant.setValue(new BigDecimal(constant.getValue()).add(new BigDecimal("1")) + "");
			constantService.update(constant);

			//获取套餐


			//批量生成卡号
			List<String>  sequenceList  = generateSequenceList("101", pointBatch, 0, amountNum.intValue(), 6);
			log.info(" batch generate , sequenceList size = "+sequenceList);
			//批量生成密码
			Map<String,List<String>>  pwdMap = CommonUtil.generatePwdList(8, 0,amountNum.intValue());
			List<String> pwdList = pwdMap.get("1");//明文密码
			log.info(" batch generate , pwdList size = "+pwdList);
			List<String> md5pwdList = pwdMap.get("2");//暗文密码
			log.info(" batch generate , md5pwdList size = "+md5pwdList);

			Long current = System.currentTimeMillis();
			for(int i=0;i<amountNum.intValue();i++){

				StringBuilder stringBuilder = new StringBuilder(" insert into coupon(id,number,pwd,md5_pwd,period,deadline," +
						"name,price,status,member_id,update_at,create_at)" +
						" values(");
				stringBuilder.append("'"+sequenceList.get(i)+"'"+",");
				stringBuilder.append("'"+sequenceList.get(i)+"'"+",");
				stringBuilder.append("'"+pwdList.get(i)+"'"+",");
				stringBuilder.append("'"+md5pwdList.get(i)+"'"+",");
				stringBuilder.append("'"+member.getPeriod()+"'"+",");
				stringBuilder.append("'"+deadline+"'"+",");
				stringBuilder.append("'"+member.getName()+"'"+",");
				stringBuilder.append("'"+member.getPrice()+"'"+",");
				stringBuilder.append("'"+Coupon.UNUSE_STATUS+"'"+",");
				stringBuilder.append("'"+memberId+"'"+",");
				stringBuilder.append("'"+current+"'"+",");
				stringBuilder.append("'"+current+"');  ");

				Txt.writeTxtFile(stringBuilder.toString());

			}
			Process proc = null;
			proc = Runtime.getRuntime().exec
					("sh "+"/data/webs/academy-admin-web/script/coupon.sh  " + fileName);
			BufferedReader in = new BufferedReader(new InputStreamReader(proc.getInputStream()));
			String line;
			while ((line = in.readLine()) != null) {
				log.info("  line  " + line);
			}
			in.close();
			try {
				proc.waitFor();
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
			log.info(" batch generate , success ");
			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("add coupon error ");
			model.addAttribute("code", -1);
		}

		return "/data/json";
	}






	/**
	 * 获取序列号
	 * @param channel  销售渠道
	 * @param printTimes 印刷次数
	 *@param  mix 最小值
	 * @param max  最大值
	 * @param length 长度
	 * @return
	 */
	public static List<String> generateSequenceList(String channel,String printTimes,Integer mix,Integer max,Integer length) {
		List<String> sequenceList = new ArrayList<>();
		for(int i=mix;i<max;i++){
			String str = channel+printTimes;
			String  formatStr  = "%0" + length + "d";
			str += String.format(formatStr, i);
			sequenceList.add(str);
		}

		return sequenceList;

	}



	@RequestMapping(value = "/a/coupon/{id}", method = RequestMethod.DELETE)
	public String deleteCouponJson(HttpServletRequest request,
								   HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete coupon : id= " + id);
		try {
			couponService.delete(id);

			log.info("add coupon success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete coupon error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}


	@RequestMapping(value = "/a/multi/coupon", method = RequestMethod.GET)
	public String getMultiCouponJson(HttpServletRequest request,
									 HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {

		List<Long> idList = new ArrayList();
		if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {



			List<Coupon> couponList = couponService.getObjectsByIds(idList);
			log.info("get  coupon data is " + couponList);

			model.addAttribute("code", 0);
			model.addAttribute("total",couponList.size());

			model.addAttribute("couponList", couponList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get coupon error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/academy-user-service/coupon/json/couponListJson";
	}


}

