/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.util;

import com.ptteng.util.ImChatUtil;
import com.ptteng.util.ParametersUtil;
import com.ptteng.util.RandomUtils;
import com.ptteng.util.httpUtils.httpRequestUtils.HttpReqUtil;
import com.ptteng.util.httpUtils.httpResponseUtiils.PostResponseUtil;
import com.ptteng.yi.nucleus.model.Students;
import com.ptteng.yi.pub.service.ImAccountService;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.log4j.Logger;

public class ImChatUtil {
    private static final Logger log = Logger.getLogger(ImChatUtil.class);
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    public static final Integer STUDENT = 0;
    public static final Integer COACH = 1;
    public static final Integer SCHOOL_MANAGER = 4;
    public static final Integer AFLTER_CUSTOMER = 2;
    public static final Integer PREPARE_CUSTOMER = 3;
    private static String accessKey;
    private static String accessSecret;
    private static String createAccIdUrl;
    private static String updateInfoUrl;
    private static String unifiedPwd;
    private static int accIdMaxLength;
    private static ImAccountService imAccountService;

    public void setCreateAccIdUrl(String createAccIdUrl) {
        ImChatUtil.createAccIdUrl = createAccIdUrl;
    }

    public void setUpdateInfoUrl(String updateInfoUrl) {
        ImChatUtil.updateInfoUrl = updateInfoUrl;
    }

    public void setAccessSecret(String accessSecret) {
        ImChatUtil.accessSecret = accessSecret;
    }

    public void setAccessKey(String accessKey) {
        ImChatUtil.accessKey = accessKey;
    }

    public void setAccIdMaxLength(int accIdMaxLength) {
        ImChatUtil.accIdMaxLength = accIdMaxLength;
    }

    public void setUnifiedPwd(String unifiedPwd) {
        ImChatUtil.unifiedPwd = unifiedPwd;
    }

    public void setImAccountService(ImAccountService imAccountService) {
        ImChatUtil.imAccountService = imAccountService;
    }

    public Map<String, String> createImAccount(String accid) throws Exception {
        log.info((Object)("accid is==" + accid));
        if (accid == null || accid.isEmpty()) {
            log.info((Object)"accid is null or empty");
            throw new Exception("accid can not be null or empty");
        }
        boolean accountExistent = imAccountService.isAccidExistent(accid);
        if (accountExistent) {
            log.info((Object)"The accid is already existent");
            throw new Exception("The accid is already existent,pls swap another one");
        }
        Map headers = this.getHeadersOfWYImChatRequest();
        HashMap<String, String> values = new HashMap<String, String>(16);
        values.put("accid", accid);
        values.put("token", unifiedPwd);
        CloseableHttpResponse response = HttpReqUtil.sendPost((String)createAccIdUrl, (Map)headers, values);
        return PostResponseUtil.handleResponseOfCreateImAccountRequest((CloseableHttpResponse)response);
    }

    public boolean updateUserInfo(String accid, Students students) throws Exception {
        String icon;
        String mobile;
        log.info((Object)("accid is==" + accid + "   students is==" + students));
        if (null == accid || accid.isEmpty() || null == students) {
            log.info((Object)"args is null or empty");
            throw new Exception("args can not be null or empty");
        }
        String name = students.getName();
        boolean hasOneParameterIsNotEmptyAndNull = ParametersUtil.hasOneParameterIsNotNullAndEmpty((String[])new String[]{name, mobile = students.getMobile(), icon = students.getImg()});
        if (!hasOneParameterIsNotEmptyAndNull) {
            log.error((Object)"students info is null or empty");
            return true;
        }
        Map headers = this.getHeadersOfWYImChatRequest();
        HashMap<String, String> values = new HashMap<String, String>(4);
        values.put("accid", accid);
        if (null != name && !name.equals("")) {
            values.put("name", name);
        }
        if (null != icon && !icon.equals("")) {
            values.put("icon", icon);
        }
        if (null != mobile && !mobile.equals("")) {
            values.put("mobile", mobile);
        }
        CloseableHttpResponse response = HttpReqUtil.sendPost((String)updateInfoUrl, (Map)headers, values);
        return PostResponseUtil.handleResponseOfUpdateInfoRequest((CloseableHttpResponse)response);
    }

    private Map<String, String> getHeadersOfWYImChatRequest() {
        HashMap<String, String> headers = new HashMap<String, String>(16);
        String nonce = RandomUtils.generateString((int)20);
        String cureTime = String.valueOf(System.currentTimeMillis() / 1000L);
        String checkSum = this.getCheckSum(accessSecret, nonce, cureTime);
        headers.put("AppKey", accessKey);
        headers.put("Nonce", nonce);
        headers.put("CurTime", cureTime);
        headers.put("CheckSum", checkSum);
        headers.put("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
        return headers;
    }

    public String getAccid(Long id, AccidType type) throws Exception {
        log.info((Object)("id is==" + id + " type is==" + type));
        if (null == id || 0L >= id) {
            log.info((Object)"id is null or zero");
            throw new Exception("id cant not be null or zero");
        }
        String accid = null;
        int accidLength = 0;
        int UUIDLength = 0;
        switch (1.$SwitchMap$com$ptteng$util$ImChatUtil$AccidType[type.ordinal()]) {
            case 1: {
                accid = "xy_" + id + "_";
                break;
            }
        }
        accidLength = accid.length();
        UUIDLength = accIdMaxLength - accidLength;
        accid = accid + RandomUtils.toFixedLengthStringByUUID((int)UUIDLength);
        return accid;
    }

    private String getCheckSum(String appSecret, String nonce, String curTime) {
        return this.encode("sha1", appSecret + nonce + curTime);
    }

    private String getMD5(String requestBody) {
        return this.encode("md5", requestBody);
    }

    private String encode(String algorithm, String value) {
        if (value == null) {
            return null;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
            messageDigest.update(value.getBytes());
            return this.getFormattedText(messageDigest.digest());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getFormattedText(byte[] bytes) {
        int len = bytes.length;
        StringBuilder buf = new StringBuilder(len * 2);
        for (int j = 0; j < len; ++j) {
            buf.append(HEX_DIGITS[bytes[j] >> 4 & 0xF]);
            buf.append(HEX_DIGITS[bytes[j] & 0xF]);
        }
        return buf.toString();
    }
}

