/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.util;

import com.qding.common.util.DataUtils;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class DynamicUtil {
    private static final Log log = LogFactory.getLog(DynamicUtil.class);

    public static Map<String, Object> getCardListParams(String pwd, Integer status, Long currentTime, Boolean count) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)pwd)) {
            params.put("pwd", " '" + pwd + "' ");
        }
        if (DataUtils.isNotNullOrEmpty((Object)status)) {
            params.put("status", status);
        }
        if (DataUtils.isNotNullOrEmpty((Object)currentTime)) {
            params.put("expire_at & >=", currentTime);
        }
        if (count.booleanValue()) {
            params.put("@query", "count(id)");
        } else {
            params.put("@query", "id");
        }
        params.put("@table", "card");
        return params;
    }

    public static Map<String, Object> getContentListParams(Integer type, Integer status, List<Integer> app, Long cityId, Boolean count) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (DataUtils.isNotNullOrEmpty((Object)type)) {
            params.put("type", type);
        }
        if (DataUtils.isNotNullOrEmpty((Object)status)) {
            params.put("status", status);
        }
        if (DataUtils.isNotNullOrEmpty((Object)cityId)) {
            params.put("city_id", cityId);
        }
        if (!CollectionUtils.isEmpty(app)) {
            String ids = StringUtils.join(app, (String)",");
            params.put("app & in ", "(" + ids + ")");
        }
        if (count.booleanValue()) {
            params.put("@query", " count(id) ");
        } else {
            params.put("@order", "  update_at desc ");
            params.put("@query", " id ");
        }
        params.put("@table", " content ");
        return params;
    }

    public static Map<String, Object> getClassListParams(Long cityId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("status", 1);
        params.put("city_id", cityId);
        params.put("showcasing", 1);
        params.put("@order", "  update_at desc ");
        params.put("@query", " id ");
        params.put("@table", " driving_class ");
        return params;
    }

    public static Map<String, Object> getSpecialPracticeParams(Integer subjectType, String special, Boolean count) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (DataUtils.isNotNullOrEmpty((Object)special)) {
            params.put("examination_point & like ", "'%" + special + "%'");
        }
        if (DataUtils.isNotNullOrEmpty((Object)subjectType)) {
            params.put("subject_type", subjectType);
        }
        if (count.booleanValue()) {
            params.put("@query", " count(id) ");
        } else {
            params.put("@query", " id ");
        }
        params.put("@table", " subject_practice ");
        return params;
    }

    public static Map<String, Object> geCenterByCityIdAndStatus(Long cityId, Integer status) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (DataUtils.isNotNullOrEmpty((Object)status)) {
            params.put("status", status);
        }
        if (DataUtils.isNotNullOrEmpty((Object)cityId)) {
            params.put("city_id ", cityId);
        }
        params.put("@query", " id ");
        params.put("@order", " create_at desc ");
        params.put("@table", " center ");
        return params;
    }

    public static Map<String, Object> getCity() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("@query", " id ");
        params.put("@table", " cities ");
        return params;
    }

    public static Map<String, Object> getVenuesList(Long cityId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (DataUtils.isNotNullOrEmpty((Object)cityId)) {
            params.put("city_id ", cityId);
        }
        params.put("@query", " id ");
        params.put("@table", " training_venues ");
        return params;
    }

    public static Map<String, Object> getOrderList(Long cityId, Long stuId, Long schoolId, Long classId, String oid, Integer status) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (DataUtils.isNotNullOrEmpty((Object)cityId)) {
            params.put("city_id ", cityId);
        }
        if (DataUtils.isNotNullOrEmpty((Object)stuId)) {
            params.put("stu_id ", stuId);
        }
        if (DataUtils.isNotNullOrEmpty((Object)schoolId)) {
            params.put("school_id ", schoolId);
        }
        if (DataUtils.isNotNullOrEmpty((Object)classId)) {
            params.put("class_id ", classId);
        }
        if (DataUtils.isNotNullOrEmpty((Object)oid)) {
            params.put("oid ", oid);
        }
        if (DataUtils.isNotNullOrEmpty((Object)status)) {
            params.put("status ", status);
        }
        params.put("@query", " id ");
        params.put("@table", " orders ");
        return params;
    }

    public static Map<String, Object> getStudentClueListParams(String name) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            params.put("name ", name);
        }
        params.put("@query", " id ");
        params.put("@table", " probation");
        return params;
    }

    public static synchronized Map<String, Object> getTestPlanBySchoolIdAndTime(Long schoolId, Integer month) throws Exception {
        log.info((Object)("schoolId is==" + schoolId + "     month is==" + month));
        Long endTime = null;
        Calendar calendar = Calendar.getInstance();
        calendar.set(2, month - 1);
        int firstDay = calendar.getActualMinimum(5);
        int lastDay = calendar.getActualMaximum(5);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(5, firstDay);
        Long beginTime = calendar.getTimeInMillis();
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(5, lastDay);
        endTime = calendar.getTimeInMillis();
        HashMap<String, Object> sqlInfo = new HashMap<String, Object>();
        if (beginTime < 9999999999L || endTime < 9999999999L) {
            log.error((Object)"beginTime or endTime is not unix time Of millisecond");
            throw new Exception("beginTime or endTime is not unix time Of millisecond");
        }
        sqlInfo.put("school_id", schoolId);
        sqlInfo.put("1", " 1 and test_time BETWEEN " + beginTime + " AND " + endTime);
        sqlInfo.put("@query", " id");
        sqlInfo.put("@table", "test_plan");
        return sqlInfo;
    }

    public static Map<String, Object> getUserMessageList(Integer messageType, Integer targetReceive, Long uid, Integer status) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(" target_receive  ", targetReceive);
        params.put("uid", uid);
        if (status == 1 || status == 2) {
            params.put("status", status);
        }
        params.put("@query", " id ");
        params.put("@order", " create_at desc ");
        params.put("@table", "user_message");
        return params;
    }

    public static Map<String, Object> getCoachList(String mobile, Long schoolId, Long cityId, Integer certification) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)mobile)) {
            params.put("mobile & like ", "'%" + mobile + "%'");
        }
        if (DataUtils.isNotNullOrEmpty((Object)schoolId)) {
            params.put("school_id ", schoolId);
        }
        if (DataUtils.isNotNullOrEmpty((Object)cityId)) {
            params.put("city_id ", cityId);
        }
        if (DataUtils.isNotNullOrEmpty((Object)certification)) {
            params.put("certification ", certification);
        }
        params.put("@query", " id ");
        params.put("@table", " coach");
        return params;
    }

    public static Map<String, Object> getAppointTimeList(Long coachTimeId, Integer status) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (DataUtils.isNotNullOrEmpty((Object)coachTimeId)) {
            params.put("coach_time_id ", coachTimeId);
        }
        if (DataUtils.isNotNullOrEmpty((Object)status)) {
            params.put("status ", status);
        }
        params.put("@query", " id ");
        params.put("@table", " advance_time ");
        return params;
    }

    public static synchronized Map<String, Object> getTestPlanIdsByCondition(Long schoolId, List<Long> time) throws Exception {
        log.info((Object)("schoolId is==" + schoolId + "  time is==" + time));
        HashMap<String, Object> sqlInfo = new HashMap<String, Object>();
        HashMap<String, List<Long>> parameters = new HashMap<String, List<Long>>(16);
        parameters.put("1", time);
        String queryCondition = "";
        block6: for (int i = 1; i < parameters.size() + 1; ++i) {
            String token = i + "";
            if (null == parameters.get(token)) continue;
            switch (token) {
                case "1": {
                    queryCondition = " and " + DynamicUtil.getSqlByTimeToGetTestPlan(time);
                    continue block6;
                }
            }
        }
        sqlInfo.put("school_id", schoolId);
        sqlInfo.put("1", " 1 " + queryCondition);
        sqlInfo.put("@query", " id");
        sqlInfo.put("@table", "test_plan");
        return sqlInfo;
    }

    private static String getSqlByTimeToGetTestPlan(List<Long> time) throws Exception {
        Long startTime = time.get(0);
        Long endTime = time.get(1);
        if (null != startTime && startTime < 9999999999L || null != endTime && endTime < 9999999999L) {
            throw new Exception("beginTime or endTime is not unix time Of millisecond,beginTime is==" + startTime + "   endTime is==" + endTime);
        }
        String sql = null;
        if (null != startTime && null != endTime) {
            sql = "test_time BETWEEN " + startTime + " and " + endTime;
        } else if (null != startTime) {
            sql = "test_time >= " + startTime;
        } else if (null != endTime) {
            sql = "test_time <= " + endTime;
        }
        return sql;
    }

    public static Map<String, Object> getAppointOrderList(List<String> type, Long time, Long timeStart, Long timeEnd, Long coachId, Long studentId, Integer subject, Long createStart, Long createEnd, Long practiceStart, Long practiceEnd) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(type)) {
            params.put("type & in ", "(" + String.join((CharSequence)",", type) + ")");
        }
        if (DataUtils.isNotNullOrEmpty((Object)time)) {
            params.put("time ", time);
        }
        if (DataUtils.isNotNullOrEmpty((Object)coachId)) {
            params.put("coach ", coachId);
        }
        if (DataUtils.isNotNullOrEmpty((Object)timeStart)) {
            params.put("time_start ", timeStart);
        }
        if (DataUtils.isNotNullOrEmpty((Object)timeEnd)) {
            params.put("time_end ", timeEnd);
        }
        if (DataUtils.isNotNullOrEmpty((Object)studentId)) {
            params.put("student ", studentId);
        }
        if (DataUtils.isNotNullOrEmpty((Object)subject)) {
            params.put("subject ", subject);
        }
        if (DataUtils.isNotNullOrEmpty((Object)createStart)) {
            params.put("create_at & >=", createStart);
        }
        if (DataUtils.isNotNullOrEmpty((Object)createEnd)) {
            params.put("create_at & <=", createEnd);
        }
        if (DataUtils.isNotNullOrEmpty((Object)practiceStart)) {
            params.put("time & >=", practiceStart);
        }
        if (DataUtils.isNotNullOrEmpty((Object)practiceEnd)) {
            params.put("time & <=", practiceEnd);
        }
        params.put("@query", " id ");
        params.put("@order", " create_at desc ");
        params.put("@table", " appoint_order ");
        return params;
    }

    public static Map<String, Object> getAppointOrderListByUpdate(List<String> type, Long coachId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(type)) {
            params.put("type & in ", "(" + String.join((CharSequence)",", type) + ")");
        }
        if (DataUtils.isNotNullOrEmpty((Object)coachId)) {
            params.put("coach ", coachId);
        }
        params.put("@query", " id ");
        params.put("@order", " update_at desc ");
        params.put("@table", " appoint_order ");
        return params;
    }

    public static Map<String, Object> getCoachFreeList(Long coachId, Long freeTime) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (DataUtils.isNotNullOrEmpty((Object)coachId)) {
            params.put("coach_id ", coachId);
        }
        if (DataUtils.isNotNullOrEmpty((Object)freeTime)) {
            params.put("free_time ", freeTime);
        }
        params.put("@query", " id ");
        params.put("@table", " coach_free ");
        return params;
    }

    public static Map<String, Object> getImAccountIdByCondition(Integer type, List<Long> ids) throws Exception {
        log.info((Object)("type is==" + type + " ids is==" + ids));
        if (null == type || null == ids || 0 == ids.size()) {
            log.info((Object)"args is null or size is zero");
            throw new Exception("args can not be null or size is zero");
        }
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("1", type);
        params.put("2", ids);
        HashMap<String, Object> sqlInfo = new HashMap<String, Object>(16);
        String queryCondition = "";
        block8: for (int i = 1; i < params.size() + 1; ++i) {
            String token = i + "";
            if (null == params.get(token)) continue;
            switch (token) {
                case "1": {
                    queryCondition = " and " + DynamicUtil.getSqlByTypeToGetImAccountId((Integer)type);
                    continue block8;
                }
                case "2": {
                    queryCondition = queryCondition + " and " + DynamicUtil.getSqlByIdsToGetImAccountId(ids);
                    continue block8;
                }
            }
        }
        if (!queryCondition.isEmpty()) {
            sqlInfo.put("1", " 1 " + queryCondition);
        }
        sqlInfo.put("@query", " id");
        sqlInfo.put("@table", " im_account");
        return sqlInfo;
    }

    private static String getSqlByTypeToGetImAccountId(Integer type) {
        log.info((Object)("type is==" + type));
        return "type = " + type;
    }

    private static String getSqlByIdsToGetImAccountId(List<Long> ids) {
        log.info((Object)("ids is==" + ids));
        return "target_id in " + DynamicUtil.listValueToSqlKeyWordINValue(ids);
    }

    public static String listValueToSqlKeyWordINValue(List value) {
        log.info((Object)("list value is==" + value));
        String valueSql = "";
        for (int i = 0; i < value.size(); ++i) {
            valueSql = 0 == i ? "(" + value.get(i) : valueSql + " ," + value.get(i);
            if (i != value.size() - 1) continue;
            valueSql = valueSql + ")";
        }
        return valueSql;
    }

    public static Map<String, Object> getPlQuery(Integer os, Integer type) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(" os  ", os);
        params.put(" type ", type);
        params.put("@query", "id");
        params.put("@table", "version");
        params.put("@order", " create_at desc ");
        return params;
    }

    public static Map<String, Object> classIdgetSchoolList(Long classId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (DataUtils.isNotNullOrEmpty((Object)classId)) {
            params.put("class_id ", classId);
        }
        params.put("@query", "id");
        params.put("@table", "school_class_relation");
        return params;
    }

    public static Map<String, Object> schoolIdgetVenuesList(List<String> school) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(school)) {
            params.put("school_id & in ", "(" + String.join((CharSequence)",", school) + ")");
        }
        params.put("@query", " id ");
        params.put("@table", " school_venues_relation ");
        return params;
    }
}

