/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.controller;

import com.gemantic.common.util.MyListUtil;
import com.ptteng.common.util.notice.NoticeUtil;
import com.ptteng.util.Calculation;
import com.ptteng.util.DynamicUtil;
import com.ptteng.util.ImChatUtil;
import com.ptteng.util.TimeUtil;
import com.ptteng.yi.nucleus.model.AdvanceTime;
import com.ptteng.yi.nucleus.model.AppointOrder;
import com.ptteng.yi.nucleus.model.Coach;
import com.ptteng.yi.nucleus.model.CoachAppointTime;
import com.ptteng.yi.nucleus.model.CoachClassRelation;
import com.ptteng.yi.nucleus.model.CoachFree;
import com.ptteng.yi.nucleus.model.Constant;
import com.ptteng.yi.nucleus.model.School;
import com.ptteng.yi.nucleus.model.Students;
import com.ptteng.yi.nucleus.service.AdvanceTimeService;
import com.ptteng.yi.nucleus.service.AppointOrderService;
import com.ptteng.yi.nucleus.service.CoachAppointTimeService;
import com.ptteng.yi.nucleus.service.CoachClassRelationService;
import com.ptteng.yi.nucleus.service.CoachFreeService;
import com.ptteng.yi.nucleus.service.CoachService;
import com.ptteng.yi.nucleus.service.ConstantService;
import com.ptteng.yi.nucleus.service.SchoolService;
import com.ptteng.yi.nucleus.service.StudentsService;
import com.ptteng.yi.pub.model.ImAccount;
import com.ptteng.yi.pub.service.ImAccountService;
import com.qding.common.util.DataUtils;
import java.io.IOException;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class practiceCarController {
    private static final Log log = LogFactory.getLog(practiceCarController.class);
    @Autowired
    private CoachService coachService;
    @Autowired
    private StudentsService studentsService;
    @Autowired
    private CoachAppointTimeService coachAppointTimeService;
    @Autowired
    private AdvanceTimeService advanceTimeService;
    @Autowired
    private ConstantService constantService;
    @Autowired
    private CoachClassRelationService coachClassRelationService;
    @Autowired
    private SchoolService schoolService;
    @Autowired
    private AppointOrderService appointOrderService;
    @Autowired
    private CoachFreeService coachFreeService;
    @Autowired
    private ImAccountService imAccountService;
    @Autowired
    private NoticeUtil coachAndroidPushServiceImpl;
    @Autowired
    private NoticeUtil coachIosPushServiceImpl;

    @RequestMapping(value={"/a/u/coach/search"}, method={RequestMethod.GET})
    public String getCoachList(HttpServletRequest request, HttpServletResponse response, ModelMap model, String mobile, Integer page, Integer size) throws Exception {
        int start;
        log.info((Object)("mobile is " + mobile + " page is " + page + " size is " + size));
        if (DataUtils.isNullOrEmpty((Object)mobile)) {
            log.info((Object)"mobile is null");
            model.addAttribute("code", (Object)-5022);
            return "/common/failure";
        }
        if (page == null) {
            page = 1;
        }
        if (size == null || size < 0) {
            size = 10;
        }
        if ((start = (page - 1) * size) < 0) {
            start = 0;
        }
        Students students = (Students)request.getAttribute("user");
        log.info((Object)("students is " + students));
        Integer certification = students.getCertification();
        if (certification.equals(Coach.CERTIFICATION_ON)) {
            log.info((Object)"students is Certification_ON");
            model.addAttribute("code", (Object)-22000);
            return "/common/failure";
        }
        try {
            Map map = DynamicUtil.getCoachList((String)mobile, null, (Long)students.getCityId(), (Integer)Coach.CERTIFICATION_OFF);
            log.info((Object)("map is " + map));
            List ids = this.coachService.getIdsByDynamicCondition(Coach.class, map, Integer.valueOf(start), size);
            log.info((Object)("ids is " + ids));
            List coachList = new ArrayList();
            if (CollectionUtils.isNotEmpty((Collection)ids)) {
                coachList = this.coachService.getObjectsByIds(ids);
            }
            log.info((Object)("coachList.size is " + coachList.size()));
            Integer total = this.coachService.getIdsByDynamicCondition(Coach.class, map, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE)).size();
            model.addAttribute("code", (Object)0);
            model.addAttribute("page", (Object)page);
            model.addAttribute("size", (Object)size);
            model.addAttribute("total", (Object)total);
            model.addAttribute("coachList", coachList);
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            model.addAttribute("code", (Object)-100000);
        }
        return "/yi-nucleus-service/practiceCarController/json/coachListJson";
    }

    @RequestMapping(value={"/a/u/coach/class/search"}, method={RequestMethod.GET})
    public String getCoachList(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long schoolId, Long classId, Integer page, Integer size) throws Exception {
        int start;
        log.info((Object)("classId is " + classId));
        if (DataUtils.isNullOrEmpty((Object)classId)) {
            log.info((Object)"mobile is null");
            model.addAttribute("code", (Object)-22006);
            return "/common/failure";
        }
        if (page == null) {
            page = 1;
        }
        if (size == null || size < 0) {
            size = 10;
        }
        if ((start = (page - 1) * size) < 0) {
            start = 0;
        }
        try {
            Students students = (Students)request.getAttribute("user");
            if (DataUtils.isNullOrEmpty((Object)students.getSchoolId())) {
                log.info((Object)"students.getSchoolId is null");
                model.addAttribute("code", (Object)-22033);
                return "/common/failure";
            }
            List ids = this.coachClassRelationService.getCoachClassRelationIdsByClassId(classId, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            log.info((Object)("ids is " + ids));
            List coachClassRelationList = new ArrayList();
            if (CollectionUtils.isNotEmpty((Collection)ids)) {
                coachClassRelationList = this.coachClassRelationService.getObjectsByIds(ids);
            }
            List coachList = new ArrayList();
            List coachIds = MyListUtil.getDistinctList((Field)CoachClassRelation.class.getDeclaredField("coachId"), coachClassRelationList);
            coachList = this.coachService.getObjectsByIds(coachIds);
            ArrayList<Coach> newCoachList = new ArrayList<Coach>();
            ArrayList endCoachList = new ArrayList();
            for (Coach coach : coachList) {
                if (coach.getSchoolId().equals(students.getSchoolId()) && coach.getStatus() == Coach.STATUS_ON.intValue()) {
                    newCoachList.add(coach);
                    continue;
                }
                log.info((Object)("coach school id is : " + coach.getSchoolId() + " coach id is " + coach.getId()));
                log.info((Object)("coach is not belong shhoolId :" + schoolId));
            }
            Integer total = newCoachList.size();
            log.info((Object)("start is " + start + "start+size is " + (start + size)));
            for (int i = start; i < start + size; ++i) {
                if (i > newCoachList.size() - 1) continue;
                endCoachList.add(newCoachList.get(i));
            }
            log.info((Object)("endCoachList is " + endCoachList.size()));
            model.addAttribute("code", (Object)0);
            model.addAttribute("page", (Object)page);
            model.addAttribute("size", (Object)size);
            model.addAttribute("total", (Object)total);
            model.addAttribute("coachList", endCoachList);
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            model.addAttribute("code", (Object)-100000);
        }
        return "/yi-nucleus-service/practiceCarController/json/coachListJson";
    }

    @RequestMapping(value={"/a/u/coach/attention/{id}"}, method={RequestMethod.POST})
    public String attentionCoach(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id, Integer subject) throws Exception {
        log.info((Object)("id is " + id + " type is " + subject));
        Students students = (Students)request.getAttribute("user");
        log.info((Object)("students is " + students));
        try {
            Coach coach = this.coachService.getObjectById(id);
            if (DataUtils.isNullOrEmpty((Object)coach)) {
                log.info((Object)"coach  is null");
                model.addAttribute("code", (Object)-22001);
                return "/common/failure";
            }
            Integer certification = coach.getCertification();
            if (certification.equals(Coach.CERTIFICATION_ON)) {
                log.info((Object)"coach  is Certification_ON");
                model.addAttribute("code", (Object)-22003);
                return "/common/failure";
            }
            if (subject.equals(0) && DataUtils.isNotNullOrEmpty((Object)students.getSectionTwoCoachId())) {
                students.setSectionTwoCoach(null);
                students.setSectionTwoCoachId(null);
            } else if (subject.equals(0) && DataUtils.isNullOrEmpty((Object)students.getSectionTwoCoachId())) {
                if (DataUtils.isNullOrEmpty((Object)coach.getName())) {
                    students.setSectionTwoCoach(coach.getNick());
                } else {
                    students.setSectionTwoCoach(coach.getName());
                }
                students.setSectionTwoCoachId(coach.getId().toString());
            }
            if (subject.equals(1) && DataUtils.isNotNullOrEmpty((Object)students.getSectionThreeCoachId())) {
                students.setSectionThreeCoach(null);
                students.setSectionThreeCoachId(null);
            } else if (subject.equals(1) && DataUtils.isNullOrEmpty((Object)students.getSectionThreeCoachId())) {
                if (DataUtils.isNullOrEmpty((Object)coach.getName())) {
                    students.setSectionThreeCoach(coach.getNick());
                } else {
                    students.setSectionThreeCoach(coach.getName());
                }
                students.setSectionThreeCoachId(coach.getId().toString());
            }
            this.studentsService.update(students);
            model.addAttribute("code", (Object)0);
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            model.addAttribute("code", (Object)-100000);
        }
        return "/common/success";
    }

    @RequestMapping(value={"/a/u/coach/arrange/{id}"}, method={RequestMethod.GET})
    public String getCoachArrange(HttpServletRequest request, HttpServletResponse response, ModelMap model, int subject, int type, Long time, @PathVariable Long id) throws Exception {
        log.info((Object)("type is " + type + " subject is " + subject));
        if (DataUtils.isNullOrEmpty((Object)subject)) {
            log.info((Object)"subject is null");
            model.addAttribute("code", (Object)-22005);
            return "/common/failure";
        }
        if (DataUtils.isNullOrEmpty((Object)type)) {
            log.info((Object)"type is null");
            model.addAttribute("code", (Object)-22004);
            return "/common/failure";
        }
        if (DataUtils.isNullOrEmpty((Object)time)) {
            log.info((Object)"time is null");
            model.addAttribute("code", (Object)-22011);
            return "/common/failure";
        }
        if (DataUtils.isNullOrEmpty((Object)id)) {
            log.info((Object)"id is null");
            model.addAttribute("code", (Object)-22007);
            return "/common/failure";
        }
        try {
            Map map;
            Long coachId = id;
            log.info((Object)("coachId is " + coachId));
            Coach coach = this.coachService.getObjectById(coachId);
            if (DataUtils.isNullOrEmpty((Object)coach)) {
                log.info((Object)"coach is null");
                model.addAttribute("code", (Object)-22001);
                return "/common/failure";
            }
            if (coach.getStatus() == Coach.STATUS_OFF.intValue()) {
                log.info((Object)"coach is freeze");
                model.addAttribute("code", (Object)-22036);
                return "/common/failure";
            }
            log.info((Object)("coach is " + coach));
            Integer subjectId = subject;
            List coachAppointTimeIds = this.coachAppointTimeService.getCoachAppointTimeIdsByStatusAndTypeAndCoachId(0, type, coachId, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            log.info((Object)("coachAppointTimeIds is " + coachAppointTimeIds));
            ArrayList<AdvanceTime> timeList = new ArrayList<AdvanceTime>();
            List advanceTimeList = new ArrayList();
            CoachAppointTime coachAppointTime = new CoachAppointTime();
            if (CollectionUtils.isEmpty((Collection)coachAppointTimeIds)) {
                List ids = this.coachAppointTimeService.getCoachAppointTimeIdsByStatusAndCityIdAndType(1, coach.getCityId(), type, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
                log.info((Object)("ids is " + ids));
                List coachAppointTimeList = new ArrayList();
                if (CollectionUtils.isNotEmpty((Collection)ids)) {
                    coachAppointTimeList = this.coachAppointTimeService.getObjectsByIds(ids);
                }
                if (CollectionUtils.isNotEmpty((Collection)ids)) {
                    coachAppointTime = (CoachAppointTime)coachAppointTimeList.get(0);
                    log.info((Object)("coachAppointTime is " + coachAppointTime));
                    Map map2 = DynamicUtil.getAppointTimeList((Long)coachAppointTime.getId(), (Integer)0);
                    log.info((Object)("map is " + map2));
                    List advanceTimeIds = this.advanceTimeService.getIdsByDynamicCondition(AdvanceTime.class, map2, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
                    log.info((Object)("advanceTimeIds is " + advanceTimeIds));
                    if (CollectionUtils.isNotEmpty((Collection)advanceTimeIds)) {
                        advanceTimeList = this.advanceTimeService.getObjectsByIds(advanceTimeIds);
                    }
                }
            } else {
                List coachAppointTimeList = this.coachAppointTimeService.getObjectsByIds(coachAppointTimeIds);
                coachAppointTime = (CoachAppointTime)coachAppointTimeList.get(0);
                log.info((Object)("coachAppointTime is " + coachAppointTime));
                map = DynamicUtil.getAppointTimeList((Long)coachAppointTime.getId(), (Integer)0);
                log.info((Object)("map is " + map));
                List advanceTimeIds = this.advanceTimeService.getIdsByDynamicCondition(AdvanceTime.class, map, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
                log.info((Object)("advanceTimeIds is " + advanceTimeIds));
                if (CollectionUtils.isNotEmpty((Collection)advanceTimeIds)) {
                    advanceTimeList = this.advanceTimeService.getObjectsByIds(advanceTimeIds);
                }
            }
            ArrayList<String> typeList = new ArrayList<String>();
            typeList.add("1");
            typeList.add("2");
            typeList.add("3");
            typeList.add("4");
            typeList.add("5");
            typeList.add("7");
            map = DynamicUtil.getAppointOrderList(typeList, (Long)time, null, null, (Long)coachId, null, (Integer)subjectId, null, null, null, null);
            log.info((Object)("map is " + map));
            List appointOrderIds = this.appointOrderService.getIdsByDynamicCondition(AppointOrder.class, map, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            List appointOrderList = new ArrayList();
            log.info((Object)("appointOrderIds is " + appointOrderIds));
            if (CollectionUtils.isNotEmpty((Collection)appointOrderIds)) {
                appointOrderList = this.appointOrderService.getObjectsByIds(appointOrderIds);
            }
            for (int i = 0; i < advanceTimeList.size(); ++i) {
                AdvanceTime advanceTime = (AdvanceTime)advanceTimeList.get(i);
                log.info((Object)("advanceTime is " + advanceTime));
                int num = 0;
                for (int a = 0; a < appointOrderList.size(); ++a) {
                    if (!advanceTime.getStartTime().equals(((AppointOrder)appointOrderList.get(a)).getTimeStart()) || !advanceTime.getEndTime().equals(((AppointOrder)appointOrderList.get(a)).getTimeEnd())) continue;
                    ++num;
                }
                log.info((Object)("length is   " + appointOrderIds.size()));
                advanceTime.setArrangeNum(Long.valueOf(num));
                if (!subjectId.equals(advanceTime.getSubject())) continue;
                timeList.add(advanceTime);
                log.info((Object)("advanceTime =========" + advanceTime));
            }
            String advanceTime = null;
            Integer appointFrequency = null;
            Integer rest = null;
            if (subjectId.equals(0)) {
                advanceTime = coachAppointTime.getTwoAdvanceTime();
                appointFrequency = coachAppointTime.getTwoAppointFrequency();
            }
            if (subjectId.equals(1)) {
                advanceTime = coachAppointTime.getThreeAdvanceTime();
                appointFrequency = coachAppointTime.getThreeAppointFrequency();
            }
            Map coachFreeMap = DynamicUtil.getCoachFreeList((Long)coachId, (Long)time);
            log.info((Object)("coachFreeMap is " + coachFreeMap));
            List ids = this.coachFreeService.getIdsByDynamicCondition(CoachFree.class, coachFreeMap, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            log.info((Object)("ids is " + ids));
            if (CollectionUtils.isEmpty((Collection)ids)) {
                rest = coachAppointTime.getTwoRest();
            } else {
                List coachFreeList = this.coachFreeService.getObjectsByIds(ids);
                CoachFree coachFree = (CoachFree)coachFreeList.get(0);
                rest = coachFree.getStatus();
            }
            log.info((Object)("timeList is " + timeList));
            log.info((Object)("advanceTime is " + advanceTime));
            log.info((Object)("appointFrequency is " + appointFrequency));
            log.info((Object)("rest is " + rest));
            model.addAttribute("code", (Object)0);
            model.addAttribute("timeList", timeList);
            model.addAttribute("advanceTime", (Object)advanceTime);
            model.addAttribute("appointFrequency", (Object)appointFrequency);
            model.addAttribute("rest", (Object)rest);
            model.addAttribute("coachAppointTime", (Object)coachAppointTime);
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            model.addAttribute("code", (Object)-100000);
        }
        return "/yi-nucleus-service/practiceCarController/json/coachArrangeDetailJson";
    }

    @RequestMapping(value={"/a/u/coach/{id}"}, method={RequestMethod.GET})
    public String getCoach(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {
        log.info((Object)(" id is " + id));
        try {
            Coach coach = this.coachService.getObjectById(id);
            if (DataUtils.isNullOrEmpty((Object)coach)) {
                log.info((Object)"coach is null");
                model.addAttribute("code", (Object)-22001);
                return "/common/failure";
            }
            List imAccountIds = this.imAccountService.getIdByBelongIdAndBelongType(ImChatUtil.COACH, id);
            log.info((Object)("imAccountIds is==" + imAccountIds));
            ImAccount imAccount = null;
            if (null != imAccountIds && 1 == imAccountIds.size()) {
                imAccount = this.imAccountService.getObjectById((Long)imAccountIds.get(0));
            } else {
                log.info((Object)"The imAccountIds is null or size is not 1");
            }
            model.addAttribute("code", (Object)0);
            model.addAttribute("coach", (Object)coach);
            model.addAttribute("imAccount", (Object)imAccount);
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            model.addAttribute("code", (Object)-100000);
        }
        return "/yi-nucleus-service/practiceCarController/json/coachDetailJson";
    }

    @RequestMapping(value={"/a/u/constant"}, method={RequestMethod.GET})
    public String getConstant(HttpServletRequest request, HttpServletResponse response, ModelMap model) throws Exception {
        Students students = (Students)request.getAttribute("user");
        log.info((Object)("students  is " + students));
        try {
            Constant constant = new Constant();
            List ids = this.constantService.getConstantIdsByTypeAndTargetIdOrderByCreateBy(Constant.CONSTANT_CITY_ID_TYPE.intValue(), students.getCityId(), Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            log.info((Object)("ids is " + ids));
            if (CollectionUtils.isEmpty((Collection)ids)) {
                constant.setEvaluate(Constant.EVALUATE_NO.intValue());
            } else {
                List list = this.constantService.getObjectsByIds(ids);
                constant = (Constant)list.get(0);
                log.info((Object)("constant is " + constant));
            }
            School school = new School();
            if (DataUtils.isNullOrEmpty((Object)students.getSchoolId())) {
                constant.setDay(Long.valueOf(Constant.NO_SCHOOL_ID_APPOINT_DAY.intValue()));
                constant.setTimeStart(Long.valueOf(Constant.NO_SCHOOL_ID_APPOINT_START.intValue()));
                constant.setTimeEnd(Long.valueOf(Constant.NO_SCHOOL_ID_APPOINT_END.intValue()));
            } else {
                List constantIds = this.constantService.getConstantIdsByTypeAndTargetIdOrderByCreateBy(Constant.CONSTANT_SCHOOL_ID_TYPE.intValue(), students.getSchoolId(), Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
                log.info((Object)("constantIds is " + constantIds));
                if (CollectionUtils.isEmpty((Collection)constantIds)) {
                    constant.setDay(Long.valueOf(Constant.NO_SCHOOL_ID_APPOINT_DAY.intValue()));
                    constant.setTimeStart(Long.valueOf(Constant.NO_SCHOOL_ID_APPOINT_START.intValue()));
                    constant.setTimeEnd(Long.valueOf(Constant.NO_SCHOOL_ID_APPOINT_END.intValue()));
                } else {
                    List constantList = this.constantService.getObjectsByIds(constantIds);
                    Constant constantData = (Constant)constantList.get(0);
                    log.info((Object)("constantData is " + constantData));
                    if (DataUtils.isNotNullOrEmpty((Object)constantData.getDay())) {
                        constant.setDay(constantData.getDay());
                    } else {
                        constant.setDay(Long.valueOf(Constant.NO_SCHOOL_ID_APPOINT_DAY.intValue()));
                    }
                    if (DataUtils.isNotNullOrEmpty((Object)constantData.getTimeStart())) {
                        constant.setTimeStart(constantData.getTimeStart());
                    } else {
                        constant.setTimeStart(Long.valueOf(Constant.NO_SCHOOL_ID_APPOINT_START.intValue()));
                    }
                    if (DataUtils.isNotNullOrEmpty((Object)constantData.getTimeEnd())) {
                        constant.setTimeEnd(constantData.getTimeEnd());
                    } else {
                        constant.setTimeEnd(Long.valueOf(Constant.NO_SCHOOL_ID_APPOINT_END.intValue()));
                    }
                }
                school = this.schoolService.getObjectById(students.getSchoolId());
                log.info((Object)("school is " + school));
            }
            ArrayList<String> typeList = new ArrayList<String>();
            typeList.add("2");
            typeList.add("3");
            typeList.add("4");
            Map map = DynamicUtil.getAppointOrderList(typeList, null, null, null, null, (Long)students.getId(), null, null, null, null, null);
            log.info((Object)("map is " + map));
            List orderMaxIds = this.appointOrderService.getIdsByDynamicCondition(AppointOrder.class, map, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            log.info((Object)("orderMaxIds is " + orderMaxIds));
            model.addAttribute("code", (Object)0);
            model.addAttribute("constant", (Object)constant);
            model.addAttribute("school", (Object)school);
            model.addAttribute("length", (Object)orderMaxIds.size());
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            model.addAttribute("code", (Object)-100000);
        }
        return "/yi-nucleus-service/practiceCarController/json/constantDetailJson";
    }

    @RequestMapping(value={"/a/u/arrange"}, method={RequestMethod.POST})
    public String arrange(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long arrangeId, Long time, Long coachId) throws Exception {
        log.info((Object)("arrangeId is " + arrangeId + " time is " + time));
        if (DataUtils.isNullOrEmpty((Object)arrangeId)) {
            log.info((Object)"arrangeId is null");
            model.addAttribute("code", (Object)-22008);
            return "/common/failure";
        }
        if (DataUtils.isNullOrEmpty((Object)time)) {
            log.info((Object)"time is null");
            model.addAttribute("code", (Object)-22010);
            return "/common/failure";
        }
        try {
            Coach coach;
            AdvanceTime advanceTime = this.advanceTimeService.getObjectById(arrangeId);
            if (DataUtils.isNullOrEmpty((Object)advanceTime)) {
                log.info((Object)"advanceTime is null");
                model.addAttribute("code", (Object)-22027);
                return "/common/failure";
            }
            log.info((Object)("advanceTime is " + advanceTime));
            CoachAppointTime coachAppointTime = this.coachAppointTimeService.getObjectById(advanceTime.getCoachTimeId());
            if (DataUtils.isNullOrEmpty((Object)coachAppointTime)) {
                log.info((Object)"coachAppointTime is null");
                model.addAttribute("code", (Object)-22028);
                return "/common/failure";
            }
            log.info((Object)("coachAppointTime is " + coachAppointTime));
            Long todayTime = TimeUtil.getTimesTodayMorningInMillis();
            Long nowTime = System.currentTimeMillis();
            log.info((Object)("nowTime is " + nowTime));
            log.info((Object)("todayTime is " + todayTime));
            Students students = (Students)request.getAttribute("user");
            Long practiceTime = time + advanceTime.getStartTime();
            log.info((Object)("practiceTime is " + practiceTime));
            Map coachFreeMap = DynamicUtil.getCoachFreeList((Long)coachId, (Long)time);
            log.info((Object)("coachFreeMap is " + coachFreeMap));
            List coachFreeIds = this.coachFreeService.getIdsByDynamicCondition(CoachFree.class, coachFreeMap, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            log.info((Object)("coachFreeIds is " + coachFreeIds));
            if (CollectionUtils.isEmpty((Collection)coachFreeIds)) {
                if (Integer.valueOf(coachAppointTime.getTwoRest()).equals(1)) {
                    log.info((Object)"coach is rest");
                    model.addAttribute("code", (Object)-22024);
                    return "/common/failure";
                }
            } else {
                List coachFreeList = this.coachFreeService.getObjectsByIds(coachFreeIds);
                CoachFree coachFree = (CoachFree)coachFreeList.get(0);
                log.info((Object)("coachFree is " + coachFree));
                if (Integer.valueOf(coachFree.getStatus()).equals(1)) {
                    log.info((Object)"coach is rest");
                    model.addAttribute("code", (Object)-22024);
                    return "/common/failure";
                }
            }
            if (Integer.valueOf(advanceTime.getSubject()).equals(0)) {
                log.info((Object)("coachAppointTime.getTwoAdvanceTime() is " + coachAppointTime.getTwoAdvanceTime()));
                BigDecimal getTwoAdvanceTime = new BigDecimal(coachAppointTime.getTwoAdvanceTime()).setScale(2, 4);
                log.info((Object)("getTwoAdvanceTime is " + getTwoAdvanceTime));
                BigDecimal oneHourTime = new BigDecimal(Constant.ONE_HOUR).setScale(2, 4);
                log.info((Object)("oneHourTime is " + oneHourTime));
                double twoAdvanceTime = Calculation.mul((double)getTwoAdvanceTime.doubleValue(), (double)oneHourTime.doubleValue());
                log.info((Object)("twoAdvanceTime is " + twoAdvanceTime));
                Long timeDifference = nowTime - (practiceTime - (long)twoAdvanceTime);
                log.info((Object)("timeDifference is" + timeDifference));
                if (timeDifference > 0L) {
                    log.info((Object)"advanceTime is out");
                    model.addAttribute("code", (Object)-22025);
                    return "/common/failure";
                }
            }
            List constantIds = this.constantService.getConstantIdsByTypeAndTargetIdOrderByCreateBy(Constant.CONSTANT_CITY_ID_TYPE.intValue(), students.getCityId(), Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            log.info((Object)("constantIds is " + constantIds));
            if (CollectionUtils.isNotEmpty((Collection)constantIds)) {
                List constantList = this.constantService.getObjectsByIds(constantIds);
                Constant constant = (Constant)constantList.get(0);
                log.info((Object)("constant is " + constant));
                Integer evaluate = constant.getEvaluate();
                ArrayList<String> typeList = new ArrayList<String>();
                typeList.add("5");
                if (evaluate.equals(Constant.EVALUATE_YES)) {
                    Map map = DynamicUtil.getAppointOrderList(typeList, null, null, null, (Long)coachId, (Long)students.getId(), null, null, null, null, null);
                    log.info((Object)("map is " + map));
                    List evaluateIds = this.appointOrderService.getIdsByDynamicCondition(AppointOrder.class, map, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
                    log.info((Object)("evaluateIds is " + evaluateIds));
                    if (CollectionUtils.isNotEmpty((Collection)evaluateIds)) {
                        log.info((Object)" evaluate order is no null");
                        model.addAttribute("code", (Object)-22012);
                        return "/common/failure";
                    }
                }
            }
            log.info((Object)("nowTime-todayTime ====" + (nowTime - todayTime)));
            if (DataUtils.isNullOrEmpty((Object)students.getSchoolId())) {
                if (nowTime - todayTime < (long)Constant.NO_SCHOOL_ID_APPOINT_START.intValue() || nowTime - todayTime > (long)Constant.NO_SCHOOL_ID_APPOINT_END.intValue()) {
                    log.info((Object)" time  is out");
                    model.addAttribute("code", (Object)-22015);
                    return "/common/failure";
                }
            } else {
                List constantTimeIds = this.constantService.getConstantIdsByTypeAndTargetIdOrderByCreateBy(Constant.CONSTANT_SCHOOL_ID_TYPE.intValue(), students.getSchoolId(), Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
                log.info((Object)("constantTimeIds is " + constantTimeIds));
                if (CollectionUtils.isEmpty((Collection)constantTimeIds)) {
                    if (nowTime - todayTime < (long)Constant.NO_SCHOOL_ID_APPOINT_START.intValue() || nowTime - todayTime > (long)Constant.NO_SCHOOL_ID_APPOINT_END.intValue()) {
                        log.info((Object)" time  is out");
                        model.addAttribute("code", (Object)-22015);
                        return "/common/failure";
                    }
                    if (time - todayTime > (long)(Constant.NO_SCHOOL_ID_APPOINT_DAY * Constant.ONE_DAY)) {
                        log.info((Object)" time  is out");
                        model.addAttribute("code", (Object)-22015);
                        return "/common/failure";
                    }
                } else {
                    List constantList = this.constantService.getObjectsByIds(constantTimeIds);
                    Constant constant = (Constant)constantList.get(0);
                    log.info((Object)("constant is " + constant));
                    if (DataUtils.isNotNullOrEmpty((Object)constant.getTimeEnd()) && DataUtils.isNotNullOrEmpty((Object)constant.getTimeEnd())) {
                        if (nowTime - todayTime < constant.getTimeStart() || nowTime - todayTime > constant.getTimeEnd()) {
                            log.info((Object)" time  is out");
                            model.addAttribute("code", (Object)-22015);
                            return "/common/failure";
                        }
                    } else if (nowTime - todayTime < (long)Constant.NO_SCHOOL_ID_APPOINT_START.intValue() || nowTime - todayTime > (long)Constant.NO_SCHOOL_ID_APPOINT_END.intValue()) {
                        log.info((Object)" time  is out");
                        model.addAttribute("code", (Object)-22015);
                        return "/common/failure";
                    }
                    if (DataUtils.isNotNullOrEmpty((Object)constant.getDay())) {
                        if (time - todayTime > constant.getDay() * (long)Constant.ONE_DAY.intValue()) {
                            log.info((Object)" time  is out");
                            model.addAttribute("code", (Object)-22015);
                            return "/common/failure";
                        }
                    } else if (time - todayTime > (long)(Constant.NO_SCHOOL_ID_APPOINT_DAY * Constant.ONE_DAY)) {
                        log.info((Object)" time  is out");
                        model.addAttribute("code", (Object)-22015);
                        return "/common/failure";
                    }
                }
            }
            log.info((Object)("advanceTime is " + advanceTime));
            if (DataUtils.isNullOrEmpty((Object)advanceTime)) {
                log.info((Object)"advanceTime is null");
                model.addAttribute("code", (Object)-22009);
                return "/common/failure";
            }
            ArrayList<String> typeList = new ArrayList<String>();
            typeList.add("1");
            typeList.add("2");
            typeList.add("3");
            typeList.add("4");
            typeList.add("5");
            typeList.add("7");
            Map userMap = DynamicUtil.getAppointOrderList(typeList, (Long)time, (Long)advanceTime.getStartTime(), (Long)advanceTime.getEndTime(), (Long)coachId, (Long)students.getId(), (Integer)advanceTime.getSubject(), null, null, null, null);
            log.info((Object)("userMap is " + userMap));
            List userOrderIds = this.appointOrderService.getIdsByDynamicCondition(AppointOrder.class, userMap, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            log.info((Object)("userOrderIds is " + userOrderIds));
            if (CollectionUtils.isNotEmpty((Collection)userOrderIds)) {
                log.info((Object)"order is already exist");
                model.addAttribute("code", (Object)-22014);
                return "/common/failure";
            }
            ArrayList<String> soldTypeList = new ArrayList<String>();
            soldTypeList.add("1");
            soldTypeList.add("2");
            soldTypeList.add("3");
            soldTypeList.add("4");
            soldTypeList.add("5");
            soldTypeList.add("7");
            Map coachStudentArrangeMap = DynamicUtil.getAppointOrderList(soldTypeList, (Long)time, null, null, (Long)coachId, (Long)students.getId(), (Integer)advanceTime.getSubject(), null, null, null, null);
            log.info((Object)("coachArrangeMap is " + coachStudentArrangeMap));
            Map studentArrangeMap = DynamicUtil.getAppointOrderList(soldTypeList, null, null, null, null, (Long)students.getId(), (Integer)advanceTime.getSubject(), (Long)todayTime, (Long)(todayTime + (long)Constant.ONE_DAY.intValue()), null, null);
            log.info((Object)("studentArrangeMap is " + studentArrangeMap));
            List coachStudentArrangeIds = this.appointOrderService.getIdsByDynamicCondition(AppointOrder.class, coachStudentArrangeMap, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            log.info((Object)("coachStudentArrangeIds is " + coachStudentArrangeIds));
            List studentArrangeIds = this.appointOrderService.getIdsByDynamicCondition(AppointOrder.class, studentArrangeMap, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            log.info((Object)("studentArrangeIds is " + studentArrangeIds));
            if (Integer.valueOf(advanceTime.getSubject()).equals(0)) {
                if (coachStudentArrangeIds.size() >= coachAppointTime.getTwoAppointFrequency()) {
                    log.info((Object)"appoint is already exist");
                    model.addAttribute("code", (Object)-22029);
                    return "/common/failure";
                }
            } else if (coachStudentArrangeIds.size() >= coachAppointTime.getThreeAppointFrequency()) {
                log.info((Object)"appoint is already exist");
                model.addAttribute("code", (Object)-22029);
                return "/common/failure";
            }
            if (DataUtils.isNotNullOrEmpty((Object)students.getResidualNum())) {
                if ((long)studentArrangeIds.size() >= students.getResidualNum()) {
                    log.info((Object)"appoint is already exist");
                    model.addAttribute("code", (Object)-22030);
                    return "/common/failure";
                }
            } else if (studentArrangeIds.size() >= 1) {
                log.info((Object)"appoint is already exist");
                model.addAttribute("code", (Object)-22030);
                return "/common/failure";
            }
            Map studentAllArrangeMap = DynamicUtil.getAppointOrderList(soldTypeList, (Long)time, null, null, null, (Long)students.getId(), null, null, null, null, null);
            List studentAllArrangeIds = this.appointOrderService.getIdsByDynamicCondition(AppointOrder.class, studentAllArrangeMap, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            List studentAllArrangeList = this.appointOrderService.getObjectsByIds(studentAllArrangeIds);
            for (int i = 0; i < studentAllArrangeList.size(); ++i) {
                AppointOrder appointOrder = (AppointOrder)studentAllArrangeList.get(i);
                if ((advanceTime.getStartTime() <= appointOrder.getTimeStart() || advanceTime.getStartTime() >= appointOrder.getTimeEnd()) && (advanceTime.getEndTime() <= appointOrder.getTimeStart() || advanceTime.getEndTime() >= appointOrder.getTimeEnd())) continue;
                log.info((Object)"time is overlay");
                model.addAttribute("code", (Object)-22031);
                return "/common/failure";
            }
            if (Integer.valueOf(students.getCertification()).equals(Coach.CERTIFICATION_ON) && DataUtils.isNullOrEmpty((Object)students.getClassId())) {
                log.info((Object)"getClassId is null");
                model.addAttribute("code", (Object)-22034);
                return "/common/failure";
            }
            BigDecimal aaa = new BigDecimal(advanceTime.getEndTime() - advanceTime.getStartTime()).setScale(2, 4);
            BigDecimal bbb = new BigDecimal((long)Constant.ONE_HOUR.intValue() * advanceTime.getNum()).setScale(2, 4);
            double studyTime = Calculation.div((double)aaa.doubleValue(), (double)bbb.doubleValue());
            log.info((Object)("studyTime is " + studyTime));
            if (DataUtils.isNotNullOrEmpty((Object)students.getClassId())) {
                double differenceTime;
                double newStudyTime;
                if (Integer.valueOf(advanceTime.getSubject()).equals(0)) {
                    BigDecimal sectionTwoDenominator;
                    BigDecimal sectionTwoNumerator;
                    if (DataUtils.isNotNullOrEmpty((Object)students.getSectionTwoNumerator())) {
                        sectionTwoNumerator = new BigDecimal(students.getSectionTwoNumerator()).setScale(2, 4);
                        log.info((Object)("sectionTwoNumerator is " + sectionTwoNumerator));
                    } else {
                        sectionTwoNumerator = new BigDecimal(0).setScale(2, 4);
                        log.info((Object)("sectionTwoNumerator is " + sectionTwoNumerator));
                    }
                    if (DataUtils.isNotNullOrEmpty((Object)students.getSectionTwoDenominator())) {
                        sectionTwoDenominator = new BigDecimal(students.getSectionTwoDenominator()).setScale(2, 4);
                        log.info((Object)("sectionTwoDenominator is " + sectionTwoDenominator));
                    } else {
                        sectionTwoDenominator = new BigDecimal(0).setScale(2, 4);
                        log.info((Object)("sectionTwoDenominator is " + sectionTwoDenominator));
                    }
                    newStudyTime = Calculation.add((double)studyTime, (double)sectionTwoNumerator.doubleValue());
                    differenceTime = Calculation.sub((double)newStudyTime, (double)sectionTwoDenominator.doubleValue());
                    if (differenceTime > 0.0) {
                        log.info((Object)"studyTime is already exist");
                        model.addAttribute("code", (Object)-22023);
                        return "/common/failure";
                    }
                    students.setSectionTwoNumerator(Double.toString(newStudyTime));
                }
                if (Integer.valueOf(advanceTime.getSubject()).equals(1)) {
                    BigDecimal sectionThreeDenominator;
                    BigDecimal sectionThreeNumerator;
                    log.info((Object)("getSectionThreeNumerator is " + students));
                    if (DataUtils.isNotNullOrEmpty((Object)students.getSectionThreeNumerator())) {
                        sectionThreeNumerator = new BigDecimal(students.getSectionThreeNumerator()).setScale(2, 4);
                        log.info((Object)("sectionThreeNumerator is " + sectionThreeNumerator));
                    } else {
                        sectionThreeNumerator = new BigDecimal(0).setScale(2, 4);
                        log.info((Object)("sectionThreeNumerator is " + sectionThreeNumerator));
                    }
                    if (DataUtils.isNotNullOrEmpty((Object)students.getSectionThreeDenominator())) {
                        sectionThreeDenominator = new BigDecimal(students.getSectionThreeDenominator()).setScale(2, 4);
                        log.info((Object)("sectionThreeDenominator is " + sectionThreeDenominator));
                    } else {
                        sectionThreeDenominator = new BigDecimal(0).setScale(2, 4);
                        log.info((Object)("sectionThreeDenominator is " + sectionThreeDenominator));
                    }
                    newStudyTime = Calculation.add((double)studyTime, (double)sectionThreeNumerator.doubleValue());
                    differenceTime = Calculation.sub((double)newStudyTime, (double)sectionThreeDenominator.doubleValue());
                    if (differenceTime > 0.0) {
                        log.info((Object)"studyTime is already exist");
                        model.addAttribute("code", (Object)-22023);
                        return "/common/failure";
                    }
                    students.setSectionThreeNumerator(Double.toString(newStudyTime));
                }
            }
            if (DataUtils.isNullOrEmpty((Object)(coach = this.coachService.getObjectById(coachId)))) {
                log.info((Object)"coach is null");
                model.addAttribute("code", (Object)-22001);
                return "/common/failure";
            }
            log.info((Object)("coach is " + coach));
            AppointOrder appointOrder = new AppointOrder();
            appointOrder.setType(AppointOrder.STUDENT_PROCESSING_COACH_UNCOMFIRMED.intValue());
            appointOrder.setTime(time);
            appointOrder.setCoach(coachId);
            if (DataUtils.isNullOrEmpty((Object)coach.getName())) {
                appointOrder.setCoachName(coach.getNick());
            } else {
                appointOrder.setCoachName(coach.getName());
            }
            appointOrder.setCoachMobile(coach.getMobile());
            appointOrder.setStudent(students.getId());
            appointOrder.setStudentName(students.getName());
            appointOrder.setStudentMobile(students.getMobile());
            appointOrder.setTimeStart(advanceTime.getStartTime());
            appointOrder.setTimeEnd(advanceTime.getEndTime());
            appointOrder.setSubject(advanceTime.getSubject());
            appointOrder.setAdvanceId(arrangeId);
            appointOrder.setStudyTime(Double.toString(studyTime));
            appointOrder.setCityId(students.getCityId());
            appointOrder.setSchoolId(students.getSchoolId());
            log.info((Object)("appointOrder is " + appointOrder));
            if (!this.getOrderCount(time, advanceTime, coachId, typeList, appointOrder, model)) {
                log.info((Object)"params error");
                return "/common/failure";
            }
            this.studentsService.update(students);
            String message = "\u60a8\u7684\u5b66\u5458\u5df2\u4e8e" + this.dateTime() + "\u53d1\u8d77\u9884\u7ea6\u7ec3\u8f66\u8ba2\u5355\u3002\u8bf7\u53ca\u65f6\u5904\u7406\u3002";
            this.otherAppUser(response, coach.getPlatform(), coach.getDeviceToken(), null, message);
            log.info((Object)("push param platform , deviceToken is " + coach.getPlatform() + " ," + coach.getDeviceToken()));
            model.addAttribute("code", (Object)0);
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage(), t);
            model.addAttribute("code", (Object)-100000);
        }
        return "/common/success";
    }

    private synchronized boolean getOrderCount(Long time, AdvanceTime advanceTime, Long coachId, List<String> typeList, AppointOrder appointOrder, ModelMap model) throws Exception {
        Integer orderIdsSize = 0;
        Long startTime = System.currentTimeMillis();
        try {
            Map map = DynamicUtil.getAppointOrderList(typeList, (Long)time, (Long)advanceTime.getStartTime(), (Long)advanceTime.getEndTime(), (Long)coachId, null, (Integer)advanceTime.getSubject(), null, null, null, null);
            log.info((Object)("map is " + map));
            List orderIds = this.appointOrderService.getIdsByDynamicCondition(AppointOrder.class, map, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            log.info((Object)("orderIds is " + orderIds));
            orderIdsSize = orderIds.size();
            if ((long)orderIdsSize.intValue() >= advanceTime.getNum()) {
                log.info((Object)"num is enough");
                model.addAttribute("code", (Object)-22013);
                return false;
            }
            this.appointOrderService.insert(appointOrder);
            log.info((Object)("getOrderCount consumption time = " + (System.currentTimeMillis() - startTime)));
            return true;
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage(), t);
            model.addAttribute("code", (Object)-10000);
            return false;
        }
    }

    @RequestMapping(value={"/a/u/car/order/list"}, method={RequestMethod.GET})
    public String getCarOrderList(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer type, Integer page, Integer size) throws Exception {
        int start;
        log.info((Object)("type is " + type));
        if (DataUtils.isNullOrEmpty((Object)type)) {
            log.info((Object)"type is null");
            model.addAttribute("code", (Object)-22016);
            return "/common/failure";
        }
        if (page == null) {
            page = 1;
        }
        if (size == null || size < 0) {
            size = 10;
        }
        if ((start = (page - 1) * size) < 0) {
            start = 0;
        }
        try {
            ArrayList<String> typeList = new ArrayList<String>();
            switch (type) {
                case 1: {
                    typeList.add("1");
                    typeList.add("2");
                    typeList.add("3");
                    typeList.add("4");
                    break;
                }
                case 2: {
                    typeList.add("2");
                    typeList.add("3");
                    typeList.add("4");
                    break;
                }
                case 3: {
                    typeList.add("5");
                    typeList.add("7");
                    break;
                }
                case 4: {
                    typeList.add("6");
                    break;
                }
            }
            Students students = (Students)request.getAttribute("user");
            log.info((Object)("students is " + students));
            Map map = DynamicUtil.getAppointOrderList(typeList, null, null, null, null, (Long)students.getId(), null, null, null, null, null);
            log.info((Object)("map is " + map));
            List orderMaxIds = this.appointOrderService.getIdsByDynamicCondition(AppointOrder.class, map, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            log.info((Object)("orderMaxIds is " + orderMaxIds));
            Integer total = null;
            List<AppointOrder> appointOrderList = new ArrayList();
            Long nowTime = System.currentTimeMillis();
            if (type.equals(3) || type.equals(4)) {
                List orderIds = this.appointOrderService.getIdsByDynamicCondition(AppointOrder.class, map, Integer.valueOf(start), size);
                log.info((Object)("orderIds is " + orderIds));
                total = orderMaxIds.size();
                if (CollectionUtils.isNotEmpty((Collection)orderIds)) {
                    appointOrderList = this.appointOrderService.getObjectsByIds(orderIds);
                }
            } else {
                AppointOrder appointOrder;
                int i;
                List appointOrderAllList = this.appointOrderService.getObjectsByIds(orderMaxIds);
                ArrayList<AppointOrder> appointOrderNewList = new ArrayList<AppointOrder>();
                for (i = 0; i < appointOrderAllList.size(); ++i) {
                    appointOrder = (AppointOrder)appointOrderAllList.get(i);
                    if (type.equals(1) && appointOrder.getTime() + appointOrder.getTimeStart() > nowTime) {
                        appointOrderNewList.add(appointOrder);
                    }
                    if (!type.equals(2) || appointOrder.getTime() + appointOrder.getTimeStart() >= nowTime) continue;
                    appointOrderNewList.add(appointOrder);
                }
                total = appointOrderNewList.size();
                for (i = 0; i < appointOrderNewList.size(); ++i) {
                    appointOrder = (AppointOrder)appointOrderNewList.get(i);
                    if (i < start && i >= start + size) continue;
                    appointOrderList.add(appointOrder);
                }
            }
            if ((page - 1) * size < total) {
                model.addAttribute("appointOrderList", appointOrderList);
            } else {
                model.addAttribute("appointOrderList", (Object)"");
            }
            model.addAttribute("code", (Object)0);
            model.addAttribute("page", (Object)page);
            model.addAttribute("size", (Object)size);
            model.addAttribute("total", (Object)total);
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            model.addAttribute("code", (Object)-100000);
        }
        return "/yi-nucleus-service/practiceCarController/json/carOrderList";
    }

    @RequestMapping(value={"/a/u/car/order/cancel/{id}"}, method={RequestMethod.PUT})
    public String carOrderCancel(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id, Integer type, String cancel) throws Exception {
        log.info((Object)("type is " + type + " id is " + id));
        if (DataUtils.isNullOrEmpty((Object)type)) {
            log.info((Object)"type is null");
            model.addAttribute("code", (Object)-22017);
            return "/common/failure";
        }
        Students students = (Students)request.getAttribute("user");
        try {
            AppointOrder appointOrder = this.appointOrderService.getObjectById(id);
            Long nowTime = System.currentTimeMillis();
            Coach coach = this.coachService.getObjectById(appointOrder.getCoach());
            if (nowTime >= appointOrder.getTimeStart() + appointOrder.getTime()) {
                log.info((Object)"type is null");
                model.addAttribute("code", (Object)-22032);
                return "/common/failure";
            }
            if (DataUtils.isNullOrEmpty((Object)appointOrder)) {
                log.info((Object)"appointOrder is null");
                model.addAttribute("code", (Object)-22034);
                return "/common/failure";
            }
            log.info((Object)("appointOrder is " + appointOrder));
            Integer orderType = appointOrder.getType();
            log.info((Object)("orderType is " + orderType + "  type  is " + type));
            if (orderType.equals(AppointOrder.STUDENT_PENDING_COACH_CANCEL)) {
                if (type.equals(1)) {
                    appointOrder.setType(AppointOrder.ORDER_SOLD.intValue());
                    appointOrder.setCancelTime(Long.valueOf(System.currentTimeMillis()));
                    if (Integer.valueOf(students.getCertification()).equals(Coach.CERTIFICATION_ON)) {
                        BigDecimal time;
                        if (Integer.valueOf(appointOrder.getSubject()).equals(0)) {
                            time = new BigDecimal(Double.valueOf(students.getSectionTwoNumerator()) - Double.valueOf(appointOrder.getStudyTime())).setScale(2, 4);
                            students.setSectionTwoNumerator(time.toString());
                        }
                        if (Integer.valueOf(appointOrder.getSubject()).equals(1)) {
                            time = new BigDecimal(Double.valueOf(students.getSectionThreeNumerator()) - Double.valueOf(appointOrder.getStudyTime())).setScale(2, 4);
                            students.setSectionThreeNumerator(time.toString());
                        }
                    }
                } else {
                    appointOrder.setType(AppointOrder.STUDENT_PROCESSING_COACH_COMFIRMED.intValue());
                    appointOrder.setCancel(null);
                    String message = "\u60a8\u7684\u5b66\u5458\u5728" + this.dateTime() + "\u62d2\u7edd\u53d6\u6d88\u7ec3\u8f66\u8ba2\u5355\u3002\u8bf7\u53ca\u65f6\u5904\u7406\u3002";
                    this.otherAppUser(response, coach.getPlatform(), coach.getDeviceToken(), null, message);
                }
            } else if (orderType.equals(AppointOrder.STUDENT_PROCESSING_COACH_UNCOMFIRMED)) {
                if (type.equals(1)) {
                    appointOrder.setType(AppointOrder.STUDENT_PROCESSING_COACH_COMFIRMED.intValue());
                } else if (type.equals(2)) {
                    appointOrder.setType(AppointOrder.STUDENT_PENDING_COACH_CANCEL.intValue());
                    if (DataUtils.isNullOrEmpty((Object)cancel)) {
                        log.info((Object)"appointOrder is null");
                        model.addAttribute("code", (Object)-22019);
                        return "/common/failure";
                    }
                    appointOrder.setCancel(cancel);
                } else {
                    if (Integer.valueOf(students.getCertification()).equals(Coach.CERTIFICATION_ON)) {
                        BigDecimal time;
                        if (Integer.valueOf(appointOrder.getSubject()).equals(0)) {
                            time = new BigDecimal(Double.valueOf(students.getSectionTwoNumerator()) - Double.valueOf(appointOrder.getStudyTime())).setScale(2, 4);
                            students.setSectionTwoNumerator(time.toString());
                        }
                        if (Integer.valueOf(appointOrder.getSubject()).equals(1)) {
                            time = new BigDecimal(Double.valueOf(students.getSectionThreeNumerator()) - Double.valueOf(appointOrder.getStudyTime())).setScale(2, 4);
                            students.setSectionThreeNumerator(time.toString());
                        }
                    }
                    appointOrder.setType(AppointOrder.ORDER_SOLD.intValue());
                    appointOrder.setCancelTime(Long.valueOf(System.currentTimeMillis()));
                }
            } else if (orderType.equals(AppointOrder.STUDENT_PROCESSING_COACH_COMFIRMED)) {
                appointOrder.setType(AppointOrder.STUDENT_PROCESSING_COACH_UNCOMFIRMED_ORDER_CANCEL.intValue());
                if (DataUtils.isNullOrEmpty((Object)cancel)) {
                    log.info((Object)"appointOrder is null");
                    model.addAttribute("code", (Object)-22019);
                    return "/common/failure";
                }
                appointOrder.setCancel(cancel);
            } else if (orderType.equals(AppointOrder.STUDENT_PROCESSING_COACH_UNCOMFIRMED_ORDER_CANCEL)) {
                if (type.equals(1)) {
                    if (Integer.valueOf(students.getCertification()).equals(Coach.CERTIFICATION_ON)) {
                        BigDecimal time;
                        if (Integer.valueOf(appointOrder.getSubject()).equals(0)) {
                            time = new BigDecimal(Double.valueOf(students.getSectionTwoNumerator()) - Double.valueOf(appointOrder.getStudyTime())).setScale(2, 4);
                            students.setSectionTwoNumerator(time.toString());
                        }
                        if (Integer.valueOf(appointOrder.getSubject()).equals(1)) {
                            time = new BigDecimal(Double.valueOf(students.getSectionThreeNumerator()) - Double.valueOf(appointOrder.getStudyTime())).setScale(2, 4);
                            students.setSectionThreeNumerator(time.toString());
                        }
                    }
                    appointOrder.setType(AppointOrder.ORDER_SOLD.intValue());
                    appointOrder.setCancelTime(Long.valueOf(System.currentTimeMillis()));
                } else {
                    appointOrder.setType(AppointOrder.STUDENT_PROCESSING_COACH_COMFIRMED.intValue());
                    appointOrder.setCancel(null);
                }
            } else {
                log.info((Object)"order is over");
                model.addAttribute("code", (Object)-22018);
                return "/common/failure";
            }
            this.appointOrderService.update(appointOrder);
            this.studentsService.update(students);
            model.addAttribute("code", (Object)0);
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            model.addAttribute("code", (Object)-100000);
        }
        return "/common/success";
    }

    @RequestMapping(value={"/a/u/car/order/evaluate/{id}"}, method={RequestMethod.PUT})
    public String carOrderEvaluate(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id, String score, String content) throws Exception {
        log.info((Object)("content is " + content + " id is " + id + " score is " + score));
        if (DataUtils.isNullOrEmpty((Object)content)) {
            log.info((Object)"content is null");
            model.addAttribute("code", (Object)-22035);
            return "/common/failure";
        }
        if (DataUtils.isNullOrEmpty((Object)score)) {
            log.info((Object)"score is null");
            model.addAttribute("code", (Object)-22020);
            return "/common/failure";
        }
        Students students = (Students)request.getAttribute("user");
        try {
            AppointOrder appointOrder = this.appointOrderService.getObjectById(id);
            if (DataUtils.isNullOrEmpty((Object)appointOrder)) {
                log.info((Object)"appointOrder is null");
                model.addAttribute("code", (Object)-22026);
                return "/common/failure";
            }
            log.info((Object)("appointOrder is " + appointOrder));
            Long studentId = students.getId();
            if (!studentId.equals(appointOrder.getStudent())) {
                log.info((Object)"studentId is error");
                model.addAttribute("code", (Object)-22022);
                return "/common/failure";
            }
            Integer type = appointOrder.getType();
            log.info((Object)("type is " + type));
            if (!type.equals(AppointOrder.ORDER_COMPLETED_EVALUATED_NO)) {
                log.info((Object)"type is error");
                model.addAttribute("code", (Object)-22021);
                return "/common/failure";
            }
            appointOrder.setComment(content);
            appointOrder.setScore(score);
            appointOrder.setType(AppointOrder.ORDER_COMPLETED_EVALUATED_YES.intValue());
            this.appointOrderService.update(appointOrder);
            model.addAttribute("code", (Object)0);
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            model.addAttribute("code", (Object)-100000);
        }
        return "/common/success";
    }

    @RequestMapping(value={"/a/u/coach/evaluate/list/{id}"}, method={RequestMethod.GET})
    public String getCarOrderEvaluateList(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id, Integer page, Integer size) throws Exception {
        int start;
        log.info((Object)(" id is " + id));
        if (page == null) {
            page = 1;
        }
        if (size == null || size < 0) {
            size = 10;
        }
        if ((start = (page - 1) * size) < 0) {
            start = 0;
        }
        try {
            ArrayList<String> typeList = new ArrayList<String>();
            typeList.add("7");
            Map map = DynamicUtil.getAppointOrderListByUpdate(typeList, (Long)id);
            log.info((Object)("map is " + map));
            List orderMaxIds = this.appointOrderService.getIdsByDynamicCondition(AppointOrder.class, map, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            List orderIds = this.appointOrderService.getIdsByDynamicCondition(AppointOrder.class, map, Integer.valueOf(start), size);
            log.info((Object)("orderIds is " + orderIds));
            Integer total = orderMaxIds.size();
            List appointOrderList = new ArrayList();
            if (CollectionUtils.isNotEmpty((Collection)orderIds)) {
                appointOrderList = this.appointOrderService.getObjectsByIds(orderIds);
            }
            model.addAttribute("code", (Object)0);
            model.addAttribute("page", (Object)page);
            model.addAttribute("size", (Object)size);
            model.addAttribute("total", (Object)total);
            model.addAttribute("appointOrderList", appointOrderList);
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            model.addAttribute("code", (Object)-100000);
        }
        return "/yi-nucleus-service/practiceCarController/json/CarOrderEvaluateList";
    }

    public String dateTime() {
        Long time = System.currentTimeMillis();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String date = format.format(time);
        return date;
    }

    private boolean otherAppUser(HttpServletResponse response, String platForm, String deviceToken, String token, String message) throws IOException {
        try {
            Long startAt = null;
            Long endAt = System.currentTimeMillis() + 518400000L;
            log.info((Object)(" startAt = " + startAt));
            String result = "";
            log.info((Object)("message : " + message));
            if ("android".equals(platForm)) {
                log.info((Object)" android ");
                result = this.coachAndroidPushServiceImpl.pushMessaeForList("android", "notification", "unicast", deviceToken.toString(), "\u5b66\u5458\u7ea6\u5355\u901a\u77e5", "\u5b66\u5458\u7ea6\u5355\u901a\u77e5", message, "go_app", "", "", "", "", startAt, "", "true", endAt, "\u6613\u6559\u7ec3APP\u901a\u77e5");
                log.info((Object)(" anResult = " + result));
            } else if ("ios".equals(platForm)) {
                log.info((Object)" ios ");
                result = this.coachIosPushServiceImpl.pushMessaeForList("ios", "notification", "unicast", deviceToken.toString(), "\u5b66\u5458\u7ea6\u5355\u901a\u77e5", "\u5b66\u5458\u7ea6\u5355\u901a\u77e5", message, "go_app", "", "", "", "", startAt, "", "true", endAt, "\u6613\u6559\u7ec3APP\u901a\u77e5");
                log.info((Object)(" iosResult = " + result));
            } else {
                log.info((Object)("user platform : " + platForm));
            }
            if (DataUtils.isNotNullOrEmpty((Object)result)) {
                JSONObject jsonObject = JSONObject.fromObject((Object)result);
                if ("SUCCESS".equals((String)jsonObject.get("ret"))) {
                    log.info((Object)" push success ");
                } else {
                    log.info((Object)("fail" + jsonObject.get("data")));
                    JSONObject data = JSONObject.fromObject((Object)jsonObject.get("data").toString());
                    log.info((Object)(" data = " + data));
                    log.info((Object)(" errorCode = " + data.get("error_code")));
                }
            } else {
                log.info((Object)"user no device before");
            }
        }
        catch (Throwable t) {
            log.error((Object)"user logout error  ");
            t.printStackTrace();
        }
        return false;
    }
}

