/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.controller;

import com.gemantic.common.util.StringUtil;
import com.ptteng.util.DynamicUtil;
import com.ptteng.util.VersionIsForceUpdateCode;
import com.ptteng.yi.pub.model.Version;
import com.ptteng.yi.pub.service.VersionService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class VersionController {
    private static final Log log = LogFactory.getLog(VersionController.class);
    @Autowired
    private VersionService versionService;
    private static final String OS = "os";
    private static final String VERSIONCODE = "versionCode";
    private static final String VERSIONNUMBER = "versionNumber";
    private static final String TYPE = "type";

    @RequestMapping(value={"/a/version"}, method={RequestMethod.GET})
    public String version(HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        log.info((Object)"version update control begin ==================");
        String os = request.getParameter(OS);
        String versionCode = request.getParameter(VERSIONCODE);
        String versionNumber = request.getParameter(VERSIONNUMBER);
        String type = request.getParameter(TYPE);
        if (StringUtil.isEmpty((String)versionCode)) {
            versionCode = request.getHeader(VERSIONCODE);
        }
        if (StringUtil.isEmpty((String)versionNumber)) {
            versionNumber = request.getHeader(VERSIONNUMBER);
        }
        if (StringUtil.isEmpty((String)os)) {
            os = request.getHeader(OS);
        }
        if (StringUtil.isEmpty((String)type)) {
            os = request.getHeader(TYPE);
        }
        log.info((Object)("os = " + os + "     versionCode = " + versionCode + "     versionNumber" + versionNumber + "       type = " + type));
        try {
            Integer needUpdate = 1;
            if (StringUtil.isEmpty((String)os)) {
                log.info((Object)"arg os is empty and need force updating");
                model.addAttribute("code", (Object)0);
                model.addAttribute("isForceUpdate", (Object)VersionIsForceUpdateCode.needForceUpdate.getValue());
                model.addAttribute("needUpdate", (Object)needUpdate);
                return "/yi-pub-service/version/json/version";
            }
            if (StringUtil.isEmpty((String)versionCode)) {
                log.info((Object)"arg versionCode is empty need force updating");
                model.addAttribute("code", (Object)0);
                model.addAttribute("isForceUpdate", (Object)VersionIsForceUpdateCode.needForceUpdate.getValue());
                model.addAttribute("needUpdate", (Object)needUpdate);
                return "/yi-pub-service/version/json/version";
            }
            if (StringUtil.isEmpty((String)versionNumber)) {
                log.info((Object)"arg versionNumber is empty need force updating");
                model.addAttribute("code", (Object)0);
                model.addAttribute("isForceUpdate", (Object)VersionIsForceUpdateCode.needForceUpdate.getValue());
                model.addAttribute("needUpdate", (Object)needUpdate);
                return "/yi-pub-service/version/json/version";
            }
            if (StringUtil.isEmpty((String)type)) {
                log.info((Object)"arg version is empty need force updating");
                model.addAttribute("code", (Object)0);
                model.addAttribute("isForceUpdate", (Object)VersionIsForceUpdateCode.needForceUpdate.getValue());
                model.addAttribute("needUpdate", (Object)needUpdate);
                return "/yi-pub-service/version/json/version";
            }
            Map params = DynamicUtil.getPlQuery((Integer)Integer.valueOf(os), (Integer)Integer.valueOf(type));
            log.info((Object)("patient android version params is :" + params));
            List paramsList = this.versionService.getIdsByDynamicCondition(Version.class, params, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            log.info((Object)("patient android version params get dynamic ids is :" + paramsList));
            List versionListByOsAndType = this.versionService.getObjectsByIds(paramsList);
            Collections.sort(versionListByOsAndType);
            ArrayList<Version> versionList = new ArrayList<Version>();
            model.addAttribute("isForceUpdate", (Object)VersionIsForceUpdateCode.noNeedForceUpdate.getValue());
            for (Version systemVersion : versionListByOsAndType) {
                switch (systemVersion.compareCode(Integer.valueOf(systemVersion.getVersion_number()), Integer.valueOf(versionNumber))) {
                    case 1: {
                        versionList.add(systemVersion);
                        if (systemVersion.getIs_force_update() == 1) {
                            log.info((Object)"need force updating");
                            model.addAttribute("isForceUpdate", (Object)VersionIsForceUpdateCode.needForceUpdate.getValue());
                            break;
                        }
                        log.info((Object)("version : " + systemVersion.getVersion_code() + " is a new version but not need tu force updating"));
                        break;
                    }
                }
            }
            Version latestVersion = null;
            log.info((Object)("new version list is" + versionList));
            if (CollectionUtils.isEmpty(versionList)) {
                log.info((Object)"version is new and don't need force updating");
                needUpdate = 0;
                model.addAttribute("isForceUpdate", (Object)VersionIsForceUpdateCode.latestUpdateVersion.getValue());
            } else {
                log.info((Object)"version is not new but don't need force updating");
                latestVersion = (Version)versionList.get(0);
            }
            log.info((Object)("latest version is" + latestVersion));
            log.info((Object)"get latestVersionInfo finish ==========");
            model.addAttribute("code", (Object)0);
            model.addAttribute("needUpdate", (Object)needUpdate);
            model.addAttribute("version", (Object)latestVersion);
        }
        catch (Exception e) {
            log.error((Object)"VersionManager error...", (Throwable)e);
            log.error((Object)"try cat a exception!");
            model.addAttribute("code", (Object)-100000);
        }
        log.info((Object)"version update control end ==================");
        return "/yi-pub-service/version/json/version";
    }
}

