/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.controller;

import com.ptteng.model.DisplayMessage;
import com.ptteng.util.DynamicUtil;
import com.ptteng.util.ParamsUtil;
import com.ptteng.yi.nucleus.model.Students;
import com.ptteng.yi.pub.model.Message;
import com.ptteng.yi.pub.model.UserMessage;
import com.ptteng.yi.pub.service.MessageService;
import com.ptteng.yi.pub.service.UserMessageService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class UserMessageController {
    private static final Log log = LogFactory.getLog(UserMessageController.class);
    @Autowired
    UserMessageService userMessageService;
    @Autowired
    MessageService messageService;

    @RequestMapping(value={"/a/u/message/list "}, method={RequestMethod.GET})
    public String getMessageList(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer messageType, Integer targetReceive, Integer page, Integer size) throws Exception {
        int paramsCode;
        int start;
        log.info((Object)("params === messageType=" + messageType + "targetReceive" + targetReceive + "page" + page + "size" + size));
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        if ((start = (page - 1) * size) < 0) {
            start = 0;
        }
        if ((paramsCode = ParamsUtil.checkParamsOfGetUserMessageList((Integer)messageType, (Integer)targetReceive, (Integer)page, (Integer)size)) != 0) {
            model.addAttribute("code", (Object)paramsCode);
            return "/common/failure";
        }
        try {
            List userMessages = new ArrayList();
            ArrayList arrayList = new ArrayList();
            ArrayList<Long> messageIds = new ArrayList<Long>();
            List messages = new ArrayList();
            ArrayList<DisplayMessage> displayMessageList = new ArrayList<DisplayMessage>();
            int numberOfUnread = 0;
            log.info((Object)"==========\u83b7\u53d6\u7528\u6237ID==========");
            Students student = (Students)request.getAttribute("user");
            Long uid = student.getId();
            log.info((Object)("\u83b7\u53d6\u7684studentId =" + uid));
            Map params = DynamicUtil.getUserMessageList((Integer)messageType, (Integer)targetReceive, (Long)uid, (Integer)0);
            List ids = this.userMessageService.getIdsByDynamicCondition(UserMessage.class, params, Integer.valueOf(start), size);
            Integer total = this.userMessageService.getIdsByDynamicCondition(UserMessage.class, params, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE)).size();
            log.info((Object)("the number of all userMessage is" + total));
            userMessages = this.userMessageService.getObjectsByIds(ids);
            for (UserMessage userMessage : userMessages) {
                Long message_id = userMessage.getMessage_id();
                messageIds.add(message_id);
            }
            messages = this.messageService.getObjectsByIds(messageIds);
            log.info((Object)("messageIds is" + messageIds));
            int i = 0;
            if (userMessages != null) {
                for (UserMessage userMessage : userMessages) {
                    DisplayMessage displayMessage = new DisplayMessage();
                    displayMessage.setUserMessageId(userMessage.getId());
                    displayMessage.setMessageId(userMessage.getMessage_id());
                    displayMessage.setPushAt(((Message)messages.get(i)).getPush_at());
                    displayMessage.setContent(((Message)messages.get(i)).getContent());
                    displayMessage.setStatus(Integer.valueOf(((Message)messages.get(i)).getStatus()));
                    displayMessage.setProgress(Integer.valueOf(userMessage.getProgress()));
                    displayMessage.setExamSubject(Integer.valueOf(((Message)messages.get(i)).getExamSubject()));
                    displayMessage.setExamTime(((Message)messages.get(i)).getExamTime());
                    if (userMessage.getStatus() == UserMessage.UNREADED_MESSAGE.intValue()) {
                        ++numberOfUnread;
                    }
                    displayMessageList.add(displayMessage);
                    ++i;
                }
            }
            log.info((Object)("the userMessages is" + arrayList));
            model.addAttribute("total", (Object)total);
            model.addAttribute("numberOfUnread", (Object)numberOfUnread);
            model.addAttribute("list", displayMessageList);
            model.addAttribute("code", (Object)0);
        }
        catch (Exception e) {
            model.addAttribute("code", (Object)-100000);
            log.error((Object)("trzy catch a exception !,see==" + e));
        }
        return "/yi-pub-service/userMessage/json/userMessageList";
    }

    @RequestMapping(value={"/a/u/message "}, method={RequestMethod.PUT})
    public String updateUserMessagesStatus(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer messageType, Integer targetReceive) throws Exception {
        log.info((Object)("params === messageType=" + messageType + "targetReceive" + targetReceive));
        int paramsCode = ParamsUtil.checkParamsOfUpdateUserMessagesStatus((Integer)messageType, (Integer)targetReceive);
        if (paramsCode != 0) {
            model.addAttribute("code", (Object)paramsCode);
            return "/common/failure";
        }
        try {
            List unReadedUserMessages = new ArrayList();
            log.info((Object)"==========\u83b7\u53d6\u7528\u6237ID==========");
            Students student = (Students)request.getAttribute("user");
            Long uid = student.getId();
            log.info((Object)("\u83b7\u53d6\u7684studentId =" + uid));
            Map params = DynamicUtil.getUserMessageList((Integer)messageType, (Integer)targetReceive, (Long)uid, (Integer)2);
            List ids = this.userMessageService.getIdsByDynamicCondition(UserMessage.class, params, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            log.info((Object)("all unReadUserMessages is" + ids));
            if (ids != null) {
                unReadedUserMessages = this.userMessageService.getObjectsByIds(ids);
                for (UserMessage userMessage : unReadedUserMessages) {
                    userMessage.setStatus(UserMessage.READED_MESSAGE.intValue());
                }
                this.userMessageService.updateList(unReadedUserMessages);
            }
            model.addAttribute("code", (Object)0);
            log.info((Object)"update userMessages status success!");
        }
        catch (Exception e) {
            e.printStackTrace();
            model.addAttribute("code", (Object)-100000);
        }
        return "/common/success";
    }

    @RequestMapping(value={"/a/u/message/unread "}, method={RequestMethod.GET})
    public String getNumberOfUnreadMessage(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer messageType, Integer targetReceive) throws Exception {
        log.info((Object)("params === messageType=" + messageType + "targetReceive" + targetReceive));
        int paramsCode = ParamsUtil.checkParamsOfUpdateUserMessagesStatus((Integer)messageType, (Integer)targetReceive);
        if (paramsCode != 0) {
            model.addAttribute("code", (Object)paramsCode);
            return "/common/failure";
        }
        int numberOfUnread = 0;
        try {
            ArrayList unReadedUserMessages = new ArrayList();
            Students student = (Students)request.getAttribute("user");
            Long uid = student.getId();
            log.info((Object)("\u83b7\u53d6\u7684studentId =" + uid));
            Map params = DynamicUtil.getUserMessageList((Integer)messageType, (Integer)targetReceive, (Long)uid, (Integer)UserMessage.UNREADED_MESSAGE);
            List ids = this.userMessageService.getIdsByDynamicCondition(UserMessage.class, params, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            log.info((Object)("all unReadUserMessages is" + ids));
            numberOfUnread = ids.size();
            log.info((Object)("numberOfUnread=" + numberOfUnread));
            model.addAttribute("numberOfUnread", (Object)numberOfUnread);
            model.addAttribute("code", (Object)0);
            log.info((Object)"update userMessages status success!");
        }
        catch (Exception e) {
            e.printStackTrace();
            model.addAttribute("code", (Object)-100000);
        }
        return "/yi-pub-service/userMessage/json/userMessageUnreadNum";
    }
}

