/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.PasswordUtils;
import com.gemantic.common.util.StringUtil;
import com.ptteng.common.util.notice.NoticeUtil;
import com.ptteng.util.DynamicUtil;
import com.ptteng.util.ImChatUtil;
import com.ptteng.util.UserNameUtil;
import com.ptteng.yi.nucleus.model.Probation;
import com.ptteng.yi.nucleus.model.Students;
import com.ptteng.yi.nucleus.service.ProbationService;
import com.ptteng.yi.nucleus.service.StudentsService;
import com.ptteng.yi.pub.model.ImAccount;
import com.ptteng.yi.pub.model.Sms;
import com.ptteng.yi.pub.service.CitiesService;
import com.ptteng.yi.pub.service.ImAccountService;
import com.ptteng.yi.pub.service.SmsService;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import com.qding.common.util.http.cookie.IdentityUtil;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class UserController {
    private static final Log log = LogFactory.getLog(UserController.class);
    @Autowired
    private StudentsService studentsService;
    @Autowired
    private SmsService smsService;
    @Autowired
    private CitiesService citiesService;
    @Autowired
    ImAccountService imAccountService;
    @Resource(name="accountConfig")
    private Map<String, String> accountConfig;
    @Autowired
    private CookieUtil cookieUtil;
    @Autowired
    private ProbationService probationService;
    @Autowired
    ImChatUtil imChatUtil;
    @Autowired
    private NoticeUtil stuAndroidPushServiceImpl;
    @Autowired
    private NoticeUtil stuIosPushServiceImpl;

    @RequestMapping(value={"/a/register"}, method={RequestMethod.POST})
    public String register(HttpServletRequest request, HttpServletResponse response, ModelMap model, String mobile, String verify, String pwd, Long cityId) throws Exception {
        block21: {
            log.info((Object)("POST request url: /a/register, get parameter mobile: " + mobile + ", verify: " + verify + ", pwd: " + pwd + ", cityId: " + cityId));
            if (StringUtils.isEmpty((CharSequence)mobile)) {
                log.info((Object)"parameter mobile is null or empty");
                model.addAttribute("code", (Object)-5022);
                return "/common/failure";
            }
            if (mobile.length() != 11) {
                log.info((Object)"parameter mobile is illegal");
                model.addAttribute("code", (Object)-5023);
                return "/common/failure";
            }
            if (StringUtils.isEmpty((CharSequence)pwd)) {
                log.info((Object)"parameter pwd is null or empty");
                model.addAttribute("code", (Object)-5008);
                return "/common/failure";
            }
            if (pwd.length() < 6 || pwd.length() > 16) {
                log.info((Object)"parameter pwd length is illegal");
                model.addAttribute("code", (Object)-5026);
                return "/common/failure";
            }
            if (DataUtils.isNullOrEmpty((Object)cityId)) {
                log.info((Object)"parameter cityId is null or empty");
                model.addAttribute("code", (Object)-5036);
                return "/common/failure";
            }
            if (cityId < 1L) {
                log.info((Object)"parameter cityId is illegal");
                model.addAttribute("code", (Object)-5037);
                return "/common/failure";
            }
            Long id = null;
            Long imAccountId = null;
            try {
                List cityIds = this.citiesService.getCitiesIdsByCityid(cityId, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
                if (CollectionUtils.isEmpty((Collection)cityIds)) {
                    log.info((Object)"there is no city in DB");
                    model.addAttribute("code", (Object)-12003);
                    return "/common/failure";
                }
                String type = "register";
                boolean verifyResult = false;
                if (this.verifyModel()) {
                    log.info((Object)"is test model ");
                    if ("555555".equals(verify)) {
                        log.info((Object)"test ,so not verify mobile ");
                        verifyResult = true;
                    } else {
                        log.info((Object)("log1: mobile is " + mobile + ",type = " + type + ",verify" + verify));
                        verifyResult = this.verifyMobileCode(model, mobile, type, verify);
                    }
                } else {
                    log.info((Object)("log1: mobile is " + mobile + ",type = " + type + ",verify" + verify));
                    verifyResult = this.verifyMobileCode(model, mobile, type, verify);
                }
                if (verifyResult) {
                    Long sid = this.studentsService.getStudentsIdByMobile(mobile);
                    if (sid != null) {
                        log.info((Object)"the mobile is already registered");
                        model.addAttribute("code", (Object)-5025);
                        return "/common/failure";
                    }
                    Students student = new Students();
                    student.setMobile(mobile);
                    student.setPwd(PasswordUtils.encode((String)pwd));
                    student.setStatus(1);
                    student.setCertification(0);
                    student.setUpdateBy(Long.valueOf(-1L));
                    student.setCreateBy(Long.valueOf(-1L));
                    student.setCityId(cityId);
                    student.setReceive(Students.RECEIVE_NO.intValue());
                    UserNameUtil userNameUtil = new UserNameUtil();
                    student.setNick(userNameUtil.getRandomName());
                    id = this.studentsService.insert(student);
                    if (id != null) {
                        String token = IdentityUtil.encodeCookie((String)"uid", (Long)id);
                        imAccountId = this.createImAccount(id, student);
                        if (DataUtils.isNullOrEmpty((Object)imAccountId)) {
                            log.info((Object)"create im account failed, will be created at next time");
                        } else {
                            log.info((Object)("create im account success, id is " + imAccountId));
                        }
                        HashMap<String, String> maps = new HashMap<String, String>();
                        maps.put("userId", id.toString());
                        maps.put("mobile", mobile);
                        this.cookieUtil.setIdentity(request, response, maps, id);
                        model.addAttribute("token", (Object)token);
                        model.addAttribute("uid", (Object)id);
                        model.addAttribute("code", (Object)"0");
                    }
                    break block21;
                }
                log.info((Object)"create im account failed or insert im account to DB failed");
                log.error((Object)"wrong verifycode");
                model.addAttribute("code", (Object)-5024);
                return "/common/failure";
            }
            catch (Throwable t) {
                t.printStackTrace();
                log.error((Object)t.getMessage());
                log.error((Object)"student register error ");
                if (null != t.getMessage() && t.getMessage().equals("register failed,cause create im account failed")) {
                    model.addAttribute("code", (Object)-24000);
                } else {
                    model.addAttribute("code", (Object)-100000);
                }
                if (null != imAccountId) {
                    this.imAccountService.delete(imAccountId);
                }
                if (null == id) break block21;
                this.studentsService.delete(id);
            }
        }
        return "/common/register";
    }

    private boolean verifyModel() {
        return "test".equals(this.accountConfig.get("testModel"));
    }

    private boolean verifyMobileCode(ModelMap model, String mobile, String type, String verify) throws ServiceException, ServiceDaoException {
        log.info((Object)("log2: mobile is " + mobile + ",type = " + type + ",verify" + verify));
        Long sid = this.smsService.getSmsIdByMobileAndTypeAndApp(mobile, type, Integer.valueOf(1));
        log.info((Object)("sid is " + sid));
        if (sid == null) {
            return false;
        }
        Sms sms = this.smsService.getObjectById(sid);
        log.info((Object)("sms is " + sms));
        String message = sms.getMessage();
        log.info((Object)("message is " + message));
        Long delay = System.currentTimeMillis() - sms.getSendAt();
        if (delay > 600000L) {
            log.info((Object)"require verify too long");
            return false;
        }
        return message.equals(verify);
    }

    @RequestMapping(value={"/a/code/send"}, method={RequestMethod.POST})
    public String sendVerify(HttpServletRequest request, HttpServletResponse response, ModelMap model, String mobile, String type) throws Exception {
        log.info((Object)(mobile + " want send sms of type " + type));
        if (StringUtils.isEmpty((CharSequence)mobile)) {
            log.info((Object)"parameter mobile is null or empty");
            model.addAttribute("code", (Object)-5022);
            return "/common/failure";
        }
        if (StringUtils.isEmpty((CharSequence)type)) {
            log.info((Object)"type is null");
            model.addAttribute("code", (Object)-5028);
            return "/common/failure";
        }
        if (StringUtils.isEmpty((CharSequence)type)) {
            log.info((Object)"parameter type is null or empty");
            model.addAttribute("code", (Object)-5033);
            return "/common/failure";
        }
        try {
            String result;
            Long uid;
            if ("register".equals(type) || "mobile".equals(type)) {
                uid = this.studentsService.getStudentsIdByMobile(mobile);
                if (uid != null) {
                    log.info((Object)(type + " is already exist  " + mobile));
                    model.addAttribute("code", (Object)-5019);
                    return "/common/failure";
                }
            } else if ("experience".equals(type)) {
                uid = this.studentsService.getStudentsIdByMobile(mobile);
                if (uid != null) {
                    Map map = new HashMap();
                    map = DynamicUtil.getStudentClueListParams((String)mobile);
                    List clueList = this.probationService.getIdsByDynamicCondition(Probation.class, map, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
                    if (clueList.size() > 0) {
                        log.info((Object)("this mobile is already use in experience  " + mobile));
                        model.addAttribute("code", (Object)-5032);
                        return "/common/failure";
                    }
                }
            } else if ("password".equals(type)) {
                uid = this.studentsService.getStudentsIdByMobile(mobile);
                if (uid == null) {
                    log.info((Object)(type + " is not already exist  " + mobile));
                    model.addAttribute("code", (Object)-5003);
                    return "/common/failure";
                }
            } else {
                log.info((Object)"parameter type is illegal");
                model.addAttribute("code", (Object)-5034);
                return "/common/failure";
            }
            int code = 0;
            log.info((Object)"sms is start");
            switch (result = this.smsService.sendSms(mobile, type, "msg", Integer.valueOf(1))) {
                case "invalidType": {
                    code = -5029;
                    break;
                }
                case "smsMoreThan5": {
                    code = -5030;
                    break;
                }
            }
            model.addAttribute("code", (Object)code);
        }
        catch (Exception t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            log.error((Object)(mobile + " send message error of type " + type));
            model.addAttribute("code", (Object)-100000);
        }
        return "/common/success";
    }

    @RequestMapping(value={"/a/code/voice"}, method={RequestMethod.POST})
    public String sendVoice(HttpServletRequest request, HttpServletResponse response, ModelMap model, String mobile, String type) throws Exception {
        log.info((Object)(mobile + " want send voice of type " + type));
        if (StringUtils.isEmpty((CharSequence)mobile)) {
            log.info((Object)"parameter mobile is null or empty");
            model.addAttribute("code", (Object)-5022);
            return "/common/failure";
        }
        if (StringUtils.isEmpty((CharSequence)type)) {
            log.info((Object)"parameter type is null or empty");
            model.addAttribute("code", (Object)-5033);
            return "/common/failure";
        }
        try {
            String result;
            Long uid;
            if ("register".equals(type) || "mobile".equals(type)) {
                uid = this.studentsService.getStudentsIdByMobile(mobile);
                if (uid != null) {
                    log.info((Object)(type + " is already exist  " + mobile));
                    model.addAttribute("code", (Object)-5019);
                    return "/common/failure";
                }
            } else if ("experience".equals(type)) {
                uid = this.studentsService.getStudentsIdByMobile(mobile);
                if (uid != null) {
                    Map map = new HashMap();
                    map = DynamicUtil.getStudentClueListParams((String)mobile);
                    List clueList = this.probationService.getIdsByDynamicCondition(Probation.class, map, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
                    if (clueList.size() > 0) {
                        log.info((Object)("this mobile is already use in experience  " + mobile));
                        model.addAttribute("code", (Object)-5032);
                        return "/common/failure";
                    }
                }
            } else if ("password".equals(type)) {
                uid = this.studentsService.getStudentsIdByMobile(mobile);
                if (uid == null) {
                    log.info((Object)(type + " is not already exist  " + mobile));
                    model.addAttribute("code", (Object)-5003);
                    return "/common/failure";
                }
            } else {
                log.info((Object)"parameter type is illegal");
                model.addAttribute("code", (Object)-5034);
                return "/common/failure";
            }
            String realMobile = mobile;
            log.info((Object)("final mobile is : " + realMobile));
            int code = 0;
            switch (result = this.smsService.sendSms(realMobile, type, "voice", Integer.valueOf(1))) {
                case "invalidType": {
                    code = -5029;
                    break;
                }
                case "smsMoreThan5": {
                    code = -5030;
                    break;
                }
                case "sendError": {
                    code = -5031;
                    break;
                }
            }
            model.addAttribute("code", (Object)code);
        }
        catch (Exception t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            log.error((Object)(mobile + " send voice error of type " + type));
            model.addAttribute("code", (Object)-1);
        }
        return "/common/success";
    }

    @RequestMapping(value={"/a/login"}, method={RequestMethod.POST})
    public String login(HttpServletRequest request, HttpServletResponse response, ModelMap model, String mobile, String pwd, String os, String deviceToken) throws Exception {
        Long imAccountId;
        log.info((Object)("========= uri is :" + request.getRequestURI()));
        log.info((Object)("========= url is :" + request.getRequestURL()));
        if (mobile == null) {
            model.addAttribute("code", (Object)-5022);
            return "/common/failure";
        }
        Long uid = this.studentsService.getStudentsIdByMobile(mobile);
        String token = IdentityUtil.encodeCookie((String)"uid", (Long)uid);
        if (uid == null) {
            model.addAttribute("code", (Object)-5003);
            return "common/failure";
        }
        log.info((Object)("uid is " + uid));
        Students student = this.studentsService.getObjectById(uid);
        Integer status = student.getStatus();
        if (status.equals(0)) {
            model.addAttribute("code", (Object)-5038);
            return "common/failure";
        }
        String pass = PasswordUtils.encode((String)pwd);
        Boolean verify = student.getPwd().equals(pass);
        if (verify.booleanValue()) {
            log.info((Object)(uid + " login "));
            HashMap<String, String> maps = new HashMap<String, String>();
            maps.put("userId", uid + "");
            this.cookieUtil.setIdentity(request, response, maps, uid);
            model.addAttribute("code", (Object)0);
            model.addAttribute("user", (Object)student);
            model.addAttribute("token", (Object)token);
            String dToken = student.getDeviceToken();
            if (DataUtils.isNotNullOrEmpty((Object)dToken) && DataUtils.isNotNullOrEmpty((Object)deviceToken)) {
                if (dToken.equals(deviceToken)) {
                    log.info((Object)"\u76f8\u540c\u8bbe\u5907\u767b\u5f55");
                } else {
                    log.info((Object)"\u4e0d\u540c\u8bbe\u5907\u767b\u5f55");
                    this.otherAppUser(response, student.getPlatform(), student.getDeviceToken(), token);
                }
            }
            log.info((Object)("the os before the web juage is " + os));
            student.setPlatform(os);
            student.setDeviceToken(deviceToken);
            this.studentsService.update(student);
            maps.put("userId", uid + "");
            maps.put("mobile", mobile);
            this.cookieUtil.setIdentity(request, response, maps, uid);
            List imAccountIds = this.imAccountService.getIdByBelongIdAndBelongType(ImChatUtil.STUDENT, uid);
            log.info((Object)("imAccountId is==" + imAccountIds));
            imAccountId = null;
            if (imAccountIds.size() > 0) {
                imAccountId = (Long)imAccountIds.get(0);
            } else {
                log.info((Object)("this user im account not found! ,imAccountIds size is " + imAccountIds.size()));
                imAccountId = this.createImAccount(uid, student);
            }
        } else {
            log.info((Object)(mobile + " wrong pwd " + pwd));
            model.put((Object)"code", (Object)-5004);
            return "/common/failure";
        }
        log.info((Object)("imAccountId is==" + imAccountId));
        ImAccount imAccount = this.imAccountService.getObjectById(imAccountId);
        log.info((Object)("ImAccount is==" + imAccount));
        model.addAttribute("code", (Object)0);
        model.addAttribute("user", (Object)student);
        model.addAttribute("token", (Object)token);
        model.addAttribute("imAccount", (Object)imAccount);
        return "/common/login";
    }

    @RequestMapping(value={"/a/password/forget"}, method={RequestMethod.PUT})
    public String resetPassword(HttpServletRequest request, HttpServletResponse response, ModelMap model, String mobile, String verify, String newPwd) throws Exception {
        try {
            log.info((Object)(" mobile = " + mobile + " verify  = " + verify + " pwd = " + newPwd));
            if (StringUtil.isEmpty((String)mobile)) {
                log.info((Object)"params mobile is null or empty");
                model.addAttribute("code", (Object)-5022);
                return "/common/failure";
            }
            if (StringUtil.isEmpty((String)verify)) {
                log.info((Object)"params verify is null or empty");
                model.addAttribute("code", (Object)-5028);
                return "/common/failure";
            }
            if (StringUtil.isEmpty((String)newPwd)) {
                log.info((Object)"params newPwd is null or empty");
                model.addAttribute("code", (Object)-5027);
                return "/common/failure";
            }
            Long uid = this.studentsService.getStudentsIdByMobile(mobile);
            if (uid == null) {
                log.info((Object)(mobile + " not exist "));
                model.addAttribute("code", (Object)-5003);
                return "/common/failure";
            }
            log.info((Object)(mobile + " exist and uid is " + uid));
            boolean verifyResult = false;
            String type = "password";
            if (this.verifyModel()) {
                if ("555555".equals(verify)) {
                    log.info((Object)"test ,so not verify mobile ");
                    verifyResult = true;
                } else {
                    verifyResult = this.verifyMobileCode(model, mobile, type, verify);
                }
            } else {
                verifyResult = this.verifyMobileCode(model, mobile, type, verify);
            }
            if (!verifyResult) {
                log.error((Object)"rewritepwd verifycode");
                model.addAttribute("code", (Object)-5024);
                return "/common/failure";
            }
            Students user = this.studentsService.getObjectById(uid);
            String encodePass = PasswordUtils.encode((String)newPwd);
            user.setPwd(encodePass);
            boolean result = this.studentsService.update(user);
            log.info((Object)(mobile + " change password," + newPwd + "result is " + result));
            log.info((Object)"rewrite password success! ");
            model.addAttribute("code", (Object)0);
            model.addAttribute("message", (Object)"\u5bc6\u7801\u4fee\u6539\u6210\u529f");
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            log.error((Object)"add user error ");
            model.addAttribute("code", (Object)-100000);
        }
        return "/common/success";
    }

    @RequestMapping(value={"/a/u/logout"}, method={RequestMethod.POST})
    public String logout(HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        log.info((Object)" welcome to manager logout ");
        try {
            this.cookieUtil.clearCookie(response);
            model.addAttribute("code", (Object)0);
            model.addAttribute("result", (Object)"/login/index");
        }
        catch (Throwable t) {
            log.error((Object)t.getMessage());
            log.error((Object)"manager logout error  ");
            model.addAttribute("code", (Object)-5005);
            model.addAttribute("result", null);
        }
        return "/data/json";
    }

    @RequestMapping(value={"/a/u/pwd"}, method={RequestMethod.PUT})
    public String updateUser(HttpServletRequest request, HttpServletResponse response, ModelMap model, String oldPwd, String newPwd) throws Exception {
        log.info((Object)(" oldPwd = " + oldPwd + " newPwd = " + newPwd));
        Students user = (Students)request.getAttribute("user");
        Long uid = user.getId();
        log.info((Object)("get uid " + uid));
        try {
            log.info((Object)(" user : " + uid + " want update pwd"));
            if (StringUtil.isEmpty((String)newPwd) || StringUtils.isEmpty((CharSequence)oldPwd)) {
                log.info((Object)"params is null");
                model.addAttribute("code", (Object)-5008);
                return "/common/failure";
            }
            String pass = PasswordUtils.encode((String)oldPwd);
            Boolean verify = user.getPwd().equals(pass);
            if (!verify.booleanValue()) {
                log.info((Object)(uid + " wrong pwd " + oldPwd));
                model.put((Object)"code", (Object)-5006);
                return "/common/failure";
            }
            log.info((Object)(uid + " have right pwd "));
            String encodePass = PasswordUtils.encode((String)newPwd);
            user.setPwd(encodePass);
            boolean bl = this.studentsService.update(user);
            model.addAttribute("code", (Object)0);
            return "/common/failure";
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            log.error((Object)("student " + uid + " update pwd error "));
            model.addAttribute("code", (Object)-100000);
            return "/common/success";
        }
    }

    public String dateTime() {
        Long time = System.currentTimeMillis();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String date = format.format(time);
        return date;
    }

    private boolean otherAppUser(HttpServletResponse response, String platForm, String deviceToken, String token) throws IOException {
        try {
            Long startAt = null;
            Long endAt = System.currentTimeMillis() + 518400000L;
            log.info((Object)(" startAt = " + startAt));
            String result = "";
            String message = "\u60a8\u7684\u8d26\u53f7\u5df2\u4e8e" + this.dateTime() + "\u5728\u5176\u4ed6\u8bbe\u5907\u767b\u5f55\u3002\u5982\u975e\u672c\u4eba\u64cd\u4f5c\uff0c\u5219\u60a8\u7684\u5bc6\u7801\u53ef\u80fd\u6cc4\u6f0f\uff0c\u8bf7\u5c3d\u5feb\u4fee\u6539\u5bc6\u7801\uff0c\u6216\u8054\u7cfb\u5ba2\u670d\u3002";
            log.info((Object)("message : " + message));
            if ("android".equals(platForm)) {
                log.info((Object)" android ");
                result = this.stuAndroidPushServiceImpl.pushMessaeForList("android", "notification", "unicast", deviceToken.toString(), "\u4e0b\u7ebf\u901a\u77e5", "\u4e0b\u7ebf\u901a\u77e5", message, "go_app", "", "", "", "", startAt, "", "true", endAt, "\u6613\u6559\u7ec3APP\u901a\u77e5");
                log.info((Object)(" anResult = " + result));
            } else if ("ios".equals(platForm)) {
                log.info((Object)" ios ");
                result = this.stuIosPushServiceImpl.pushMessaeForList("ios", "notification", "unicast", deviceToken.toString(), "\u4e0b\u7ebf\u901a\u77e5", "\u4e0b\u7ebf\u901a\u77e5", message, "go_app", "", "", "", "", startAt, "", "true", endAt, "\u6613\u6559\u7ec3APP\u901a\u77e5");
                log.info((Object)(" iosResult = " + result));
            } else {
                log.info((Object)("user platform : " + platForm));
            }
            if (DataUtils.isNotNullOrEmpty((Object)result)) {
                JSONObject jsonObject = JSONObject.fromObject((Object)result);
                if ("SUCCESS".equals((String)jsonObject.get("ret"))) {
                    log.info((Object)" push success ");
                } else {
                    log.info((Object)("fail" + jsonObject.get("data")));
                    JSONObject data = JSONObject.fromObject((Object)jsonObject.get("data").toString());
                    log.info((Object)(" data = " + data));
                    log.info((Object)(" errorCode = " + data.get("error_code")));
                }
            } else {
                log.info((Object)"user no device before");
            }
        }
        catch (Throwable t) {
            log.error((Object)"user logout error  ");
            t.printStackTrace();
        }
        return false;
    }

    private Long createImAccount(Long id, Students student) throws Exception {
        log.info((Object)"===== create a new im account begin ========");
        Long imAccountId = null;
        try {
            String accid = this.imChatUtil.getAccid(id, ImChatUtil.AccidType.STUDENT);
            String accidToken = null;
            String code = null;
            String message = null;
            Map result = this.imChatUtil.createImAccount(accid);
            log.info((Object)("result is " + result));
            code = (String)result.get("code");
            if ("200".equals(code)) {
                log.info((Object)"create im account success");
                accidToken = (String)result.get("token");
                accid = (String)result.get("accid");
                ImAccount imAccount = new ImAccount();
                imAccount.setAccount(accid);
                imAccount.setBelongId(id);
                imAccount.setBelongtType(0);
                imAccount.setToken(accidToken);
                imAccount.setCreateAt(Long.valueOf(System.currentTimeMillis()));
                imAccount.setCreateBy(id);
                imAccount.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
                imAccount.setUpdateBy(id);
                imAccountId = this.imAccountService.insert(imAccount);
                log.info((Object)("create im account success,insert to DB success, id is" + imAccountId));
                boolean success = this.imChatUtil.updateUserInfo(accid, student);
                if (success) {
                    log.info((Object)"update student info success");
                } else {
                    log.info((Object)"update student info failed");
                }
            } else {
                message = (String)result.get("message");
                log.info((Object)("create im account failed,see==" + message));
                throw new Exception("register failed,cause create im account failed");
            }
            log.info((Object)"===== create a new im account end ========");
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.info((Object)t.getMessage(), t);
        }
        return imAccountId;
    }
}

